/*
 *****************************************************************************
 *                                                                           *
 *  UNIVERSITY OF LOWELL Motif/C++ Binding				     *	
 *                                                                           *
 *  COPYRIGHT (c) 1990 BY  UNIVERSITY OF LOWELL, DEPARTMENT OF COMPUTER      *
 *  SCIENCE, LOWELL, MA 01854                                                *
 *                                                                           *
 *  LICENSED MATERIAL - PROGRAM PROPERTY OF UNIVERSITY OF LOWELL. ALL RIGHTS *
 *  RESERVED.                                                                *
 *                                                                           *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    *
 *  ONLY  IN  ACCORDANCE  WITH  THE TERMS OF  SUCH  LICENSE  AND WITH THE    *
 *  INCLUSION OF THE  ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER    *
 *  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    *
 *  OTHER PERSON.  NO TITLE TO  OR OWNERSHIP OF  THE  SOFTWARE  IS HEREBY    *
 *  TRANSFERRED.                                                             *
 *                                                                           *
 *  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    *
 *  AND  SHOULD  NOT BE CONSTRUED AS A COMMITMENT BY UNIVERSITY OF LOWELL    *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * File Name      :                                                          *
 * Author         :                                                          *
 * Created        :                                                          *
 * Description    :                                                          *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 * Edit History   :                                                          *
 * date         who                     what                                 *
 *                                                                           *
 *****************************************************************************
 */
/*
//-----------------------------------------------------------------------------
//
// $Source: /usr/proj/grl/motifplb/design_review_1_efforts/lib_1/XMBulletinB.hh,v $
// $Revision: 1.2 $
// $State: Exp $
// $Author: grlcr $
// $Date: 89/12/08 15:22:14 $
// $Locker:  $
//
// $Log:	XMBulletinB.hh,v $
Revision 1.2  89/12/08  15:22:14  grlcr
*** empty log message ***

Revision 1.1  89/11/22  12:27:10  kseethar
Initial revision

Revision 1.2  89/11/03  10:38:21  motifplb
*** empty log message ***

Revision 1.1  89/11/02  12:08:58  motifplb
Initial revision

// ***** Created Oct 11, 1989 by BRM *****
//-----------------------------------------------------------------------------
*/

#ifndef XMBulletinBoard_hh
#define XMBulletinBoard_hh

#include "XMManager.hh"
#include <Xm/BulletinB.h>

class XMBulletinBoard: public XMManager {
 protected:
     // ****CONSTRUCTORS****
     XMBulletinBoard ();

 public :
     // ****CONSTRUCTORS****
     XMBulletinBoard (XMObject*, String,Boolean managed=True);
     XMBulletinBoard (XMObject* parent, String name, 
	              Dimension width,
		      Dimension height,
		      short margin_width, 
		      short margin_height,
		      Boolean managed = True);
     XMBulletinBoard (XMObject* parent, String name, 
	              Dimension width,
		      Dimension height,
		      Dimension border_width, 
		      XMFontList* label_font_list,
		      Boolean managed = True);

     // ****DESTRUCTOR****
     ~XMBulletinBoard ();

     // ****METHODS TO SET THE BulletinBoard RESOURCES****
     void set_allowOverlap             (Boolean);
     void set_autoUnmanage             (Boolean);
     void set_buttonFontList           (XMFontList*);
     void set_cancelButton             (XMObject*);
     void set_defaultButton            (XMObject*);
     void set_defaultPosition          (Boolean);
     void set_dialogStyle              (u_char);
     void set_dialogTitle              (XMString*);
     void set_labelFontList            (XMFontList*);
     void set_marginHeight             (short);
     void set_marginWidth              (short);
     void set_noResize                 (Boolean);
     void set_resizePolicy             (u_char);
     void set_shadowType               (u_char);
     void set_stringDirection          (XmStringDirection);
     void set_textFontList             (XMFontList*);
     void set_focusCallback            (XtCallbackList);
     void set_mapCallback              (XtCallbackList);
     void set_textTranslations         (XtTranslations);
     void set_unmapCallback            (XtCallbackList);
     void set_entry_focusCallback      (XtCallbackProc, caddr_t);
     void set_entry_mapCallback        (XtCallbackProc, caddr_t);
     void set_entry_unmapCallback      (XtCallbackProc, caddr_t);

     // ****METHODS TO GET THE BulletinBoard RESOURCES****
     void get_allowOverlap             (Boolean*);
     void get_autoUnmanage             (Boolean*);
     void get_buttonFontList           (XMFontList*);
     void get_cancelButton             (XMObject*);
     void get_defaultButton            (XMObject*);
     void get_defaultPosition          (Boolean*);
     void get_dialogStyle              (u_char*);
     void get_dialogTitle              (XMString*);
     void get_labelFontList            (XMFontList*);
     void get_marginHeight             (short*);
     void get_marginWidth              (short*);
     void get_noResize                 (Boolean*);
     void get_resizePolicy             (u_char*);
     void get_shadowType               (u_char*);
     void get_stringDirection          (XmStringDirection*);
     void get_textFontList             (XMFontList*);
};

#endif     // XMBulletinBoard_hh

// dont add stuff after this endif



