//
//	A timing test for barrier. Everything is in the one file.
//

#include "stream.h"
#include "Thread.h"
#include "SimulationMultiplexor.h"
#include "Barrier.h"
#include "Statistic.h"
#include "timer.h"

#define TRIALS 100
#define SAMPLES 10

Barrier TheBarrier(0);

class BarrierTest : public Thread {
    int howMany;
public:
    BarrierTest();
    virtual void main();
};

inline
BarrierTest::BarrierTest() : ("BarrierTest", 100, 0, 0)
{
}

void
BarrierTest::main()
{
    for ( ;; ) {
	TheBarrier.rendezvous();
    }
}

class ControlTask : public Thread {
    int from;
    int to;
    int by;
    double start;
    double elapsed;
    int testers;
    Statistic stats;

public:
    ControlTask(int,int,int);
    virtual void main();
};

ControlTask::ControlTask(int f, int t, int b)
{
    from = f;
    to = t;
    by = b;
    testers = 0;
}

void
ControlTask::main()
{
    cout << "About to enroll";

    ThisCpu -> enrollCpu();

    for (int i = from; i <= to; i += by ) {
	TheBarrier.height(i+1);
	cout << "Build testers..\n";
	while( testers < i) {
	    ThisCpu -> add(new BarrierTest);
	    testers++;
	}

	cout << "Let everyone rendezvous\n";

	hold(1);
	stats.reset();
	//
	// start collecting sampls
	//
	for (int sample = 0; sample < SAMPLES; sample++ ) {
	    cout << ".." << sample << ".."; cout.flush();
	    start = seconds();
	    for (int trial = 0; trial < TRIALS; trial++) {
		TheBarrier.rendezvous();
		hold(1);
	    }
	    double elapsed = seconds() - start;
//	    cout << "Elapsed = " << elapsed << "\n";
	    stats += elapsed;
	}
	cout << "\n";
	cout << "For " << SAMPLES << " samples of " << TRIALS <<" trials\n";
	cout << "of " << i << " threads,\n";
	cout << "we get " << stats << "\n";
    }
}

main(int argc, char** argv)
{
    SimulationMultiplexor Cpu(1);

    int from = atoi(argv[1]);
    int to = atoi(argv[2]);
    int by = atoi(argv[3]);
    int cpus = atoi(argv[4]);

    cout << "From = " << from << " and to = " << to << "\n";
    cout << "with " << cpus << " cpus\n";

    Cpu.add( new ControlTask(from,to,by) );
    Cpu.fireItUp( cpus, to * 1024 + 4000000);
    cout << "Done!\n";
}

