// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#include "SingleSimMux.h"
#include "AwesimeHeap.h"
#include "Thread.h"
#include "HardwareContextP.h"
#include "TimeSchedulerSplayPQ.h"
#include "ReserveByException.h"
#include <math.h>
#include "Debug.h"


extern int CpuMuxDebugFlag;

SingleSimMux::SingleSimMux(int debug )
    : SimulationMultiplexor(debug), SingleCpuMux(debug)
{
    ThisSimulationMultiplexor = this;
    ThisCpu = this;
    
    SingleCpuMux::allocateLocalEventStructures(0,1);
    pNameTemplate = "SingleSimMux";
    sprintf(nameSpace, "[%s-%d] ", pNameTemplate, SingleCpuMux::iYam);
    pName = nameSpace;
    SingleSimMux::allocateLocalEventStructures(0,1);
}

void
SingleSimMux::allocateLocalEventStructures(int, int)
{
    DEBUG_START;
    cerr  << name() << " enter allocateLocalEventStructures\n";
    DEBUG_END;
    myPendingEvents = new TimeSchedulerSplayPQ;
}

void
SingleSimMux::allocateEventStructures(int newIYam, int outOf)
{
    
    DEBUG_START;
    
    cerr  << name() << " enter allocateEventStructures\n";
    DEBUG_END;
    
    allocateLocalEventStructures(newIYam, outOf);
    
    //
    // must do this after the local structures get set up so that
    // CpuMultiplexors does not increase until all data structures are
    // in place, otherwise people may poke at them before they're set up.
    //
    
    //CpuMultiplexor::allocateEventStructures(newIYam, outOf);
}

void
SingleSimMux::deallocateEventStructures()
{
    
    //    CpuMultiplexor::deallocateEventStructures();
    
    DEBUG_START;
    cerr  << name() << " enter deallocateEventStructures\n";
    DEBUG_END;
    
    delete myPendingEvents;
    myPendingEvents = 0;
}

void
SingleSimMux::warmThePot(int)
{
    DEBUG_START;
    cerr  << name() << " enter warmThePot\n";
    DEBUG_END;
    
    SingleCpuMux::warmThePot(1);
}

void
SingleSimMux::coolItDown()
{
    DEBUG_START;
    cerr  << name() << " enter coolItDown\n";
    DEBUG_END;

    SingleCpuMux::coolItDown();
}

void
SingleSimMux::add( Thread * t )
{
    
    DEBUG_START;
    cerr  << name() << " enter SingleSimMux::add\n";
    DEBUG_END;
    
    myPendingEvents->enq( TimeScheduler(t, CurrentSimulatedTime) );
}

Thread * SingleSimMux::remove()
{
    DEBUG_START;
    cerr  << name() << " enter SingleSimMux::remove\n";
    DEBUG_END;
    
    if ( *terminated || myPendingEvents -> empty() ) {
	return(0);
    }
    TimeScheduler item = myPendingEvents -> deq();
    CurrentSimulatedTime = item.time();
    return( item.thread() );
}

int
SingleSimMux::advanceTime()
{
    assert(0);
}

void
SingleSimMux::stirItAround()
{
    DEBUG_START;
    cerr  << name() << " enter SingleSimMux::stirItAround\n";
    DEBUG_END;
    
    for (;;) {
	assert( myCurrentEvents -> isEmpty() );
	
	DEBUG_START;
	cerr  << name() << " Prepare to dispatch task\n";
	DEBUG_END;
	
	if ( myPendingEvents -> empty() ) {
	    DEBUG_START;
	    cerr  << name() << " myPendingEvents is empty\n";
	    DEBUG_END;
	    return;
	}
	//
	//	Grab reference to schedule item, and then delete it
	//	to avoid copy overhead
	//

	TimeScheduler &item = myPendingEvents -> front();
	DEBUG_START;
	cerr << name() << "itemis " << hex(long(item.thread()));
	cerr << " " << item.time() << "\n";
	DEBUG_END;
	
	CurrentSimulatedTime = item.time();
	currentThread = item.thread();
	myPendingEvents -> del_front();
	
	DEBUG_START;
	cerr << name() << " switch to " << hex(long(currentThread));
	cerr << " at " << CurrentSimulatedTime << "\n";
	cerr.flush();
	DEBUG_END;
	
	systemContext.switchContext(&(currentThread -> pContext));
	raisedBy -> handleException();
	raisedBy = 0;
    }

    DEBUG_START;
    cerr  << name() << " exit SingleSimMux::stirItAround\n";
    DEBUG_END;
    
}
