// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#include "SingleCpuMux.h"
#include "CpuMultiplexorP.h"
#include "SpinLock.h"
#include "SpinFetchAndOp.h"
#include "Thread.h"
#include "ThreadContainer.h"
#include "ReserveByException.h"
#include <math.h>

//
//	This can not be private, or we wont see all the action
//
extern int CpuMuxDebugFlag;

SingleCpuMux::SingleCpuMux(int debug) : (debug)
{
    CpuMuxDebugFlag = debug;
    pNameTemplate = "SingleCpuMux";
    sprintf(nameSpace, "[%s-%d] ", pNameTemplate, iYam);
    pName = nameSpace;
}

SingleCpuMux::~SingleCpuMux()
{
}

void
SingleCpuMux::allocateLocalEventStructures(int newIYam, int outOf)
{
    assert( newIYam == 0 && outOf == 1 );

    iYam = newIYam;
    sprintf(nameSpace, "[%s-%d] ", pNameTemplate, iYam);
    pName = nameSpace;

    myCurrentEvents = AllocateHardwareCurrentEventsStructure();
}

void
SingleCpuMux::allocateEventStructures(int newIYam, int outOf)
{
    allocateLocalEventStructures(newIYam, outOf);
}

void
SingleCpuMux::deallocateEventStructures()
{
    delete myCurrentEvents;
    myCurrentEvents = 0;
}

void
SingleCpuMux::fireItUp(int, unsigned)
{
    warmThePot(1);
    stirItAround();
    coolItDown();
}

void
SingleCpuMux::warmThePot(int)
{
    pid = getpid();
    enabled = 1;
}

void
SingleCpuMux::coolItDown()
{
    // empty
}

void
SingleCpuMux::add(Thread *who)
{
    addUnlocked( who );
}

Thread *
SingleCpuMux::remove()
{
    
    //
    //	System stopped?
    //
    if ( *terminated ) {
	return(0);
    }
    return( myCurrentEvents -> remove() );
}

//
// This is the job dispatcher.
//

void
SingleCpuMux::stirItAround()
{
    currentThread = 0;

    while( ! *terminated ) {
	//
	//	remove directly instead of calling remove
	//
	currentThread = myCurrentEvents -> remove();

	if (currentThread == 0 ) {
	    return;
	}
	systemContext.switchContext(&(currentThread -> pContext));
	raisedBy -> handleException();
	raisedBy = 0;
    }
}
