#include <stream.h>
#include "BatchStatistic.h"
#include <math.h>

void
BatchStatistic::batch()
{
    batchStats += mean();
}

void
BatchStatistic::operator+=(double value)
{
    SampleStatistic::operator+=(value);
    if ( n >= pBatchTrigger ) {
	batch();
    }
}

void BatchStatistic::batchReset()
{
    return( batchStats.reset() );
}
int BatchStatistic::batchSamples()
{
    return( batchStats.samples() );
}
double BatchStatistic::batchMean()
{
    return( batchStats.mean() );
}
double BatchStatistic::batchStdDev()
{
    return( batchStats.stdDev() );
}
double BatchStatistic::batchVar()
{
    return( batchStats.var() );
}
double BatchStatistic::batchMin()
{
    return( batchStats.min() );
}
double BatchStatistic::batchMax()
{
    return( batchStats.max() );
}
double BatchStatistic::batchSum()
{
    return( batchStats.sum() );
}

double BatchStatistic::batchConfidence(int p_percentage)
{
    return( batchStats.confidence(p_percentage) );
}
double BatchStatistic::batchConfidence(double p_value)
{
    return( batchStats.confidence(p_value) );
}

void
BatchStatistic::classPrintOn(ostream& st)
{
    st << batchStats.samples() << " " << batchStats.mean();
    st << " " << batchStats.stdDev() << " ";
    st << batchStats.confidence(90) << " " << batchStats.confidence(95);
    st << " " << batchStats.confidence(99);
}
