// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "BoundedFifo.h"
#include "stream.h"
#include "assert.h"

BoundedFifo::BoundedFifo(int xpMaxLength, int defaultLength)
    : (defaultLength),
    upperBoundLock(xpMaxLength, &upperBoundLockFifo), upperBoundLockFifo()
{
    pMaxLength = xpMaxLength;
};

void
BoundedFifo::add(AwesimeFifoItem* t) {
    upperBoundLock.reserve();
    LockedFifo::add(t);
    lowerBoundLock.release();
}

bool
BoundedFifo::remove(AwesimeFifoItem *item)
{
    (void) lowerBoundLock.reserve();
    bool ok = LockedFifo::remove(item);
    assert(ok);
    upperBoundLock.release();
    return(ok);
}

bool
BoundedFifo::removeNoBlock(AwesimeFifoItem *item)
{
    bool ok = removeNoBlock( item );
    if (ok) {
	upperBoundLock.release();
    }
    return(ok);
}

bool BoundedFifo::removeIfFound(AwesimeFifoItem *item) {
    (void) lowerBoundLock.reserve();
    bool ok = LockedFifo::removeIfFound(item);
    if (ok) {
	upperBoundLock.release();
    } else {
	lowerBoundLock.release();
    }
    return(ok);
}

bool
BoundedFifo::doDelete(AwesimeFifoIndex& index) {
    //
    // This is problematic. Since this is a LockedFifo, this person
    // will be the only one with access to the list. If he blocks
    // at this point, he's dead-meat.
    //
    // So, is this an error? If so, should we protect him?
    //
    bool whaHap = AwesimeFifo::doDelete(index);
    if (whaHap) {
	bool noBlock = lowerBoundLock.reserveNoBlock();
	assert( noBlock );
	lowerBoundLock.reserve();
	upperBoundLock.release();
    }
    return(whaHap);
}

unsigned int BoundedFifo::size()
{
    return(AwesimeFifo::size());
}
