// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef FIFOSCHEDULERH
#define FIFOSCHEDULERH
#pragma once

#include <ThreadContainer.h>
#include <AwesimeFifo.h>

class Thread;

class FifoScheduler : public ThreadContainer {
    AwesimeFifo fifo;

public:

    FifoScheduler(int defaultLength = 0, bool xdebug = 0);

    virtual void add(Thread *t);
    virtual void add(double when, Thread *t);
    virtual Thread* remove();
    virtual Thread* remove(Thread*);

    virtual bool isEmpty();
    virtual unsigned size();
    virtual void classPrintOn(ostream& s);
};
		     
#endif FIFOSCHEDULERH
