// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef _LowerBoundedHeap_h
#define _LowerBoundedHeap_h
#pragma once

#include <Semaphore.h>
#include <LockedHeap.h>

class LowerBoundedHeap : public LockedHeap {

protected:
    Semaphore lowerBoundLock;
    
public:
    
    LowerBoundedHeap(int defaultLength = 0);
    
    virtual void add(AwesimeHeapItem &t);
    virtual bool remove(AwesimeHeapItem &item);
    
    virtual bool doDelete(AwesimeHeapIndex& index);
    
    virtual unsigned size();
    
    virtual void classPrintOn(ostream& s);
};

#endif /* _LowerBoundedHeap_h */
