// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include <stream.h>
#include "SpinBarrier.h"
#include "CpuMultiplexor.h"
#include "Pragma.h"

C_EXTERNAL_FUNCTION( int getpid() );

//
//	Make everyone exit
//
#ifdef USE_SHARED_MEMORY

void
SpinBarrier::lowerBarrier()
{
    reserve();
    generation++;
    pCount = 0;
    release();
}

int
SpinBarrier::rendezvous()
{
    reserve();
    pCount++;

    //
    // Waiting people just read generation, and the final process
    // just writes it, so we dont really even need to use the locks here.
    //
    if ( pCount == pHeight ) {
	pCount = 0;
	generation++;
	release();
    } else {

	short gen = generation;
	VOLATILE short *genp = &generation;	// bug in 1.35

	release();
	int timesAround = 0;
	int totalGetPids = 0;
	while ( gen == *genp ) {
	    if ( timesAround > pLoops ) {
		(void) getpid();
		timesAround = 0;
		totalGetPids++;
		if ( pMaxLoops > 0 && totalGetPids > pMaxLoops ) {
		    return(0);
		}
	    }
	    timesAround++;

	}
    }
    return(1);
}
#endif /* USE_SHARED_MEMORY */

void
SpinBarrier::height(int newHeight)
{
    reserve();
    if (pCount >= newHeight) {
	pCount = 0;
	generation++;
    }
    else {
	pHeight = newHeight;
    }
    release();
}
