/*
 * ErrFac.c -- member functions of class ErrorFacility
 */
/*
 *  Author:     S.M. Orlow
 *              Systex,Inc.
 *              Beltsville, MD 20705
 *              301-474-0111
 *
 *  Contractor: K.E. Gorlen
 *              Computer Systems Laboratory
 *              Rm. 2017, Bld 12A
 *              National Institutes of Health
 *              Bethesda, MD 20205
 *              (301)-496-5361
 *
 * Modification History:
 */

#include "ErrFac.h"
#include <string.h>

#define DEFAULT_EXPANSION_FACTOR 2
#define expand_by(F,X) (X) + (X)/(F)
#define DEFAULT_FACILITY_CAPACITY 16

const char* left_cmt = "/*";
const char* rght_cmt = "*/";

ErrorSpecs :: ErrorSpecs(int err_sev,char* err_args,char* err_text) {
	severity = err_sev;
	args = new char[strlen(err_args)+1];
	strcpy(args,err_args);
	text = new char[strlen(err_text)+1];
	strcpy(text,err_text);
	}

void ErrorSpecs :: printOn(ostream& strm) {
	strm << severity << ", \042" << args << "\042, " << text;
	}

ErrorFacility :: ErrorFacility(char* long_name,char* short_name,
				int fac_code,char* base_name) {
	longname  = new char[strlen(long_name)+1];
	strcpy(longname,long_name);
	shortname  = new char[strlen(short_name)+1];
	strcpy(shortname,short_name);
	basename  = new char[strlen(base_name)+1];
	strcpy(basename,base_name);
	Code = fac_code;

	capacity = DEFAULT_FACILITY_CAPACITY;
	errlist = new ErrorSpecsPt[capacity];
	size = 0;
	}

void ErrorFacility :: resize(int newcapacity) {
	if ( newcapacity <= capacity ) return;
	ErrorSpecsPt* tmp = errlist;
	errlist = new ErrorSpecsPt[newcapacity];

	for(int i=0; i<=capacity; i++)
	  errlist[i] = tmp[i];

	capacity = newcapacity;
	delete tmp;
	}

void ErrorFacility :: add(ErrorSpecs& sp) {
//cerr << "ErrorFacility: capacity=" << capacity << " size = " << size << "\n";
	if ( size == capacity ) 
	  resize(expand_by(DEFAULT_EXPANSION_FACTOR,capacity));
	errlist[size++] = &sp;
	}
void ErrorFacility :: h_init(ostream& strm) {
	strm << left_cmt << "\n"
 	     << "* " << basename << ".h\n"
 	     << "* C include file created by errgen utility.  DO NOT EDIT!\n"
	     << rght_cmt << "\n";

	strm << left_cmt << "\n *     ***** " << longname 
			  << " facility *****\n " << rght_cmt << "\n";

	strm << "\nextern void " << shortname << "errinit();\n\n";
	}

void ErrorFacility :: h_define(ostream& strm,char* name,int val) {
	strm << "#define " << shortname << name << "\011\011" << val << "\n";
	}

void ErrorFacility :: printOn(ostream& strm) {
	strm << left_cmt << "\n" << " * " << basename << ".c --"
             << " Error definition file generated by errgen.  DO NOT EDIT!\n"
	     << rght_cmt << "\n";
	strm << "#include <errors.h>\n"
	     << "#include \042" << basename << ".h\042\n"
	     << "extern ErrFac errfac[MAX_FACILITIES];\n";
	strm << left_cmt << "\n"
	     << "*	***** " << longname << " facility *****\n"
	     << rght_cmt << "\n";
	strm << "ErrSpecs " << shortname << "errlist[] = {\n";

	for(int i=0; i<size; i++) {
	  strm << " {";
	  errlist[i]->printOn(strm);
	  strm << " }";
	  if ( i < size-1 ) strm << ",";
	  strm << "\n";
	  };
	strm << "};\n";

	strm << left_cmt << "\n"
	     << "* Error initialization routine for " << longname 
	     << " facility.\n" << rght_cmt << "\n";

	strm << "void " << shortname << "errinit() {\n"
	     << "errfac[" << Code << "].last = " 
	     << shortname << "LAST_ERROR;\n"
	     << "errfac[" << Code << "].longname = \042" <<longname<< "\042;\n"
	     << "errfac[" << Code << "].errlist = " << shortname <<"errlist;\n"
	     << "};\n";
	}
