/* Array.c.m4 -- template for implementations of generic array objects

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: uunet!ncifcrf.gov!nih-csl!keith
	Internet: keith%nih-csl@ncifcrf.gov
	September, 1985

Function:

m4 macro template for the .c files for arrays of the specified
fundamental type: char, int, short, long, unsigned, float, and double.
For example, to generate the implementation of an array of chars:

	m4 Array.c.m4 Arraychar.p >Arraychar.c

The type-specific part of the implementation is in the file
Arraychar.p, for example.

WARNING -- Make changes to the .p or .m4 files, not to the .c file
they generate.

$Log:	Array_c.m4,v $
Revision 1.3  88/02/04  12:51:59  keith
Make Class class_CLASSNAME const.
Make destructor non-inline.

Revision 1.2  88/01/16  23:37:10  keith
Remove pre-RCS modification history

*/

#define NEW(type,size)	((type*)malloc(sizeof(type)*(size)))


/* Arraychar.p -- type-specific functions for class Arraychar

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: uunet!ncifcrf.gov!nih-csl!keith
	Internet: keith%nih-csl@ncifcrf.gov
	September, 1985

Function:
	
Type-specific functions for class Arraychar, such as hash() and
printOn().  Generic functions are generated from the m4 template file
Array.c.m4.

WARNING -- Make changes to the .p or .m4 files, not to the .c file
they generate.

$Log:	Arraychar.p,v $
 * Revision 1.3  88/02/17  12:44:20  keith
 * Fix infinite recursion in Arraychar::printOn().
 * 
 * Revision 1.2  88/01/16  23:37:24  keith
 * Remove pre-RCS modification history
 * 
*/

#include "Arraychar.h"
#include "oopsconfig.h"
#include <libc.h>
#include "oopsIO.h"

#define	THIS	Arraychar
#define	BASE	Collection
DEFINE_CLASS(Arraychar,Collection,1,"$Header: Arraychar.p,v 1.3 88/02/17 12:44:20 keith Exp $",NULL,NULL);

static int charCmp(char* a, char* b)
{
	return *(unsigned char*)a - *(unsigned char*)b;
}

static union hash_char_mask {
	unsigned in[sizeof(int)];
	char ch[sizeof(int)*sizeof(int)];
	hash_char_mask();
} mask;

static hash_char_mask::hash_char_mask()
{
	for (register unsigned i=0; i<sizeof(int); i++) {
		for (register unsigned j=0; j<sizeof(int); j++) ch[sizeof(int)*i+j] = j<i ? 0xff : 0;
	}
}

unsigned THIS::hash()
{
	register unsigned h = sz;
	register unsigned i = div_sizeof_int(sz);
	register unsigned* vv = (unsigned*)v;
	while (i--) h ^= *vv++;
	if ((i = mod_sizeof_int(sz)) != 0)
		h ^= *vv & mask.in[i];
	return h;
}

void THIS::printOn(ostream& strm)
{
	strm << className() << "[";
	for (register unsigned i=0; i<sz; i++) {
		strm << "\t" << form("0x%.2x",(unsigned int)(unsigned char)v[i]);
	}
	strm << "]\n";
}

THIS::THIS(istream& strm, THIS& where)
{
	this = &where;
	strm >> sz;
	v = NEW(char,sz);
	for (register unsigned i =0; i<sz; i++) { int _i; strm >> _i; v[i] = _i; }
}

void THIS::storer(ostream& strm)
{
	Object::storer(strm);
	strm << sz << " ";
	for (register unsigned i=0; i<sz; i++) strm << (unsigned int)(unsigned char)v[i] << " ";
}

Arraychar::Arraychar(fileDescTy& fd, Arraychar& where)
{
	this = &where;
	readBin(fd,sz);
	v = NEW(char,sz);
	readBin(fd,v,sz);
}

void Arraychar::storer(fileDescTy& fd) 
{
	Object::storer(fd);
	storeBin(fd,sz);
	storeBin(fd,v,sz);
}

Arraychar::Arraychar(unsigned size)
{
	sz = size;
	if (size==0) AllocSizeErr();
	else v = NEW(char,sz);
}

Arraychar::Arraychar(const Arraychar& a)
{
	register unsigned i = a.sz;
	sz = i;
	v = NEW(char,i);
	register char* vv = &v[0];
	register char* av = &a.v[0];
	while (i--) *vv++ = *av++;
}

Arraychar::~Arraychar()	{ DELETE(v); }

void Arraychar::operator=(const Arraychar& a)
{
	if (v != a.v) {
		DELETE(v);
		v = NEW(char,sz=a.sz);
		register unsigned i = a.sz;
		register char* vv = &v[0];
		register char* av = &a.v[0];
		while (i--) *vv++ = *av++;
	}
}

bool Arraychar::operator==(const Arraychar& a)
{
	if (sz != a.sz) return NO;
	register unsigned i = sz;
	register char* vv = &v[0];
	register char* av = &a.v[0];
	while (i--) if (*vv++ != *av++) return NO;
	return YES;
}

unsigned Arraychar::capacity()	{ return sz; }

bool Arraychar::isEqual(const Object& a)
{
	return a.isSpecies(class_Arraychar) && *this==*(Arraychar*)&a;
}

const Class* Arraychar::species()	{ return &class_Arraychar; }

void Arraychar::reSize(unsigned newsz)
{
	if (newsz<=0) AllocSizeErr();
	v = REALLOC(v,newsz);
	sz = newsz;
}

void Arraychar::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	register char* av = &v[0];
	register unsigned i = sz;
	v = NEW(char,i);
	register char* vv = &v[0];
	while (i--) *vv++ = *av++;
}

unsigned Arraychar::size()	{ return sz; }

void Arraychar::sort()
{
	qsort(v,sz,sizeof(char),charCmp);
}

extern const int OOPS_ALLOCSIZE;
extern const int OOPS_INDEXRANGE;

void Arraychar::AllocSizeErr()
{
	setOOPSerror(OOPS_ALLOCSIZE,DEFAULT,this,className());
}
void Arraychar::IndexRangeErr()
{
	setOOPSerror(OOPS_INDEXRANGE,DEFAULT,this,className());
}

