      PROGRAM FLOW
C-------------------------------------------------------------------------
C Flow UNIX interface routine.
C Sets up various required input files and parameters for Flow
C 
C Julian Bunn 1992
C-------------------------------------------------------------------------
      INCLUDE 'lunits.h'
      INCLUDE 'params.h'
      INCLUDE 'jobcom.h'
      INCLUDE 'ignore.h'
      INCLUDE 'trecom.h'
      PARAMETER (MLLEN=255,maxarg=100)
      character*(mxlin) argval
      character*1 key,char
      CHARACTER*(MLLEN)  cfile,clong
      character*(mxnam) touppr
      LOGICAL LOG,fexist,fold,fqold,tidy
      external touppr
c
c get all arguments
c
      numargs = iargc()
      if(numargs.gt.maxarg) then
         write(6,'(A)') ' Flow --> Too many arguments '
         goto 900
      endif
c
c get input file from Flow
c
      call getarg(numargs,cfile)       
      lfile = index(cfile,' ')-1
      write(6,'(A)') ' Flow --> Input Floppy file '//cfile(:lfile)
      inquire(file=cfile(:lfile),exist=fexist)
      if(.not.fexist) then
        write(6,'(A)') ' Flow --> Input file not found !'
        goto 900
      endif
      lintre = 50
      open(lintre,file=cfile(:lfile),status='old',
     &     form='unformatted',err=900)
c
      log = .false.      
      lext = .true.
      lqery = .false.                    
      lchrt = .false.
      lsubs = .false.
      lcomm = .false.
      ltree = .false.
      largc = .false.
      loutch = 96
      ctree = '$$$$'
c
c Find if -l was given
c
      do 400 iarg = 1,numargs-1
         call getarg(iarg,argval)
         larg = index(argval,' ')-1 
         key = argval(2:2)
         if(key.eq.'l') then
           log = .true.
         endif
  400 continue
c
c loop over all qualifiers
c
      icheck = 0
      do 500 iarg = 1,numargs-1
         call getarg(iarg,argval)
         larg = index(argval,' ')-1 
         key = argval(2:2)
         if(key.eq.'l') then
           log = .true.
         else if(key.eq.'A') then
           largc = .true.
           loutar = 61
           if(argval(3:3).eq.' ') then
              cargf = 'argmnts.dat'
              largf = 11
           else
              cargf = argval(3:)
              largf = index(cargf,' ')-1 
           endif
           inquire(file=cargf(:largf),exist=fexist)
           if(fexist) then
              open(loutar,file=cargf(:largf),status='old')
              close(loutar,status='delete')
           endif
           if(log) write(6,'(A)') ' Flow --> Argument checks: '//
     &             cargf(:largf) 
           open(loutar,file=cargf(:largf),status='new',err=900)
         else if(key.eq.'q') then
           lqery = .true.
           if(log) write(6,'(A)') ' Flow --> Queries on the tree'
         else if(key.eq.'E') then
           lext = .false.
           if(log) write(6,'(A)') ' Flow --> Exclude externals'
         else if(key.eq.'c') then
           if(argval(3:3).eq.' ') then
              ccomm = 'procom.dat'
              lcmm = 10
           else
              ccomm = argval(3:)
              lcmm = index(ccomm,' ')-1 
           endif
           inquire(file=ccomm(:lcmm),exist=fexist)
           if(fexist) then
              open(loutco,file=ccomm(:lcmm),status='old')
              close(loutco,status='delete')
           endif
           if(log) write(6,'(A)') ' Flow --> COMMON Table: '//
     &             ccomm(:lcmm) 
           lcomm = .true.
           loutco = 60
           open(loutco,file=ccomm(:lcmm),status='new',err=900)
         else if(key.eq.'s') then
           if(argval(3:3).eq.' ') then
              chart = 'protre.dat'
              lchart = 10
           else
              chart = argval(3:)
              lchart = index(chart,' ')-1 
           endif
           inquire(file=chart(:lchart),exist=fexist)
           if(fexist) then
              open(loutre,file=chart(:lchart),status='old')
              close(loutre,status='delete')
           endif
           if(log) write(6,'(A)') ' Flow --> Text Structure Chart: '//
     &             chart(:lchart) 
           ltree = .true.
           loutre = 61
           open(loutre,file=chart(:lchart),status='new',err=900)
         else if(key.eq.'i') then
           clong = argval(3:)
           llong = lenocc(clong)
           if(llong.le.0) then
              write(6,'(A)') ' Flow --> No Ignore names given'
              goto 900
           endif
   60      icomma = index(clong,',')
           if(icomma.ne.0) then
              nigno = nigno + 1
              cigno(nigno) = clong(:icomma-1)
              ligno(nigno) = icomma-1
              clong = clong(icomma+1:)
              cigno(nigno) = touppr(cigno(nigno)) 
              goto 60
           endif
           nigno = nigno + 1
           ligno(nigno) = index(clong,' ')-1
           cigno(nigno) = clong(:ligno(nigno))
           cigno(nigno) = touppr(cigno(nigno)) 
           if(log) write(6,'(A)') ' Flow --> Ignore modules:'
           if(log) write(6,'(10x,6a)') (cigno(i),i=1,nigno)
         else if(key.eq.'g') then
           if(argval(3:3).eq.' ') then
              cgraph = 'flow.ps'
              lgraph = 7
           else
              cgraph = argval(3:)
              lgraph = index(cgraph,' ')-1 
           endif
           inquire(file=cgraph(:lgraph),exist=fexist)
           if(fexist) then
              open(loutch,file=cgraph(:lgraph),status='old')
              close(loutch,status='delete')
           endif
           if(log) write(6,'(A)') ' Flow --> Graphical Chart: '//
     &             cgraph(:lgraph) 
           lchrt = .true.
           loutch = 96
           open(loutch,file=cgraph(:lgraph),status='new',err=900)
         else if(key.eq.'n') then
           ctree = argval(3:)
           ltre = lenocc(ctree)
           if(ltre.le.0) then
             if(log) write(6,'(A)') ' Flow --> No node name for -n'
             goto 900
           endif
           ctree = touppr(ctree)
           if(log) write(6,'(A)') ' Flow --> Start from node: '//
     &             ctree(:ltre)
         else 
           write(6,'(A)') ' Flow --> Unrecognized qualifier '//key
           goto 900
         endif
  500 continue
c
c Call Flow
c
      call prodes
c
      if(lcomm) close(loutco)
      if(ltree) close(loutre)
      if(lchrt) close(loutch)
      close(lintre)
      goto 2000
c
  900 write(6,'(A)') ' Flow aborted'     
      stop 1
 2000 CONTINUE
      END
