;;; -*- Log: C.Log -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;; If you want to use this code or any part of CMU Common Lisp, please contact
;;; Scott Fahlman or slisp-group@cs.cmu.edu.
;;;
(ext:file-comment
  "$Header: exports.lisp,v 1.76 92/03/11 10:02:15 wlott Exp $")
;;;
;;; **********************************************************************
;;;
;;; All the stuff necessary to export various symbols from various packages.
;;;

(in-package "LISP")

(if (find-package "XLIB")
    (rename-package "XLIB" "XLIB" '("OLD-XLIB"))
    (make-package "XLIB" :nicknames '("OLD-XLIB") :use nil))
(if (find-package "ASSEMBLER")
    (rename-package "ASSEMBLER" "ASSEMBLER" '("ASSEM"))
    (make-package "ASSEMBLER" :nicknames '("ASSEM") :use nil))
(if (find-package "C-CALL")
    (rename-package "C-CALL" "C-CALL" 'nil)
    (make-package "C-CALL" :nicknames 'nil :use nil))
(if (find-package "INSPECT")
    (rename-package "INSPECT" "INSPECT" 'nil)
    (make-package "INSPECT" :nicknames 'nil :use nil))
(if (find-package "BIGNUM")
    (rename-package "BIGNUM" "BIGNUM" 'nil)
    (make-package "BIGNUM" :nicknames 'nil :use nil))
(if (find-package "WALKER")
    (rename-package "WALKER" "WALKER" 'nil)
    (make-package "WALKER" :nicknames 'nil :use nil))
(if (find-package "UNIX")
    (rename-package "UNIX" "UNIX" 'nil)
    (make-package "UNIX" :nicknames 'nil :use nil))
(if (find-package "PCL")
    (rename-package "PCL" "PCL" 'nil)
    (make-package "PCL" :nicknames 'nil :use nil))
(shadow '("DOCUMENTATION" "DESTRUCTURING-BIND") "PCL")
(if (find-package "FORMAT")
    (rename-package "FORMAT" "FORMAT" 'nil)
    (make-package "FORMAT" :nicknames 'nil :use nil))
(if (find-package "HEMLOCK")
    (rename-package "HEMLOCK" "HEMLOCK" '("ED"))
    (make-package "HEMLOCK" :nicknames '("ED") :use nil))
(if (find-package "SPELL")
    (rename-package "SPELL" "SPELL" 'nil)
    (make-package "SPELL" :nicknames 'nil :use nil))
(if (find-package "COMMON-LISP")
    (rename-package "COMMON-LISP" "COMMON-LISP" '("CL" "LISP"))
    (make-package "LISP" :nicknames 'nil :use nil))
(if (find-package "EVAL")
    (rename-package "EVAL" "EVAL" 'nil)
    (make-package "EVAL" :nicknames 'nil :use nil))
(if (find-package "ITERATE")
    (rename-package "ITERATE" "ITERATE" 'nil)
    (make-package "ITERATE" :nicknames 'nil :use nil))
#+pmax
(if (find-package "MIPS")
    (rename-package "MIPS" "MIPS" '("VM" "OLD-MIPS"))
    (make-package "MIPS" :nicknames '("VM" "OLD-MIPS") :use nil))
#+sparc
(if (find-package "SPARC")
    (rename-package "SPARC" "SPARC" '("VM" "OLD-SPARC"))
    (make-package "SPARC" :nicknames '("VM" "OLD-SPARC") :use nil))
#+ibmrt
(if (find-package "RT")
    (rename-package "RT" "RT" '("VM" "OLD-RT"))
    (make-package "RT" :nicknames '("VM" "OLD-RT") :use nil))
(if (find-package "CONDITIONS")
    (rename-package "CONDITIONS" "CONDITIONS" 'nil)
    (make-package "CONDITIONS" :nicknames 'nil :use nil))
(if (find-package "DISASSEM")
    (rename-package "DISASSEM" "DISASSEM" 'nil)
    (make-package "DISASSEM" :nicknames 'nil :use nil))
(if (find-package "DEBUG")
    (rename-package "DEBUG" "DEBUG" 'nil)
    (make-package "DEBUG" :nicknames 'nil :use nil))
(if (find-package "EXTENSIONS")
    (rename-package "EXTENSIONS" "EXTENSIONS" '("EXT"))
    (make-package "EXTENSIONS" :nicknames '("EXT") :use nil))
(if (find-package "LOOP")
    (rename-package "LOOP" "LOOP" 'nil)
    (make-package "LOOP" :nicknames 'nil :use nil))
(if (find-package "HEMLOCK-INTERNALS")
    (rename-package "HEMLOCK-INTERNALS" "HEMLOCK-INTERNALS" '("HI"))
    (make-package "HEMLOCK-INTERNALS" :nicknames '("HI") :use nil))
(if (find-package "DEBUG-INTERNALS")
    (rename-package "DEBUG-INTERNALS" "DEBUG-INTERNALS" '("DI"))
    (make-package "DEBUG-INTERNALS" :nicknames '("DI") :use nil))
(if (find-package "C")
    (rename-package "C" "C" '("OLD-C"))
    (make-package "C" :nicknames '("OLD-C") :use nil))
(if (find-package "DIRED")
    (rename-package "DIRED" "DIRED" 'nil)
    (make-package "DIRED" :nicknames 'nil :use nil))
(shadow '("DELETE-FILE" "RENAME-FILE") "DIRED")
(if (find-package "WIRE")
    (rename-package "WIRE" "WIRE" 'nil)
    (make-package "WIRE" :nicknames 'nil :use nil))
(if (find-package "PRETTY-PRINT")
    (rename-package "PRETTY-PRINT" "PRETTY-PRINT" '("PP"))
    (make-package "PRETTY-PRINT" :nicknames '("PP") :use nil))
(if (find-package "SYSTEM")
    (rename-package "SYSTEM" "SYSTEM" '("SYS"))
    (make-package "SYSTEM" :nicknames '("SYS") :use nil))
(if (find-package "ALIEN")
    (rename-package "ALIEN" "ALIEN" 'nil)
    (make-package "ALIEN" :nicknames 'nil :use nil))
(if (find-package "ALIEN-INTERNALS")
    (rename-package "ALIEN-INTERNALS" "ALIEN-INTERNALS" 'nil)
    (make-package "ALIEN-INTERNALS" :nicknames 'nil :use nil))
(if (find-package "PROFILE")
    (rename-package "PROFILE" "PROFILE" 'nil)
    (make-package "PROFILE" :nicknames 'nil :use nil))
(if (find-package "COMMON-LISP-USER")
    (rename-package "COMMON-LISP-USER" "COMMON-LISP-USER" '("CL-USER" "USER"))
    (make-package "COMMON-LISP-USER" :nicknames '("CL-USER" "USER") :use nil))
(if (find-package "KERNEL")
    (rename-package "KERNEL" "KERNEL" 'nil)
    (make-package "KERNEL" :nicknames 'nil :use nil))
(use-package '("LISP") "XLIB")
(use-package '("LISP" "C" "EXTENSIONS" "KERNEL") "ASSEMBLER")
(use-package '("SYSTEM" "ALIEN-INTERNALS" "ALIEN" "LISP") "C-CALL")
(use-package '("KERNEL" "EXTENSIONS" "LISP") "INSPECT")
(use-package '("LISP" "KERNEL") "BIGNUM")
(use-package '("LISP") "WALKER")
(use-package '("LISP") "UNIX")
(use-package '("WALKER" "ITERATE" "LISP") "PCL")
(use-package '("KERNEL" "LISP" "EXTENSIONS") "FORMAT")
(use-package '("LISP" "HEMLOCK-INTERNALS" "EXTENSIONS" "SYSTEM") "HEMLOCK")
(use-package '("LISP" "EXTENSIONS" "SYSTEM") "SPELL")
(use-package '("EXTENSIONS" "SYSTEM" "DEBUG" "KERNEL" "BIGNUM") "LISP")
(use-package '("LISP" "KERNEL") "EVAL")
(use-package '("LISP" "WALKER") "ITERATE")
(use-package
 '("C-CALL" "ALIEN-INTERNALS" "ALIEN" "BIGNUM" "LISP" "KERNEL" "EXTENSIONS"
   "SYSTEM" "ASSEMBLER" "C")
 "VM")
(use-package '("EXTENSIONS" "LISP") "CONDITIONS")
(use-package '("LISP") "DISASSEM")
(use-package '("EXTENSIONS" "LISP" "SYSTEM") "DEBUG")
(use-package '("C-CALL" "ALIEN" "LISP" "SYSTEM") "EXTENSIONS")
(use-package '("LISP") "LOOP")
(use-package '("LISP" "SYSTEM" "EXTENSIONS") "HEMLOCK-INTERNALS")
(use-package '("LISP" "SYSTEM" "EXTENSIONS" "KERNEL") "DEBUG-INTERNALS")
(use-package
 '("ALIEN-INTERNALS" "ALIEN" "LISP" "EXTENSIONS" "KERNEL" "SYSTEM" "BIGNUM"
   "ASSEMBLER")
 "C")
(use-package '("LISP") "DIRED")
(use-package '("LISP") "WIRE")
(use-package '("KERNEL" "EXTENSIONS" "LISP") "PRETTY-PRINT")
(use-package '("EXTENSIONS" "LISP") "SYSTEM")
(use-package '("SYSTEM" "EXTENSIONS" "LISP") "ALIEN")
(use-package '("LISP") "ALIEN-INTERNALS")
(use-package '("LISP") "PROFILE")
(use-package '("PCL" "EXTENSIONS" "LISP") "COMMON-LISP-USER")
(use-package '("ALIEN-INTERNALS" "LISP" "EXTENSIONS" "SYSTEM" "BIGNUM")
             "KERNEL")
(intern "TYPE-ERROR" "LISP")
(defpackage "XLIB"
            (:import-from "LISP" "TYPE-ERROR")
            (:export "*VERSION*" "ACCESS-CONTROL" "ACCESS-ERROR" "ACCESS-HOSTS"
             "ACTIVATE-SCREEN-SAVER" "ADD-ACCESS-HOST" "ADD-RESOURCE"
             "ADD-TO-SAVE-SET" "ALIST" "ALLOC-COLOR" "ALLOC-COLOR-CELLS"
             "ALLOC-COLOR-PLANES" "ALLOC-ERROR" "ALLOW-EVENTS" "ANGLE"
             "ARC-SEQ" "ARRAY-INDEX" "ATOM-ERROR" "ATOM-NAME" "BELL"
             "BIT-GRAVITY" "BITMAP" "BITMAP-FORMAT" "BITMAP-FORMAT-LSB-FIRST-P"
             "BITMAP-FORMAT-P" "BITMAP-FORMAT-PAD" "BITMAP-FORMAT-UNIT"
             "BITMAP-IMAGE" "BOOLE-CONSTANT" "BOOLEAN" "CARD16" "CARD29"
             "CARD32" "CARD8" "CARD8->CHAR" "CHANGE-ACTIVE-POINTER-GRAB"
             "CHANGE-KEYBOARD-CONTROL" "CHANGE-KEYBOARD-MAPPING"
             "CHANGE-POINTER-CONTROL" "CHANGE-PROPERTY" "CHAR->CARD8"
             "CHAR-ASCENT" "CHAR-ATTRIBUTES" "CHAR-DESCENT" "CHAR-LEFT-BEARING"
             "CHAR-RIGHT-BEARING" "CHAR-WIDTH" "CHARACTER->KEYSYMS"
             "CHARACTER-IN-MAP-P" "CIRCULATE-WINDOW-DOWN" "CIRCULATE-WINDOW-UP"
             "CLEAR-AREA" "CLOSE-DISPLAY" "CLOSE-DOWN-MODE" "CLOSE-FONT"
             "CLOSED-DISPLAY" "COLOR" "COLOR-BLUE" "COLOR-GREEN" "COLOR-P"
             "COLOR-RED" "COLOR-RGB" "COLORMAP" "COLORMAP-DISPLAY"
             "COLORMAP-EQUAL" "COLORMAP-ERROR" "COLORMAP-ID" "COLORMAP-P"
             "COLORMAP-PLIST" "COLORMAP-VISUAL-INFO" "CONNECTION-FAILURE"
             "CONVERT-SELECTION" "COPY-AREA" "COPY-COLORMAP-AND-FREE"
             "COPY-GCONTEXT" "COPY-GCONTEXT-COMPONENTS" "COPY-IMAGE"
             "COPY-PLANE" "CREATE-COLORMAP" "CREATE-CURSOR" "CREATE-GCONTEXT"
             "CREATE-GLYPH-CURSOR" "CREATE-IMAGE" "CREATE-PIXMAP"
             "CREATE-WINDOW" "CURSOR" "CURSOR-DISPLAY" "CURSOR-EQUAL"
             "CURSOR-ERROR" "CURSOR-ID" "CURSOR-P" "CURSOR-PLIST" "CUT-BUFFER"
             "DECLARE-EVENT" "DECODE-CORE-ERROR" "DEFAULT-ERROR-HANDLER"
             "DEFAULT-KEYSYM-INDEX" "DEFAULT-KEYSYM-TRANSLATE" "DEFINE-ERROR"
             "DEFINE-EXTENSION" "DEFINE-GCONTEXT-ACCESSOR" "DEFINE-KEYSYM"
             "DEFINE-KEYSYM-SET" "DELETE-PROPERTY" "DELETE-RESOURCE"
             "DESTROY-SUBWINDOWS" "DESTROY-WINDOW" "DEVICE-BUSY"
             "DEVICE-EVENT-MASK" "DEVICE-EVENT-MASK-CLASS"
             "DISCARD-CURRENT-EVENT" "DISCARD-FONT-INFO" "DISPLAY"
             "DISPLAY-AFTER-FUNCTION" "DISPLAY-AUTHORIZATION-DATA"
             "DISPLAY-AUTHORIZATION-NAME" "DISPLAY-BITMAP-FORMAT"
             "DISPLAY-BYTE-ORDER" "DISPLAY-DEFAULT-SCREEN" "DISPLAY-DISPLAY"
             "DISPLAY-ERROR-HANDLER" "DISPLAY-FINISH-OUTPUT"
             "DISPLAY-FORCE-OUTPUT" "DISPLAY-HOST" "DISPLAY-IMAGE-LSB-FIRST-P"
             "DISPLAY-INVOKE-AFTER-FUNCTION" "DISPLAY-KEYCODE-RANGE"
             "DISPLAY-MAX-KEYCODE" "DISPLAY-MAX-REQUEST-LENGTH"
             "DISPLAY-MIN-KEYCODE" "DISPLAY-MOTION-BUFFER-SIZE"
             "DISPLAY-NSCREENS" "DISPLAY-P" "DISPLAY-PIXMAP-FORMATS"
             "DISPLAY-PLIST" "DISPLAY-PROTOCOL-MAJOR-VERSION"
             "DISPLAY-PROTOCOL-MINOR-VERSION" "DISPLAY-PROTOCOL-VERSION"
             "DISPLAY-RELEASE-NUMBER" "DISPLAY-REPORT-ASYNCHRONOUS-ERRORS"
             "DISPLAY-RESOURCE-ID-BASE" "DISPLAY-RESOURCE-ID-MASK"
             "DISPLAY-ROOTS" "DISPLAY-VENDOR" "DISPLAY-VENDOR-NAME"
             "DISPLAY-XDEFAULTS" "DISPLAY-XID" "DRAW-ARC" "DRAW-ARCS"
             "DRAW-DIRECTION" "DRAW-GLYPH" "DRAW-GLYPHS" "DRAW-IMAGE-GLYPH"
             "DRAW-IMAGE-GLYPHS" "DRAW-LINE" "DRAW-LINES" "DRAW-POINT"
             "DRAW-POINTS" "DRAW-RECTANGLE" "DRAW-RECTANGLES" "DRAW-SEGMENTS"
             "DRAWABLE" "DRAWABLE-BORDER-WIDTH" "DRAWABLE-DEPTH"
             "DRAWABLE-DISPLAY" "DRAWABLE-EQUAL" "DRAWABLE-ERROR"
             "DRAWABLE-HEIGHT" "DRAWABLE-ID" "DRAWABLE-P" "DRAWABLE-PLIST"
             "DRAWABLE-ROOT" "DRAWABLE-WIDTH" "DRAWABLE-X" "DRAWABLE-Y"
             "ERROR-KEY" "EVENT-CASE" "EVENT-COND" "EVENT-HANDLER" "EVENT-KEY"
             "EVENT-LISTEN" "EVENT-MASK" "EVENT-MASK-CLASS" "EXTENSION-OPCODE"
             "FIND-ATOM" "FONT" "FONT-ALL-CHARS-EXIST-P" "FONT-ASCENT"
             "FONT-DEFAULT-CHAR" "FONT-DESCENT" "FONT-DIRECTION" "FONT-DISPLAY"
             "FONT-EQUAL" "FONT-ERROR" "FONT-ID" "FONT-MAX-BYTE1"
             "FONT-MAX-BYTE2" "FONT-MAX-CHAR" "FONT-MIN-BYTE1" "FONT-MIN-BYTE2"
             "FONT-MIN-CHAR" "FONT-NAME" "FONT-P" "FONT-PATH" "FONT-PLIST"
             "FONT-PROPERTIES" "FONT-PROPERTY" "FONTABLE"
             "FORCE-GCONTEXT-CHANGES" "FREE-COLORMAP" "FREE-COLORS"
             "FREE-CURSOR" "FREE-GCONTEXT" "FREE-PIXMAP" "GCONTEXT"
             "GCONTEXT-ARC-MODE" "GCONTEXT-BACKGROUND" "GCONTEXT-CACHE-P"
             "GCONTEXT-CAP-STYLE" "GCONTEXT-CLIP-MASK" "GCONTEXT-CLIP-ORDERING"
             "GCONTEXT-CLIP-X" "GCONTEXT-CLIP-Y" "GCONTEXT-DASH-OFFSET"
             "GCONTEXT-DASHES" "GCONTEXT-DISPLAY" "GCONTEXT-EQUAL"
             "GCONTEXT-ERROR" "GCONTEXT-EXPOSURES" "GCONTEXT-FILL-RULE"
             "GCONTEXT-FILL-STYLE" "GCONTEXT-FONT" "GCONTEXT-FOREGROUND"
             "GCONTEXT-FUNCTION" "GCONTEXT-ID" "GCONTEXT-JOIN-STYLE"
             "GCONTEXT-KEY" "GCONTEXT-LINE-STYLE" "GCONTEXT-LINE-WIDTH"
             "GCONTEXT-P" "GCONTEXT-PLANE-MASK" "GCONTEXT-PLIST"
             "GCONTEXT-STIPPLE" "GCONTEXT-SUBWINDOW-MODE" "GCONTEXT-TILE"
             "GCONTEXT-TS-X" "GCONTEXT-TS-Y" "GET-EXTERNAL-EVENT-CODE"
             "GET-IMAGE" "GET-PROPERTY" "GET-RAW-IMAGE" "GET-RESOURCE"
             "GET-SEARCH-RESOURCE" "GET-SEARCH-TABLE" "GET-STANDARD-COLORMAP"
             "GET-WM-CLASS" "GLOBAL-POINTER-POSITION" "GRAB-BUTTON" "GRAB-KEY"
             "GRAB-KEYBOARD" "GRAB-POINTER" "GRAB-SERVER" "GRAB-STATUS"
             "ICON-SIZES" "ICONIFY-WINDOW" "ID-CHOICE-ERROR"
             "ILLEGAL-REQUEST-ERROR" "IMAGE" "IMAGE-BLUE-MASK" "IMAGE-DEPTH"
             "IMAGE-GREEN-MASK" "IMAGE-HEIGHT" "IMAGE-NAME" "IMAGE-PIXMAP"
             "IMAGE-PLIST" "IMAGE-RED-MASK" "IMAGE-WIDTH" "IMAGE-X"
             "IMAGE-X-HOT" "IMAGE-X-P" "IMAGE-XY" "IMAGE-XY-BITMAP-LIST"
             "IMAGE-XY-P" "IMAGE-Y-HOT" "IMAGE-Z" "IMAGE-Z-BITS-PER-PIXEL"
             "IMAGE-Z-P" "IMAGE-Z-PIXARRAY" "IMPLEMENTATION-ERROR"
             "INPUT-FOCUS" "INSTALL-COLORMAP" "INSTALLED-COLORMAPS" "INT16"
             "INT32" "INT8" "INTERN-ATOM" "INVALID-FONT" "KEYBOARD-CONTROL"
             "KEYBOARD-MAPPING" "KEYCODE->CHARACTER" "KEYCODE->KEYSYM" "KEYSYM"
             "KEYSYM->CHARACTER" "KEYSYM->KEYCODES" "KEYSYM-IN-MAP-P"
             "KEYSYM-SET" "KILL-CLIENT" "KILL-TEMPORARY-CLIENTS" "LENGTH-ERROR"
             "LIST-EXTENSIONS" "LIST-FONT-NAMES" "LIST-FONTS" "LIST-PROPERTIES"
             "LOAD-CLX" "LOOKUP-COLOR" "LOOKUP-ERROR" "MAKE-COLOR"
             "MAKE-EVENT-HANDLERS" "MAKE-EVENT-KEYS" "MAKE-EVENT-MASK"
             "MAKE-RESOURCE-DATABASE" "MAKE-STATE-KEYS" "MAKE-STATE-MASK"
             "MAKE-WM-HINTS" "MAKE-WM-SIZE-HINTS" "MAP-RESOURCE"
             "MAP-SUBWINDOWS" "MAP-WINDOW" "MAPPING-NOTIFY" "MASK16" "MASK32"
             "MATCH-ERROR" "MAX-CHAR-ASCENT" "MAX-CHAR-ATTRIBUTES"
             "MAX-CHAR-DESCENT" "MAX-CHAR-LEFT-BEARING"
             "MAX-CHAR-RIGHT-BEARING" "MAX-CHAR-WIDTH" "MERGE-RESOURCES"
             "MIN-CHAR-ASCENT" "MIN-CHAR-ATTRIBUTES" "MIN-CHAR-DESCENT"
             "MIN-CHAR-LEFT-BEARING" "MIN-CHAR-RIGHT-BEARING" "MIN-CHAR-WIDTH"
             "MISSING-PARAMETER" "MODIFIER-KEY" "MODIFIER-MAPPING"
             "MODIFIER-MASK" "MOTION-EVENTS" "NAME-ERROR" "NO-OPERATION"
             "OPEN-DISPLAY" "OPEN-FONT" "PIXARRAY" "PIXEL" "PIXMAP"
             "PIXMAP-DISPLAY" "PIXMAP-EQUAL" "PIXMAP-ERROR" "PIXMAP-FORMAT"
             "PIXMAP-FORMAT-BITS-PER-PIXEL" "PIXMAP-FORMAT-DEPTH"
             "PIXMAP-FORMAT-P" "PIXMAP-FORMAT-SCANLINE-PAD" "PIXMAP-ID"
             "PIXMAP-P" "PIXMAP-PLIST" "POINT-SEQ" "POINTER-CONTROL"
             "POINTER-EVENT-MASK" "POINTER-EVENT-MASK-CLASS" "POINTER-MAPPING"
             "POINTER-POSITION" "PROCESS-EVENT" "PUT-IMAGE" "PUT-RAW-IMAGE"
             "QUERY-BEST-CURSOR" "QUERY-BEST-STIPPLE" "QUERY-BEST-TILE"
             "QUERY-COLORS" "QUERY-EXTENSION" "QUERY-KEYMAP" "QUERY-POINTER"
             "QUERY-TREE" "QUEUE-EVENT" "READ-BITMAP-FILE" "READ-RESOURCES"
             "RECOLOR-CURSOR" "RECT-SEQ" "REMOVE-ACCESS-HOST"
             "REMOVE-FROM-SAVE-SET" "REPARENT-WINDOW" "REPEAT-SEQ"
             "REPLY-LENGTH-ERROR" "REPLY-TIMEOUT" "REQUEST-ERROR"
             "RESET-SCREEN-SAVER" "RESOURCE-DATABASE"
             "RESOURCE-DATABASE-TIMESTAMP" "RESOURCE-ERROR" "RESOURCE-ID"
             "RESOURCE-KEY" "RGB-COLORMAPS" "RGB-VAL" "ROOT-RESOURCES"
             "ROTATE-CUT-BUFFERS" "ROTATE-PROPERTIES" "SCREEN"
             "SCREEN-BACKING-STORES" "SCREEN-BLACK-PIXEL"
             "SCREEN-DEFAULT-COLORMAP" "SCREEN-DEPTHS"
             "SCREEN-EVENT-MASK-AT-OPEN" "SCREEN-HEIGHT"
             "SCREEN-HEIGHT-IN-MILLIMETERS" "SCREEN-MAX-INSTALLED-MAPS"
             "SCREEN-MIN-INSTALLED-MAPS" "SCREEN-P" "SCREEN-PLIST"
             "SCREEN-ROOT" "SCREEN-ROOT-DEPTH" "SCREEN-ROOT-VISUAL"
             "SCREEN-ROOT-VISUAL-INFO" "SCREEN-SAVE-UNDERS-P" "SCREEN-SAVER"
             "SCREEN-WHITE-PIXEL" "SCREEN-WIDTH" "SCREEN-WIDTH-IN-MILLIMETERS"
             "SEG-SEQ" "SELECTION-OWNER" "SEND-EVENT" "SEQUENCE-ERROR"
             "SET-ACCESS-CONTROL" "SET-CLOSE-DOWN-MODE" "SET-INPUT-FOCUS"
             "SET-MODIFIER-MAPPING" "SET-POINTER-MAPPING" "SET-SCREEN-SAVER"
             "SET-SELECTION-OWNER" "SET-STANDARD-COLORMAP"
             "SET-STANDARD-PROPERTIES" "SET-WM-CLASS" "SET-WM-PROPERTIES"
             "SET-WM-RESOURCES" "STATE-KEYSYM-P" "STATE-MASK-KEY" "STORE-COLOR"
             "STORE-COLORS" "STRINGABLE" "TEXT-EXTENTS" "TEXT-WIDTH"
             "TIMESTAMP" "TRANSIENT-FOR" "TRANSLATE-COORDINATES"
             "TRANSLATE-DEFAULT" "TRANSLATION-FUNCTION" "TYPE-ERROR"
             "UNDEFINE-KEYSYM" "UNEXPECTED-REPLY" "UNGRAB-BUTTON" "UNGRAB-KEY"
             "UNGRAB-KEYBOARD" "UNGRAB-POINTER" "UNGRAB-SERVER"
             "UNINSTALL-COLORMAP" "UNKNOWN-ERROR" "UNMAP-SUBWINDOWS"
             "UNMAP-WINDOW" "VALUE-ERROR" "VISUAL-INFO"
             "VISUAL-INFO-BITS-PER-RGB" "VISUAL-INFO-BLUE-MASK"
             "VISUAL-INFO-CLASS" "VISUAL-INFO-COLORMAP-ENTRIES"
             "VISUAL-INFO-DISPLAY" "VISUAL-INFO-GREEN-MASK" "VISUAL-INFO-ID"
             "VISUAL-INFO-P" "VISUAL-INFO-PLIST" "VISUAL-INFO-RED-MASK"
             "WARP-POINTER" "WARP-POINTER-IF-INSIDE" "WARP-POINTER-RELATIVE"
             "WARP-POINTER-RELATIVE-IF-INSIDE" "WIN-GRAVITY" "WINDOW"
             "WINDOW-ALL-EVENT-MASKS" "WINDOW-BACKGROUND"
             "WINDOW-BACKING-PIXEL" "WINDOW-BACKING-PLANES"
             "WINDOW-BACKING-STORE" "WINDOW-BIT-GRAVITY" "WINDOW-BORDER"
             "WINDOW-CLASS" "WINDOW-COLORMAP" "WINDOW-COLORMAP-INSTALLED-P"
             "WINDOW-CURSOR" "WINDOW-DISPLAY" "WINDOW-DO-NOT-PROPAGATE-MASK"
             "WINDOW-EQUAL" "WINDOW-ERROR" "WINDOW-EVENT-MASK" "WINDOW-GRAVITY"
             "WINDOW-ID" "WINDOW-MAP-STATE" "WINDOW-OVERRIDE-REDIRECT"
             "WINDOW-P" "WINDOW-PLIST" "WINDOW-PRIORITY" "WINDOW-SAVE-UNDER"
             "WINDOW-VISUAL" "WINDOW-VISUAL-INFO" "WITH-DISPLAY"
             "WITH-EVENT-QUEUE" "WITH-GCONTEXT" "WITH-SERVER-GRABBED"
             "WITH-STATE" "WITHDRAW-WINDOW" "WM-CLIENT-MACHINE"
             "WM-COLORMAP-WINDOWS" "WM-COMMAND" "WM-HINTS" "WM-HINTS-FLAGS"
             "WM-HINTS-ICON-MASK" "WM-HINTS-ICON-PIXMAP" "WM-HINTS-ICON-WINDOW"
             "WM-HINTS-ICON-X" "WM-HINTS-ICON-Y" "WM-HINTS-INITIAL-STATE"
             "WM-HINTS-INPUT" "WM-HINTS-P" "WM-HINTS-WINDOW-GROUP"
             "WM-ICON-NAME" "WM-NAME" "WM-NORMAL-HINTS" "WM-PROTOCOLS"
             "WM-RESOURCES" "WM-SIZE-HINTS" "WM-SIZE-HINTS-BASE-HEIGHT"
             "WM-SIZE-HINTS-BASE-WIDTH" "WM-SIZE-HINTS-HEIGHT"
             "WM-SIZE-HINTS-HEIGHT-INC" "WM-SIZE-HINTS-MAX-ASPECT"
             "WM-SIZE-HINTS-MAX-HEIGHT" "WM-SIZE-HINTS-MAX-WIDTH"
             "WM-SIZE-HINTS-MIN-ASPECT" "WM-SIZE-HINTS-MIN-HEIGHT"
             "WM-SIZE-HINTS-MIN-WIDTH" "WM-SIZE-HINTS-P"
             "WM-SIZE-HINTS-USER-SPECIFIED-POSITION-P"
             "WM-SIZE-HINTS-USER-SPECIFIED-SIZE-P" "WM-SIZE-HINTS-WIDTH"
             "WM-SIZE-HINTS-WIDTH-INC" "WM-SIZE-HINTS-WIN-GRAVITY"
             "WM-SIZE-HINTS-X" "WM-SIZE-HINTS-Y" "WM-ZOOM-HINTS"
             "WRITE-BITMAP-FILE" "WRITE-RESOURCES" "XATOM"))
(dolist
    (name
     '("BACKEND-SB-LIST" "DO-LIVE-TNS" "FINITE-SB" "FINITE-SB-LIVE-TNS"
       "IR2-BLOCK-BLOCK" "IR2-BLOCK-LIVE-IN" "MAKE-INSTRUCTION" "PRINT-TN"
       "REALLY-MAKE-INSTRUCTION" "SB-KIND" "SC-ELEMENT-SIZE" "TN" "TN-KIND"
       "TN-NUMBER" "TN-READS" "TN-WRITES" "UNMAKE-INSTRUCTION" "VOP" "VOP-ARGS"
       "VOP-BLOCK" "VOP-INFO" "VOP-INFO-ARG-COSTS" "VOP-INFO-ARG-TYPES"
       "VOP-INFO-MOVE-ARGS" "VOP-INFO-NAME" "VOP-INFO-RESULT-COSTS"
       "VOP-INFO-SAVE-P" "VOP-REFS" "VOP-RESULTS" "VOP-SAVE-SET" "VOP-TEMPS"))
  (intern name "C"))
(defpackage "ASSEMBLER"
            (:import-from "C" "BACKEND-SB-LIST" "DO-LIVE-TNS" "FINITE-SB"
             "FINITE-SB-LIVE-TNS" "IR2-BLOCK-BLOCK" "IR2-BLOCK-LIVE-IN"
             "MAKE-INSTRUCTION" "PRINT-TN" "REALLY-MAKE-INSTRUCTION" "SB-KIND"
             "SC-ELEMENT-SIZE" "TN" "TN-KIND" "TN-NUMBER" "TN-READS"
             "TN-WRITES" "UNMAKE-INSTRUCTION" "VOP" "VOP-ARGS" "VOP-BLOCK"
             "VOP-INFO" "VOP-INFO-ARG-COSTS" "VOP-INFO-ARG-TYPES"
             "VOP-INFO-MOVE-ARGS" "VOP-INFO-NAME" "VOP-INFO-RESULT-COSTS"
             "VOP-INFO-SAVE-P" "VOP-REFS" "VOP-RESULTS" "VOP-SAVE-SET"
             "VOP-TEMPS")
            (:export "*CURRENT-POSITION*" "ALIGN" "ASSEMBLE" "ASSEMBLY-CALL"
             "COUNT-INSTRUCTIONS" "DEFINE-ARGUMENT-TYPE" "DEFINE-FIXUP-TYPE"
             "DEFINE-FORMAT" "DEFINE-INSTRUCTION" "DEFINE-PSEUDO-INSTRUCTION"
             "DEFINE-RANDOM-RESOURCES" "DEFINE-REGISTER-FILE"
             "DEFINE-RESOURCES" "DELAYED-BRANCH" "DELAYED-LOAD" "DUMP-SEGMENT"
             "EMIT-CODE-VECTOR" "EMIT-LABEL" "EXPAND-PSEUDO-INSTRUCTIONS"
             "FINALIZE-SEGMENT" "FIXUP" "FIXUP-FLAVOR" "FIXUP-NAME"
             "FIXUP-OFFSET" "FIXUP-P" "GEN-LABEL" "INSERT-SEGMENT" "INST"
             "INSTRUCTION-ARGUMENT-ONE" "INSTRUCTION-ARGUMENT-THREE"
             "INSTRUCTION-ARGUMENT-TWO" "INSTRUCTION-ARGUMENT-ZERO"
             "INSTRUCTION-CONSTANT-ONE" "INSTRUCTION-CONSTANT-TWO"
             "INSTRUCTION-CONSTANT-ZERO" "INSTRUCTION-RESULT-ZERO" "LABEL"
             "LABEL-ID" "LABEL-POSITION" "MAKE-FIXUP" "MAKE-SEGMENT" "NOP"
             "NUKE-SEGMENT" "OPTIMIZE-SEGMENT" "RELATIVE-BRANCH"
             "SEGMENT-CHECK-REGISTERS" "UNCONDITIONAL-BRANCH"))
(dolist (name '("CHAR" "FLOAT")) (intern name "LISP"))
(defpackage "C-CALL"
            (:import-from "LISP" "CHAR" "FLOAT")
            (:export "C-STRING" "CHAR" "DOUBLE" "FLOAT" "INT" "LONG" "SHORT"
             "UNSIGNED-CHAR" "UNSIGNED-INT" "UNSIGNED-LONG" "UNSIGNED-SHORT"
             "VOID"))
(defpackage "INSPECT"
            (:export "*INTERFACE-STYLE*" "REMOVE-ALL-DISPLAYS"
             "REMOVE-OBJECT-DISPLAY" "SHOW-OBJECT"))
(defpackage "BIGNUM"
            (:export "%ADD-WITH-CARRY" "%ALLOCATE-BIGNUM" "%ASHL" "%ASHR"
             "%BIGNUM-LENGTH" "%BIGNUM-REF" "%BIGNUM-SET" "%BIGNUM-SET-LENGTH"
             "%DIGIT-0-OR-PLUSP" "%DIGIT-LOGICAL-SHIFT-RIGHT"
             "%FIXNUM-DIGIT-WITH-CORRECT-SIGN" "%FIXNUM-TO-DIGIT" "%FLOOR"
             "%LOGAND" "%LOGIOR" "%LOGNOT" "%LOGXOR" "%MULTIPLY"
             "%MULTIPLY-AND-ADD" "%SUBTRACT-WITH-BORROW" "ADD-BIGNUMS"
             "BIGNUM-ASHIFT-LEFT" "BIGNUM-ASHIFT-RIGHT" "BIGNUM-COMPARE"
             "BIGNUM-DEPOSIT-BYTE" "BIGNUM-ELEMENT-TYPE" "BIGNUM-GCD"
             "BIGNUM-INDEX" "BIGNUM-INTEGER-LENGTH" "BIGNUM-LOAD-BYTE"
             "BIGNUM-LOGCOUNT" "BIGNUM-LOGICAL-AND" "BIGNUM-LOGICAL-IOR"
             "BIGNUM-LOGICAL-NOT" "BIGNUM-LOGICAL-XOR" "BIGNUM-PLUS-P"
             "BIGNUM-TO-FLOAT" "BIGNUM-TRUNCATE" "BIGNUM-TYPE"
             "FLOAT-BIGNUM-RATIO" "MAKE-SMALL-BIGNUM"
             "MULTIPLY-BIGNUM-AND-FIXNUM" "MULTIPLY-BIGNUMS" "MULTIPLY-FIXNUMS"
             "NEGATE-BIGNUM" "SUBTRACT-BIGNUM"))
(defpackage "WALKER"
            (:export "*VARIABLE-DECLARATIONS*" "DEFINE-WALKER-TEMPLATE"
             "NESTED-WALK-FORM" "VARIABLE-DECLARATION"
             "VARIABLE-GLOBALLY-SPECIAL-P" "VARIABLE-LEXICAL-P"
             "VARIABLE-SPECIAL-P" "WALK-FORM"))
(defpackage "UNIX"
            (:export "CADDR-T" "D-INO" "D-NAME" "D-NAMLEN" "D-OFF" "D-RECLEN"
             "DADDR-T" "DEV-T" "DIRECT" "EXECGRP" "EXECOTH" "EXECOWN" "F-DUPFD"
             "F-GETFD" "F-GETFL" "F-GETOWN" "F-SETFD" "F-SETFL" "F-SETOWN"
             "FAPPEND" "FASYNC" "FCREAT" "FEXCL" "FIONREAD" "FNDELAY" "FTRUNC"
             "F_OK" "GET-UNIX-ERROR-MSG" "GID-T" "INO-T" "IT-INTERVAL"
             "IT-VALUE" "ITIMERVAL" "KBDCGET" "KBDCRESET" "KBDCRST" "KBDCSET"
             "KBDCSSTD" "KBDGCLICK" "KBDSCLICK" "KBDSGET" "L_INCR" "L_SET"
             "L_XTND" "OFF-T" "O_APPEND" "O_CREAT" "O_EXCL" "O_RDONLY" "O_RDWR"
             "O_TRUNC" "O_WRONLY" "READGRP" "READOTH" "READOWN" "RLIM-CUR"
             "RLIM-MAX" "RLIMIT" "RU-IDRSS" "RU-INBLOCK" "RU-ISRSS" "RU-IXRSS"
             "RU-MAJFLT" "RU-MAXRSS" "RU-MINFLT" "RU-MSGRCV" "RU-MSGSND"
             "RU-NIVCSW" "RU-NSIGNALS" "RU-NSWAP" "RU-NVCSW" "RU-OUBLOCK"
             "RU-STIME" "RU-UTIME" "RUSAGE_CHILDREN" "RUSAGE_SELF" "RUSEAGE"
             "R_OK" "S-IEXEC" "S-IFBLK" "S-IFCHR" "S-IFDIR" "S-IFLNK" "S-IFMT"
             "S-IFREG" "S-IFSOCK" "S-IREAD" "S-ISGID" "S-ISUID" "S-ISVTX"
             "S-IWRITE" "SAVETEXT" "SC-MASK" "SC-ONSTACK" "SC-PC" "SETGIDEXEC"
             "SETUIDEXEC" "SG-ERASE" "SG-FLAGS" "SG-ISPEED" "SG-KILL"
             "SG-OSPEED" "SGTTYB" "SIGCONTEXT" "SIZE-T" "ST-ATIME" "ST-BLKSIZE"
             "ST-BLOCKS" "ST-CTIME" "ST-DEV" "ST-GID" "ST-MODE" "ST-MTIME"
             "ST-NLINK" "ST-RDEV" "ST-SIZE" "ST-UID" "STAT" "SWBLK-T" "T-BRKC"
             "T-DSUSPC" "T-EOFC" "T-FLUSHC" "T-INTRC" "T-LNEXTC" "T-QUITC"
             "T-RPRNTC" "T-STARTC" "T-STOPC" "T-SUSPC" "T-WERASC" "TCHARS"
             "TERMINAL-SPEEDS" "TIME-T" "TIMEVAL" "TIMEZONE" "TIOCFLUSH"
             "TIOCGETC" "TIOCGETP" "TIOCGLTC" "TIOCGPGRP" "TIOCGWINSZ"
             "TIOCNOTTY" "TIOCSETC" "TIOCSETP" "TIOCSLTC" "TIOCSPGRP"
             "TIOCSWINSZ" "TTY-CBREAK" "TTY-CRMOD" "TTY-ECHO" "TTY-LCASE"
             "TTY-RAW" "TTY-TANDEM" "TV-SEC" "TV-USEC" "TZ-DSTTIME"
             "TZ-MINUTESWEST" "UID-T" "UNIX-ACCEPT" "UNIX-ACCESS" "UNIX-BIND"
             "UNIX-CHDIR" "UNIX-CHMOD" "UNIX-CHOWN" "UNIX-CLOSE" "UNIX-CONNECT"
             "UNIX-CREAT" "UNIX-CURRENT-DIRECTORY" "UNIX-DUP" "UNIX-DUP2"
             "UNIX-ERRNO" "UNIX-EXECVE" "UNIX-EXIT" "UNIX-FCHMOD" "UNIX-FCHOWN"
             "UNIX-FCNTL" "UNIX-FD" "UNIX-FILE-MODE" "UNIX-FORK" "UNIX-FSTAT"
             "UNIX-FSYNC" "UNIX-FTRUNCATE" "UNIX-GETDTABLESIZE" "UNIX-GETEGID"
             "UNIX-GETGID" "UNIX-GETHOSTID" "UNIX-GETHOSTNAME"
             "UNIX-GETPAGESIZE" "UNIX-GETPGRP" "UNIX-GETPID" "UNIX-GETPPID"
             "UNIX-GETRUSAGE" "UNIX-GETTIMEOFDAY" "UNIX-GETUID" "UNIX-GID"
             "UNIX-IOCTL" "UNIX-ISATTY" "UNIX-LINK" "UNIX-LISTEN" "UNIX-LSEEK"
             "UNIX-LSTAT" "UNIX-MKDIR" "UNIX-OPEN" "UNIX-PATHNAME" "UNIX-PID"
             "UNIX-PIPE" "UNIX-READ" "UNIX-READLINK" "UNIX-RECV" "UNIX-RENAME"
             "UNIX-RMDIR" "UNIX-SELECT" "UNIX-SEND" "UNIX-SETPGRP"
             "UNIX-SETREGID" "UNIX-SETREUID" "UNIX-SOCKET" "UNIX-STAT"
             "UNIX-SYMLINK" "UNIX-SYNC" "UNIX-TRUNCATE" "UNIX-TTYNAME"
             "UNIX-UID" "UNIX-UNLINK" "UNIX-UTIMES" "UNIX-WRITE" "WINSIZE"
             "WRITEGRP" "WRITEOTH" "WRITEOWN" "WS-COL" "WS-ROW" "WS-XPIXEL"
             "WS-YPIXEL" "W_OK" "X_OK"))
(intern "FUNCALLABLE-INSTANCE-P" "KERNEL")
(defpackage "PCL"
            (:import-from "KERNEL" "FUNCALLABLE-INSTANCE-P")
            (:export "ADD-METHOD" "BUILT-IN-CLASS" "CALL-METHOD"
             "CALL-NEXT-METHOD" "CHANGE-CLASS" "CLASS-NAME" "CLASS-OF"
             "COMPUTE-APPLICABLE-METHODS" "DEFCLASS" "DEFGENERIC"
             "DEFINE-METHOD-COMBINATION" "DEFMETHOD" "ENSURE-GENERIC-FUNCTION"
             "FIND-CLASS" "FIND-METHOD" "FUNCTION-KEYWORDS" "GENERIC-FLET"
             "GENERIC-LABELS" "INITIALIZE-INSTANCE" "INVALID-METHOD-ERROR"
             "MAKE-INSTANCE" "MAKE-INSTANCES-OBSOLETE"
             "METHOD-COMBINATION-ERROR" "METHOD-QUALIFIERS" "NEXT-METHOD-P"
             "NO-APPLICABLE-METHOD" "NO-NEXT-METHOD" "PRINT-OBJECT"
             "REINITIALIZE-INSTANCE" "REMOVE-METHOD" "SHARED-INITIALIZE"
             "SLOT-BOUNDP" "SLOT-EXISTS-P" "SLOT-MAKUNBOUND" "SLOT-MISSING"
             "SLOT-UNBOUND" "SLOT-VALUE" "STANDARD" "STANDARD-CLASS"
             "STANDARD-GENERIC-FUNCTION" "STANDARD-METHOD" "STANDARD-OBJECT"
             "STRUCTURE-CLASS" "UPDATE-INSTANCE-FOR-DIFFERENT-CLASS"
             "UPDATE-INSTANCE-FOR-REDEFINED-CLASS" "WITH-ACCESSORS"
             "WITH-ADDED-METHODS" "WITH-SLOTS"))
(defpackage "FORMAT")
(defpackage "HEMLOCK")
(defpackage "SPELL"
            (:export "CORRECT-SPELLING" "MAX-ENTRY-LENGTH"
             "MAYBE-READ-SPELL-DICTIONARY" "SPELL-ADD-ENTRY"
             "SPELL-COLLECT-CLOSE-WORDS" "SPELL-READ-DICTIONARY"
             "SPELL-REMOVE-ENTRY" "SPELL-ROOT-FLAGS" "SPELL-ROOT-WORD"
             "SPELL-TRY-WORD"))
(defpackage "LISP"
            (:export "&ALLOW-OTHER-KEYS" "&AUX" "&BODY" "&ENVIRONMENT" "&KEY"
             "&OPTIONAL" "&REST" "&WHOLE" "*" "**" "***" "*APPLYHOOK*"
             "*BREAK-ON-SIGNALS*" "*BREAK-ON-WARNINGS*"
             "*COMPILE-FILE-PATHNAME*" "*COMPILE-FILE-TRUENAME*"
             "*COMPILE-PRINT*" "*COMPILE-VERBOSE*" "*DEBUG-IO*"
             "*DEBUGGER-HOOK*" "*DEFAULT-PATHNAME-DEFAULTS*"
             "*DESCRIBE-INDENTATION*" "*DESCRIBE-LEVEL*"
             "*DESCRIBE-PRINT-LENGTH*" "*DESCRIBE-PRINT-LEVEL*"
             "*DESCRIBE-VERBOSE*" "*ERROR-OUTPUT*" "*EVALHOOK*" "*FEATURES*"
             "*GENSYM-COUNTER*" "*LOAD-VERBOSE*" "*MACROEXPAND-HOOK*"
             "*MODULES*" "*PACKAGE*" "*PRINT-ARRAY*" "*PRINT-BASE*"
             "*PRINT-CASE*" "*PRINT-CIRCLE*" "*PRINT-ESCAPE*" "*PRINT-GENSYM*"
             "*PRINT-LENGTH*" "*PRINT-LEVEL*" "*PRINT-LINES*"
             "*PRINT-MISER-WIDTH*" "*PRINT-PPRINT-DISPATCH*" "*PRINT-PRETTY*"
             "*PRINT-RADIX*" "*PRINT-READABLY*" "*PRINT-RIGHT-MARGIN*"
             "*QUERY-IO*" "*RANDOM-STATE*" "*READ-BASE*"
             "*READ-DEFAULT-FLOAT-FORMAT*" "*READ-EVAL*" "*READ-SUPPRESS*"
             "*READTABLE*" "*STANDARD-INPUT*" "*STANDARD-OUTPUT*"
             "*TERMINAL-IO*" "*TRACE-OUTPUT*" "+" "++" "+++" "-" "/" "//" "///"
             "/=" "1+" "1-" "<" "<=" "=" ">" ">=" "ABORT" "ABS" "ACONS" "ACOS"
             "ACOSH" "ADJOIN" "ADJUST-ARRAY" "ADJUSTABLE-ARRAY-P"
             "ALPHA-CHAR-P" "ALPHANUMERICP" "AND" "APPEND" "APPLY" "APPLYHOOK"
             "APROPOS" "APROPOS-LIST" "AREF" "ARITHMETIC-ERROR"
             "ARITHMETIC-ERROR-OPERANDS" "ARITHMETIC-ERROR-OPERATION" "ARRAY"
             "ARRAY-DIMENSION" "ARRAY-DIMENSION-LIMIT" "ARRAY-DIMENSIONS"
             "ARRAY-ELEMENT-TYPE" "ARRAY-HAS-FILL-POINTER-P"
             "ARRAY-IN-BOUNDS-P" "ARRAY-RANK" "ARRAY-RANK-LIMIT"
             "ARRAY-ROW-MAJOR-INDEX" "ARRAY-TOTAL-SIZE"
             "ARRAY-TOTAL-SIZE-LIMIT" "ARRAYP" "ASH" "ASIN" "ASINH" "ASSERT"
             "ASSOC" "ASSOC-IF" "ASSOC-IF-NOT" "ATAN" "ATANH" "ATOM"
             "BASE-CHAR" "BASE-CHARACTER" "BASE-STRING" "BIGNUM" "BIT"
             "BIT-AND" "BIT-ANDC1" "BIT-ANDC2" "BIT-EQV" "BIT-IOR" "BIT-NAND"
             "BIT-NOR" "BIT-NOT" "BIT-ORC1" "BIT-ORC2" "BIT-VECTOR"
             "BIT-VECTOR-P" "BIT-XOR" "BLOCK" "BOOLE" "BOOLE-1" "BOOLE-2"
             "BOOLE-AND" "BOOLE-ANDC1" "BOOLE-ANDC2" "BOOLE-C1" "BOOLE-C2"
             "BOOLE-CLR" "BOOLE-EQV" "BOOLE-IOR" "BOOLE-NAND" "BOOLE-NOR"
             "BOOLE-ORC1" "BOOLE-ORC2" "BOOLE-SET" "BOOLE-XOR" "BOTH-CASE-P"
             "BOUNDP" "BREAK" "BUTLAST" "BYTE" "BYTE-POSITION" "BYTE-SIZE"
             "CAAAAR" "CAAADR" "CAAAR" "CAADAR" "CAADDR" "CAADR" "CAAR"
             "CADAAR" "CADADR" "CADAR" "CADDAR" "CADDDR" "CADDR" "CADR"
             "CALL-ARGUMENTS-LIMIT" "CAR" "CASE" "CATCH" "CCASE" "CDAAAR"
             "CDAADR" "CDAAR" "CDADAR" "CDADDR" "CDADR" "CDAR" "CDDAAR"
             "CDDADR" "CDDAR" "CDDDAR" "CDDDDR" "CDDDR" "CDDR" "CDR" "CEILING"
             "CELL-ERROR" "CERROR" "CHAR" "CHAR-BIT" "CHAR-BITS"
             "CHAR-BITS-LIMIT" "CHAR-CODE" "CHAR-CODE-LIMIT" "CHAR-CONTROL-BIT"
             "CHAR-DOWNCASE" "CHAR-EQUAL" "CHAR-FONT" "CHAR-FONT-LIMIT"
             "CHAR-GREATERP" "CHAR-HYPER-BIT" "CHAR-INT" "CHAR-LESSP"
             "CHAR-META-BIT" "CHAR-NAME" "CHAR-NOT-EQUAL" "CHAR-NOT-GREATERP"
             "CHAR-NOT-LESSP" "CHAR-SUPER-BIT" "CHAR-UPCASE" "CHAR/=" "CHAR<"
             "CHAR<=" "CHAR=" "CHAR>" "CHAR>=" "CHARACTER" "CHARACTERP"
             "CHECK-TYPE" "CIS" "CLEAR-INPUT" "CLEAR-OUTPUT" "CLOSE" "CLRHASH"
             "CODE-CHAR" "COERCE" "COMMON" "COMMONP" "COMPILATION-SPEED"
             "COMPILE" "COMPILE-FILE" "COMPILED-FUNCTION" "COMPILED-FUNCTION-P"
             "COMPILER-LET" "COMPLEMENT" "COMPLEX" "COMPLEXP"
             "COMPUTE-RESTARTS" "CONCATENATE" "COND" "CONDITION" "CONJUGATE"
             "CONS" "CONSP" "CONSTANTLY" "CONSTANTP" "CONTINUE" "CONTROL-ERROR"
             "COPY-ALIST" "COPY-LIST" "COPY-PPRINT-DISPATCH" "COPY-READTABLE"
             "COPY-SEQ" "COPY-SYMBOL" "COPY-TREE" "COS" "COSH" "COUNT"
             "COUNT-IF" "COUNT-IF-NOT" "CTYPECASE" "DEBUG-INFO" "DECF"
             "DECLAIM" "DECLARATION" "DECLARE" "DECODE-FLOAT"
             "DECODE-UNIVERSAL-TIME" "DEFCONSTANT" "DEFINE-CONDITION"
             "DEFINE-MODIFY-MACRO" "DEFINE-SETF-METHOD" "DEFMACRO" "DEFPACKAGE"
             "DEFPARAMETER" "DEFSETF" "DEFSTRUCT" "DEFTYPE" "DEFUN" "DEFVAR"
             "DELETE" "DELETE-DUPLICATES" "DELETE-FILE" "DELETE-IF"
             "DELETE-IF-NOT" "DENOMINATOR" "DEPOSIT-FIELD" "DESCRIBE"
             "DESTRUCTURING-BIND" "DIGIT-CHAR" "DIGIT-CHAR-P" "DIRECTORY"
             "DIRECTORY-NAMESTRING" "DISASSEMBLE" "DIVISION-BY-ZERO" "DO" "DO*"
             "DO-ALL-SYMBOLS" "DO-EXTERNAL-SYMBOLS" "DO-SYMBOLS"
             "DOCUMENTATION" "DOLIST" "DOTIMES" "DOUBLE-FLOAT"
             "DOUBLE-FLOAT-EPSILON" "DOUBLE-FLOAT-NEGATIVE-EPSILON" "DPB"
             "DRIBBLE" "ECASE" "ED" "EIGHTH" "ELT" "ENCODE-UNIVERSAL-TIME"
             "END-OF-FILE" "ENDP" "ENOUGH-NAMESTRING" "EQ" "EQL" "EQUAL"
             "EQUALP" "ERROR" "ETYPECASE" "EVAL" "EVAL-WHEN" "EVALHOOK" "EVENP"
             "EVERY" "EXP" "EXPORT" "EXPT" "EXTENDED-CHAR" "FBOUNDP" "FCEILING"
             "FDEFINITION" "FFLOOR" "FIFTH" "FILE-AUTHOR" "FILE-ERROR"
             "FILE-ERROR-PATHNAME" "FILE-LENGTH" "FILE-NAMESTRING"
             "FILE-POSITION" "FILE-WRITE-DATE" "FILL" "FILL-POINTER" "FIND"
             "FIND-ALL-SYMBOLS" "FIND-IF" "FIND-IF-NOT" "FIND-PACKAGE"
             "FIND-RESTART" "FIND-SYMBOL" "FINISH-OUTPUT" "FIRST" "FIXNUM"
             "FLET" "FLOAT" "FLOAT-DIGITS" "FLOAT-PRECISION" "FLOAT-RADIX"
             "FLOAT-SIGN" "FLOATING-POINT-OVERFLOW" "FLOATING-POINT-UNDERFLOW"
             "FLOATP" "FLOOR" "FMAKUNBOUND" "FORCE-OUTPUT" "FORMAT" "FORMATTER"
             "FOURTH" "FRESH-LINE" "FROUND" "FTRUNCATE" "FTYPE" "FUNCALL"
             "FUNCTION" "FUNCTION-LAMBDA-EXPRESSION" "FUNCTIONP" "GCD" "GENSYM"
             "GENTEMP" "GET" "GET-DECODED-TIME" "GET-DISPATCH-MACRO-CHARACTER"
             "GET-INTERNAL-REAL-TIME" "GET-INTERNAL-RUN-TIME"
             "GET-MACRO-CHARACTER" "GET-OUTPUT-STREAM-STRING" "GET-PROPERTIES"
             "GET-SETF-METHOD" "GET-SETF-METHOD-MULTIPLE-VALUE"
             "GET-UNIVERSAL-TIME" "GETF" "GETHASH" "GO" "GRAPHIC-CHAR-P"
             "HANDLER-BIND" "HANDLER-CASE" "HASH-TABLE" "HASH-TABLE-COUNT"
             "HASH-TABLE-P" "HOST-NAMESTRING" "IDENTITY" "IF" "IGNORABLE"
             "IGNORE" "IGNORE-ERRORS" "IMAGPART" "IMPORT" "IN-PACKAGE" "INCF"
             "INLINE" "INPUT-STREAM-P" "INSPECT" "INT-CHAR" "INTEGER"
             "INTEGER-DECODE-FLOAT" "INTEGER-LENGTH" "INTEGERP" "INTERN"
             "INTERNAL-TIME-UNITS-PER-SECOND" "INTERSECTION" "INVOKE-DEBUGGER"
             "INVOKE-RESTART" "INVOKE-RESTART-INTERACTIVELY" "ISQRT" "KEYWORD"
             "KEYWORDP" "LABELS" "LAMBDA" "LAMBDA-LIST-KEYWORDS"
             "LAMBDA-PARAMETERS-LIMIT" "LAST" "LCM" "LDB" "LDB-TEST" "LDIFF"
             "LEAST-NEGATIVE-DOUBLE-FLOAT" "LEAST-NEGATIVE-LONG-FLOAT"
	     "LEAST-NEGATIVE-NORMALIZED-DOUBLE-FLOAT"
	     "LEAST-NEGATIVE-NORMALIZED-LONG-FLOAT"
	     "LEAST-NEGATIVE-NORMALIZED-SHORT-FLOAT"
	     "LEAST-NEGATIVE-NORMALIZED-SINGLE-FLOAT"
             "LEAST-NEGATIVE-SHORT-FLOAT" "LEAST-NEGATIVE-SINGLE-FLOAT"
             "LEAST-POSITIVE-DOUBLE-FLOAT" "LEAST-POSITIVE-LONG-FLOAT"
             "LEAST-POSITIVE-NORMALIZED-DOUBLE-FLOAT"
             "LEAST-POSITIVE-NORMALIZED-LONG-FLOAT"
             "LEAST-POSITIVE-NORMALIZED-SHORT-FLOAT"
             "LEAST-POSITIVE-NORMALIZED-SINGLE-FLOAT"
             "LEAST-POSITIVE-SHORT-FLOAT" "LEAST-POSITIVE-SINGLE-FLOAT"
             "LENGTH" "LET" "LET*" "LISP-IMPLEMENTATION-TYPE"
             "LISP-IMPLEMENTATION-VERSION" "LIST" "LIST*" "LIST-ALL-PACKAGES"
             "LIST-LENGTH" "LISTEN" "LISTP" "LOAD" "LOAD-TIME-VALUE" "LOCALLY"
             "LOG" "LOGAND" "LOGANDC1" "LOGANDC2" "LOGBITP" "LOGCOUNT" "LOGEQV"
             "LOGIOR" "LOGNAND" "LOGNOR" "LOGNOT" "LOGORC1" "LOGORC2" "LOGTEST"
             "LOGXOR" "LONG-FLOAT" "LONG-FLOAT-EPSILON"
             "LONG-FLOAT-NEGATIVE-EPSILON" "LONG-SITE-NAME" "LOOP"
             "LOOP-FINISH" "LOWER-CASE-P" "MACHINE-INSTANCE" "MACHINE-TYPE"
             "MACHINE-VERSION" "MACRO-FUNCTION" "MACROEXPAND" "MACROEXPAND-1"
             "MACROLET" "MAKE-ARRAY" "MAKE-BROADCAST-STREAM" "MAKE-CHAR"
             "MAKE-CONCATENATED-STREAM" "MAKE-CONDITION"
             "MAKE-DISPATCH-MACRO-CHARACTER" "MAKE-ECHO-STREAM"
             "MAKE-HASH-TABLE" "MAKE-LIST" "MAKE-PACKAGE" "MAKE-PATHNAME"
             "MAKE-RANDOM-STATE" "MAKE-SEQUENCE" "MAKE-STRING"
             "MAKE-STRING-INPUT-STREAM" "MAKE-STRING-OUTPUT-STREAM"
             "MAKE-SYMBOL" "MAKE-SYNONYM-STREAM" "MAKE-TWO-WAY-STREAM"
             "MAKUNBOUND" "MAP" "MAPC" "MAPCAN" "MAPCAR" "MAPCON" "MAPHASH"
             "MAPL" "MAPLIST" "MASK-FIELD" "MAX" "MEMBER" "MEMBER-IF"
             "MEMBER-IF-NOT" "MERGE" "MERGE-PATHNAMES" "MIN" "MINUSP"
             "MISMATCH" "MOD" "MOST-NEGATIVE-DOUBLE-FLOAT"
             "MOST-NEGATIVE-FIXNUM" "MOST-NEGATIVE-LONG-FLOAT"
             "MOST-NEGATIVE-SHORT-FLOAT" "MOST-NEGATIVE-SINGLE-FLOAT"
             "MOST-POSITIVE-DOUBLE-FLOAT" "MOST-POSITIVE-FIXNUM"
             "MOST-POSITIVE-LONG-FLOAT" "MOST-POSITIVE-SHORT-FLOAT"
             "MOST-POSITIVE-SINGLE-FLOAT" "MUFFLE-WARNING"
             "MULTIPLE-VALUE-BIND" "MULTIPLE-VALUE-CALL" "MULTIPLE-VALUE-LIST"
             "MULTIPLE-VALUE-PROG1" "MULTIPLE-VALUE-SETQ"
             "MULTIPLE-VALUES-LIMIT" "NAME-CHAR" "NAMESTRING" "NBUTLAST"
             "NCONC" "NIL" "NINTERSECTION" "NINTH" "NOT" "NOTANY" "NOTEVERY"
             "NOTINLINE" "NRECONC" "NREVERSE" "NSET-DIFFERENCE"
             "NSET-EXCLUSIVE-OR" "NSTRING-CAPITALIZE" "NSTRING-DOWNCASE"
             "NSTRING-UPCASE" "NSUBLIS" "NSUBST" "NSUBST-IF" "NSUBST-IF-NOT"
             "NSUBSTITUTE" "NSUBSTITUTE-IF" "NSUBSTITUTE-IF-NOT" "NTH"
             "NTH-VALUE" "NTHCDR" "NULL" "NUMBER" "NUMBERP" "NUMERATOR"
             "NUNION" "ODDP" "OPEN" "OPTIMIZE" "OR" "OTHERWISE"
             "OUTPUT-STREAM-P" "PACKAGE" "PACKAGE-ERROR"
             "PACKAGE-ERROR-PACKAGE" "PACKAGE-NAME" "PACKAGE-NICKNAMES"
             "PACKAGE-SHADOWING-SYMBOLS" "PACKAGE-USE-LIST"
             "PACKAGE-USED-BY-LIST" "PACKAGEP" "PAIRLIS" "PARSE-INTEGER"
             "PARSE-NAMESTRING" "PATHNAME" "PATHNAME-DEVICE"
             "PATHNAME-DIRECTORY" "PATHNAME-HOST" "PATHNAME-MATCH-P"
             "PATHNAME-NAME" "PATHNAME-TYPE" "PATHNAME-VERSION" "PATHNAMEP"
             "PEEK-CHAR" "PHASE" "PI" "PLUSP" "POP" "POSITION" "POSITION-IF"
             "POSITION-IF-NOT" "PPRINT" "PPRINT-DISPATCH"
             "PPRINT-EXIT-IF-LIST-EXHAUSTED" "PPRINT-FILL" "PPRINT-INDENT"
             "PPRINT-LINEAR" "PPRINT-LOGICAL-BLOCK" "PPRINT-NEWLINE"
             "PPRINT-POP" "PPRINT-TAB" "PPRINT-TABULAR" "PRIN1"
             "PRIN1-TO-STRING" "PRINC" "PRINC-TO-STRING" "PRINT"
             "PRINT-UNREADABLE-OBJECT" "PROBE-FILE" "PROCLAIM" "PROG" "PROG*"
             "PROG1" "PROG2" "PROGN" "PROGRAM-ERROR" "PROGV" "PROVIDE" "PSETF"
             "PSETQ" "PUSH" "PUSHNEW" "QUOTE" "RANDOM" "RANDOM-STATE"
             "RANDOM-STATE-P" "RASSOC" "RASSOC-IF" "RASSOC-IF-NOT" "RATIO"
             "RATIONAL" "RATIONALIZE" "RATIONALP" "READ" "READ-BYTE"
             "READ-CHAR" "READ-CHAR-NO-HANG" "READ-DELIMITED-LIST"
             "READ-FROM-STRING" "READ-LINE" "READ-PRESERVING-WHITESPACE"
             "READTABLE" "READTABLEP" "REAL" "REALPART" "REDUCE" "REM" "REMF"
             "REMHASH" "REMOVE" "REMOVE-DUPLICATES" "REMOVE-IF" "REMOVE-IF-NOT"
             "REMPROP" "RENAME-FILE" "RENAME-PACKAGE" "REPLACE" "REQUIRE"
             "REST" "RESTART" "RESTART-BIND" "RESTART-CASE" "RESTART-NAME"
             "RETURN" "RETURN-FROM" "REVAPPEND" "REVERSE" "ROOM" "ROTATEF"
             "ROUND" "ROW-MAJOR-AREF" "RPLACA" "RPLACD" "SAFETY" "SATISFIES"
             "SBIT" "SCALE-FLOAT" "SCHAR" "SEARCH" "SECOND" "SEQUENCE"
             "SERIOUS-CONDITION" "SET" "SET-CHAR-BIT" "SET-DIFFERENCE"
             "SET-DISPATCH-MACRO-CHARACTER" "SET-EXCLUSIVE-OR"
             "SET-MACRO-CHARACTER" "SET-PPRINT-DISPATCH" "SET-SYNTAX-FROM-CHAR"
             "SETF" "SETQ" "SEVENTH" "SHADOW" "SHADOWING-IMPORT" "SHIFTF"
             "SHORT-FLOAT" "SHORT-FLOAT-EPSILON" "SHORT-FLOAT-NEGATIVE-EPSILON"
             "SHORT-SITE-NAME" "SIGNAL" "SIGNED-BYTE" "SIGNUM" "SIMPLE-ARRAY"
             "SIMPLE-BASE-STRING" "SIMPLE-BIT-VECTOR" "SIMPLE-BIT-VECTOR-P"
             "SIMPLE-CONDITION" "SIMPLE-CONDITION-FORMAT-ARGUMENTS"
             "SIMPLE-CONDITION-FORMAT-STRING" "SIMPLE-ERROR" "SIMPLE-STRING"
             "SIMPLE-STRING-P" "SIMPLE-TYPE-ERROR" "SIMPLE-VECTOR"
             "SIMPLE-VECTOR-P" "SIMPLE-WARNING" "SIN" "SINGLE-FLOAT"
             "SINGLE-FLOAT-EPSILON" "SINGLE-FLOAT-NEGATIVE-EPSILON" "SINH"
             "SIXTH" "SLEEP" "SOFTWARE-TYPE" "SOFTWARE-VERSION" "SOME" "SORT"
             "SPACE" "SPECIAL" "SPECIAL-FORM-P" "SPEED" "SQRT" "STABLE-SORT"
             "STACK-OVERFLOW" "STANDARD-CHAR" "STANDARD-CHAR-P" "STEP"
             "STORAGE-CONDITION" "STORAGE-EXHAUSTED" "STORE-VALUE" "STREAM"
             "STREAM-ELEMENT-TYPE" "STREAM-ERROR" "STREAM-ERROR-STREAM"
             "STREAMP" "STRING" "STRING-CAPITALIZE" "STRING-CHAR"
             "STRING-CHAR-P" "STRING-DOWNCASE" "STRING-EQUAL" "STRING-GREATERP"
             "STRING-LEFT-TRIM" "STRING-LESSP" "STRING-NOT-EQUAL"
             "STRING-NOT-GREATERP" "STRING-NOT-LESSP" "STRING-RIGHT-TRIM"
             "STRING-TRIM" "STRING-UPCASE" "STRING/=" "STRING<" "STRING<="
             "STRING=" "STRING>" "STRING>=" "STRINGP" "STRUCTURE" "SUBLIS"
             "SUBSEQ" "SUBSETP" "SUBST" "SUBST-IF" "SUBST-IF-NOT" "SUBSTITUTE"
             "SUBSTITUTE-IF" "SUBSTITUTE-IF-NOT" "SUBTYPEP" "SVREF" "SXHASH"
             "SYMBOL" "SYMBOL-FUNCTION" "SYMBOL-MACROLET" "SYMBOL-NAME"
             "SYMBOL-PACKAGE" "SYMBOL-PLIST" "SYMBOL-VALUE" "SYMBOLP" "T"
             "TAGBODY" "TAILP" "TAN" "TANH" "TENTH" "TERPRI" "THE" "THIRD"
             "THROW" "TIME" "TRACE" "TRANSLATE-PATHNAME" "TREE-EQUAL"
             "TRUENAME" "TRUNCATE" "TYPE" "TYPE-ERROR" "TYPE-ERROR-DATUM"
             "TYPE-ERROR-EXPECTED-TYPE" "TYPE-OF" "TYPECASE" "TYPEP"
             "UNBOUND-VARIABLE" "UNDEFINED-FUNCTION" "UNEXPORT" "UNINTERN"
             "UNION" "UNLESS" "UNREAD-CHAR" "UNSIGNED-BYTE" "UNTRACE"
             "UNUSE-PACKAGE" "UNWIND-PROTECT" "UPPER-CASE-P" "USE-PACKAGE"
             "USE-VALUE" "USER-HOMEDIR-PATHNAME" "VALUES" "VALUES-LIST"
             "VARIABLE" "VECTOR" "VECTOR-POP" "VECTOR-PUSH"
             "VECTOR-PUSH-EXTEND" "VECTORP" "WARN" "WARNING" "WHEN"
             "WILD-PATHNAME-P" "WITH-COMPILATION-UNIT"
             "WITH-HASH-TABLE-ITERATOR" "WITH-INPUT-FROM-STRING"
             "WITH-OPEN-FILE" "WITH-OPEN-STREAM" "WITH-OUTPUT-TO-STRING"
             "WITH-PACKAGE-ITERATOR" "WITH-SIMPLE-RESTART"
             "WITH-STANDARD-IO-SYNTAX" "WRITE" "WRITE-BYTE" "WRITE-CHAR"
             "WRITE-LINE" "WRITE-STRING" "WRITE-TO-STRING" "Y-OR-N-P"
             "YES-OR-NO-P" "ZEROP"))
(defpackage "EVAL"
            (:export "*EVAL-STACK-TRACE*" "*INTERNAL-APPLY-NODE-TRACE*"
             "*INTERPRETED-FUNCTION-CACHE-MINIMUM-SIZE*"
             "*INTERPRETED-FUNCTION-CACHE-THRESHOLD*"
             "FLUSH-INTERPRETED-FUNCTION-CACHE" "INTERNAL-EVAL"
             "INTERPRETED-FUNCTION-ARGLIST" "INTERPRETED-FUNCTION-CLOSURE"
             "INTERPRETED-FUNCTION-LAMBDA-EXPRESSION"
             "INTERPRETED-FUNCTION-NAME" "INTERPRETED-FUNCTION-P"
             "INTERPRETED-FUNCTION-TYPE" "MAKE-INTERPRETED-FUNCTION"
             "TRACE-EVAL"))
(defpackage "ITERATE"
            (:export "*ITERATE-WARNINGS*" "COLLECTING" "EACHTIME" "ELEMENTS"
             "GATHER" "GATHERING" "INTERVAL" "ITERATE" "ITERATE*" "JOINING"
             "LIST-ELEMENTS" "LIST-TAILS" "MAXIMIZING" "MINIMIZING"
             "PLIST-ELEMENTS" "SUMMING" "UNTIL" "WHILE" "WITH-GATHERING"))
(dolist
    (name
     '("%ARRAY-TYPEP" "%ASET" "%BITSET" "%CHARSET" "%PUT" "%RPLACA" "%RPLACD"
       "%SBITSET" "%SCHARSET" "%SET-DOCUMENTATION" "%SET-FDEFINITION"
       "%SET-FILL-POINTER" "%SET-ROW-MAJOR-AREF" "%SETELT" "%SETNTH"
       "%SP-STRING-COMPARE" "%SVSET" "%TYPEP" "*READ-ONLY-SPACE-FREE-POINTER*"
       "*STATIC-SPACE-FREE-POINTER*" "CURRENT-DYNAMIC-SPACE-START"
       "DYNAMIC-0-SPACE-START" "DYNAMIC-1-SPACE-START" "FIXNUM" "LONG-FLOAT-P"
       "READ-ONLY-SPACE-START" "SHORT-FLOAT-P" "STATIC-SPACE-START" "STRING/=*"
       "STRING<*" "STRING<=*" "STRING=*" "STRING>*" "STRING>=*"))
  (intern name "LISP"))
(dolist (name '("%PRIMITIVE" "%STANDARD-CHAR-P" "%STRING-CHAR-P"))
  (intern name "SYSTEM"))
(intern "BIGNUM-TYPE" "BIGNUM")
(dolist
    (name
     '("%SP-SET-DEFINITION" "%SP-SET-PLIST" "ARRAY-HEADER-P" "BASE-CHAR-P"
       "DOUBLE-FLOAT-P" "SIMPLE-ARRAY-P" "SINGLE-FLOAT-P"))
  (intern name "KERNEL"))
(defpackage #+pmax "MIPS" #+sparc "SPARC" #+ibmrt "RT"
            (:import-from "LISP" "%ARRAY-TYPEP" "%ASET" "%BITSET" "%CHARSET"
             "%PUT" "%RPLACA" "%RPLACD" "%SBITSET" "%SCHARSET"
             "%SET-DOCUMENTATION" "%SET-FDEFINITION" "%SET-FILL-POINTER"
             "%SET-ROW-MAJOR-AREF" "%SETELT" "%SETNTH" "%SP-STRING-COMPARE"
             "%SVSET" "%TYPEP" "*READ-ONLY-SPACE-FREE-POINTER*"
             "*STATIC-SPACE-FREE-POINTER*" "CURRENT-DYNAMIC-SPACE-START"
             "DYNAMIC-0-SPACE-START" "DYNAMIC-1-SPACE-START" "FIXNUM"
             "LONG-FLOAT-P" "READ-ONLY-SPACE-START" "SHORT-FLOAT-P"
             "STATIC-SPACE-START" "STRING/=*" "STRING<*" "STRING<=*" "STRING=*"
             "STRING>*" "STRING>=*")
            (:import-from "SYSTEM" "%PRIMITIVE" "%STANDARD-CHAR-P"
             "%STRING-CHAR-P")
            (:import-from "BIGNUM" "BIGNUM-TYPE")
            (:import-from "KERNEL" "%SP-SET-DEFINITION" "%SP-SET-PLIST"
             "ARRAY-HEADER-P" "BASE-CHAR-P" "DOUBLE-FLOAT-P" "SIMPLE-ARRAY-P"
             "SINGLE-FLOAT-P")
            (:export "*ASSEMBLY-UNIT-LENGTH*" "*PRIMITIVE-OBJECTS*"
             "ANY-REG-SC-NUMBER" "ARRAY-DATA-SLOT" "ARRAY-DIMENSIONS-OFFSET"
             "ARRAY-DISPLACED-P-SLOT" "ARRAY-DISPLACEMENT-SLOT"
             "ARRAY-ELEMENTS-SLOT" "ARRAY-FILL-POINTER-P-SLOT"
             "ARRAY-FILL-POINTER-SLOT" "ATOMIC-FLAG" "BASE-CHAR-REG-SC-NUMBER"
             "BASE-CHAR-STACK-SC-NUMBER" "BASE-CHAR-TYPE"
             "BIGNUM-DIGITS-OFFSET" "BIGNUM-TYPE" "BINDING-SIZE"
             "BINDING-SYMBOL-SLOT" "BINDING-VALUE-SLOT" "BREAKPOINT-TRAP"
             "BYTE-BITS" "CATCH-BLOCK-CURRENT-CODE-SLOT"
             "CATCH-BLOCK-CURRENT-CONT-SLOT" "CATCH-BLOCK-CURRENT-UWP-SLOT"
             "CATCH-BLOCK-ENTRY-PC-SLOT" "CATCH-BLOCK-PREVIOUS-CATCH-SLOT"
             "CATCH-BLOCK-SC-NUMBER" "CATCH-BLOCK-SIZE" "CATCH-BLOCK-SIZE-SLOT"
             "CATCH-BLOCK-TAG-SLOT" "CERROR-TRAP"
             "CLOSURE-FUNCTION-HEADER-TYPE" "CLOSURE-FUNCTION-SLOT"
             "CLOSURE-HEADER-TYPE" "CLOSURE-INFO-OFFSET" "CODE-BREAKDOWN"
             "CODE-CODE-SIZE-SLOT" "CODE-CONSTANTS-OFFSET"
             "CODE-DEBUG-INFO-SLOT" "CODE-ENTRY-POINTS-SLOT" "CODE-HEADER-TYPE"
             "CODE-TRACE-TABLE-OFFSET-SLOT" "COMPLEX-ARRAY-TYPE"
             "COMPLEX-BIT-VECTOR-TYPE" "COMPLEX-IMAG-SLOT" "COMPLEX-REAL-SLOT"
             "COMPLEX-SIZE" "COMPLEX-STRING-TYPE" "COMPLEX-TYPE"
             "COMPLEX-VECTOR-TYPE" "CONS-CAR-SLOT" "CONS-CDR-SLOT" "CONS-SIZE"
             "CONSTANT-SC-NUMBER" "CONTROL-STACK-SC-NUMBER" "COUNT-NO-OPS"
             "CURRENT-FLOAT-TRAP" "DEFINE-FOR-EACH-PRIMITIVE-OBJECT"
             "DESCRIPTOR-REG-SC-NUMBER" "DESCRIPTOR-VS-NON-DESCRIPTOR-STORAGE"
             "DOUBLE-FLAOT-EXPONENT-BYTE" "DOUBLE-FLOAT-BIAS"
             "DOUBLE-FLOAT-DIGITS" "DOUBLE-FLOAT-EXPONENT-BYTE"
             "DOUBLE-FLOAT-FILLER-SLOT" "DOUBLE-FLOAT-HIDDEN-BIT"
             "DOUBLE-FLOAT-NORMAL-EXPONENT-MAX"
             "DOUBLE-FLOAT-NORMAL-EXPONENT-MIN" "DOUBLE-FLOAT-SIGNIFICAND-BYTE"
             "DOUBLE-FLOAT-SIZE" "DOUBLE-FLOAT-TRAPPING-NAN-BIT"
             "DOUBLE-FLOAT-TYPE" "DOUBLE-FLOAT-VALUE-SLOT"
             "DOUBLE-REG-SC-NUMBER" "DOUBLE-STACK-SC-NUMBER" "ERROR-TRAP"
             "EVEN-FIXNUM-TYPE" "EXPORTED-STATIC-SYMBOLS" "FIND-HOLES" "FIXNUM"
             "FIXUP-CODE-OBJECT" "FLOAT-DIVIDE-BY-ZERO-TRAP-BIT"
             "FLOAT-IMPRECISE-TRAP-BIT" "FLOAT-INVALID-TRAP-BIT"
             "FLOAT-OVERFLOW-TRAP-BIT" "FLOAT-SIGN-SHIFT"
             "FLOAT-UNDERFLOW-TRAP-BIT" "FLOATING-POINT-MODES"
             "FUNCALLABLE-INSTANCE-FUNCTION-SLOT"
             "FUNCALLABLE-INSTANCE-HEADER-TYPE"
             "FUNCALLABLE-INSTANCE-INFO-OFFSET" "FUNCTION-END-BREAKPOINT-TRAP"
             "FUNCTION-HEADER-ARGLIST-SLOT" "FUNCTION-HEADER-CODE-OFFSET"
             "FUNCTION-HEADER-NAME-SLOT" "FUNCTION-HEADER-NEXT-SLOT"
             "FUNCTION-HEADER-SELF-SLOT" "FUNCTION-HEADER-TYPE"
             "FUNCTION-HEADER-TYPE-SLOT" "FUNCTION-POINTER-TYPE" "GENESIS"
             "HALT-TRAP" "IMMEDIATE-BASE-CHAR-SC-NUMBER"
             "IMMEDIATE-SAP-SC-NUMBER" "IMMEDIATE-SC-NUMBER"
             "INTERIOR-REG-SC-NUMBER" "INTERNAL-ERROR-ARGUMENTS"
             "INTERRUPTED-FLAG" "LIST-POINTER-TYPE" "LOWTAG-BITS"
             "LOWTAG-LIMIT" "LOWTAG-MASK" "MEMORY-USAGE" "MOST-POSITIVE-COST"
             "NEGATIVE-IMMEDIATE-SC-NUMBER" "NON-DESCRIPTOR-REG-SC-NUMBER"
             "NULL-SC-NUMBER" "ODD-FIXNUM-TYPE" "OFFSET-STATIC-SYMBOL"
             "OTHER-IMMEDIATE-0-TYPE" "OTHER-IMMEDIATE-1-TYPE"
             "OTHER-POINTER-TYPE" "PAD-DATA-BLOCK" "PENDING-INTERRUPT-TRAP"
             "PRIMITIVE-OBJECT" "PRIMITIVE-OBJECT-HEADER"
             "PRIMITIVE-OBJECT-LOWTAG" "PRIMITIVE-OBJECT-NAME"
             "PRIMITIVE-OBJECT-OPTIONS" "PRIMITIVE-OBJECT-P"
             "PRIMITIVE-OBJECT-SIZE" "PRIMITIVE-OBJECT-SLOTS"
             "PRIMITIVE-OBJECT-VARIABLE-LENGTH" "PRINT-ALLOCATED-OBJECTS"
             "RANDOM-IMMEDIATE-SC-NUMBER" "RATIO-DENOMINATOR-SLOT"
             "RATIO-NUMERATOR-SLOT" "RATIO-SIZE" "RATIO-TYPE"
             "REGISTER-SAVE-PENALTY" "RETURN-PC-HEADER-TYPE"
             "RETURN-PC-RETURN-POINT-OFFSET" "SAP-POINTER-SLOT"
             "SAP-REG-SC-NUMBER" "SAP-SIZE" "SAP-STACK-SC-NUMBER" "SAP-TYPE"
             "SIGFPE-HANDLER" "SIGNED-REG-SC-NUMBER" "SIGNED-STACK-SC-NUMBER"
             "SIMPLE-ARRAY-DOUBLE-FLOAT-TYPE" "SIMPLE-ARRAY-SINGLE-FLOAT-TYPE"
             "SIMPLE-ARRAY-TYPE" "SIMPLE-ARRAY-UNSIGNED-BYTE-16-TYPE"
             "SIMPLE-ARRAY-UNSIGNED-BYTE-2-TYPE"
             "SIMPLE-ARRAY-UNSIGNED-BYTE-32-TYPE"
             "SIMPLE-ARRAY-UNSIGNED-BYTE-4-TYPE"
             "SIMPLE-ARRAY-UNSIGNED-BYTE-8-TYPE" "SIMPLE-BIT-VECTOR-TYPE"
             "SIMPLE-STRING-TYPE" "SIMPLE-VECTOR-TYPE" "SINGLE-FLOAT-BIAS"
             "SINGLE-FLOAT-DIGITS" "SINGLE-FLOAT-EXPONENT-BYTE"
             "SINGLE-FLOAT-HIDDEN-BIT" "SINGLE-FLOAT-NORMAL-EXPONENT-MAX"
             "SINGLE-FLOAT-NORMAL-EXPONENT-MIN" "SINGLE-FLOAT-SIGNIFICAND-BYTE"
             "SINGLE-FLOAT-SIZE" "SINGLE-FLOAT-TRAPPING-NAN-BIT"
             "SINGLE-FLOAT-TYPE" "SINGLE-FLOAT-VALUE-SLOT"
             "SINGLE-REG-SC-NUMBER" "SINGLE-STACK-SC-NUMBER" "SLOT-DOCS"
             "SLOT-LENGTH" "SLOT-NAME" "SLOT-OFFSET" "SLOT-OPTIONS"
             "SLOT-REST-P" "STATIC-SYMBOL-OFFSET" "STATIC-SYMBOL-P"
             "STATIC-SYMBOLS" "STRUCTURE-HEADER-TYPE" "STRUCTURE-POINTER-TYPE"
             "STRUCTURE-SLOTS-OFFSET" "STRUCTURE-USAGE" "SYMBOL-FUNCTION-SLOT"
             "SYMBOL-HEADER-TYPE" "SYMBOL-NAME-SLOT" "SYMBOL-PACKAGE-SLOT"
             "SYMBOL-PLIST-SLOT" "SYMBOL-RAW-FUNCTION-ADDR-SLOT"
             "SYMBOL-SETF-FUNCTION-SLOT" "SYMBOL-SIZE" "SYMBOL-VALUE-SLOT"
             "TARGET-BINDING-STACK-START" "TARGET-BYTE-ORDER"
             "TARGET-CONTROL-STACK-START" "TARGET-DYNAMIC-SPACE-START"
             "TARGET-FASL-CODE-FORMAT" "TARGET-FASL-FILE-TYPE"
             "TARGET-HEAP-ADDRESS-SPACE" "TARGET-MOST-NEGATIVE-FIXNUM"
             "TARGET-MOST-POSITIVE-FIXNUM" "TARGET-READ-ONLY-SPACE-START"
             "TARGET-STATIC-SPACE-START" "TRACE-TABLE-CALL-SITE"
             "TRACE-TABLE-FUNCTION-EPILOGUE" "TRACE-TABLE-FUNCTION-PROLOGUE"
             "TRACE-TABLE-NORMAL" "TYPE-BITS" "TYPE-MASK" "UNBOUND-MARKER-TYPE"
             "UNINTERNED-SYMBOL-COUNT" "UNSIGNED-IMMEDIATE-SC-NUMBER"
             "UNSIGNED-REG-SC-NUMBER" "UNSIGNED-STACK-SC-NUMBER"
             "UNWIND-BLOCK-CURRENT-CODE-SLOT" "UNWIND-BLOCK-CURRENT-CONT-SLOT"
             "UNWIND-BLOCK-CURRENT-UWP-SLOT" "UNWIND-BLOCK-ENTRY-PC-SLOT"
             "UNWIND-BLOCK-SIZE" "VALUE-CELL-HEADER-TYPE" "VALUE-CELL-SIZE"
             "VALUE-CELL-VALUE-SLOT" "VECTOR-DATA-OFFSET" "VECTOR-LENGTH-SLOT"
             "VECTOR-MUST-REHASH-SUBTYPE" "VECTOR-NORMAL-SUBTYPE"
             "VECTOR-STRUCTURE-SUBTYPE" "VECTOR-VALID-HASHING-SUBTYPE"
             "WEAK-POINTER-BROKEN-SLOT" "WEAK-POINTER-NEXT-SLOT"
             "WEAK-POINTER-SIZE" "WEAK-POINTER-TYPE" "WEAK-POINTER-VALUE-SLOT"
             "WORD-BITS" "WORD-BYTES" "WORD-SHIFT" "ZERO-SC-NUMBER"))
(defpackage "CONDITIONS")
(intern "DISASSEMBLE" "LISP")
(defpackage "DISASSEM"
            (:import-from "LISP" "DISASSEMBLE")
            (:export "*NOTE-COLUMN*" "*OPCODE-COLUMN-WIDTH*" "ADD-COMMENT-HOOK"
             "ADD-HOOK" "ADD-NOTE-HOOK" "ARG-VALUE" "CREATE-DSTATE"
             "DISASSEM-STATE" "DISASSEMBLE" "DISASSEMBLE-CODE-COMPONENT"
             "DISASSEMBLE-FUNCTION" "DISASSEMBLE-MEMORY" "DISASSEMBLE-SEGMENT"
             "DISASSEMBLE-SEGMENTS" "DSTATE-CODE" "DSTATE-CURPOS"
             "DSTATE-GET-PROP" "DSTATE-NEXTPOS" "DSTATE-SEGMENT-LENGTH"
             "DSTATE-SEGMENT-SAP" "DSTATE-SEGMENT-START" "FIELD-TYPE"
             "FIND-INST" "GEN-FIELD-TYPE-DECL-FORM" "GEN-INST-DECL-FORM"
             "GEN-INST-FORMAT-DECL-FORM" "GET-CODE-SEGMENTS"
             "GET-FUNCTION-SEGMENTS" "GET-INST-SPACE" "HANDLE-BREAK-ARGS"
             "INST" "INST-FORMAT" "LABEL-SEGMENTS"
             "MAYBE-NOTE-ASSEMBLER-ROUTINE" "MAYBE-NOTE-ASSOCIATED-STORAGE-REF"
             "MAYBE-NOTE-NIL-INDEXED-OBJECT"
             "MAYBE-NOTE-NIL-INDEXED-SYMBOL-SLOT-REF"
             "MAYBE-NOTE-SINGLE-STORAGE-REF" "NOTE" "NOTE-CODE-CONSTANT"
             "PARAMS" "PRIN1-QUOTED-SHORT" "PRIN1-SHORT" "PRINT-BYTES"
             "PRINT-CURRENT-ADDRESS" "PRINT-FIELD" "PRINT-INST"
             "PRINT-INST-USING" "PRINT-NOTES-AND-NEWLINE" "PRINT-WORDS"
             "SAP-REF-DCHUNK" "SEG-DEBUG-FUNCTION" "SEG-LENGTH" "SEG-START"
             "SEGMENT" "SET-ADDRESS-PRINTING-RANGE" "SET-DISASSEM-PARAMS"
             "SET-DSTATE-SEGMENT" "SIGN-EXTEND" "SPECIALIZE"))
(dolist
    (name
     '("*MAX-TRACE-INDENTATION*" "*TRACE-PRINT-LENGTH*" "*TRACE-PRINT-LEVEL*"
       "*TRACED-FUNCTION-LIST*"))
  (intern name "EXTENSIONS"))
(defpackage "DEBUG"
            (:import-from "EXTENSIONS" "*MAX-TRACE-INDENTATION*"
             "*TRACE-PRINT-LENGTH*" "*TRACE-PRINT-LEVEL*"
             "*TRACED-FUNCTION-LIST*")
            (:export "*AUTO-EVAL-IN-FRAME*" "*DEBUG-PRINT-LENGTH*"
             "*DEBUG-PRINT-LEVEL*" "*DEBUG-PROMPT*" "*FLUSH-DEBUG-ERRORS*"
             "*HELP-LINE-SCROLL-COUNT*" "*IN-THE-DEBUGGER*"
             "*MAX-TRACE-INDENTATION*" "*TRACE-FRAME*" "*TRACE-PRINT-LENGTH*"
             "*TRACE-PRINT-LEVEL*" "*TRACED-FUNCTION-LIST*" "ARG" "BACKTRACE"
             "INTERNAL-DEBUG" "VAR"))
(intern "CHAR" "LISP")
(defpackage "EXTENSIONS"
            (:import-from "LISP" "CHAR")
            (:export "*AFTER-GC-HOOKS*" "*AFTER-SAVE-INITIALIZATIONS*"
             "*ALL-MODIFIER-NAMES*" "*BACKUP-EXTENSION*" "*BEFORE-GC-HOOKS*"
             "*BEFORE-SAVE-INITIALIZATIONS*" "*BLOCK-COMPILE-DEFAULT*"
             "*BYTES-CONSED-BETWEEN-GCS*" "*CHAR" "*CLX-FDS-TO-DISPLAYS*"
             "*COMMAND-LINE-STRINGS*" "*COMMAND-LINE-SWITCHES*"
             "*COMMAND-LINE-UTILITY-NAME*" "*COMMAND-LINE-WORDS*"
             "*COMMAND-SWITCH-DEMONS*" "*COMPATIBILITY-WARNINGS*"
             "*COMPILE-PROGRESS*" "*DERIVE-FUNCTION-TYPES*"
             "*DESCRIBE-IMPLEMENTATION-DETAILS*" "*DESCRIBE-INDENTATION*"
             "*DESCRIBE-LEVEL*" "*DESCRIBE-PRINT-LENGTH*"
             "*DESCRIBE-PRINT-LEVEL*" "*DESCRIBE-VERBOSE*"
             "*DISPLAY-EVENT-HANDLERS*" "*EDITOR-LISP-P*"
             "*EFFICENCY-NOTE-COST-THRESHOLD*" "*EFFICENCY-NOTE-LIMIT*"
             "*ENCLOSING-SOURCE-CUTOFF*" "*ENVIRONMENT-LIST*"
             "*ERROR-PRINT-LENGTH*" "*ERROR-PRINT-LEVEL*" "*GC-INHIBIT-HOOK*"
             "*GC-NOTIFY-AFTER*" "*GC-NOTIFY-BEFORE*" "*GC-VERBOSE*"
             "*HEMLOCK-VERSION*" "*IGNORE-FLOATING-POINT-UNDERFLOW*"
             "*INFO-ENVIRONMENT*" "*INTEXP-MAXIMUM-EXPONENENT*"
             "*KEYWORD-PACKAGE*" "*LISP-PACKAGE*" "*LOAD-IF-SOURCE-NEWER*"
             "*MAX-OLD-TRACE-INDENTATION*" "*MAX-STEP-INDENTATION*"
             "*MAX-TRACE-INDENTATION*" "*MODULE-FILE-TRANSLATIONS*"
             "*OLD-TRACE-PRINT-LENGTH*" "*OLD-TRACE-PRINT-LEVEL*"
             "*OLD-TRACED-FUNCTION-LIST*" "*PROMPT*" "*REQUIRE-VERBOSE*"
             "*SAFE-DEFSTRUCT-ACCESSORS*" "*SETF-FDEFINITION-HOOK*"
             "*STEP-PRINT-LENGTH*" "*STEP-PRINT-LEVEL*" "*TERMINAL-LINE-MODE*"
             "*TOP-LEVEL-AUTO-DECLARE*" "*TRACE-PRINT-LENGTH*"
             "*TRACE-PRINT-LEVEL*" "*TRACED-FUNCTION-LIST*"
             "*UNDEFINED-WARNING-LIMIT*" "ACCEPT-TCP-CONNECTION"
             "ADD-OOB-HANDLER" "AMBIGUOUS-FILES" "ARGUMENT-LIST" "ASSQ"
             "BASIC-DEFINITION" "BIGNUMP" "BITP" "CACHE-HASH-EQ"
             "CALL-USER-MISCOP" "CANCEL-FINALIZATION" "CAREFUL-SYMBOL-FUNCTION"
             "CAREFULLY-ADD-FONT-PATHS" "CHAR" "CHAR-KEY-EVENT"
             "CLEAN-UP-COMPILER" "CLEAR-INFO" "CLEAR-SEARCH-LIST"
             "CLOSE-SOCKET" "CMD-SWITCH-ARG" "CMD-SWITCH-NAME"
             "CMD-SWITCH-STRING" "CMD-SWITCH-VALUE" "CMD-SWITCH-WORDS"
             "COLLECT" "COMMAND-LINE-SWITCH" "COMMAND-LINE-SWITCH-P"
             "COMPACT-INFO-ENVIRONMENT" "COMPILE-FROM-STREAM" "COMPILEDP"
             "COMPLETE-FILE" "CONCAT-PNAMES" "CONNECT-TO-INET-SOCKET"
             "CONSTANT" "CONSTANT-ARGUMENT" "CONSTANT-FUNCTION"
             "CREATE-INET-LISTENER" "CREATE-INET-SOCKET" "DEBUG"
	     "DEF-SOURCE-CONTEXT"
             "DEFAULT-CLX-EVENT-HANDLER" "DEFAULT-DIRECTORY"
             "DEFINE-CLX-MODIFIER" "DEFINE-HASH-CACHE" "DEFINE-INFO-CLASS"
             "DEFINE-INFO-TYPE" "DEFINE-KEY-EVENT-MODIFIER"
             "DEFINE-KEYBOARD-MODIFIER" "DEFINE-KEYSYM" "DEFINE-MOUSE-CODE"
             "DEFINE-MOUSE-KEYSYM" "DEFMODULE" "DEFSWITCH" "DEFUN-CACHED"
             "DELETEF" "DELQ" "DISABLE-CLX-EVENT-HANDLING"
             "DO-ALPHA-KEY-EVENTS" "DO-ANONYMOUS" "DO-INFO"
             "DOUBLE-FLOAT-NEGATIVE-INFINITY" "DOUBLE-FLOAT-POSITIVE-INFINITY"
             "DOUBLE-FLOATP" "DOVECTOR" "E" "ENABLE-CLX-EVENT-HANDLING"
             "ENCAPSULATE" "ENCAPSULATED-DEFINITION" "ENCAPSULATED-P"
             "END-BLOCK" "ENUMERATE-SEARCH-LIST" "FILE-COMMENT" "FILE-WRITABLE"
             "FINALIZE" "FIXNUMP" "FLOAT-DENORMALIZED-P" "FLOAT-INFINITY-P"
             "FLOAT-NAN-P" "FLOAT-TRAPPING-NAN-P" "FLOATING-POINT-INEXACT"
             "FLOATING-POINT-INVALID" "FLUSH-DISPLAY-EVENTS"
             "FORMAT-DECODED-TIME" "FORMAT-UNIVERSAL-TIME" "FREEZE-TYPE" "GC"
             "GC-OFF" "GC-ON" "GET-BYTES-CONSED" "GET-CODE-POINTER"
             "GET-COMMAND-LINE-SWITCH" "GET-DATA-POINTER"
             "GET-FLOATING-POINT-MODES" "GET-STREAM-COMMAND" "GRINDEF"
             "HOST-ENTRY" "HOST-ENTRY-ADDR" "HOST-ENTRY-ADDR-LIST"
             "HOST-ENTRY-ALIASES" "HOST-ENTRY-NAME" "HTONL" "HTONS"
             "INADDR-ANY" "INDENTING-FURTHER" "INFO"
             "INHIBIT-WARNINGS" "INTERACTIVE-EVAL" "IPPROTO-TCP" "IPPROTO-UDP"
             "ITERATE" "KEY-EVENT" "KEY-EVENT-BIT-P" "KEY-EVENT-BITS"
             "KEY-EVENT-BITS-MODIFIERS" "KEY-EVENT-CHAR" "KEY-EVENT-KEYSYM"
             "KEY-EVENT-MODIFIER-MASK" "KEY-EVENT-P" "KEYSYM-NAMES"
             "KEYSYM-PREFERRED-NAME" "LETF" "LETF*" "LISTEN-SKIP-WHITESPACE"
             "LOAD-FOREIGN" "LONG-FLOAT-NEGATIVE-INFINITY"
             "LONG-FLOAT-POSITIVE-INFINITY" "LONG-FLOATP" "LOOKUP-HOST-ENTRY"
             "MAKE-CASE-FROB-STREAM" "MAKE-INFO-ENVIRONMENT" "MAKE-KEY-EVENT"
             "MAKE-KEY-EVENT-BITS" "MAKE-STREAM-COMMAND" "MAKE-WEAK-POINTER"
             "MAYBE-INLINE" "MEMQ" "NAME-KEYSYM" "NTOHL" "NTOHS"
             "OBJECT-SET-EVENT-HANDLER" "OLD-TRACE" "OLD-UNTRACE" "ONCE-ONLY"
             "OPEN-CLX-DISPLAY" "OPTIMIZE-INTERFACE" "PARSE-TIME"
             "PRINT-DIRECTORY" "PRINT-HERALD" "PRINT-PRETTY-KEY"
             "PRINT-PRETTY-KEY-EVENT" "PROCESS-ALIVE-P" "PROCESS-CLOSE"
             "PROCESS-CORE-DUMPED" "PROCESS-ERROR" "PROCESS-EXIT-CODE"
             "PROCESS-INPUT" "PROCESS-KILL" "PROCESS-OUTPUT" "PROCESS-P"
             "PROCESS-PID" "PROCESS-PLIST" "PROCESS-PTY" "PROCESS-STATUS"
             "PROCESS-STATUS-HOOK" "PROCESS-WAIT" "PUTF" "QUIT" "RATIOP"
             "READ-CHAR-NO-EDIT" "REALP" "REMOVE-ALL-OOB-HANDLERS"
             "REMOVE-OOB-HANDLER" "REQUIRED-ARGUMENT" "RESET-FOREIGN-POINTERS"
             "RUN-PROGRAM" "SAVE" "SAVE-ALL-BUFFERS" "SAVE-LISP"
             "SCAVENGER-HOOK" "SCAVENGER-HOOK-P" "SEARCH-LIST"
             "SEND-CHARACTER-OUT-OF-BAND" "SERVE-BUTTON-PRESS"
             "SERVE-BUTTON-RELEASE" "SERVE-CIRCULATE-NOTIFY"
             "SERVE-CIRCULATE-REQUEST" "SERVE-CLIENT-MESSAGE"
             "SERVE-COLORMAP-NOTIFY" "SERVE-CONFIGURE-NOTIFY"
             "SERVE-CONFIGURE-REQUEST" "SERVE-CREATE-NOTIFY"
             "SERVE-DESTROY-NOTIFY" "SERVE-ENTER-NOTIFY" "SERVE-EXPOSURE"
             "SERVE-FOCUS-IN" "SERVE-FOCUS-OUT" "SERVE-GRAPHICS-EXPOSURE"
             "SERVE-GRAVITY-NOTIFY" "SERVE-KEY-PRESS" "SERVE-KEY-RELEASE"
             "SERVE-LEAVE-NOTIFY" "SERVE-MAP-NOTIFY" "SERVE-MAP-REQUEST"
             "SERVE-MOTION-NOTIFY" "SERVE-NO-EXPOSURE" "SERVE-PROPERTY-NOTIFY"
             "SERVE-REPARENT-NOTIFY" "SERVE-RESIZE-REQUEST"
             "SERVE-SELECTION-CLEAR" "SERVE-SELECTION-NOTIFY"
             "SERVE-SELECTION-REQUEST" "SERVE-UNMAP-NOTIFY"
             "SERVE-VISIBILITY-NOTIFY" "SET-FLOATING-POINT-MODES"
             "SET-SYMBOL-FUNCTION-CAREFULLY" "SHORT-FLOAT-NEGATIVE-INFINITY"
             "SHORT-FLOAT-POSITIVE-INFINITY" "SHORT-FLOATP"
             "SINGLE-FLOAT-NEGATIVE-INFINITY" "SINGLE-FLOAT-POSITIVE-INFINITY"
             "SINGLE-FLOATP" "START-BLOCK" "STREAM-COMMAND"
             "STREAM-COMMAND-ARGS" "STREAM-COMMAND-NAME" "STREAM-COMMAND-P"
             "STRUCTUREP" "SYMBOLICATE" "TRANSLATE-CHARACTER"
             "TRANSLATE-KEY-EVENT" "TRANSLATE-MOUSE-CHARACTER"
             "TRANSLATE-MOUSE-KEY-EVENT" "TRULY-THE" "UNCOMPILE"
             "UNDEFINED-VALUE" "UNENCAPSULATE" "UNIX-NAMESTRING" "WEAK-POINTER"
             "WEAK-POINTER-P" "WEAK-POINTER-VALUE" "WITH-CLX-EVENT-HANDLING"))
(defpackage "LOOP")
(defpackage "HEMLOCK-INTERNALS"
            (:export "*BUFFER-LIST*" "*BUFFER-NAMES*"
             "*CHARACTER-ATTRIBUTE-NAMES*" "*COMMAND-NAMES*"
             "*CREATE-INITIAL-WINDOWS-HOOK*" "*CREATE-WINDOW-HOOK*"
             "*DELETE-WINDOW-HOOK*" "*ECHO-AREA-BUFFER*" "*ECHO-AREA-STREAM*"
             "*ECHO-AREA-WINDOW*" "*EDITOR-INPUT*" "*GLOBAL-VARIABLE-NAMES*"
             "*INPUT-TRANSCRIPT*" "*INVOKE-HOOK*" "*KEY-EVENT-HISTORY*"
             "*LAST-KEY-EVENT-TYPED*" "*LOGICAL-KEY-EVENT-NAMES*"
             "*MODE-NAMES*" "*PARSE-DEFAULT*" "*PARSE-DEFAULT-STRING*"
             "*PARSE-HELP*" "*PARSE-INPUT-REGION*" "*PARSE-PROMPT*"
             "*PARSE-STARTING-MARK*" "*PARSE-STRING-TABLES*" "*PARSE-TYPE*"
             "*PARSE-VALUE-MUST-EXIST*" "*PARSE-VERIFICATION-FUNCTION*"
             "*PRINT-REGION*" "*RANDOM-TYPEOUT-BUFFERS*"
             "*RANDOM-TYPEOUT-HOOK*" "*REAL-EDITOR-INPUT*" "*WINDOW-LIST*"
             "ABORT-RECURSIVE-EDIT" "ADD-HOOK" "AFTER-EDITOR-INITIALIZATIONS"
             "BIND-KEY" "BLANK-AFTER-P" "BLANK-BEFORE-P" "BLANK-LINE-P"
             "BUFFER" "BUFFER-DELETE-HOOK" "BUFFER-END" "BUFFER-END-MARK"
             "BUFFER-MAJOR-MODE" "BUFFER-MINOR-MODE" "BUFFER-MODELINE-FIELD-P"
             "BUFFER-MODELINE-FIELDS" "BUFFER-MODES" "BUFFER-MODIFIED"
             "BUFFER-NAME" "BUFFER-PATHNAME" "BUFFER-POINT" "BUFFER-REGION"
             "BUFFER-SIGNATURE" "BUFFER-START" "BUFFER-START-MARK"
             "BUFFER-VARIABLES" "BUFFER-WINDOWS" "BUFFER-WRITABLE"
             "BUFFER-WRITE-DATE" "BUFFERP" "CENTER-WINDOW"
             "CHARACTER-ATTRIBUTE" "CHARACTER-ATTRIBUTE-DOCUMENTATION"
             "CHARACTER-ATTRIBUTE-HOOKS" "CHARACTER-ATTRIBUTE-NAME"
             "CHARACTER-ATTRIBUTE-P" "CHARACTER-OFFSET" "CLEAR-ECHO-AREA"
             "CLEAR-EDITOR-INPUT" "CLRSTRING" "COMMAND" "COMMAND-BINDINGS"
             "COMMAND-CASE" "COMMAND-DOCUMENTATION" "COMMAND-FUNCTION"
             "COMMAND-NAME" "COMMANDP" "COMPLETE-STRING" "COPY-MARK"
             "COPY-REGION" "COUNT-CHARACTERS" "COUNT-LINES" "CURRENT-BUFFER"
             "CURRENT-POINT" "CURRENT-VARIABLE-TABLES" "CURRENT-WINDOW"
             "CURSORPOS-TO-MARK" "DEFATTRIBUTE" "DEFAULT-FONT" "DEFCOMMAND"
             "DEFHVAR" "DEFINE-LOGICAL-KEY-EVENT" "DEFINE-TTY-FONT" "DEFMODE"
             "DELETE-AND-SAVE-REGION" "DELETE-BUFFER" "DELETE-CHARACTERS"
             "DELETE-FONT-MARK" "DELETE-KEY-BINDING" "DELETE-LINE-FONT-MARKS"
             "DELETE-MARK" "DELETE-REGION" "DELETE-STRING" "DELETE-VARIABLE"
             "DELETE-WINDOW" "DIRECTORYP" "DISPLAYED-P" "DO-ALPHA-CHARS"
             "DO-STRINGS" "EDITOR-DESCRIBE-FUNCTION" "EDITOR-ERROR"
             "EDITOR-ERROR-FORMAT-ARGUMENTS" "EDITOR-ERROR-FORMAT-STRING"
             "EDITOR-FINISH-OUTPUT" "EDITOR-SLEEP" "EMPTY-LINE-P" "END-LINE-P"
             "ENTER-WINDOW-AUTORAISE" "EXIT-HEMLOCK" "EXIT-RECURSIVE-EDIT"
             "FETCH-CUT-STRING" "FILTER-REGION" "FIND-AMBIGUOUS"
             "FIND-ATTRIBUTE" "FIND-CONTAINING" "FIND-PATTERN" "FIRST-LINE-P"
             "FONT-MARK" "FUN-DEFINED-FROM-PATHNAME" "GET-COMMAND"
             "GET-KEY-EVENT" "GETSTRING" "HANDLE-LISP-ERRORS" "HEMLOCK-BOUND-P"
             "HEMLOCK-OUTPUT-STREAM" "HEMLOCK-OUTPUT-STREAM-P"
             "HEMLOCK-REGION-STREAM" "HEMLOCK-REGION-STREAM-P" "HLET"
             "IN-RECURSIVE-EDIT" "INPUT-WAITING" "INSERT-CHARACTER"
             "INSERT-REGION" "INSERT-STRING" "INVOKE-HOOK" "KEY-TRANSLATION"
             "LAST-COMMAND-TYPE" "LAST-KEY-EVENT-CURSORPOS" "LAST-LINE-P"
             "LINE" "LINE-BUFFER" "LINE-CHARACTER" "LINE-END" "LINE-LENGTH"
             "LINE-NEXT" "LINE-OFFSET" "LINE-PLIST" "LINE-PREVIOUS"
             "LINE-SIGNATURE" "LINE-START" "LINE-STRING" "LINE-TO-REGION"
             "LINE<" "LINE<=" "LINE>" "LINE>=" "LINEP" "LINES-RELATED"
             "LISTEN-EDITOR-INPUT" "LOGICAL-KEY-EVENT-DOCUMENTATION"
             "LOGICAL-KEY-EVENT-KEY-EVENTS" "LOGICAL-KEY-EVENT-NAME"
             "LOGICAL-KEY-EVENT-P" "LOUD-MESSAGE" "MAKE-BUFFER" "MAKE-COMMAND"
             "MAKE-EMPTY-REGION" "MAKE-HEMLOCK-OUTPUT-STREAM"
             "MAKE-HEMLOCK-REGION-STREAM" "MAKE-KBDMAC-STREAM"
             "MAKE-MODELINE-FIELD" "MAKE-RING" "MAKE-STRING-TABLE"
             "MAKE-WINDOW" "MAKE-XWINDOW-LIKE-HWINDOW" "MAP-BINDINGS" "MARK"
             "MARK-AFTER" "MARK-BEFORE" "MARK-CHARPOS" "MARK-COLUMN"
             "MARK-KIND" "MARK-LINE" "MARK-TO-CURSORPOS" "MARK/=" "MARK<"
             "MARK<=" "MARK=" "MARK>" "MARK>=" "MARKP"
             "MERGE-RELATIVE-PATHNAMES" "MESSAGE" "MODE-DOCUMENTATION"
             "MODE-MAJOR-P" "MODE-VARIABLES" "MODELINE-FIELD"
             "MODELINE-FIELD-FUNCTION" "MODELINE-FIELD-NAME" "MODELINE-FIELD-P"
             "MODELINE-FIELD-WIDTH" "MODIFY-KBDMAC-STREAM" "MOVE-FONT-MARK"
             "MOVE-MARK" "MOVE-TO-COLUMN" "MOVE-TO-POSITION"
             "NEW-SEARCH-PATTERN" "NEXT-CHARACTER" "NEXT-WINDOW"
             "NINSERT-REGION" "PAUSE-HEMLOCK" "PREFIX-ARGUMENT"
             "PREVIOUS-CHARACTER" "PREVIOUS-WINDOW" "PROMPT-FOR-BUFFER"
             "PROMPT-FOR-EXPRESSION" "PROMPT-FOR-FILE" "PROMPT-FOR-INTEGER"
             "PROMPT-FOR-KEY" "PROMPT-FOR-KEY-EVENT" "PROMPT-FOR-KEYWORD"
             "PROMPT-FOR-STRING" "PROMPT-FOR-VARIABLE" "PROMPT-FOR-Y-OR-N"
             "PROMPT-FOR-YES-OR-NO" "READ-FILE" "RECURSIVE-EDIT" "REDISPLAY"
             "REDISPLAY-ALL" "REGION" "REGION-BOUNDS" "REGION-END"
             "REGION-START" "REGION-TO-STRING" "REGIONP" "REMOVE-HOOK"
             "REMOVE-SCHEDULED-EVENT" "REPLACE-PATTERN" "REPROMPT"
             "REVERSE-FIND-ATTRIBUTE" "RING" "RING-LENGTH" "RING-POP"
             "RING-PUSH" "RING-REF" "RINGP" "ROTATE-RING" "SAME-LINE-P"
             "SCHEDULE-EVENT" "SCROLL-WINDOW" "SEARCH-CHAR-CODE-LIMIT"
             "SEARCH-PATTERN" "SEARCH-PATTERN-P" "SET-REGION-BOUNDS" "SETV"
             "SHADOW-ATTRIBUTE" "SHOW-MARK" "START-LINE-P" "STORE-CUT-STRING"
             "STRING-TABLE" "STRING-TABLE-P" "STRING-TABLE-SEPARATOR"
             "STRING-TO-REGION" "STRING-TO-VARIABLE" "SYNTAX-CHAR-CODE-LIMIT"
             "UNGET-KEY-EVENT" "UNSHADOW-ATTRIBUTE" "UPDATE-MODELINE-FIELD"
             "UPDATE-MODELINE-FIELDS" "USE-BUFFER" "VALUE"
             "VARIABLE-DOCUMENTATION" "VARIABLE-HOOKS" "VARIABLE-NAME"
             "VARIABLE-VALUE" "WINDOW" "WINDOW-BUFFER" "WINDOW-DISPLAY-END"
             "WINDOW-DISPLAY-RECENTERING" "WINDOW-DISPLAY-START" "WINDOW-FONT"
             "WINDOW-HEIGHT" "WINDOW-POINT" "WINDOW-WIDTH" "WINDOWP"
             "WITH-INPUT-FROM-REGION" "WITH-MARK" "WITH-OUTPUT-TO-MARK"
             "WITH-POP-UP-DISPLAY" "WITH-WRITABLE-BUFFER" "WRITE-FILE"))
(dolist
    (name
     '("DEBUG-SOURCE" "DEBUG-SOURCE-COMPILED" "DEBUG-SOURCE-CREATED"
       "DEBUG-SOURCE-FROM" "DEBUG-SOURCE-NAME" "DEBUG-SOURCE-P"
       "DEBUG-SOURCE-START-POSITIONS"))
  (intern name "C"))
(defpackage "DEBUG-INTERNALS"
            (:import-from "C" "DEBUG-SOURCE" "DEBUG-SOURCE-COMPILED"
             "DEBUG-SOURCE-CREATED" "DEBUG-SOURCE-FROM" "DEBUG-SOURCE-NAME"
             "DEBUG-SOURCE-P" "DEBUG-SOURCE-START-POSITIONS")
            (:export "*DEBUGGING-INTERPRETER*" "ACTIVATE-BREAKPOINT"
             "AMBIGUOUS-DEBUG-VARIABLES" "AMBIGUOUS-VARIABLE-NAME" "BREAKPOINT"
             "BREAKPOINT-ACTIVE-P" "BREAKPOINT-HOOK-FUNCTION" "BREAKPOINT-INFO"
             "BREAKPOINT-KIND" "BREAKPOINT-P" "BREAKPOINT-WHAT" "CODE-LOCATION"
             "CODE-LOCATION-DEBUG-BLOCK" "CODE-LOCATION-DEBUG-FUNCTION"
             "CODE-LOCATION-DEBUG-SOURCE" "CODE-LOCATION-FORM-NUMBER"
             "CODE-LOCATION-P" "CODE-LOCATION-TOP-LEVEL-FORM-OFFSET"
             "CODE-LOCATION-UNKNOWN-P" "CODE-LOCATION=" "DEACTIVATE-BREAKPOINT"
             "DEBUG-BLOCK" "DEBUG-BLOCK-ELSEWHERE-P" "DEBUG-BLOCK-P"
             "DEBUG-BLOCK-SUCCESSORS" "DEBUG-CONDITION" "DEBUG-ERROR"
             "DEBUG-FUNCTION" "DEBUG-FUNCTION-FUNCTION" "DEBUG-FUNCTION-KIND"
             "DEBUG-FUNCTION-LAMBDA-LIST" "DEBUG-FUNCTION-NAME"
             "DEBUG-FUNCTION-P" "DEBUG-FUNCTION-START-LOCATION"
             "DEBUG-FUNCTION-SYMBOL-VARIABLES" "DEBUG-SOURCE"
             "DEBUG-SOURCE-COMPILED" "DEBUG-SOURCE-CREATED" "DEBUG-SOURCE-FROM"
             "DEBUG-SOURCE-NAME" "DEBUG-SOURCE-P" "DEBUG-SOURCE-ROOT-NUMBER"
             "DEBUG-SOURCE-START-POSITIONS" "DEBUG-VARIABLE"
             "DEBUG-VARIABLE-ID" "DEBUG-VARIABLE-INFO-AVAILABLE"
             "DEBUG-VARIABLE-NAME" "DEBUG-VARIABLE-P" "DEBUG-VARIABLE-PACKAGE"
             "DEBUG-VARIABLE-SYMBOL" "DEBUG-VARIABLE-VALID-VALUE"
             "DEBUG-VARIABLE-VALIDITY" "DEBUG-VARIABLE-VALUE"
             "DELETE-BREAKPOINT" "DELETE-BREAKPOINT-FOR-EDITOR" "DO-BLOCKS"
             "DO-DEBUG-BLOCK-LOCATIONS" "DO-DEBUG-FUNCTION-BLOCKS"
             "DO-DEBUG-FUNCTION-VARIABLES" "EVAL-IN-FRAME"
             "FORM-NUMBER-TRANSLATIONS" "FRAME" "FRAME-CATCHES"
             "FRAME-CODE-LOCATION" "FRAME-DEBUG-FUNCTION" "FRAME-DOWN"
             "FRAME-FUNCTION-MISMATCH" "FRAME-NUMBER" "FRAME-P" "FRAME-UP"
             "FUNCTION-DEBUG-FUNCTION" "FUNCTION-END-COOKIE-VALID-P"
             "INVALID-CONTROL-STACK-POINTER" "INVALID-VALUE"
             "LAMBDA-LIST-UNAVAILABLE" "MAKE-BREAKPOINT" "NO-DEBUG-BLOCKS"
             "NO-DEBUG-FUNCTION-RETURNS" "NO-DEBUG-INFO" "PREPROCESS-FOR-EVAL"
             "RETURN-FROM-FRAME" "SET-BREAKPOINT-FOR-EDITOR"
             "SET-LOCATION-BREAKPOINT-FOR-EDITOR" "SOURCE-PATH-CONTEXT"
             "TOP-FRAME" "UNHANDLED-CONDITION" "UNKNOWN-CODE-LOCATION"
             "UNKNOWN-CODE-LOCATION-P" "UNKNOWN-DEBUG-VARIABLE"))
(dolist
    (name
     '("%ALIGNED-SAP" "%ARRAY-TYPEP" "%ASET" "%BITSET" "%CHARSET" "%PUT"
       "%RPLACA" "%RPLACD" "%SBITSET" "%SCHARSET" "%SET-DOCUMENTATION"
       "%SET-FDEFINITION" "%SET-FILL-POINTER" "%SET-ROW-MAJOR-AREF"
       "%SET-SAP-REF-DESCRIPTOR" "%SETELT" "%SETNTH" "%SP-STRING-COMPARE"
       "%SVSET" "%TYPEP" "LONG-FLOAT-P" "NIL" "RETURN" "SET" "SHORT-FLOAT-P"
       "STRING/=*" "STRING<*" "STRING<=*" "STRING=*" "STRING>*" "STRING>=*"
       "SYMBOL-FUNCTION" "SYMBOL-VALUE" "THROW" "VALUES-LIST"))
  (intern name "LISP"))
(intern "BOOLEAN" "ALIEN")
(dolist
    (name
     '("%PRIMITIVE" "%STANDARD-CHAR-P" "%STRING-CHAR-P" "BITS" "BYTES"
       "C-PROCEDURE" "CHECK<=" "CHECK=" "CT-A-VAL" "CT-A-VAL-OFFSET"
       "CT-A-VAL-P" "CT-A-VAL-SAP" "CT-A-VAL-SIZE" "CT-A-VAL-TYPE"
       "DEFENUMERATION" "DEFOPERATOR" "DEPORT-BOOLEAN" "DEPORT-INTEGER"
       "ENUMERATION" "FOREIGN-SYMBOL-ADDRESS" "LONG-WORDS" "MAKE-CT-A-VAL"
       "NATURALIZE-BOOLEAN" "NATURALIZE-INTEGER" "NULL-TERMINATED-STRING"
       "PERQ-STRING" "POINTER" "PORT" "RECORD-SIZE" "SAP+" "SAP-REF-16"
       "SAP-REF-32" "SAP-REF-8" "SAP-REF-SAP" "SIGNED-SAP-REF-16"
       "SIGNED-SAP-REF-32" "SIGNED-SAP-REF-8" "SYSTEM-AREA-POINTER" "WORDS"))
  (intern name "SYSTEM"))
(intern "SYMBOLICATE" "EXTENSIONS")
(dolist
    (name
     '("%RAW-BITS" "%SET-SAP-REF-16" "%SET-SAP-REF-32" "%SET-SAP-REF-8"
       "%SET-SAP-REF-DOUBLE" "%SET-SAP-REF-SAP" "%SET-SAP-REF-SINGLE"
       "%SP-SET-DEFINITION" "%SP-SET-PLIST" "ARRAY-HEADER-P" "BASE-CHAR-P"
       "CODE-INSTRUCTIONS" "DOUBLE-FLOAT-P" "ODD-KEYWORD-ARGUMENTS-ERROR"
       "SIMPLE-ARRAY-P" "SINGLE-FLOAT-P" "STRUCTURE-REF" "STRUCTURE-SET"
       "UNKNOWN-KEYWORD-ARGUMENT-ERROR"))
  (intern name "KERNEL"))
(defpackage "C"
            (:import-from "LISP" "%ALIGNED-SAP" "%ARRAY-TYPEP" "%ASET"
             "%BITSET" "%CHARSET" "%PUT" "%RPLACA" "%RPLACD" "%SBITSET"
             "%SCHARSET" "%SET-DOCUMENTATION" "%SET-FDEFINITION"
             "%SET-FILL-POINTER" "%SET-ROW-MAJOR-AREF"
             "%SET-SAP-REF-DESCRIPTOR" "%SETELT" "%SETNTH" "%SP-STRING-COMPARE"
             "%SVSET" "%TYPEP" "LONG-FLOAT-P" "NIL" "RETURN" "SET"
             "SHORT-FLOAT-P" "STRING/=*" "STRING<*" "STRING<=*" "STRING=*"
             "STRING>*" "STRING>=*" "SYMBOL-FUNCTION" "SYMBOL-VALUE" "THROW"
             "VALUES-LIST")
            (:import-from "ALIEN" "BOOLEAN")
            (:import-from "SYSTEM" "%PRIMITIVE" "%STANDARD-CHAR-P"
             "%STRING-CHAR-P" "BITS" "BYTES" "C-PROCEDURE" "CHECK<=" "CHECK="
             "CT-A-VAL" "CT-A-VAL-OFFSET" "CT-A-VAL-P" "CT-A-VAL-SAP"
             "CT-A-VAL-SIZE" "CT-A-VAL-TYPE" "DEFENUMERATION" "DEFOPERATOR"
             "DEPORT-BOOLEAN" "DEPORT-INTEGER" "ENUMERATION"
             "FOREIGN-SYMBOL-ADDRESS" "LONG-WORDS" "MAKE-CT-A-VAL"
             "NATURALIZE-BOOLEAN" "NATURALIZE-INTEGER" "NULL-TERMINATED-STRING"
             "PERQ-STRING" "POINTER" "PORT" "RECORD-SIZE" "SAP+" "SAP-REF-16"
             "SAP-REF-32" "SAP-REF-8" "SAP-REF-SAP" "SIGNED-SAP-REF-16"
             "SIGNED-SAP-REF-32" "SIGNED-SAP-REF-8" "SYSTEM-AREA-POINTER"
             "WORDS")
            (:import-from "EXTENSIONS" "SYMBOLICATE")
            (:import-from "KERNEL" "%RAW-BITS" "%SET-SAP-REF-16"
             "%SET-SAP-REF-32" "%SET-SAP-REF-8" "%SET-SAP-REF-DOUBLE"
             "%SET-SAP-REF-SAP" "%SET-SAP-REF-SINGLE" "%SP-SET-DEFINITION"
             "%SP-SET-PLIST" "ARRAY-HEADER-P" "BASE-CHAR-P" "CODE-INSTRUCTIONS"
             "DOUBLE-FLOAT-P" "ODD-KEYWORD-ARGUMENTS-ERROR" "SIMPLE-ARRAY-P"
             "SINGLE-FLOAT-P" "STRUCTURE-REF" "STRUCTURE-SET"
             "UNKNOWN-KEYWORD-ARGUMENT-ERROR")
            (:export "%ALIEN-FUNCALL" "%CATCH-BREAKUP" "%CONTINUE-UNWIND"
             "%LISTIFY-REST-ARGS" "%MORE-ARG" "%UNWIND-PROTECT-BREAKUP"
             "*BACKEND*" "*CODE-SEGMENT*" "*COLLECT-DYNAMIC-STATISTICS*"
             "*COMPILE-TIME-DEFINE-MACROS*" "*COMPILER-NOTIFICATION-FUNCTION*"
             "*COMPILING-FOR-INTERPRETER*" "*CONVERTING-FOR-INTERPRETER*"
             "*COUNT-VOP-USAGES*" "*ELSEWHERE*" "*NATIVE-BACKEND*"
             "*SUPPRESS-VALUES-DECLARATION*" "*TARGET-BACKEND*"
             "ALLOC-NUMBER-STACK-SPACE" "ALLOCATE-CODE-OBJECT" "ALLOCATE-FRAME"
             "ALLOCATE-FULL-CALL-FRAME" "ANY" "ARGUMENT-COUNT-ERROR"
             "ATTRIBUTES" "ATTRIBUTES-INTERSECTION" "ATTRIBUTES-UNION"
             "ATTRIBUTES=" "BACKEND-ANY-PRIMITIVE-TYPE"
             "BACKEND-ASSEMBLER-RESOURCES" "BACKEND-BYTE-ORDER"
             "BACKEND-DISASSEM-PARAMS" "BACKEND-FASL-FILE-IMPLEMENTATION"
             "BACKEND-FASL-FILE-TYPE" "BACKEND-FASL-FILE-VERSION"
             "BACKEND-FEATURES" "BACKEND-INFO-ENVIRONMENT"
             "BACKEND-INSTRUCTION-FLAVORS" "BACKEND-INSTRUCTION-FORMATS"
             "BACKEND-NAME" "BACKEND-REGISTER-SAVE-PENALTY"
             "BACKEND-SPECIAL-ARG-TYPES" "BACKEND-VERSION" "BIND" "BRANCH"
             "CALL" "CALL-LOCAL" "CALL-NAMED" "CALL-OUT" "CALL-VARIABLE"
             "CALLEE-NFP-TN" "CALLEE-RETURN-PC-TN" "CATCH-BLOCK" "CHECK-CONS"
             "CHECK-FIXNUM" "CHECK-FUNCTION" "CHECK-FUNCTION-OR-SYMBOL"
             "CHECK-SIGNED-BYTE-32" "CHECK-SYMBOL" "CHECK-UNSIGNED-BYTE-32"
             "CLOSURE-INIT" "CLOSURE-REF" "CODE-CONSTANT-REF"
             "CODE-CONSTANT-SET" "CODE-INSTRUCTIONS" "COERCE-TO-FUNCTION"
             "COMPILE-FOR-EVAL" "COMPONENT" "COMPONENT-HEADER-LENGTH"
             "COMPONENT-INFO" "COMPONENT-LIVE-TN" "COMPUTE-FUNCTION"
             "COMPUTE-OLD-NFP" "COPY-MORE-ARG" "COUNT-ME"
             "CURRENT-BINDING-POINTER" "CURRENT-NFP-TN" "CURRENT-STACK-POINTER"
             "DEALLOC-NUMBER-STACK-SPACE" "DEF-BOOLEAN-ATTRIBUTE"
             "DEF-IR1-TRANSLATOR" "DEF-PRIMITIVE-TRANSLATOR"
             "DEF-PRIMITIVE-TYPE" "DEF-PRIMITIVE-TYPE-ALIAS"
             "DEF-SOURCE-TRANSFORM" "DEF-VM-SUPPORT-ROUTINE"
             "DEFINE-ASSEMBLY-ROUTINE" "DEFINE-MOVE-FUNCTION" "DEFINE-MOVE-VOP"
             "DEFINE-STORAGE-BASE" "DEFINE-STORAGE-CLASS" "DEFINE-VOP"
             "DEFKNOWN" "DEFOPTIMIZER" "DEFTRANSFORM" "DERIVE-TYPE"
             "ENTRY-NODE-INFO-NLX-TAG" "ENTRY-NODE-INFO-ST-TOP"
             "ENVIRONMENT-DEBUG-LIVE-TN" "ENVIRONMENT-LIVE-TN"
             "FASL-FILE-IMPLEMENTATIONS" "FAST-SAFE-COERCE-TO-FUNCTION"
             "FAST-SYMBOL-FUNCTION" "FAST-SYMBOL-VALUE" "FLUSHABLE" "FOLDABLE"
             "FORCE-TN-TO-STACK" "FOREIGN-SYMBOL-ADDRESS" "GET-VECTOR-SUBTYPE"
             "HALT" "IF-EQ" "IR2-COMPONENT-CONSTANTS" "IR2-CONVERT"
             "IR2-ENVIRONMENT-NUMBER-STACK-P" "KNOWN-CALL-LOCAL" "KNOWN-RETURN"
             "LAMBDA-EVAL-INFO-ARGS-PASSED" "LAMBDA-EVAL-INFO-ENTRIES"
             "LAMBDA-EVAL-INFO-FRAME-SIZE" "LAMBDA-EVAL-INFO-FUNCTION"
             "LOCATION=" "LTN-ANNOTATE" "MAKE-ALIAS-TN" "MAKE-CATCH-BLOCK"
             "MAKE-CLOSURE" "MAKE-CONSTANT-TN" "MAKE-FIXNUM"
             "MAKE-LOAD-TIME-CONSTANT-TN" "MAKE-N-TNS" "MAKE-NORMAL-TN"
             "MAKE-OTHER-IMMEDIATE-TYPE" "MAKE-RANDOM-TN"
             "MAKE-REPRESENTATION-TN" "MAKE-RESTRICTED-TN" "MAKE-SC-OFFSET"
             "MAKE-STACK-POINTER-TN" "MAKE-TN-REF" "MAKE-UNWIND-BLOCK"
             "MAKE-VALUE-CELL" "MAKE-WIRED-TN" "META-PRIMITIVE-TYPE-OR-LOSE"
             "META-SB-OR-LOSE" "META-SC-NUMBER-OR-LOSE" "META-SC-OR-LOSE"
             "MORE-ARG-CONTEXT" "MOVABLE" "MOVE" "MULTIPLE-CALL"
             "MULTIPLE-CALL-LOCAL" "MULTIPLE-CALL-NAMED"
             "MULTIPLE-CALL-VARIABLE" "NIL" "NLX-ENTRY" "NLX-ENTRY-MULTIPLE"
             "NON-DESCRIPTOR-STACK" "NOTE-ENVIRONMENT-START"
             "NOTE-THIS-LOCATION" "ODD-KEYWORD-ARGUMENTS-ERROR" "OPTIMIZER"
             "PACK-TRACE-TABLE" "PMAX-FASL-FILE-IMPLEMENTATION" "POLICY"
             "PREDICATE" "PRIMITIVE-TYPE" "PRIMITIVE-TYPE-OF"
             "PRIMITIVE-TYPE-OR-LOSE" "PRIMITIVE-TYPE-VOP" "PUSH-VALUES"
             "READ-PACKED-BIT-VECTOR" "READ-VAR-INTEGER" "READ-VAR-STRING"
             "RESET-STACK-POINTER" "RESTORE-DYNAMIC-STATE" "RETURN"
             "RETURN-MULTIPLE" "RT-AFPA-FASL-FILE-IMPLEMENTATION"
             "RT-FASL-FILE-IMPLEMENTATION" "SAVE-DYNAMIC-STATE" "SB"
             "SB-ALLOCATED-SIZE" "SB-NAME" "SB-OR-LOSE" "SB-P" "SC" "SC-CASE"
             "SC-IS" "SC-NAME" "SC-NUMBER" "SC-NUMBER-OR-LOSE"
             "SC-OFFSET-OFFSET" "SC-OFFSET-SCN" "SC-OR-LOSE" "SC-P" "SC-SB"
             "SET" "SET-UNWIND-PROTECT" "SET-VECTOR-SUBTYPE"
             "SETUP-CLOSURE-ENVIRONMENT" "SETUP-ENVIRONMENT"
             "SPARC-FASL-FILE-IMPLEMENTATION" "SPECIFY-SAVE-TN" "STRUCTURE-REF"
             "STRUCTURE-SET" "SXHASH-SIMPLE-STRING" "SXHASH-SIMPLE-SUBSTRING"
             "SYMBOL-FUNCTION" "SYMBOL-VALUE" "SYMBOLICATE" "TAIL-CALL"
             "TAIL-CALL-NAMED" "TAIL-CALL-VARIABLE" "TEMPLATE-OR-LOSE" "THROW"
             "TN" "TN-OFFSET" "TN-P" "TN-REF" "TN-REF-ACROSS" "TN-REF-LOAD-TN"
             "TN-REF-NEXT" "TN-REF-NEXT-REF" "TN-REF-P" "TN-REF-TARGET"
             "TN-REF-TN" "TN-REF-VOP" "TN-REF-WRITE-P" "TN-SC" "TN-VALUE"
             "TRACE-TABLE-ENTRY" "TYPE-CHECK-ERROR" "UNBIND" "UNBIND-TO-HERE"
             "UNKNOWN-KEYWORD-ARGUMENT-ERROR" "UNSAFE" "UNWIND" "UWP-ENTRY"
             "VALUE-CELL-REF" "VALUE-CELL-SET" "VALUES-LIST"
             "VERIFY-ARGUMENT-COUNT" "WRITE-PACKED-BIT-VECTOR"
             "WRITE-VAR-INTEGER" "WRITE-VAR-STRING" "XEP-ALLOCATE-FRAME"))
(defpackage "DIRED"
            (:export "*CLOBBER-DEFAULT*" "*ERROR-FUNCTION*"
             "*RECURSIVE-DEFAULT*" "*REPORT-FUNCTION*" "*UPDATE-DEFAULT*"
             "*YESP-FUNCTION*" "COPY-FILE" "DELETE-FILE" "FIND-FILE"
             "MAKE-DIRECTORY" "PATHNAMES-FROM-PATTERN" "RENAME-FILE"))
(defpackage "WIRE"
            (:export "*CURRENT-WIRE*" "CONNECT-TO-REMOTE-SERVER"
             "CREATE-REQUEST-SERVER" "DESTROY-REQUEST-SERVER"
             "FORGET-REMOTE-TRANSLATION" "MAKE-REMOTE-OBJECT" "MAKE-WIRE"
             "REMOTE" "REMOTE-OBJECT" "REMOTE-OBJECT-EQ"
             "REMOTE-OBJECT-LOCAL-P" "REMOTE-OBJECT-P" "REMOTE-OBJECT-VALUE"
             "REMOTE-VALUE" "REMOTE-VALUE-BIND" "WIRE-EOF" "WIRE-ERROR"
             "WIRE-FD" "WIRE-FORCE-OUTPUT" "WIRE-GET-BIGNUM" "WIRE-GET-BYTE"
             "WIRE-GET-NUMBER" "WIRE-GET-OBJECT" "WIRE-GET-STRING"
             "WIRE-IO-ERROR" "WIRE-LISTEN" "WIRE-OUTPUT-BIGNUM"
             "WIRE-OUTPUT-BYTE" "WIRE-OUTPUT-FUNCALL" "WIRE-OUTPUT-NUMBER"
             "WIRE-OUTPUT-OBJECT" "WIRE-OUTPUT-STRING" "WIRE-P"))
(defpackage "PRETTY-PRINT" (:export "PRETTY-STREAM" "PRETTY-STREAM-P"))
(intern "LOAD-FOREIGN" "EXTENSIONS")
(defpackage "SYSTEM"
            (:import-from "EXTENSIONS" "LOAD-FOREIGN")
            (:export "%ASSEMBLER-CODE-TYPE" "%BIND-ALIGNED-SAP" "%PRIMITIVE"
             "%SP-BYTE-BLT" "%SP-FIND-CHARACTER"
             "%SP-FIND-CHARACTER-WITH-ATTRIBUTE"
             "%SP-REVERSE-FIND-CHARACTER-WITH-ATTRIBUTE" "%STANDARD-CHAR-P"
             "%STRING-CHAR-P" "*BEEP-FUNCTION*"
             "*IN-THE-COMPILER*" "*LONG-SITE-NAME*"
             "*MAXIMUM-INTERPRETER-ERROR-CHECKING*" "*NAMESERVERPORT*"
             "*PORNOGRAPHY-OF-DEATH*" "*PORT-OWNERSHIP-RIGHTS-HANDLERS*"
             "*PORT-RECEIVE-RIGHTS-HANDLERS*" "*SHORT-SITE-NAME*"
             "*SOFTWARE-TYPE*" "*STDERR*" "*STDIN*" "*STDOUT*" "*TASK-DATA*"
             "*TASK-NOTIFY*" "*TASK-SELF*" "*TTY*" "*TYPESCRIPTPORT*"
             "*USERTYPESCRIPT*" "*USERWINDOW*" "*XWINDOW-TABLE*"
             "ADD-FD-HANDLER" "ADD-PORT-DEATH-HANDLER" "ADD-PORT-OBJECT"
             "ADD-XWINDOW-OBJECT" "ALLOCATE-SYSTEM-MEMORY" "BEEP" "BITS"
             "BYTES" "C-PROCEDURE" "CHECK<=" "CHECK=" "COMPILER-VERSION"
             "CT-A-VAL" "CT-A-VAL-OFFSET" "CT-A-VAL-P" "CT-A-VAL-SAP"
             "CT-A-VAL-SIZE" "CT-A-VAL-TYPE" "DEALLOCATE-SYSTEM-MEMORY"
             "DEFAULT-INTERRUPT" "DEFENUMERATION" "DEFOPERATOR" "DEFRECORD"
             "DEPORT-BOOLEAN" "DEPORT-INTEGER" "DOUBLE-FLOAT-RADIX"
             "ENABLE-INTERRUPT" "ENUMERATION" "FD-STREAM" "FD-STREAM-FD"
             "FD-STREAM-P" "FEXPR" "FIND-IF-IN-CLOSURE"
             "FOREIGN-SYMBOL-ADDRESS" "GET-PAGE-SIZE" "GET-SYSTEM-INFO"
	     "IGNORE-INTERRUPT"
             "INT-SAP" "INVALIDATE-DESCRIPTOR" "IO-TIMEOUT" "LONG-FLOAT-RADIX"
             "LONG-WORDS" "MACRO" "MAKE-CT-A-VAL" "MAKE-FD-STREAM"
             "MAKE-INDENTING-STREAM" "MAKE-OBJECT-SET" "MAP-PORT" "MAP-XWINDOW"
             "NATURALIZE-BOOLEAN" "NATURALIZE-INTEGER" "NULL-TERMINATED-STRING"
             "OBJECT-SET-OPERATION" "OUTPUT-RAW-BYTES" "PARSE-BODY"
             "PERQ-STRING" "POINTER" "POINTER<" "POINTER>" "PORT" "PRIMEP"
             "READ-N-BYTES" "REALLOCATE-SYSTEM-MEMORY" "RECORD-SIZE"
             "REMOVE-FD-HANDLER" "REMOVE-PORT-DEATH-HANDLER"
             "REMOVE-PORT-OBJECT" "REMOVE-XWINDOW-OBJECT"
             "RESOLVE-LOADED-ASSEMBLER-REFERENCES" "SAP+" "SAP-" "SAP-INT"
             "SAP-REF-16" "SAP-REF-32" "SAP-REF-8" "SAP-REF-DESCRIPTOR"
             "SAP-REF-DOUBLE" "SAP-REF-SAP" "SAP-REF-SINGLE" "SAP<" "SAP<="
             "SAP=" "SAP>" "SAP>=" "SCRUB-CONTROL-STACK" "SERVE-ALL-EVENTS"
             "SERVE-EVENT" "SERVER" "SERVER-MESSAGE" "SHORT-FLOAT-RADIX"
             "SIGNED-SAP-REF-16" "SIGNED-SAP-REF-32" "SIGNED-SAP-REF-8"
             "SINGLE-FLOAT-RADIX" "SYMBOL-MACRO-LET" "SYSTEM-AREA-POINTER"
             "SYSTEM-AREA-POINTER-P" "UNPROCLAIM" "UNSTRUCTURED" "VECTOR-SAP"
             "WAIT-UNTIL-FD-USABLE" "WITH-ENABLED-INTERRUPTS" "WITH-FD-HANDLER"
             "WITH-INTERRUPTS" "WITH-REPLY-PORT" "WITHOUT-GCING"
             "WITHOUT-HEMLOCK" "WITHOUT-INTERRUPTS" "WORDS"))
(dolist
    (name
     '("*" "ARRAY" "DOUBLE-FLOAT" "FUNCTION" "INTEGER" "SINGLE-FLOAT" "UNION"
       "VALUES"))
  (intern name "LISP"))
(defpackage "ALIEN"
            (:import-from "LISP" "*" "ARRAY" "DOUBLE-FLOAT" "FUNCTION"
             "INTEGER" "SINGLE-FLOAT" "UNION" "VALUES")
            (:export "*" "ADDR" "ALIEN" "ALIEN-FUNCALL" "ALIEN-SAP"
             "ALIEN-SIZE" "ARRAY" "BOOLEAN" "CAST" "DEF-ALIEN-ROUTINE"
             "DEF-ALIEN-TYPE" "DEF-ALIEN-VARIABLE" "DEF-BUILTIN-ALIEN-TYPE"
             "DEREF" "DOUBLE-FLOAT" "ENUM" "EXTERN-ALIEN" "FUNCTION" "INTEGER"
             "SAP-ALIEN" "SIGNED" "SINGLE-FLOAT" "SLOT" "STRUCT" "UNION"
             "UNSIGNED" "VALUES" "WITH-ALIEN"))
(dolist
    (name
     '("%CAST" "%DEREF-ADDR" "%HEAP-ALIEN" "%HEAP-ALIEN-ADDR"
       "%LOCAL-ALIEN-ADDR" "%LOCAL-ALIEN-FORCED-TO-MEMORY-P" "%SAP-ALIEN"
       "%SET-DEREF" "%SET-HEAP-ALIEN" "%SET-LOCAL-ALIEN" "%SET-SLOT"
       "%SLOT-ADDR" "*VALUES-TYPE-OKAY*" "ALIEN" "ALIEN-ARRAY-TYPE"
       "ALIEN-ARRAY-TYPE-DIMENSIONS" "ALIEN-ARRAY-TYPE-ELEMENT-TYPE"
       "ALIEN-ARRAY-TYPE-P" "ALIEN-BOOLEAN-TYPE" "ALIEN-BOOLEAN-TYPE-P"
       "ALIEN-DOUBLE-FLOAT-TYPE" "ALIEN-DOUBLE-FLOAT-TYPE-P"
       "ALIEN-ENUM-TYPE" "ALIEN-ENUM-TYPE-P" "ALIEN-FLOAT-TYPE"
       "ALIEN-FLOAT-TYPE-P" "ALIEN-FUNCTION-TYPE"
       "ALIEN-FUNCTION-TYPE-ARG-TYPES" "ALIEN-FUNCTION-TYPE-P"
       "ALIEN-FUNCTION-TYPE-RESULT-TYPE" "ALIEN-INTEGER-TYPE"
       "ALIEN-INTEGER-TYPE-P" "ALIEN-INTEGER-TYPE-SIGNED"
       "ALIEN-POINTER-TYPE" "ALIEN-POINTER-TYPE-P" "ALIEN-POINTER-TYPE-TO"
       "ALIEN-RECORD-FIELD" "ALIEN-RECORD-FIELD-NAME"
       "ALIEN-RECORD-FIELD-OFFSET" "ALIEN-RECORD-FIELD-P"
       "ALIEN-RECORD-FIELD-TYPE" "ALIEN-RECORD-TYPE"
       "ALIEN-RECORD-TYPE-FIELDS" "ALIEN-RECORD-TYPE-P"
       "ALIEN-SINGLE-FLOAT-TYPE" "ALIEN-SINGLE-FLOAT-TYPE-P"
       "ALIEN-SUBTYPE-P" "ALIEN-TYPE" "ALIEN-TYPE-=" "ALIEN-TYPE-ALIGNMENT"
       "ALIEN-TYPE-BITS" "ALIEN-TYPE-P" "ALIEN-TYPEP" "ALIEN-VALUE"
       "ALIEN-VALUE-TYPE" "ALIEN-VALUES-TYPE" "ALIEN-VALUES-TYPE-P"
       "ALIEN-VALUES-TYPE-VALUES" "ALIGN-OFFSET" "COMPUTE-ALIEN-REP-TYPE"
       "COMPUTE-DEPORT-LAMBDA" "COMPUTE-DEPOSIT-LAMBDA"
       "COMPUTE-EXTRACT-LAMBDA" "COMPUTE-LISP-REP-TYPE"
       "COMPUTE-NATURALIZE-LAMBDA" "DEF-ALIEN-TYPE-CLASS"
       "DEF-ALIEN-TYPE-METHOD" "DEF-ALIEN-TYPE-TRANSLATOR" "DEPORT"
       "DEPOSIT-ALIEN-VALUE" "DISPOSE-LOCAL-ALIEN" "EXTRACT-ALIEN-VALUE"
       "HEAP-ALIEN-INFO" "HEAP-ALIEN-INFO-P" "HEAP-ALIEN-INFO-SAP-FORM"
       "HEAP-ALIEN-INFO-TYPE" "INVOKE-ALIEN-TYPE-METHOD" "LOCAL-ALIEN"
       "LOCAL-ALIEN-INFO" "LOCAL-ALIEN-INFO-FORCE-TO-MEMORY-P"
       "LOCAL-ALIEN-INFO-P" "LOCAL-ALIEN-INFO-TYPE"
       "MAKE-ALIEN-FUNCTION-TYPE" "MAKE-ALIEN-POINTER-TYPE"
       "MAKE-LOCAL-ALIEN" "NATURALIZE" "NOTE-LOCAL-ALIEN-TYPE"
       "PARSE-ALIEN-TYPE" "UNPARSE-ALIEN-TYPE"))
  (intern name "ALIEN"))
(defpackage "ALIEN-INTERNALS"
            (:import-from "ALIEN" "%CAST" "%DEREF-ADDR" "%HEAP-ALIEN"
             "%HEAP-ALIEN-ADDR" "%LOCAL-ALIEN-ADDR"
             "%LOCAL-ALIEN-FORCED-TO-MEMORY-P" "%SAP-ALIEN" "%SET-DEREF"
             "%SET-HEAP-ALIEN" "%SET-LOCAL-ALIEN" "%SET-SLOT" "%SLOT-ADDR"
             "*VALUES-TYPE-OKAY*" "ALIEN" "ALIEN-ARRAY-TYPE"
             "ALIEN-ARRAY-TYPE-DIMENSIONS" "ALIEN-ARRAY-TYPE-ELEMENT-TYPE"
             "ALIEN-ARRAY-TYPE-P" "ALIEN-BOOLEAN-TYPE" "ALIEN-BOOLEAN-TYPE-P"
             "ALIEN-DOUBLE-FLOAT-TYPE" "ALIEN-DOUBLE-FLOAT-TYPE-P"
             "ALIEN-ENUM-TYPE" "ALIEN-ENUM-TYPE-P" "ALIEN-FLOAT-TYPE"
             "ALIEN-FLOAT-TYPE-P" "ALIEN-FUNCTION-TYPE"
             "ALIEN-FUNCTION-TYPE-ARG-TYPES" "ALIEN-FUNCTION-TYPE-P"
             "ALIEN-FUNCTION-TYPE-RESULT-TYPE" "ALIEN-INTEGER-TYPE"
             "ALIEN-INTEGER-TYPE-P" "ALIEN-INTEGER-TYPE-SIGNED"
             "ALIEN-POINTER-TYPE" "ALIEN-POINTER-TYPE-P"
             "ALIEN-POINTER-TYPE-TO" "ALIEN-RECORD-FIELD"
             "ALIEN-RECORD-FIELD-NAME" "ALIEN-RECORD-FIELD-OFFSET"
             "ALIEN-RECORD-FIELD-P" "ALIEN-RECORD-FIELD-TYPE"
             "ALIEN-RECORD-TYPE" "ALIEN-RECORD-TYPE-FIELDS"
             "ALIEN-RECORD-TYPE-P" "ALIEN-SINGLE-FLOAT-TYPE"
             "ALIEN-SINGLE-FLOAT-TYPE-P" "ALIEN-SUBTYPE-P" "ALIEN-TYPE"
             "ALIEN-TYPE-=" "ALIEN-TYPE-ALIGNMENT" "ALIEN-TYPE-BITS"
             "ALIEN-TYPE-P" "ALIEN-TYPEP" "ALIEN-VALUE" "ALIEN-VALUE-TYPE"
             "ALIEN-VALUES-TYPE" "ALIEN-VALUES-TYPE-P"
             "ALIEN-VALUES-TYPE-VALUES" "ALIGN-OFFSET" "COMPUTE-ALIEN-REP-TYPE"
             "COMPUTE-DEPORT-LAMBDA" "COMPUTE-DEPOSIT-LAMBDA"
             "COMPUTE-EXTRACT-LAMBDA" "COMPUTE-LISP-REP-TYPE"
             "COMPUTE-NATURALIZE-LAMBDA" "DEF-ALIEN-TYPE-CLASS"
             "DEF-ALIEN-TYPE-METHOD" "DEF-ALIEN-TYPE-TRANSLATOR" "DEPORT"
             "DEPOSIT-ALIEN-VALUE" "DISPOSE-LOCAL-ALIEN" "EXTRACT-ALIEN-VALUE"
             "HEAP-ALIEN-INFO" "HEAP-ALIEN-INFO-P" "HEAP-ALIEN-INFO-SAP-FORM"
             "HEAP-ALIEN-INFO-TYPE" "INVOKE-ALIEN-TYPE-METHOD" "LOCAL-ALIEN"
             "LOCAL-ALIEN-INFO" "LOCAL-ALIEN-INFO-FORCE-TO-MEMORY-P"
             "LOCAL-ALIEN-INFO-P" "LOCAL-ALIEN-INFO-TYPE"
             "MAKE-ALIEN-FUNCTION-TYPE" "MAKE-ALIEN-POINTER-TYPE"
             "MAKE-LOCAL-ALIEN" "NATURALIZE" "NOTE-LOCAL-ALIEN-TYPE"
             "PARSE-ALIEN-TYPE" "UNPARSE-ALIEN-TYPE")
            (:export "%CAST" "%DEREF-ADDR" "%HEAP-ALIEN" "%HEAP-ALIEN-ADDR"
             "%LOCAL-ALIEN-ADDR" "%LOCAL-ALIEN-FORCED-TO-MEMORY-P" "%SAP-ALIEN"
             "%SET-DEREF" "%SET-HEAP-ALIEN" "%SET-LOCAL-ALIEN" "%SET-SLOT"
             "%SLOT-ADDR" "*VALUES-TYPE-OKAY*" "ALIEN" "ALIEN-ARRAY-TYPE"
             "ALIEN-ARRAY-TYPE-DIMENSIONS" "ALIEN-ARRAY-TYPE-ELEMENT-TYPE"
             "ALIEN-ARRAY-TYPE-P" "ALIEN-BOOLEAN-TYPE" "ALIEN-BOOLEAN-TYPE-P"
             "ALIEN-DOUBLE-FLOAT-TYPE" "ALIEN-DOUBLE-FLOAT-TYPE-P"
             "ALIEN-ENUM-TYPE" "ALIEN-ENUM-TYPE-P" "ALIEN-FLOAT-TYPE"
             "ALIEN-FLOAT-TYPE-P" "ALIEN-FUNCTION-TYPE"
             "ALIEN-FUNCTION-TYPE-ARG-TYPES" "ALIEN-FUNCTION-TYPE-P"
             "ALIEN-FUNCTION-TYPE-RESULT-TYPE" "ALIEN-INTEGER-TYPE"
             "ALIEN-INTEGER-TYPE-P" "ALIEN-INTEGER-TYPE-SIGNED"
             "ALIEN-POINTER-TYPE" "ALIEN-POINTER-TYPE-P"
             "ALIEN-POINTER-TYPE-TO" "ALIEN-RECORD-FIELD"
             "ALIEN-RECORD-FIELD-NAME" "ALIEN-RECORD-FIELD-OFFSET"
             "ALIEN-RECORD-FIELD-P" "ALIEN-RECORD-FIELD-TYPE"
             "ALIEN-RECORD-TYPE" "ALIEN-RECORD-TYPE-FIELDS"
             "ALIEN-RECORD-TYPE-P" "ALIEN-SINGLE-FLOAT-TYPE"
             "ALIEN-SINGLE-FLOAT-TYPE-P" "ALIEN-SUBTYPE-P" "ALIEN-TYPE"
             "ALIEN-TYPE-=" "ALIEN-TYPE-ALIGNMENT" "ALIEN-TYPE-BITS"
             "ALIEN-TYPE-P" "ALIEN-TYPEP" "ALIEN-VALUE" "ALIEN-VALUE-TYPE"
             "ALIEN-VALUES-TYPE" "ALIEN-VALUES-TYPE-P"
             "ALIEN-VALUES-TYPE-VALUES" "ALIGN-OFFSET" "COMPUTE-ALIEN-REP-TYPE"
             "COMPUTE-DEPORT-LAMBDA" "COMPUTE-DEPOSIT-LAMBDA"
             "COMPUTE-EXTRACT-LAMBDA" "COMPUTE-LISP-REP-TYPE"
             "COMPUTE-NATURALIZE-LAMBDA" "DEF-ALIEN-TYPE-CLASS"
             "DEF-ALIEN-TYPE-METHOD" "DEF-ALIEN-TYPE-TRANSLATOR" "DEPORT"
             "DEPOSIT-ALIEN-VALUE" "DISPOSE-LOCAL-ALIEN" "EXTRACT-ALIEN-VALUE"
             "HEAP-ALIEN-INFO" "HEAP-ALIEN-INFO-P" "HEAP-ALIEN-INFO-SAP-FORM"
             "HEAP-ALIEN-INFO-TYPE" "INVOKE-ALIEN-TYPE-METHOD" "LOCAL-ALIEN"
             "LOCAL-ALIEN-INFO" "LOCAL-ALIEN-INFO-FORCE-TO-MEMORY-P"
             "LOCAL-ALIEN-INFO-P" "LOCAL-ALIEN-INFO-TYPE"
             "MAKE-ALIEN-FUNCTION-TYPE" "MAKE-ALIEN-POINTER-TYPE"
             "MAKE-LOCAL-ALIEN" "NATURALIZE" "NOTE-LOCAL-ALIEN-TYPE"
             "PARSE-ALIEN-TYPE" "UNPARSE-ALIEN-TYPE"))
(defpackage "PROFILE"
            (:export "*TIMED-FUNCTIONS*" "PROFILE" "REPORT-TIME" "RESET-TIME"
             "UNPROFILE"))
(dolist
    (name
     '("ARRAY-RANK" "ARRAY-TOTAL-SIZE" "CHAR-INT" "FLOAT-DIGITS" "FLOAT-RADIX"
       "PATHNAME-DEVICE" "PATHNAME-DIRECTORY" "PATHNAME-HOST" "PATHNAME-NAME"
       "PATHNAME-TYPE" "PATHNAME-VERSION"))
  (intern name "LISP"))
(intern "BOOLEAN" "ALIEN")
(intern "VOID" "C-CALL")
(defpackage "KERNEL"
            (:import-from "LISP" "ARRAY-RANK" "ARRAY-TOTAL-SIZE" "CHAR-INT"
             "FLOAT-DIGITS" "FLOAT-RADIX" "PATHNAME-DEVICE"
             "PATHNAME-DIRECTORY" "PATHNAME-HOST" "PATHNAME-NAME"
             "PATHNAME-TYPE" "PATHNAME-VERSION")
            (:import-from "ALIEN" "BOOLEAN")
	    (:import-from "C-CALL" "VOID")
            (:export "%ACOS" "%ACOSH" "%ARRAY-AVAILABLE-ELEMENTS"
             "%ARRAY-DATA-VECTOR" "%ARRAY-DIMENSION" "%ARRAY-DISPLACED-P"
             "%ARRAY-DISPLACEMENT" "%ARRAY-FILL-POINTER"
             "%ARRAY-FILL-POINTER-P" "%ASIN" "%ASINH" "%ATAN" "%ATAN2" "%ATANH"
             "%CALLER-FRAME-AND-PC" "%CBRT" "%CHECK-BOUND" "%CLOSURE-FUNCTION"
             "%CLOSURE-INDEX-REF" "%COS" "%COSH" "%DEPOSIT-FIELD"
             "%DOUBLE-FLOAT" "%DPB" "%EXP" "%EXPM1" "%FUNCTION-HEADER-ARGLIST"
             "%FUNCTION-HEADER-NAME" "%FUNCTION-HEADER-TYPE" "%HYPOT" "%LDB"
             "%LOG" "%LOG10" "%LOG1P" "%MAKE-COMPLEX"
             "%MAKE-FUNCALLABLE-INSTANCE" "%MAKE-RATIO" "%MASK-FIELD" "%NEGATE"
             "%POW" "%RAW-BITS" "%SET-FUNCALLABLE-INSTANCE-FUNCTION"
             "%SET-FUNCALLABLE-INSTANCE-INFO" "%SET-RAW-BITS" "%SET-SAP-REF-16"
             "%SET-SAP-REF-32" "%SET-SAP-REF-8" "%SET-SAP-REF-DOUBLE"
             "%SET-SAP-REF-SAP" "%SET-SAP-REF-SINGLE" "%SET-STACK-REF" "%SIN"
             "%SINGLE-FLOAT" "%SINH" "%SP-SET-DEFINITION" "%SP-SET-PLIST"
             "%SQRT" "%SXHASH-SIMPLE-STRING" "%SXHASH-SIMPLE-SUBSTRING" "%TAN"
             "%TANH" "%UNARY-ROUND" "%UNARY-TRUNCATE" "%WITH-ARRAY-DATA"
             "*CURRENT-LEVEL*" "*EMPTY-TYPE*" "*EVAL-STACK-TOP*" "*NULL-TYPE*"
             "*PRETTY-PRINTER*" "*UNIVERSAL-TYPE*"
             "*UNPARSE-FUNCTION-TYPE-SIMPLIFY*" "*WILD-TYPE*"
             "32BIT-LOGICAL-AND" "32BIT-LOGICAL-ANDC1" "32BIT-LOGICAL-ANDC2"
             "32BIT-LOGICAL-EQV" "32BIT-LOGICAL-NAND" "32BIT-LOGICAL-NOR"
             "32BIT-LOGICAL-NOT" "32BIT-LOGICAL-OR" "32BIT-LOGICAL-ORC1"
             "32BIT-LOGICAL-ORC2" "32BIT-LOGICAL-XOR" "ALIEN-TYPE-TYPE"
             "ALIEN-TYPE-TYPE-ALIEN-TYPE" "ALIEN-TYPE-TYPE-P" "ALLOCATE-VECTOR"
             "ALWAYS-SUBTYPEP" "ARGS-TYPE" "ARGS-TYPE-ALLOWP" "ARGS-TYPE-KEYP"
             "ARGS-TYPE-KEYWORDS" "ARGS-TYPE-OPTIONAL" "ARGS-TYPE-P"
             "ARGS-TYPE-REQUIRED" "ARGS-TYPE-REST" "ARRAY-HEADER-P"
             "ARRAY-RANK" "ARRAY-TOTAL-SIZE" "ARRAY-TYPE" "ARRAY-TYPE-COMPLEXP"
             "ARRAY-TYPE-DIMENSIONS" "ARRAY-TYPE-ELEMENT-TYPE" "ARRAY-TYPE-P"
             "ARRAY-TYPE-SPECIALIZED-ELEMENT-TYPE" "ASH-INDEX" "BASE-CHAR-P"
             "BINDING-STACK-POINTER-SAP" "BIT-BASH-AND" "BIT-BASH-ANDC1"
             "BIT-BASH-ANDC2" "BIT-BASH-CLEAR" "BIT-BASH-COPY" "BIT-BASH-EQV"
             "BIT-BASH-IOR" "BIT-BASH-LOGNAND" "BIT-BASH-LOGNOR" "BIT-BASH-NOT"
             "BIT-BASH-ORC1" "BIT-BASH-ORC2" "BIT-BASH-SET" "BIT-BASH-XOR"
             "BIT-INDEX" "BOGUS-ARGUMENT-TO-VALUES-LIST-ERROR" "BOOLE-CODE"
             "BOOLEAN" "BYTE-SPECIFIER" "CALLABLE" "CHAR-INT"
             "CHECK-FOR-CIRCULARITY" "CODE-COMPONENT" "CODE-COMPONENT-P"
             "CODE-DEBUG-INFO" "CODE-HEADER-REF" "CODE-HEADER-SET"
             "CODE-INSTRUCTIONS" "CONSED-SEQUENCE" "CONSTANT-TYPE"
             "CONSTANT-TYPE-P" "CONSTANT-TYPE-TYPE" "CONTAINING-INTEGER-TYPE"
             "CONTROL-STACK-POINTER-SAP" "COPY-FROM-SYSTEM-AREA"
             "COPY-NUMERIC-TYPE" "COPY-TO-SYSTEM-AREA" "CSUBTYPEP" "CTYPE"
             "CTYPE-OF" "CTYPE-P" "CTYPEP" "CURRENT-FP" "CURRENT-SP"
             "DATA-VECTOR-REF" "DATA-VECTOR-SET" "DECODE-DOUBLE-FLOAT"
             "DECODE-SINGLE-FLOAT" "DESCEND-INTO" "DIVISION-BY-ZERO-ERROR"
             "DOUBLE-FLOAT-EXPONENT" "DOUBLE-FLOAT-HIGH-BITS"
             "DOUBLE-FLOAT-LOW-BITS" "DOUBLE-FLOAT-P"
             "DYNAMIC-SPACE-FREE-POINTER" "ERROR-NUMBER-OR-LOSE" "FILENAME"
             "FLOAT-DIGITS" "FLOAT-EXPONENT" "FLOAT-FORMAT-DIGITS"
             "FLOAT-FORMAT-MAX" "FLOAT-RADIX" "FORM" "FUNCALLABLE-INSTANCE-P"
             "FUNCTION-CODE-HEADER" "FUNCTION-TYPE" "FUNCTION-TYPE-ALLOWP"
             "FUNCTION-TYPE-KEYP" "FUNCTION-TYPE-KEYWORDS"
             "FUNCTION-TYPE-NARGS" "FUNCTION-TYPE-OPTIONAL" "FUNCTION-TYPE-P"
             "FUNCTION-TYPE-REQUIRED" "FUNCTION-TYPE-REST"
             "FUNCTION-TYPE-RETURNS" "FUNCTION-TYPE-WILD-ARGS"
             "FUNCTION-WORD-OFFSET" "GET-CLOSURE-LENGTH" "GET-HEADER-DATA"
             "GET-LISP-OBJ-ADDRESS" "GET-LOWTAG" "GET-TYPE" "HAIRY-TYPE"
             "HAIRY-TYPE-CHECK-TEMPLATE" "HAIRY-TYPE-SPECIFIER"
             "HANDLE-CIRCULARITY" "INDEX" "INTEGER-DECODE-DOUBLE-FLOAT"
             "INTEGER-DECODE-SINGLE-FLOAT" "INTERNAL-TIME"
             "INVALID-ARGUMENT-COUNT-ERROR" "INVALID-ARRAY-INDEX-ERROR"
             "INVALID-UNWIND-ERROR" "IRRATIONAL" "KEY-INFO" "KEY-INFO-NAME"
             "KEY-INFO-P" "KEY-INFO-TYPE" "LEXICAL-ENVIRONMENT" "LRA"
             "LRA-CODE-HEADER" "LRA-P" "MAKE-ALIEN-TYPE-TYPE" "MAKE-ARGS-TYPE"
             "MAKE-ARRAY-HEADER" "MAKE-DOUBLE-FLOAT" "MAKE-FUNCTION-TYPE"
             "MAKE-KEY-INFO" "MAKE-LISP-OBJ" "MAKE-MEMBER-TYPE"
             "MAKE-NAMED-TYPE" "MAKE-NUMERIC-TYPE" "MAKE-SINGLE-FLOAT"
             "MAKE-STRUCTURE" "MAKE-STRUCTURE-TYPE" "MAKE-UNION-TYPE"
             "MAKE-VALUES-TYPE" "MEMBER-TYPE" "MEMBER-TYPE-MEMBERS"
             "MEMBER-TYPE-P" "MERGE-BITS" "MUTATOR-SELF" "NAMED-TYPE"
             "NAMED-TYPE-NAME" "NAMED-TYPE-P" "NATIVE-BYTE-ORDER" "NEGATE"
             "NEVER-SUBTYPEP" "NIL-FUNCTION-RETURNED-ERROR" "NOT-<=-ERROR"
             "NOT-=-ERROR" "NUMERIC-CONTAGION" "NUMERIC-TYPE"
             "NUMERIC-TYPE-CLASS" "NUMERIC-TYPE-COMPLEXP" "NUMERIC-TYPE-FORMAT"
             "NUMERIC-TYPE-HIGH" "NUMERIC-TYPE-LOW" "NUMERIC-TYPE-P"
             "OBJECT-NOT-ARRAY-ERROR" "OBJECT-NOT-BASE-CHAR-ERROR"
             "OBJECT-NOT-BIGNUM-ERROR" "OBJECT-NOT-BIT-VECTOR-ERROR"
             "OBJECT-NOT-COERCABLE-TO-FUNCTION-ERROR"
             "OBJECT-NOT-COMPLEX-ERROR" "OBJECT-NOT-CONS-ERROR"
             "OBJECT-NOT-DOUBLE-FLOAT-ERROR" "OBJECT-NOT-FIXNUM-ERROR"
             "OBJECT-NOT-FLOAT-ERROR" "OBJECT-NOT-FUNCTION-ERROR"
             "OBJECT-NOT-FUNCTION-OR-SYMBOL-ERROR" "OBJECT-NOT-INTEGER-ERROR"
             "OBJECT-NOT-LIST-ERROR" "OBJECT-NOT-NUMBER-ERROR"
             "OBJECT-NOT-RATIO-ERROR" "OBJECT-NOT-RATIONAL-ERROR"
             "OBJECT-NOT-REAL-ERROR" "OBJECT-NOT-SAP-ERROR"
             "OBJECT-NOT-SIGNED-BYTE-32-ERROR"
             "OBJECT-NOT-SIMPLE-ARRAY-DOUBLE-FLOAT-ERROR"
             "OBJECT-NOT-SIMPLE-ARRAY-ERROR"
             "OBJECT-NOT-SIMPLE-ARRAY-SINGLE-FLOAT-ERROR"
             "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-16-ERROR"
             "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-2-ERROR"
             "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-32-ERROR"
             "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-4-ERROR"
             "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-8-ERROR"
             "OBJECT-NOT-SIMPLE-BIT-VECTOR-ERROR"
             "OBJECT-NOT-SIMPLE-STRING-ERROR" "OBJECT-NOT-SIMPLE-VECTOR-ERROR"
             "OBJECT-NOT-SINGLE-FLOAT-ERROR" "OBJECT-NOT-STRING-ERROR"
             "OBJECT-NOT-STRUCTURE-ERROR" "OBJECT-NOT-SYMBOL-ERROR"
             "OBJECT-NOT-TYPE-ERROR" "OBJECT-NOT-UNSIGNED-BYTE-32-ERROR"
             "OBJECT-NOT-VECTOR-ERROR" "OBJECT-NOT-WEAK-POINTER-ERROR"
             "ODD-KEYWORD-ARGUMENTS-ERROR" "OUTPUT-OBJECT" "OUTPUT-UGLY-OBJECT"
             "PARSE-LAMBDA-LIST" "PARSE-UNKNOWN-TYPE"
             "PARSE-UNKNOWN-TYPE-SPECIFIER" "PATHNAME-DEVICE"
             "PATHNAME-DIRECTORY" "PATHNAME-HOST" "PATHNAME-NAME"
             "PATHNAME-TYPE" "PATHNAME-VERSION" "PATHNAMELIKE"
             "PUNT-IF-TOO-LONG" "SCALE-DOUBLE-FLOAT" "SCALE-SINGLE-FLOAT"
             "SEQUENCE-END" "SET-HEADER-DATA" "SHIFT-TOWARDS-END"
             "SHIFT-TOWARDS-START" "SIGNAL-INIT" "SIGNED-BYTE-32-P"
             "SIMPLE-ARRAY-DOUBLE-FLOAT-P" "SIMPLE-ARRAY-P"
             "SIMPLE-ARRAY-SINGLE-FLOAT-P" "SIMPLE-ARRAY-UNSIGNED-BYTE-16-P"
             "SIMPLE-ARRAY-UNSIGNED-BYTE-2-P" "SIMPLE-ARRAY-UNSIGNED-BYTE-32-P"
             "SIMPLE-ARRAY-UNSIGNED-BYTE-4-P" "SIMPLE-ARRAY-UNSIGNED-BYTE-8-P"
             "SIMPLE-UNBOXED-ARRAY" "SINGLE-FLOAT-BITS" "SINGLE-FLOAT-EXPONENT"
             "SINGLE-FLOAT-P" "SINGLE-VALUE-TYPE" "SPECIFIER-TYPE" "STACK-REF"
             "STREAMLIKE" "STRINGABLE" "STRINGLIKE" "STRUCTURE-INDEX"
             "STRUCTURE-INDEX-REF" "STRUCTURE-INDEX-SET" "STRUCTURE-LENGTH"
             "STRUCTURE-REF" "STRUCTURE-SET" "STRUCTURE-TYPE"
             "STRUCTURE-TYPE-NAME" "STRUCTURE-TYPE-P" "SYSTEM-AREA-CLEAR"
             "SYSTEM-AREA-COPY" "TRUTH" "TWO-ARG-*" "TWO-ARG-+" "TWO-ARG--"
             "TWO-ARG-/" "TWO-ARG-/=" "TWO-ARG-<" "TWO-ARG-<=" "TWO-ARG-="
             "TWO-ARG->" "TWO-ARG->=" "TWO-ARG-AND" "TWO-ARG-GCD" "TWO-ARG-IOR"
             "TWO-ARG-LCM" "TWO-ARG-XOR" "TYPE-DIFFERENCE" "TYPE-EXPAND"
             "TYPE-INIT" "TYPE-INTERSECT" "TYPE-INTERSECTION" "TYPE-SPECIFIER"
             "TYPE-SPECIFIER-SYMBOLS" "TYPE-UNION" "TYPE/=" "TYPE="
             "TYPES-INTERSECT" "UNBOUND-SYMBOL-ERROR" "UNBOXED-ARRAY"
             "UNDEFINED-SYMBOL-ERROR" "UNION-TYPE" "UNION-TYPE-P"
             "UNION-TYPE-TYPES" "UNKNOWN-ERROR"
             "UNKNOWN-KEYWORD-ARGUMENT-ERROR" "UNKNOWN-TYPE" "UNKNOWN-TYPE-P"
             "UNKNOWN-TYPE-SPECIFIER" "UNSEEN-THROW-TAG-ERROR"
             "UNSIGNED-BYTE-32-P" "VALUES-SPECIFIER-TYPE"
             "VALUES-SPECIFIER-TYPE-CACHE-CLEAR" "VALUES-SUBTYPEP"
             "VALUES-TYPE" "VALUES-TYPE-ALLOWP" "VALUES-TYPE-INTERSECT"
             "VALUES-TYPE-INTERSECTION" "VALUES-TYPE-KEYP"
             "VALUES-TYPE-KEYWORDS" "VALUES-TYPE-OPTIONAL" "VALUES-TYPE-P"
             "VALUES-TYPE-REQUIRED" "VALUES-TYPE-REST" "VALUES-TYPE-UNION"
             "VALUES-TYPES" "VALUES-TYPES-INTERSECT" "VOID"
             "WITH-CIRCULARITY-DETECTION" "WRONG-NUMBER-OF-INDICES-ERROR"
	     "FDEFN" "MAKE-FDEFN" "FDEFN-P" "FDEFN-NAME" "FDEFN-FUNCTION"
	     "FDEFN-MAKUNBOUND"))
