;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;

#|
==================================================================
Change log:
    2/20/92 Andrew Mickish - Moved make-package call to Garnet-Loader
    2/18/92 Brad Myers - add gilt-gadget-utils
    3/26/91 Pervin - Load compiled files in Lucid.
    3/22/91 Ed Pervin - Added test to not load gadgets if compiling
	 	all of Garnet
    3/14/91 Andrew Mickish - Added Motif Version
   12/10/90 Brad Myers - created
==================================================================
|#

(in-package "USER" :use '("LISP"))

(format t "Compiling Gilt...~%")

;; check first to see if pathname variable is set
(unless (boundp 'Garnet-Gilt-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-Gilt-PathName before loading this file."))

;; Only loads these file when not compiling all of Garnet.
(unless (boundp 'user::*Garnet-Going-To-Compile*)
  (dolist (gadget '(
		  "text-buttons-loader"
		  "x-buttons-loader"
		  "radio-buttons-loader"
		  "labeled-box-loader"
		  "scrolling-labeled-box-loader"
		  "error-gadget-loader"
		  "v-slider-loader"
		  "prop-sheet-win-loader"
		  "multi-selection-loader"
		  "motif-text-buttons-loader"
		  "motif-check-buttons-loader"
		  "motif-radio-buttons-loader"
		  "motif-v-scroll-loader"
		  "motif-h-scroll-loader"
		  "motif-slider-loader"
		  "motif-menu-loader"
		  "motif-gauge-loader"
		  "motif-scrolling-labeled-box-loader"
		  "motif-prop-sheet-win-loader"
		  ))
  (load (merge-pathnames gadget
			 #+cmu "gadgets:"
			 #+(not cmu) user::Garnet-Gadgets-PathName))))

#+allegroV3.1
(user::gc t)

(defvar gilt-files '(
		     "gilt-string-edit"
		     "gilt-functions"
		     "gilt-font-imp" "gilt-font-props" "motif-gilt-font-props"
		     "gilt-gadget-utils"
		     "gilt-gadgets" "motif-gilt-gadgets"
		     "gilt"
		     "gilt-save" "motif-gilt-save"
		     "gilt-read" "motif-gilt-read"
		     "color-imp" "color-props" "motif-color-props"
		     "line-imp" "line-props" "motif-line-props"
		     "fill-imp" "fill-props" "motif-fill-props"
		     "align-imp" "align-props" "motif-align-props"
		     ))

(dolist (file gilt-files)
  (Compile-file (merge-pathnames file
			 #+cmu "gilt-src:"
			 #+(not cmu) user::Garnet-Gilt-Src))
  #+(or allegro explorer lispworks lucid)
  (load (merge-pathnames file user::Garnet-Gilt-Src))
  #+allegroV3.1(user::gc t))

(setf (get :garnet-modules :gilt) t)

(format t "... Done Compiling Gilt~%")
