;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 
;;; This file loads all the garnet modules.
;;; 
;;; ** To prevent certain parts from being loaded, first set
;;;      user::load-XX-p to NIL.
;;; ** To get some of the parts which are not loaded by default to be loaded,
;;;    set user::load-XX-p to T.
;;; ** If you are a non-CMU user, set Your-Garnet-Pathname to be your local
;;;    Garnet directory, and set Your-CLX-Pathname to be your local CLX
;;;    directory.
;;; ** To override where something is loaded from, set Garnet-xx-PathName
;;;    before loading this file and/or Garnet-xx-src
;;;
;;; The controlling variables are:
;;; 
;;;      load-clx-p          (Default: NIL => clx not loaded)
;;;      load-kr-p           (Default: T   => kr loaded)
;;;      load-opal-p         (Default: T   => opal loaded)
;;;      load-inter-p        (Default: T   => interactors loaded)
;;;      load-multifont-p    (Default: NIL => multifont *NOT* loaded)
;;;      load-gesture-p      (Default: NIL => gestures *NOT* loaded)
;;;      load-ps-p           (Default: T   => ps loaded)
;;;      load-aggregadgets-p (Default: T   => aggregadgets loaded)
;;;      load-aggregraphs-p  (Default: NIL => aggregraphs *NOT* loaded)
;;;      load-gadgets-p      (Default: NIL => gadgets *NOT* loaded)
;;;      load-debug-p        (Default: T   => debugging tools loaded)
;;;      load-demos-p        (Default: NIL => demos *NOT* loaded)
;;;      load-gilt-p         (Default: NIL => gilt *NOT* loaded)
;;;      load-lapidary-p     (Default: NIL => lapidary *NOT* loaded)
;;;      load-c32-p          (Default: NIL => C32 *NOT* loaded)
;;;
;;; The first part of this file lists the file names where the various
;;; parts of Garnet come from.  This will need to be modified for each new
;;; installation of Garnet.
;;;
;;; To override any particular file name place, it is only necessary to
;;; assign the variable name Garnet-XX-Pathname before this file is loaded
;;; (since they are defined here using defvar, the old name will stay in
;;; affect).
;;;



#|
============================================================
Change log:

05/27/92 Joly - Interactors package should use kr package.
05/25/92 Joly/Pervin - Package CLTL1 does not exist in LispWorks.
05/21/92 Dario Giuse - Added load-c32-p.
05/14/92 Szekely/Pervin - Do not launch process if compiling.
05/04/92 Russell Almond - Added allegro-v4.1 switches.
04/22/92 Ed Pervin - Added launch-process-p switch.
04/10/92 Andrew Mickish - Added "gg:" prefix to garnet-load and garnet-compile
04/02/92 Rich McDaniel - Added load-multifont-p
03/13/92 Ed Pervin - Added :cmu-test
03/11/92 Andrew Mickish - Removed unlesses from CMU ext:search-list setf's
03/06/92 Andrew Mickish - Added *compiler-extension* switches
02/20/92 Andrew Mickish - Added package definitions for Explorer lisp;
           Added gesture pathnames, etc.
02/11/92 Andrew Mickish - Added :garnet-debug to *features* list;  changed
           pathnames from /afs/cs/ to /afs/cs.cmu.edu/.
04/25/91 Ed Pervin - Official release of version 1.4; alpha directory changed
           back to test.  No longer support :cmu-lucid3.1 and :cmu-lucid4.0.
04/19/91 Ed Pervin - Added lispworks to switches.
04/15/91 Ed Pervin - Changed (make-packages **) to
	   (unless (find-package **) (make-package **)).
04/03/91 Ed Pervin - Changed :sparc-test4.0 --> :sparc-test and
           added :pmax-test.
03/21/91 Ed Pervin - Release 1.4; test directory changed to alpha.
03/07/91 Andrew Mickish - Added aggregraphs.
03/07/91 Brad Myers - Made new motif-gilt-loader, and also garnet-load.
03/01/91 Ed Pervin - Added :sparc-test for version compiled in Allegro 4.0.
02/27/91 Dilip D'Souza - Added everything with #+allegro-v4.0 switches.
02/25/91 Ed Pervin - Pushed :garnet on *features* list.
01/24/91 Andrew Mickish - Added Gilt.
01/02/90 Andrew Mickish - Added :rt-test and :sparc-test options.
11/29/90 Brad Myers - Added :cmu-sparc option.
10/05/90 Ed Pervin - New variables Your-Garnet-Pathname and Your-CLX-Pathname
           which determine all the :external pathnames.
08/09/90 Ed Pervin - Release 1.3
08/07/90 Ed Pervin - rbd --> ecp
07/25/90 Ed Pervin - Added *dont-load-modules-twice*;  amickish --> preddy
04/02/90 Ed Pervin - Call xlib:load-clx in Lucid explicitly.
03/19/90 Ed Pervin - Got rid of Garnet-Font-Pathname
02/14/90 Ed Pervin - Added color screen option
01/04/90 Ed Pervin - Added :external option and version number
12/19/89 Ed Pervin - Now loads CLX.
12/13/89 Ed Pervin - Added :cmu-allegro option.
12/05/89 Brad Myers - Fixed so works with garnet-compiler
10/30/89 Brad Myers - New file structure and src directories;  changed
           dont-load-xx to load-xxx-p
10/17/89 Brad Myers - Added debug
08/18/89 Brad Myers - Added Toolkit
06/07/89 Brad Myers - Created
============================================================
|#

;; The function provide is no longer part of common lisp and so was
;; removed from the lisp package in the most recent release of
;; LispWorks (version 2.1 onwards). This will retrieve its definition.
#+lispworks (setf (symbol-function 'lisp::provide)
                  (symbol-function 'system::provide))
#+lispworks (export 'provide 'lisp)

#+(or allegro-v4.0 allegro-v4.1)
(setf excl::*cltl1-in-package-compatibility-p* t)
#+(or allegro-v4.0 allegro-v4.1)
(setf comp:*cltl1-compile-file-toplevel-compatibility-p* t)

(in-package "USER" :use '("LISP"))

#+(or allegro-v4.0 allegro-v4.1)
(progn
  (unless (find-package "KR")
    (make-package "KR" :use '("LISP" "CLTL1")))
  (unless (find-package "KR-DEBUG")
    (make-package "KR-DEBUG" :use '("LISP" "CLTL1")))
  (unless (find-package "OPAL")
    (make-package "OPAL" :use '("LISP" "KR" "CLTL1")))
  (unless (find-package "INTERACTORS")
    (make-package "INTERACTORS" :use '("LISP" "KR" "CLTL1")
		  :nicknames '("INTER")))
  (unless (find-package "GARNET-GADGETS")
    (make-package "GARNET-GADGETS" :use '("LISP" "KR" "CLTL1")
		  :nicknames '("GG")))
  (unless (find-package "GARNET-DEBUG")
    (make-package "GARNET-DEBUG" :use '("KR" "OPAL" "LISP" "CLTL1")
		  :nicknames '("GD")))
  (unless (find-package "GILT")
    (make-package "GILT" :use '("LISP" "KR" "CLTL1")))
  (unless (find-package "C32")
    (make-package "C32" :use '("LISP" "KR" "CLTL1")))
  (unless (find-package "GARNETDRAW")
    (make-package "GARNETDRAW" :use '("LISP" "KR" "CLTL1")))
  (unless (find-package "LAPIDARY")
    (make-package "LAPIDARY" :use '("LISP" "KR" "CLTL1"))))

#-(or allegro-v4.0 allegro-v4.1)
(progn
  (unless (find-package "KR")
    (make-package "KR" :use '("LISP")))
  (unless (find-package "KR-DEBUG")
    (make-package "KR-DEBUG" :use '("LISP")))
  (unless (find-package "OPAL")
    (make-package "OPAL" :use '("LISP" "KR")))
  (unless (find-package "INTERACTORS")
    (make-package "INTERACTORS" :use '("LISP" "KR")
		  :nicknames '("INTER")))
  (unless (find-package "GARNET-GADGETS")
    (make-package "GARNET-GADGETS" :use '("LISP" "KR")
		  :nicknames '("GG")))
  (unless (find-package "GARNET-DEBUG")
    (make-package "GARNET-DEBUG" :use '("KR" "OPAL" "LISP")
		  :nicknames '("GD")))
  (unless (find-package "GILT")
    (make-package "GILT" :use '("LISP" "KR")))
  (unless (find-package "C32")
    (make-package "C32" :use '("LISP" "KR")))
  (unless (find-package "GARNETDRAW")
    (make-package "GARNETDRAW" :use '("LISP" "KR")))
  (unless (find-package "LAPIDARY")
    (make-package "LAPIDARY" :use '("LISP" "KR"))))



(defparameter Garnet-Version-Number "2.1")
(pushnew :GARNET *features*)
(pushnew :GARNET-V2.1 *features*)

;;; The :GARNET-DEBUG option allows many different kinds of run-time checking,
;;; and also loads some extra test code.  After you have debugged your code
;;; and want it to run faster, remove :GARNET-DEBUG from the *features* list
;;; and RECOMPILE all of Garnet and your code.  The result will be smaller and
;;; somewhat faster.
;;; To remove :GARNET-DEBUG from the *features* list, either defvar
;;; Garnet-Garnet-Debug to NIL before you load the garnet-loader, or simply
;;; comment out the next few lines.
(defvar Garnet-Garnet-Debug T)
(if Garnet-Garnet-Debug
    (pushnew :garnet-debug *features*)
    (setf *features* (delete :garnet-debug *features*)))

;;; Garnet-Version controls where the files are loaded from/
;;; Because this is a defvar, if Garnet-Version is set before this file is
;;; loaded, its original value will be used.

(defvar Garnet-Version :sparc-test)
	;; options are:
	;;	:test for the testing version
        ;;      :rt-test for the testing version compiled for the RT
        ;;      :sparc-test for the testing version compiled for the Sparc Station
        ;;      :pmax-test for the testing version compiled for the Pmax
	;;	:cmu-test for the testing version compiled for CMU CommonLisp
	;;	:lucid-test for the testing version compiled in Sun Lucid
	;;	:cmu for the released version for CMU CommonLisp
        ;;      :cmu-sparc for released version for Allegro on a Sparc Station
	;;	:cmu-pmax for released version compiled for the PMax
	;;	:external for all other non-CMU versions


(format T "** Loading Garnet Version ~a from ~s~%" Garnet-Version-Number Garnet-Version)

;;; *dont-load-modules-twice* tells whether to re-load modules
;;; if a user loads garnet-loader.lisp a second time.
(defparameter *dont-load-modules-twice* t)

;;; load-XX-p control whether the various parts are loaded or not
;;; Because these use defvar, if they are set before this file is
;;; loaded, their original value will be used.

(defvar load-clx-p NIL)

(unless (boundp '*Garnet-Going-To-Compile*)
  (defvar load-kr-p T)
  (defvar load-opal-p T)
  (defvar load-inter-p T)
  (defvar load-multifont-p NIL)
  (defvar load-gesture-p NIL)
  (defvar load-ps-p T)
  (defvar load-aggregadgets-p T)
  (defvar load-aggregraphs-p NIL)
  (defvar load-debug-p #+garnet-debug T #-garnet-debug NIL)
  (defvar load-gadgets-p NIL)
  (defvar load-demos-p NIL)
  (defvar load-lapidary-p nil)
  (defvar load-gilt-p NIL)
  (defvar load-c32-p NIL))

;;; launch-process-p controls whether Garnet will launch
;;; a separate process to detect keyboard and mouse events.
(unless (boundp 'launch-process-p)
  (defvar launch-process-p t))

;;; Insert your pathname of Garnet into Your-Garnet-Pathname and where
;;; your CLX comes from into Your-CLX-pathname.  For example:
;;; (defvar Your-CLX-Pathname "/usr/local/lisp/clx/")
;;; (defvar Your-Garnet-Pathname "/usr/your-name/garnet/")
;;; All the :external pathnames will depend on these two pathnames.

(defvar Your-CLX-Pathname "<your clx pathname>")       ;;; SET THIS
(defvar Your-Garnet-Pathname "<your garnet pathname>") ;;; SET THIS

(defvar CLX-PathName
  (case Garnet-Version
    (:external Your-CLX-Pathname)
    (:sparc-test "/usr/misc/.allegro/lib/code/")
    (:lucid-test "/usr/misc/.allegro/lib/code/")
    (:cmu-pmax "/usr/misc/.allegro/lib/code/")
    (:cmu-sparc  "/usr/misc/.allegro/lib/code/")
    ((:pmax-test :pmax-bin)  "/usr/misc/.allegro/lib/code/")
    (T NIL)))

(defvar Garnet-KR-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/kr/"))
    (:test "/afs/cs.cmu.edu/user/dzg/garnet/kr/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/kr/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/kr/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/kr/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/kr/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/kr/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/kr/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/kr/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/kr/")
    (T (error "No version for KR"))))
(defvar Garnet-KR-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/kr/"))
    (:test "/afs/cs.cmu.edu/user/dzg/garnet/kr/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/kr/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/kr/")
    (T (error "No version for KR"))))

(defvar Garnet-Opal-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/opal/"))
    (:test "/afs/cs.cmu.edu/user/ecp/garnet/opal/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/opal/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/opal/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/opal/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/opal/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/opal/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/opal/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/opal/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/opal/")
    (T (error "No version for Opal"))))
(defvar Garnet-Opal-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/opal/"))
    (:test "/afs/cs.cmu.edu/user/ecp/garnet/opal/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/opal/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/opal/")
    (T (error "No version for Opal"))))

(defvar Garnet-Inter-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/inter/"))
    (:test "/afs/cs.cmu.edu/user/bam/garnet/inter/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/inter/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/inter/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/inter/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/inter/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/inter/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/inter/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/inter/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/inter/")
    (T (error "No version for Inter"))))
(defvar Garnet-Inter-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/inter/"))
    (:test "/afs/cs.cmu.edu/user/bam/garnet/inter/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/inter/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/inter/")
    (T (error "No version for Inter"))))

(defvar Garnet-Gesture-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/gesture/"))
    (:test "/afs/cs.cmu.edu/user/bam/garnet/gesture/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/gesture/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/gesture/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/gesture/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/gesture/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/gesture/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/gesture/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/gesture/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/gesture/")
    (T (error "No version for Gesture"))))
(defvar Garnet-Gesture-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/gesture/"))
    (:test "/afs/cs.cmu.edu/user/bam/garnet/gesture/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/gesture/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/gesture/")
    (T (error "No version for Gesture"))))

;; Directory used for gesture data
(defvar Garnet-Gesture-Data-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "lib/gesture/"))
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/lib/gesture/")
    ((:test :rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/lib/gesture/")
    (T (error "No version for Gesture data"))))

(defvar Garnet-PS-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/ps/"))
    (:test "/afs/cs.cmu.edu/user/ecp/garnet/ps/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/ps/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/ps/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/ps/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/ps/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/ps/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/ps/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/ps/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/ps/")
    (T (error "No version for Ps"))))
(defvar Garnet-PS-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/ps/"))
    (:test "/afs/cs.cmu.edu/user/ecp/garnet/ps/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/ps/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/ps/")
    (T (error "No version for Ps"))))

(defvar Garnet-Aggregadgets-PathName 
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/aggregadgets/"))
    (:test "/afs/cs.cmu.edu/user/ecp/garnet/aggregadgets/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/aggregadgets/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/aggregadgets/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/aggregadgets/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/aggregadgets/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/aggregadgets/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/aggregadgets/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/aggregadgets/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/aggregadgets/")
    (T (error "No version for Aggregadgets"))))
(defvar Garnet-Aggregadgets-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/aggregadgets/"))
    (:test "/afs/cs.cmu.edu/user/ecp/garnet/aggregadgets/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/aggregadgets/")
    ((:cmu :cmu-sparc :cmu-pmax)
     "/afs/cs.cmu.edu/project/garnet/src/aggregadgets/")
    (T (error "No version for Aggregadgets"))))

(defvar Garnet-Gadgets-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/gadgets/"))
    (:test "/afs/cs.cmu.edu/user/amickish/garnet/src/gadgets")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/gadgets/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/gadgets/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/gadgets/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/gadgets/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/gadgets/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/gadgets/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/gadgets/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/gadgets/")
    (T (error "No version for Gadgets"))))
(defvar Garnet-Gadgets-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/gadgets/"))
    (:test "/afs/cs.cmu.edu/user/amickish/garnet/src/gadgets/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/gadgets/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/gadgets/")
    (T (error "No version for Gadgets"))))

(defvar Garnet-Debug-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/debug/"))
    (:test "/afs/cs.cmu.edu/user/ecp/garnet/debug/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/debug/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/debug/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/debug/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/debug/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/debug/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/debug/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/debug/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/debug/")
    (T (error "No version for Debug"))))
(defvar Garnet-Debug-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/debug/"))
    (:test "/afs/cs.cmu.edu/user/ecp/garnet/debug/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/debug/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/debug/")
    (T (error "No version for Debug"))))

(defvar Garnet-Demos-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/demos/"))
    (:test "/afs/cs.cmu.edu/user/oh/garnet/demos/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/demos/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/demos/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/demos/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/demos/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/demos/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/demos/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/demos/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/demos/")
    (T (error "No version for Demos"))))
(defvar Garnet-Demos-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/demos/"))
    (:test "/afs/cs.cmu.edu/user/oh/garnet/demos/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/demos/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/demos/")
    (T (error "No version for Demos"))))

(defvar Garnet-Lapidary-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/lapidary/"))
    (:test "/afs/cs.cmu.edu/user/bvz/garnet/lapidary/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/rt-bin/lapidary/")
    (:sparc-test "/afs/cs/user/bvz/garnet/lapidary/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/lapidary/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/lapidary/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/lapidary/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/lapidary/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/lapidary/")
    (:cmu-sparc   "/afs/cs/user/bvz/garnet/lapidary/")
    (T (error "No version for Lapidary"))))
(defvar Garnet-Lapidary-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/lapidary/"))
    (:test "/afs/cs.cmu.edu/user/bvz/garnet/lapidary/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test :cmu-pmax :cmu :cmu-sparc)
     "/afs/cs/user/bvz/garnet/lapidary/")
    (T (error "No version for Lapidary"))))

(defvar Garnet-Gilt-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/gilt/"))
    (:test "/afs/cs.cmu.edu/user/bam/garnet/gilt/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/gilt/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/gilt/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/gilt/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/gilt/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/gilt/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/gilt/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/gilt/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/gilt/")
    (T (error "No version for Gilt"))))
(defvar Garnet-Gilt-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/gilt/"))
    (:test "/afs/cs.cmu.edu/user/bam/garnet/gilt/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/gilt/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/gilt/")
    (T (error "No version for Gilt"))))

(defvar Garnet-C32-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/c32/"))
    (:test "/afs/cs.cmu.edu/user/bam/garnet/c32/")
    (:rt-test "/afs/cs.cmu.edu/project/garnet/test/rt-bin/c32/")
    (:sparc-test "/afs/cs.cmu.edu/project/garnet/test/sparc-bin/c32/")
    (:lucid-test "/afs/cs.cmu.edu/project/garnet/test/lucid-bin/c32/")
    (:pmax-test "/afs/cs.cmu.edu/project/garnet/test/pmax-bin/c32/")
    (:cmu-test "/afs/cs.cmu.edu/project/garnet/test/cmu-bin/c32/")
    (:cmu-pmax "/afs/cs.cmu.edu/project/garnet/pmax-bin/c32/")
    (:cmu  "/afs/cs.cmu.edu/project/garnet/rt-bin/c32/")
    (:cmu-sparc   "/afs/cs.cmu.edu/project/garnet/sparc-bin/c32/")
    (T (error "No version for C32"))))
(defvar Garnet-C32-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/c32/"))
    (:test "/afs/cs.cmu.edu/user/bam/garnet/c32/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/src/c32/")
    ((:rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/src/c32/")
    (T (error "No version for C32"))))

;; Directory used for cursors and bitmaps
(defvar Garnet-Bitmap-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "lib/bitmaps/"))
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/lib/bitmaps/")
    ((:test :rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/lib/bitmaps/")
    (T (error "No version for bitmaps"))))

;; Directory used for pixmaps
(defvar Garnet-Pixmap-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "lib/pixmaps/"))
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/lib/pixmaps/")
    ((:test :rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/lib/pixmaps/")
    (T (error "No version for pixmaps"))))

;; Directory used for bitmaps and things needed by Gilt
(defvar Garnet-Gilt-Bitmap-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "lib/gilt/"))
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/lib/gilt/")
    ((:test :rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/lib/gilt/")
    (T (error "No version for Gilt bitmaps"))))

;; Directory used for bitmaps and things needed by C32
(defvar Garnet-C32-Bitmap-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "lib/c32/"))
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/lib/c32/")
    ((:test :rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/lib/c32/")
    (T (error "No version for C32 bitmaps"))))

;; Directory used for data files needed by demo-circle.
(defvar Garnet-DataFile-PathName
  (case Garnet-Version
    (:external  (concatenate 'string Your-Garnet-Pathname "lib/data/"))
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs.cmu.edu/project/garnet/lib/data/")
    ((:test :rt-test :sparc-test :lucid-test :pmax-test :cmu-test)
     "/afs/cs.cmu.edu/project/garnet/test/lib/data/")
    (T (error "No version for data files"))))

;;;----------------------------------------------------------

;;; When compiling, the binaries will be in the same directories as the
;;; source files, so make all the path names be the same
;;;
;;; After compilation is finished, the user should move all the binaries
;;; into their own directories, as specified by the pathnames above.
(defvar *Garnet-Going-To-Compile*)

(when (and (boundp '*Garnet-Going-To-Compile*)
	   *Garnet-Going-To-Compile*)
  (setf Garnet-KR-Pathname Garnet-KR-Src)
  (setf Garnet-Opal-Pathname Garnet-Opal-Src)
  (setf Garnet-Inter-Pathname Garnet-Inter-Src)
  (setf Garnet-Gesture-Pathname Garnet-Gesture-Src)
  (setf Garnet-PS-Pathname Garnet-PS-Src)
  (setf Garnet-Aggregadgets-Pathname Garnet-Aggregadgets-Src)
  (setf Garnet-Gadgets-Pathname Garnet-Gadgets-Src)
  (setf Garnet-Debug-Pathname Garnet-Debug-Src)
  (setf Garnet-Demos-Pathname Garnet-Demos-Src)
  (setf Garnet-Lapidary-Pathname Garnet-Lapidary-Src)
  (setf Garnet-Gilt-Pathname Garnet-Gilt-Src)
  (setf Garnet-C32-Pathname Garnet-C32-Src)
  )

;;;----------------------------------------------------------

;;; If at cmu, then set up the search lists
#+cmu
(progn
  (setf (ext:search-list "kr:")
	(list Garnet-KR-PathName))
  (setf (ext:search-list "kr-src:")
	(list Garnet-KR-Src))

  (setf (ext:search-list "opal:")
	(list Garnet-Opal-PathName))
  (setf (ext:search-list "opal-src:")
	(list Garnet-Opal-Src))

  (setf (ext:search-list "inter:")
	(list Garnet-Inter-PathName))
  (setf (ext:search-list "inter-src:")
	(list Garnet-Inter-Src))

  (setf (ext:search-list "gesture:")
	(list Garnet-Gesture-PathName))
  (setf (ext:search-list "gesture-src:")
	(list Garnet-Gesture-Src))
  (setf (ext:search-list "gesture-data:")
	(list Garnet-Gesture-Data-PathName))

  (setf (ext:search-list "ps:")
	(list Garnet-PS-PathName))
  (setf (ext:search-list "ps-src:")
	(list Garnet-PS-Src))

  (setf (ext:search-list "aggregadgets:")
	(list Garnet-Aggregadgets-PathName))
  (setf (ext:search-list "aggregadgets-src:")
	(list Garnet-Aggregadgets-Src))

  (setf (ext:search-list "gadgets:")
	(list Garnet-Gadgets-PathName))
  (setf (ext:search-list "gadgets-src:")
	(list Garnet-Gadgets-Src))

  (setf (ext:search-list "debug:")
	(list Garnet-Debug-PathName))
  (setf (ext:search-list "debug-src:")
	(list Garnet-Debug-Src))

  (setf (ext:search-list "demos:")
	(list Garnet-Demos-PathName))
  (setf (ext:search-list "demos-src:")
	(list Garnet-Demos-Src))

  (setf (ext:search-list "lapidary:")
	(list Garnet-Lapidary-PathName))
  (setf (ext:search-list "lapidary-src:")
	(list Garnet-Lapidary-Src))

  (setf (ext:search-list "gilt:")
	(list Garnet-Gilt-PathName))
  (setf (ext:search-list "gilt-src:")
	(list Garnet-Gilt-Src))

  (setf (ext:search-list "c32:")
	(list Garnet-C32-PathName))
  (setf (ext:search-list "c32-src:")
	(list Garnet-C32-Src))
  )

(defparameter CLX-Loader
  (when CLX-PathName
    #+allegro (merge-pathnames "clx" CLX-Pathname)
    #+lucid (merge-pathnames "defsystem" CLX-Pathname)))

(defparameter Garnet-KR-Loader
  (merge-pathnames "kr-loader"
		   #+cmu "kr:"
		   #+(not cmu) Garnet-KR-PathName))

(defparameter Garnet-Opal-Loader
  (merge-pathnames "opal-loader"
		   #+cmu "opal:"
		   #+(not cmu) Garnet-Opal-PathName))

(defparameter Garnet-Inter-Loader
  (merge-pathnames "inter-loader"
		   #+cmu "inter:"
		   #+(not cmu) Garnet-Inter-PathName))

(defparameter Garnet-Multifont-Loader
  (merge-pathnames "multifont-loader"
		   #+cmu "opal:"
		   #+(not cmu) Garnet-Opal-PathName))

(defparameter Garnet-Gesture-Loader
  (merge-pathnames "gesture-loader"
		   #+cmu "gesture:"
		   #+(not cmu) Garnet-Gesture-PathName))

(defparameter Garnet-PS-Loader
  (merge-pathnames "ps-loader"
		   #+cmu "ps:"
		   #+(not cmu) Garnet-PS-PathName))

(defparameter Garnet-Aggregadgets-Loader
  (merge-pathnames "aggregadgets-loader"
		   #+cmu "aggregadgets:"
		   #+(not cmu) Garnet-Aggregadgets-PathName))

(defparameter Garnet-Aggregraphs-Loader
  (merge-pathnames "aggregraphs-loader"
		   #+cmu "aggregadgets:"
		   #+(not cmu) Garnet-Aggregadgets-PathName))

(defparameter Garnet-Gadgets-Loader
  (merge-pathnames "gadgets-loader"
		   #+cmu "gadgets:"
		   #+(not cmu) Garnet-Gadgets-PathName))

(defparameter Garnet-Debug-Loader
  (merge-pathnames "debug-loader"
		   #+cmu "debug:"
		   #+(not cmu) Garnet-Debug-PathName))

(defparameter Garnet-Demos-Loader
  (merge-pathnames "demos-loader"
		   #+cmu "demos:"
		   #+(not cmu) Garnet-Demos-PathName))

(defparameter Garnet-Lapidary-Loader
  (merge-pathnames "lapidary-loader"
		   #+cmu "lapidary:"
		   #+(not cmu) Garnet-Lapidary-PathName))

(defparameter Garnet-Gilt-Loader
  (merge-pathnames "gilt-loader"
		   #+cmu "gilt:"
		   #+(not cmu) Garnet-Gilt-PathName))

(defparameter Garnet-C32-Loader
  (merge-pathnames "c32-loader"
		   #+cmu "c32:"
		   #+(not cmu) Garnet-C32-PathName))

(defparameter Garnet-Motif-Gilt-Loader
  (merge-pathnames "motif-gilt-loader"
		   #+cmu "gilt:"
		   #+(not cmu) Garnet-Gilt-PathName))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(format t "...Loading Garnet ...~%")
(setf *load-verbose* t)

;;;Patches for CLX on the RT.
;;;(load "/afs/cs.cmu.edu/project/clisp-1/chiles/archive/clx-r3/clx")
;;;(load "/afs/cs.cmu.edu/project/clisp-1/chiles/archive/clx-r3/display")

(when load-clx-p
   (format T "~% %%%%%%% Loading CLX %%%%%%%%~%")
   (load CLX-Loader))
#+lucid
(when load-clx-p
#+lcl3.0 (funcall (find-symbol 'load-clx 'xlib) CLX-Pathname)
#-lcl3.0 (     load-clx CLX-Pathname))
#-cmu
(unless load-clx-p (format T "~%****** NOT Loading CLX *******~%"))

(if load-kr-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :kr))
	(format T "~%****** KR already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading KR %%%%%%%%~%")
          (load Garnet-KR-Loader)))
    (format T "~%****** NOT Loading KR *******~%"))

(if load-opal-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :opal))
	(format T "~%****** Opal already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Opal %%%%%%%%~%")
          (load Garnet-Opal-Loader)))
    (format T "~%****** NOT Loading Opal *******~%"))

(if load-inter-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :inter))
	(format T "~%****** Interactors already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Interactors %%%%%%%%~%")
          (load Garnet-Inter-Loader)))
    (format T "~%****** NOT Loading Interactors *******~%"))

(if load-multifont-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :multifont))
	(format T "~%****** Multifont already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Multifont %%%%%%%%~%")
          (load Garnet-Multifont-Loader)))
    (format T "~%****** NOT Loading Multifont *******~%"))

(if load-gesture-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :gesture))
	(format T "~%****** Gestures already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Gestures %%%%%%%%~%")
          (load Garnet-Gesture-Loader)))
    (format T "~%****** NOT Loading Gestures *******~%"))

(if load-ps-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :ps))
	(format T "~%****** PS already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading PS %%%%%%%%~%")
          (load Garnet-PS-Loader)))
    (format T "~%****** NOT Loading PS *******~%"))

(if load-aggregadgets-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :aggregadgets))
	(format T "~%****** Aggregadgets already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Aggregadgets %%%%%%%%~%")
          (load Garnet-Aggregadgets-Loader)))
    (format T "~%****** NOT Loading Aggregadgets *******~%"))

(if load-aggregraphs-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :aggregraphs))
	(format T "~%****** Aggregraphs already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Aggregraphs %%%%%%%%~%")
          (load Garnet-Aggregraphs-Loader)))
    (format T "~%****** NOT Loading Aggregraphs *******
** To load aggregraph programs, execute (load Garnet-Aggregraphs-Loader)~%"))


(if load-gadgets-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :gadgets))
	(format T "~%****** Gadgets already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Gadgets %%%%%%%%~%")
          (load Garnet-Gadgets-Loader)))
    (format T "~%****** NOT Loading Gadgets *******~%"))

(if load-debug-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :debug))
	(format T "~%****** Debugging programs already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Debugging programs %%%%%%%%~%")
          (load Garnet-Debug-Loader)))
    (format T "~%****** NOT Loading Debug Files *******
** To load debug programs, execute (load Garnet-Debug-Loader)~%"))

(if load-demos-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :demos))
	(format T "~%****** Demos already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Demos %%%%%%%%~%")
          (load Garnet-Demos-Loader)))
    (format T "~%****** NOT Loading Demos *******
** To load Demos, execute (load Garnet-Demos-Loader)~%"))

(if load-lapidary-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :lapidary))
	(format T "~%****** Lapidary already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Lapidary %%%%%%%%~%")
          (load Garnet-Lapidary-Loader)))
    (format T "~%****** NOT Loading Lapidary *******
** To load Lapidary, execute (load Garnet-Lapidary-Loader)~%"))

(if load-gilt-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :gilt))
	(format T "~%****** Gilt already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Gilt %%%%%%%%~%")
          (load Garnet-Gilt-Loader)))
    (format T "~%****** NOT Loading Gilt *******
** To load Gilt, execute (load Garnet-Gilt-Loader) or
   (load Garnet-Motif-Gilt-Loader)~%"))

(if load-c32-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :c32))
	(format T "~%****** C32 already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading C32 %%%%%%%%~%")
          (load Garnet-C32-Loader)))
    (format T "~%****** NOT Loading C32 *******
** To load C32, execute (load Garnet-C32-Loader)~%"))


;--------------------------------------------------------------------
(defun user::Garnet-Load (filename)
  (let ((pos (position #\: filename)))
    (if pos
	(let* ((head (subseq filename 0 pos))
	       (tail (subseq filename (1+ pos)))
	       (prefix (cond
			 ((string= head "clx") CLX-PathName)
			 ((string= head "kr") Garnet-KR-PathName)
			 ((string= head "opal") Garnet-Opal-Pathname)
			 ((string= head "inter") Garnet-Inter-PathName)
			 ((string= head "gesture") Garnet-Gesture-PathName)
			 ((string= head "gestures") Garnet-Gesture-PathName)
			 ((string= head "ps") Garnet-PS-PathName)
			 ((string= head "aggregadgets") Garnet-Aggregadgets-PathName)
			 ((string= head "gadgets") Garnet-Gadgets-PathName)
			 ((string= head "gg") Garnet-Gadgets-PathName)
			 ((string= head "debug") Garnet-Debug-PathName)
			 ((string= head "demos") Garnet-Demos-PathName)
			 ((string= head "demo") Garnet-Demos-PathName)
			 ((string= head "lapidary") Garnet-Lapidary-PathName)
			 ((string= head "gilt") Garnet-Gilt-PathName)
			 ((string= head "c32") Garnet-C32-PathName)
			 ((string= head "kr-src") Garnet-KR-Src)
			 ((string= head "opal-src") Garnet-Opal-Src)
			 ((string= head "inter-src") Garnet-Inter-Src)
			 ((string= head "gesture-src") Garnet-Gesture-Src)
			 ((string= head "gestures-src") Garnet-Gesture-Src)
			 ((string= head "ps-src") Garnet-PS-Src)
			 ((string= head "aggregadgets-src") Garnet-Aggregadgets-Src)
			 ((string= head "gadgets-src") Garnet-Gadgets-Src)
			 ((string= head "gg-src") Garnet-Gadgets-Src)
			 ((string= head "debug-src") Garnet-Debug-Src)
			 ((string= head "demos-src") Garnet-Demos-Src)
			 ((string= head "demo-src") Garnet-Demos-Src)
			 ((string= head "lapidary-src") Garnet-Lapidary-Src)
			 ((string= head "gilt-src") Garnet-Gilt-Src)
			 ((string= head "c32-src") Garnet-C32-Src)
			 (t (error "Bad prefix ~%" head))))
	       (finalname (merge-pathnames tail prefix)))
	  (format T "Loading ~s~%" finalname)
	  (load finalname))
	;; else no colon, load regular
	(progn
	  (format T "NO COLON, Loading ~s~%" filename)
	  (load filename)))))

;;; 
;;; This function will compile your garnet files while keeping the
;;; sources and binaries separated.  If you want to just compile one
;;; file from Garnet, like the gadget file gauge.lisp, then you could
;;; use this function to compile the source file and automatically
;;; save the binary file in the bin directory.
;;;
;;; Example:
;;;    (garnet-compile "gadgets:gauge") 
;;;    Takes the source file from Garnet-Gadgets-Src, compiles it, and
;;;    saves the binary file in Garnet-Gadgets-Pathname (the binary
;;;    gadgets directory).
;;;
(defvar *compiler-extension*
  #+allegro ".fasl"
  #+lucid   ".lbin"
  #+(and cmu sparc)       ".sparcf"
  #+(and cmu (not sparc)) ".fasl")

(defun user::Garnet-Compile (filename)
  (let ((pos (position #\: filename)))
    (if pos
	(let* ((head (subseq filename 0 pos))
	       (tail (subseq filename (1+ pos)))
	       (src-prefix (cond
		 ((string= head "clx") CLX-Src)
		 ((string= head "kr") Garnet-KR-Src)
		 ((string= head "opal") Garnet-Opal-Src)
		 ((string= head "inter") Garnet-Inter-Src)
		 ((string= head "gesture") Garnet-Gesture-Src)
		 ((string= head "gestures") Garnet-Gesture-Src)
		 ((string= head "ps") Garnet-PS-Src)
		 ((string= head "aggregadgets") Garnet-Aggregadgets-Src)
		 ((string= head "gadgets") Garnet-Gadgets-Src)
		 ((string= head "gg") Garnet-Gadgets-Src)
		 ((string= head "debug") Garnet-Debug-Src)
		 ((string= head "demos") Garnet-Demos-Src)
		 ((string= head "demo") Garnet-Demos-Src)
		 ((string= head "lapidary") Garnet-Lapidary-Src)
		 ((string= head "gilt") Garnet-Gilt-Src)
		 ((string= head "c32") Garnet-C32-Src)
		 (t (error (concatenate 'string "Bad prefix " head)))))
	       (bin-prefix (cond
		 ((string= head "clx") CLX-PathName)
		 ((string= head "kr") Garnet-KR-PathName)
		 ((string= head "opal") Garnet-Opal-PathName)
		 ((string= head "inter") Garnet-Inter-PathName)
		 ((string= head "gesture") Garnet-Gesture-PathName)
		 ((string= head "gestures") Garnet-Gesture-PathName)
		 ((string= head "ps") Garnet-PS-PathName)
		 ((string= head "aggregadgets") Garnet-Aggregadgets-PathName)
		 ((string= head "gadgets") Garnet-Gadgets-PathName)
		 ((string= head "gg") Garnet-Gadgets-PathName)
		 ((string= head "debug") Garnet-Debug-PathName)
		 ((string= head "demos") Garnet-Demos-PathName)
		 ((string= head "demo") Garnet-Demos-PathName)
		 ((string= head "lapidary") Garnet-Lapidary-PathName)
		 ((string= head "gilt") Garnet-Gilt-PathName)
		 ((string= head "c32") Garnet-C32-PathName)
		 (t (error (concatenate 'string "Bad prefix " head)))))
	       (src-finalname (merge-pathnames
				(concatenate 'string tail ".lisp")
				src-prefix))
	       (bin-finalname (merge-pathnames
			        (concatenate 'string tail *compiler-extension*)
				bin-prefix)))
	  (format T "Compiling ~s~%" src-finalname)
	  (format T "for output to ~s~%" bin-finalname)
	  (compile-file src-finalname :output-file bin-finalname))
	;; else no colon, abort
	(error "NO COLON, aborting compile"))))


(format t "~%... Garnet Load Complete ...~%")
