(in-package "USER" :use '("LISP"))


(setf Garnet-Gilt-BitMap-PathName "/azure/homes/bvz/garnet/gilt/")

(dolist (loader-file '("text-buttons-loader"
			"error-gadget-loader"
                 	"arrow-line-loader"
		 	"labeled-box-loader"
		 	"x-buttons-loader"
	 	 	"v-slider-loader"
		 	"scrolling-labeled-box-loader"
		 	"radio-buttons-loader"
	 	 	"scrolling-window-loader"
		 	"scrolling-menu-loader"
			"prop-sheet-win-loader"))
 (load (merge-pathnames loader-file
                           #+cmu "gadgets:"
                           #+(not cmu) user::Garnet-Gadgets-PathName)
          :verbose T))

;;;
;;;     Functions needed from Gilt
(load (merge-pathnames "gilt-functions-loader"
			 user::Garnet-Gilt-PathName))

(Defparameter Garnet-Lapidary-Files
  '(	

;    "shapes"
;    "lines"
;    "draw"
	"support-menu-editor"		        "new-editor"
        "text"   "text-properties"
        "gadgetcopy"
        "lapidary-save"	"lapidary-read"	"support-save-restore" "save-restore"
	"choice-inter" "text-inter"
	"move-grow-inter" "angle-inter" "two-point-inter"
    "support-inter" "by-demo"
    "interactors" "interactors-menu"
))

(setf i 0)
(dolist (file Garnet-Lapidary-Files)
	 (compile-file (merge-pathnames file Garnet-Lapidary-Src))
	 #+allegro
	 (if (> i 6)
	     (progn
	       (gc t)
	       (setf i 0))
	     (incf i))
	 #+(or allegro explorer lispworks lucid)
	 (load (merge-pathnames file Garnet-Lapidary-Src)))

