;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; CHANGE LOG:
;;; 04/15/92 Mickish - Added ps-multifont and load of multifont-loader
;;;

(in-package "USER" :use '("LISP"))

;; Only loads this file when not compiling all of Garnet.
(unless (boundp 'user::*Garnet-Going-To-Compile*)
  (load (merge-pathnames "multifont-loader"
			 #+cmu "opal:"
			 #+(not cmu) user::Garnet-Opal-PathName)))

(Defparameter Garnet-PS-Files
  '(
    "ps"
    "ps-multifont"
    ))

(dolist (file Garnet-PS-Files)
	 (compile-file (merge-pathnames file Garnet-PS-Src))
	 #+(or allegro explorer lispworks lucid cmu)
	 (load         (merge-pathnames file Garnet-PS-Src)))



#+(or allegro explorer lispworks lucid cmu)
(setf (get :garnet-modules :ps) T)


