/* Scheme implementation intended for JACAL.
   Copyright (C) 1990, 1991 Aubrey Jaffer.
   See the file `scm.c' for terms applying to this program */

/* SCMVERSION is a string for the version specifier.  The number is
the major version number and the trailing letter is the revision:
"a" for alpha release, "b" for beta release, "c", "d", and so on.
There is a separate PATCHLEVEL defined in "patchlvl.h" */

#ifndef SCMVERSION
#define SCMVERSION "3a"
#endif

/* If your scheme code runs under this program without any errors you
can disable almost all error checking by compiling all files with this
line or better yet by changing the makefile. */

/* #define RECKLESS */

/* IMPLINIT is the full pathname (surrounded by double quotes) of
Init.scm, the Scheme initialization code.  This is best defined in the
makefile, if possible.  If available, scm uses the value of
environment variable SCM_INIT_PATH instead of IMPLINIT. */

/* #define IMPLINIT "/usr/jaffer/scm/Init.scm" */

/* Define STR_EXTENSIONS if you want substring-move-left! and
substring-move-right! */

#define STR_EXTENSIONS

/* Define IO_EXTENSIONS if you want R/W files and file-position */

#define IO_EXTENSIONS

/* Define BIGDIG to an integer type whose size is smaller than long if
you want bignums.  BIGNUMS ARE NOT IMPLEMENTED YET. */

/* #define BIGDIG short */

/* Define FLOATS if you want floating point numbers.  This is best
done in the Makefile */

/* #define FLOATS */

/* Define SINGLES if you want single precision floats and
   (sizeof (float) == sizeof (long)) */

#ifdef FLOATS
#define SINGLES
#endif

/* Define ENGNOT if you want floats to display in engineering notation
(exponents always multiples of 3) instead of scientific notation. */

#define ENGNOT

/* NUMBUFLEN is the maximum number of characters you expect to be
neccessary for the printed or string representation of number */

#ifndef NUMBUFLEN
#ifdef FLOATS
#define NUMBUFLEN 40
#else
#define NUMBUFLEN 15
#endif /* FLOATS */
#endif /* NUMBUFLEN */

/* FLORADIX is the base of the mantissa of floating point numbers (usually 2) */

#define FLORADIX 2

/* MEMOIZE_LOCALS will speed up most local variable references.  You
will need to remove this and recompile eval.c if you use very large or
deep environments (more than 32767 bound variables in one procedure)*/

#define MEMOIZE_LOCALS

/* PTR_LT defines how to compare two CELLPTRs (which may not be in the
same array).  CELLPTR is a pointer to a cons cell which may be
compared or differenced.  SCMPTR is used for stack bounds. */

#ifdef __TURBOC__
#define MSDOS
typedef cell huge *CELLPTR;
typedef SCM  huge *SCMPTR;
#else
typedef cell *CELLPTR;
typedef SCM  *SCMPTR;
#endif
# define PTR_LT(x,y) (x < y)

#ifndef _SIZE_T
typedef unsigned int size_t;
#endif

/* The following 6 definitions are defined automatically by the C
pre-processor.  You will need to override these if you are
cross-compiling or if the C pre-processor has different properties
than the compiler. */

#if (((-1)%2 == -1) && ((-1)%(-2) == -1) && (1%2 == 1) && (1%(-2) == 1))
#else
#define BADIVSGNS
#endif

/* SRS is signed right shift */
/*--- Turbo C++ v1.0 has a bug with right shifts of signed longs!
      It is believed to be fixed in Turbo C++ v1.01                ---*/
#if ((((-1L)<<2)+2)>>2 == -1L) && (__TURBOC__ != 0x295)
#define SRS(x,y) ((x)>>y)
#else
#define SRS(x,y) (((x)<0) ? ~((~(x))>>y) : (x)>>y)
#endif

/* char_code_limit is the number of distinct characters represented by
the unsigned char datatype. */

#define char_code_limit 256

/* most-positive-fixnum is the INUM closest to positive infinity. */

#define most_positive_fixnum ((unsigned long)~0L>>3)

/* most_negative_fixnum is the INUM closest to negative infinity. */

#if (0 != ~0)
#define most_negative_fixnum (-most_positive_fixnum-1)
#else
#define most_negative_fixnum (-most_positive_fixnum)
#endif

/* the rest of "scm.h" applies only to sys.c */

#ifdef IN_SYS

#if (('\n'=='\025') && (' '=='\100') && ('a'=='\201') && ('A'=='\301'))
#define EBCDIC
#endif
#if (('\n'=='\012') && (' '=='\040') && ('a'=='\141') && ('A'=='\101'))
#define ASCII
#endif

/* end of automatic C pre-processor definitions */

/* If you only need straight stack continuations CHEAP_CONTINUATIONS
will run faster and use less storage than not having it.  Machines
with unusual stacks need this. */

/* #define CHEAP_CONTINUATIONS */

/* James Clark came up with this neat one instruction fix for
continuations on the SPARC.  It flushes the register windows so that
all the state of the process is contained in the stack. */

#ifdef sparc
#define FLUSH_REGISTER_WINDOWS asm("ta 3")
#else
#define FLUSH_REGISTER_WINDOWS /* empty */
#endif

/* LINE_INCREMENTORS are the characters which cause the line count to
be incremented for the purposes of error reporting.  This feature is
only used for scheme code loaded from files.

WHITE_SPACES are other characters which should be treated like spaces
in programs.  in both cases sparate characters with ":case " */

#define LINE_INCREMENTORS  '\n'
#define WHITE_SPACES  ' ':case '\t':case '\r':case '\f'

/* OPEN_READ, OPEN_WRITE, and OPEN_BOTH are used to request the proper
mode to open files in.  MSDOS does carraige return - newline
translation if not opened in `b' mode. */

#ifdef MSDOS
#define OPEN_READ "rb"
#define OPEN_WRITE "wb"
#define OPEN_BOTH "r+b"
#else
#define OPEN_READ "r"
#define OPEN_WRITE "w"
#define OPEN_BOTH "r+"
#endif

/* If stack is not longword aligned then */

/* #define SHORT_ALIGN */
#ifdef THINK_C
#define SHORT_ALIGN
#endif
#ifdef MSDOS
#define SHORT_ALIGN
#endif

/* If stacks grow up then */

/* #define STACK_GROWS_UP */
#ifdef hp9000s800
#define STACK_GROWS_UP
#endif
#ifdef pyr
#define STACK_GROWS_UP
#endif

/* CELL_UP and CELL_DN are used by init_heap_seg to find cell aligned inner
bounds for allocated storage */

#define CELL_UP(p) (CELLPTR)(~7L & ((long)(p)+7))
#define CELL_DN(p) (CELLPTR)(1+(7 | ((long)(p)-7)))

/* how to get the local definition for malloc */

#ifdef unix
	char *malloc();
	char *realloc();
#else
#ifdef MSDOS
#ifdef __TURBOC__
#include <alloc.h>
#else
#include <malloc.h>
#endif
#endif
#endif

/* NUM_HASH_BUCKETS is the number of symbol hash table buckets.  */

#define NUM_HASH_BUCKETS 137

/* If fewer than MIN_GC_YIELD cells are recovered during a garbage
collection (GC) more space is allocated for the heap. */

#define MIN_GC_YIELD 500

/* These are parameters for controlling memory allocation.  The heap is
the area out of which cons and object headers is allocated.  Each heap
object is 8 bytes.  The units of the SIZE parameters is bytes.

INIT_HEAP_SIZE is the initial size of heap.  If this much heap cannot
be allocated, HEAP_SEG_SIZE will be used.  HEAP_SEG_SIZE is the size
of heap to try to allocate when more heap is needed.  HEAP_SEG_SIZE
must fit into type size_t.  MIN_HEAP_SEG_SIZE is minimum size of heap
to accept when more heap is needed.  */

#define INIT_HEAP_SIZE 200000
#ifdef _QC
#define HEAP_SEG_SIZE 32400
#else
#define HEAP_SEG_SIZE 64800
#endif
#define MIN_HEAP_SEG_SIZE 8000

/* Here is an alternative definition of HEAP_SEG_SIZE, which will result in
exponential rather than linear growth of the heap. */

/* #define HEAP_SEG_SIZE (INIT_HEAP_SIZE << (num_heap_segs-1)) */

#endif /* IN_SYS */
