;;;; "Init.scm", Scheme initialization code for SCM.
;;; Copyright (C) 1991, 1992 Aubrey Jaffer.
;;; See the file `COPYING' for terms applying to this program.

;;; (library-vicinity) should be defined to be the pathname of the
;;; directory where files of Scheme library functions reside.

(set! *features*
      (append '(getenv system abort integer-limits
		p1178 rev4-report rev4-optional-procedures
		rev2-procedures)
	      *features*))

(define library-vicinity
  (let ((library-path
	 (or (getenv "SCHEME_LIBRARY_PATH")
	     (case (software-type)
	       ((UNIX) "/usr/lib/scheme/")
	       ((VMS) "lib$scheme:")
	       ((MSDOS) "C:\\SCMLIB\\")
 	       ((MACOS THINKC) "camus Napoleon:Think C4.0:scm3.0:")
	       ((AMIGA) "Scheme:libs/")
	       (else "")))))

    (lambda () library-path)))

;;; program-vicinity is here in case the Scheme Library cannot be found.
(define program-vicinity
  (let ((*vicinity-suffix*
	 (case (software-type)
	   ((UNIX AMIGA)	'(#\/))
	   ((VMS)	'(#\: #\]))
	   ((MSDOS)	'(#\\))
	   ((MACOS THINKC)	'(#\:)))))
    (lambda ()
      (let loop ((i (- (string-length *load-pathname*) 1)))
	(cond ((negative? i) "")
	      ((memv (string-ref *load-pathname* i)
		     *vicinity-suffix*)
	       (substring *load-pathname* 0 (+ i 1)))
	      (else (loop (- i 1))))))))

(define in-vicinity string-append)

(cond ((try-load (in-vicinity (library-vicinity) "require.scm")))
      (else
       (perror "WARNING")
       (display "WARNING: Couldn't find require.scm in (library-vicinity)")
       (write (library-vicinity))
       (newline)
       (set-errno! 0)))

;;; DO NOT MOVE!  This has to be done after "require.scm" is loaded.
(set! load
      (lambda (file)
	(cond ((> (verbose) 0)
	       (display ";loading ")
	       (write file)
	       (newline)))
	(force-output)
	(or (try-load file)
	    ;;HERE is where the suffix gets specified
	    (try-load (string-append file ".scm"))
	    (error "LOAD couldn't find file " file))
	(set-errno! 0)
	(cond ((> (verbose) 0)
	       (display ";done loading ")
	       (write file)
	       (newline)))))

(define (error . args)
  (perror "ERROR")
  (set-errno! 0)
  (display "ERROR: ")
  (if (not (null? args))
      (begin (display (car args))
	     (for-each (lambda (x) (display #\ ) (write x))
		       (cdr args))))
  (newline)
  (abort))

(define slib:error error)

;;; This is the vicinity where this file resides.
(define implementation-vicinity
  (let ((vic (program-vicinity)))
    (lambda () vic)))

(define (terms)
  (list-file (in-vicinity (implementation-vicinity) "COPYING")))

(define (list-file file)
  (call-with-input-file file
    (lambda (inport)
      (do ((c (read-char inport) (read-char inport)))
	  ((eof-object? c))
	(write-char c)))))

;;;; Here are some Revised^2 Scheme functions:
(define (string-null? str)
  (= 0 (string-length str)))

;;; I am guessing at the definition of this
(define (append! a b)
  (cond ((null? a) b)
	(else (set-cdr! (last-pair a) b)
	      a)))

(define (1+ n) (+ n 1))
(define (-1+ n) (+ n -1))
(define 1- -1+)
(define <? <)
(define <=? <=)
(define =? =)
(define >? >)
(define >=? >=)

;; define these as appropriate for your system.
(define slib:tab #\tab)
(define slib:form-feed #\page)

(if (= (length (program-arguments)) 1) (verbose 1))

(if (not (memq 'ed *features*))
    (define (ed . args)
      (system (apply string-append
		     (or (getenv "EDITOR") "ed")
		     (map (lambda (s) (string-append " " s)) args)))))
(if (not (memq 'ed *features*))
    (set! *features* (cons 'ed *features*)))

;;; ABS and MAGNITUDE can be the same.
(if (inexact? (string->number "0.0")) (set! abs magnitude))

;;; This loads the user's initialization file or program arguments.
(or
 (eq? (software-type) 'THINKC)
 (member "-no-init-file" (program-arguments))
 (try-load (in-vicinity (or (getenv "HOME") (user-vicinity))
			"ScmInit.scm"))
 (begin (set-errno! 0) #f)
 (for-each load (cdr (program-arguments))))
