; "withfile.scm", with-input-from-file and with-output-to-file
; functions for Scheme.  
; Copyright (c) 1992, Aubrey Jaffer

(require 'dynamic-wind)

(define withfile:current-input (current-input-port))
(define withfile:current-output (current-output-port))

(define (current-input-port) withfile:current-input)
(define (current-output-port) withfile:current-output)

(define (with-input-from-file file thunk)
  (define oport withfile:current-input)
  (define port (open-input-file file))
  (dynamic-wind (lambda() (set! withfile:current-input port))
		thunk
		(lambda() (set! withfile:current-input oport))))

(define (with-output-from-file file thunk)
  (define oport withfile:current-output)
  (define port (open-output-file file))
  (dynamic-wind (lambda() (set! withfile:current-output port))
		thunk
		(lambda() (set! withfile:current-output oport))))

(define peek-char
  (let ((peek-char peek-char))
    (lambda opt
      (peek-char (if (null? opt) withfile:current-input (car opt))))))

(define read-char
  (let ((read-char read-char))
    (lambda opt
      (read-char (if (null? opt) withfile:current-input (car opt))))))

(define read
  (let ((read read))
    (lambda opt
      (read (if (null? opt) withfile:current-input (car opt))))))

(define write-char
  (let ((write-char write-char))
    (lambda (obj . opt)
      (write-char obj (if (null? opt) withfile:current-output (car opt))))))

(define write
  (let ((write write))
    (lambda (obj . opt)
      (write obj (if (null? opt) withfile:current-output (car opt))))))

(define display
  (let ((display display))
    (lambda (obj . opt)
      (display obj (if (null? opt) withfile:current-output (car opt))))))

(define newline
  (let ((newline newline))
    (lambda opt
      (newline (if (null? opt) withfile:current-output (car opt))))))

(define force-output
  (let ((force-output force-output))
    (lambda opt
      (force-output (if (null? opt) withfile:current-output (car opt))))))
