;;; defforcps.scm  -- define-foreign, Continuation Passing Style

;;; This defines define-foreign as macro that defines a wrapper for the
;;; primitive function that the define-foreign describes.  The wrapper takes
;;; as its first parameter a function to call with the results of primitive
;;; function.  For example,
;;;
;;;         (lib$spawn (lambda (stat pid)
;;;     		 (define tell (lambda objs (for-each display objs)))
;;;     		 (tell #\newline "stat: " stat
;;;     		       #\newline "pid: " pid))
;;;     	       "DIR")
;;;
;;; will display the return status and pid returned by LIB$SPAWN.
;;;
;;; To use this, load this file and then load the file containing the
;;; define-foreign's; of course the file of define-foreigns must already have
;;; been run through GENSCMINT.SCM and linked with SCM so the primitive
;;; functions it defines are available for use.

(define define-foreign
  (procedure->macro
   (lambda (exp env)
     (let ((name (cadr exp)))
       `(define ,name
	  (let ((prim-fun ,name))
	    (lambda (cont . rest)
	      (apply cont (vector->list (apply prim-fun rest))))))))))

;;; EOF 
