/* config.h: Some stuff you can set up! */

/*
 * If you are on a SysV system or one that uses the termio tty interface, you
 * will probably have to uncomment the following.  
 */
/* #define TERMIO  /* */

/* BANNER_FILE: this file is displayed before the first "Nickname: " prompt. */
#define BANNER_FILE "/usr/etc/irc/banner"

/*
 * MOTD_FILE: set this to the full path of a file that will be displayed
 * after the user logs in.  If commented out, no motd is used.  The MOTD_FILE
 * is also ignored if you are not using a PASSWD_FILE (put all your messages
 * in the BANNER_FILE in this case) 
 */
#define MOTD_FILE "/usr/etc/irc/motd"

/*
 * SAVE_DIR: path of a directory in which users can /SAVE IRCII settings.
 * Commenting this out will prevent users from being able to save settings 
 */
#define SAVE_DIR "/usr/etc/irc"

/*
 * PASSWD_FILE: full path name of the password file for irciid.  If you
 * comment out this password file definition, no passwords will be required
 * to connect to the system.  The format of each line of the password file is
 * as follows: 
 *
 * nick:encrypted password:uid:Mail Address 
 *
 * Nicknames and passwords are case sensitive during login.  The uid is only
 * used (currently) to create the salt for the password encryption.  The Mail
 * Address is used as the IRCNAME of the person.  When adding new users, it's
 * usually easiest to not put in a password (since its tough to encrypt in
 * your head), then sign-on as that user with no password and change it. 
 */
#define PASSWD_FILE "/usr/etc/irc/irc.passwd"

/*
 * DAEMON_UID: Set this to the uid that you want the IRCII process to run as.
 * A similiar define existing in irc.h of the IRCII sources which may be set
 * to the same value.  This will prevent any telnet user from being able to
 * write to disk and exec processes 
 */
#define DAEMON_UID 1

/*
 * RESTRICTIONS_FILE: This is the full path name of a file which can contain
 * host restriction information.  If this file does not exist, all
 * connections are accepted. If this file exists, it should contain entries
 * of the following form: 
 *
 * [+|-]hostname 
 *
 * where each entry is separated by whitespace.  If a + is given before a
 * hostname, than connections from that host are accepted.  If a - is given
 * before a hostname, than connections from that host are rejected.  Each
 * hostname may contain wildcards.  The wildcard character is an asterisk
 * (*).  If any hostname matches both a host with a + and a host with a -,
 * the connection will be rejected.  The following are legal entries: 
 *
 * +*.cmu.edu -annex*.cmu.edu 
 *
 * The first entry would accept connections from anyone at CMU.  The second
 * entry would restrict that to people not telnetting from machines begining
 * with the word "annex" (These are telnet servers at CMU and thus people can
 * easily maintain anonymity if they connect from these machines). The order
 * of the entries does not matter. 
 */
#define RESTRICTIONS_FILE "/usr/etc/irc/irciid.hosts"

/*
 * IRCII_PATH: This is the full path of the IRCII program to executed.  If
 * you do not wish to use IRCII, you may have to do some other hacking to get
 * things to work.  I have tailored this for IRCII 
 */
#define IRCII_PATH "/afs/andrew/usr3/ms5n/bin/.irc"

/*
 * IRCSERVER: This is the IRCSERVER environment variable which defines the
 * server list for the connecting telnet.  PLEASE set this to something
 * reasonable for your site, or remove it completely and let IRCII use the
 * defaults you have set up 
 */
#define IRCSERVER "IRCSERVER=fairhope.andrew.cmu.edu garfield.mit.edu unix.cis.pitt.edu sirius.ctr.columbia.edu unicorn.wwu.edu"

/*
 * LOG_FILE: The full path of a file in which irciid should log connections.
 * If passwd files are used, then the users nick and connect host are logged,
 * if no passwd file is used, only the connection host is logged.  An entry
 * is added to this file when the connection is established (with timestamp)
 * and when it is broken (with timestamp). 
 *
 * Note: the LOG_FILE is *not* self-creating. You must create the initial empty
 * file.  Once the file exists, irciid will start to write to it.  This is so
 * you can easily disable the LOG_FILE feature (by simply rm or mv the
 * LOG_FILE) without having to recompile 
 */
#define LOG_FILE "/usr/etc/irc/connect.log"

/*
 * USE_LOG: This is a file that will contain user nicknames and the number of
 * times each has logged in since the file creation time.  This is a slightly
 * more concise format than the LOG_FILE, but it also contains less
 * information (no hostnames, ttys, or timestamps).  This is ignored if you
 * are not using a PASSWD_FILE 
 *
 * Note: the USE_LOG is *not* self-creating. You must create the initial empty
 * file.  Once the file exists, irciid will start to write to it.  This is so
 * you can easily disable the USE_LOG feature (by simply rm or mv the
 * USE_LOG) without having to recompile 
 */
#define USE_LOG "/usr/etc/irc/use.log"
