'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_Expr.man,v 1.2 89/03/24 14:16:11 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_Expr tcl
.BS
.SH NAME
Tcl_Expr \- evaluate an expression
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
int
\fBTcl_Expr\fR(\fIinterp, string, valuePtr\fR)
.SH ARGUMENTS
.AS Tcl_Interp *interp
.AP Tcl_Interp *interp in
Interpreter in whose context to evaluate \fIstring\fR.
.AP char *string in
Expression to be evaluated.
.AP int *valuePtr out
The expression's (integer) value will be stored here.
.BE

.SH DESCRIPTION
.PP
\fBTcl_Expr\fR is a utility procedure used by several of the Tcl commands.
Given a string whose contents are an expression of the form
accepted by the \fBexpr\fR command, this procedure evaluates
the expression and returns the integer result in \fI*valuePtr\fR.
Normally \fBTcl_Expr\fR returns \fBTCL_OK\fR as its result.  However, if
the expression contains a syntax error then Tcl_Expr
returns \fBTCL_ERROR\fR and sets \fIinterp->result\fR to point
to an error message in the usual fashion.
\fBTcl_Expr\fR may make nested calls to \fBTcl_Eval\fR while parsing the
expression;  if any of these calls returns an error then
\fBTcl_Expr\fR will return that same error information.  If an error
is returned, then \fI*valuePtr\fR will not be modified.

.SH KEYWORDS
evaluate, expression
