#
# Compare, in detail, two strings
#

proc compare {s1 s2} {
    if {[string equal $s1 $s2]} {
	return equal
    }
    if {[string length $s1] != [string length $s2]} {
	return "s1 length [string length $s1] != s2 length [string length $s2]"
    }
    set i 0
    foreach c1 [split $s1 {}] c2 [split $s2 {}] {
	if {[string compare $c1 $c2] != 0} {
	    scan $c1 %c c1scanval
	    scan $c2 %c c2scanval
	    binary scan $c1 a c1binval
	    binary scan $c2 a c2binval
	    return "char($i) c1 $c1 $c1scanval $c1binval c2 $c2 $c2scanval $c2binval"
	}
	incr i
    }
}
