'\" -*- tcl -*-
'\"
'\" Generated from ../tcllib/modules/pop3d/pop3d.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "pop3d" n 1.0 pop3d "Tcl POP3 Server Package"
.BS
.SH NAME
pop3d \- Tcl POP3 server implementation
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBpop3d ?1.0?\fR
.sp
\fB::pop3d::new\fR ?\fIserverName\fR?\fR
.sp
\fBserverName\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
.sp
\fIserverName\fR \fBup\fR\fR
.sp
\fIserverName\fR \fBdown\fR\fR
.sp
\fIserverName\fR \fBdestroy\fR ?\fImode\fR?\fR
.sp
\fIserverName\fR \fBconfigure\fR\fR
.sp
\fIserverName\fR \fBconfigure\fR \fI-option\fR\fR
.sp
\fIserverName\fR \fBconfigure\fR \fI-option value\fR...\fR
.sp
\fIserverName\fR \fBcget\fR \fI-option\fR\fR
.sp
\fIserverName\fR \fBconn\fR list\fR
.sp
\fIserverName\fR \fBconn\fR state \fIid\fR\fR
.sp
\fIauthCmd\fR \fBlookup\fR \fIname\fR\fR
.sp
\fIstorageCmd\fR \fBdele\fR \fImbox\fR \fImsgList\fR\fR
.sp
\fIstorageCmd\fR \fBlock\fR \fImbox\fR\fR
.sp
\fIstorageCmd\fR \fBunlock\fR \fImbox\fR\fR
.sp
\fIstorageCmd\fR \fBsize\fR \fImbox\fR \fImsgId\fR\fR
.sp
\fIstorageCmd\fR \fBstat\fR \fImbox\fR\fR
.sp
\fIstorageCmd\fR \fBget\fR \fImbox\fR \fImsgId\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
.TP
\fB::pop3d::new\fR ?\fIserverName\fR?\fR
This command creates a new server object with an associated global Tcl
command whose name is \fIserverName\fR.
The command \fBserverName\fR may be used to invoke various operations
on the server.  It has the following general form:
.TP
\fBserverName\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.PP
A pop3 server can be started on any port the caller has permission for
from the operating system. The default port will be 110, which is the
port defined by the standard (RFC 1939).
After creating, configuring and starting a the server object will
listen for and accept connections on that port and handle them
according to the POP3 protocol.
.PP
\fBNote:\fR The server provided by this module will handle only the
basic protocol by itself. For the higher levels of user authentication
and handling of the actual mailbox contents callbacks will be invoked.
.PP
The following commands are possible for server objects:
.TP
\fIserverName\fR \fBup\fR\fR
After this call the server will listen for connections on its configured port.
.TP
\fIserverName\fR \fBdown\fR\fR
After this call the server will stop listening for connections. This
does not affect existing connections.
.TP
\fIserverName\fR \fBdestroy\fR ?\fImode\fR?\fR
Destroys the server object. Currently open connections are handled
depending on the chosen mode.
The provided \fImode\fRs are:
.RS
.TP
\fBkill\fR
Destroys the server immediately, and forcefully closes all currently
open connections. This is the default mode.
.TP
\fBdefer\fR
Stops the server from accepting new connections and will actually
destroy it only after the last of the currently open connections for
the server is closed.
.RE
.TP
\fIserverName\fR \fBconfigure\fR\fR
Returns a list containing all options and their current values in a
format suitable for use by the command \fBarray set\fR. The options
themselves are described in section \fBOPTIONS\fR.
.TP
\fIserverName\fR \fBconfigure\fR \fI-option\fR\fR
Returns the current value of the specified option. This is an alias
for the method \fBcget\fR. The options themselves are described in
section \fBOPTIONS\fR.
.TP
\fIserverName\fR \fBconfigure\fR \fI-option value\fR...\fR
Sets the specified option to the provided value. The options
themselves are described in section \fBOPTIONS\fR.
.TP
\fIserverName\fR \fBcget\fR \fI-option\fR\fR
Returns the current value of the specified option. The options
themselves are described in section \fBOPTIONS\fR.
.TP
\fIserverName\fR \fBconn\fR list\fR
Returns a list containing the ids of all connections currently open.
.TP
\fIserverName\fR \fBconn\fR state \fIid\fR\fR
Returns a list suitable for [\fBarray set\fR] containing the
state of the connection referenced by \fIid\fR.
.SH "OPTIONS"
The following options are available to pop3 server objects.
.TP
\fB-port\fR \fIport\fR
Defines the \fIport\fR to listen on for new connections. Default is
110. This option is a bit special. If \fIport\fR is set to "0" the
server, or rather the operating system, will select a free port on its
own. When querying \fB-port\fR the id of this chosen port will be
returned. Changing the port while the server is up will neither change
the returned value, nor will it change on which port the server is
listening on. Only after resetting the server via a call to
\fBdown\fR followed by a call to \fBup\fR will the new port take
effect. It is at that time that the value returned when querying
\fB-port\fR will change too.
.TP
\fB-auth\fR \fIcommand\fR
Defines a \fIcommand\fR prefix to call whenever the authentication of
a user is required. If no such command is specified the server will
reject all users. The interface which has to be provided by the
command prefix is described in section \fBAUTHENTICATION\fR.
.TP
\fB-storage\fR \fIcommand\fR
Defines a \fIcommand\fR prefix to call whenever the handling of
mailbox contents is required. If no such command is specified the
server will claim that all mailboxes are empty. The interface which
has to be provided by the command prefix is described in section
\fBMAILBOXES\fR.
.SH "AUTHENTICATION"
Here we describe the interface which has to be provided by the
authentication callback so that pop3 servers following the interface
of this module are able to use it.
.TP
\fIauthCmd\fR \fBlookup\fR \fIname\fR\fR
This method is given a user\fIname\fR and has to return a two-element
list containing the password for this user and a storage reference, in
this order.
.sp
The storage reference is passed unchanged to the storage callback, see
sections \fBOPTIONS\fR and \fBMAILBOXES\fR for either the
option defining it and or the interface to provide, respectively.
.SH "MAILBOXES"
Here we describe the interface which has to be provided by the storage
callback so that pop3 servers following the interface of this module
are able to use it. The \fImbox\fR argument is the storage reference
as returned by the \fBlookup\fR method of the authentication
command, see section \fBAUTHENTICATION\fR.
.TP
\fIstorageCmd\fR \fBdele\fR \fImbox\fR \fImsgList\fR\fR]
Deletes the messages whose numeric ids are contained in the
\fImsgList\fR from the mailbox specified via \fImbox\fR.
.TP
\fIstorageCmd\fR \fBlock\fR \fImbox\fR\fR
This method locks the specified mailbox for use by a single connection
to the server. This is necessary to prevent havoc if several
connections to the same mailbox are open. The complementary method is
\fBunlock\fR. The command will return true if the lock could be set
successfully or false if not.
.TP
\fIstorageCmd\fR \fBunlock\fR \fImbox\fR\fR
This is the complementary method to \fBlock\fR, it revokes the lock
on the specified mailbox.
.TP
\fIstorageCmd\fR \fBsize\fR \fImbox\fR \fImsgId\fR\fR
Determines the size of the message specified through its id in
\fImsgId\fR, in bytes, and returns this number.
.TP
\fIstorageCmd\fR \fBstat\fR \fImbox\fR\fR
Determines the number of messages in the specified mailbox and returns
this number.
.TP
\fIstorageCmd\fR \fBget\fR \fImbox\fR \fImsgId\fR\fR
Returns a handle for the specified message. This handle is a mime
token following the interface described in the documentation of
package \fBmime\fR. The pop3 server will use the functionality of
the mime token to send the mail to the requestor at the other end of a
pop3 connection.
.SH "KEYWORDS"
pop3, internet, network, protocol, rfc1939
