'\"
'\" Copyright (c) 1998-2000 by Ajuba Solutions.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: html.n,v 1.17 2002/06/03 20:21:46 andreas_kupries Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH html n 1.2.1 Html "HTML Generation"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::html \- Procedures to generate HTML structures.
.SH SYNOPSIS
.sp
\fBpackage require Tcl 8.2\fR
.sp
\fBpackage require html ?1.2.1?\fR
.sp
\fBhtml::author\fR \fIauthor\fR
.sp
\fBhtml::bodyTag\fR \fIargs\fR
.sp
\fBhtml::cell\fR \fIparam value {tag td}\fR
.sp
\fBhtml::checkbox\fR \fIname value\fR
.sp
\fBhtml::checkSet\fR \fIkey sep list\fR
.sp
\fBhtml::checkValue\fR \fIname {value 1}\fR
.sp
\fBhtml::closeTag\fR \fI\fR
.sp
\fBhtml::default\fR \fIkey {param {}}\fR
.sp
\fBhtml::description\fR \fIdescription\fR
.sp
\fBhtml::end\fR \fI\fR
.sp
\fBhtml::eval\fR \fIarg ?args?\fR
.sp
\fBhtml::extractParam\fR \fIparam key {val ""}\fR
.sp
\fBhtml::font\fR \fIargs\fR
.sp
\fBhtml::for\fR \fIstart test next body\fR
.sp
\fBhtml::foreach\fR \fIvarlist1 list1 ?varlist2 list2 ...? body\fR
.sp
\fBhtml::formValue\fR \fIname {defvalue {}}\fR
.sp
\fBhtml::getFormInfo\fR \fIargs\fR
.sp
\fBhtml::getTitle\fR \fI\fR
.sp
\fBhtml::h\fR \fIlevel string {param {}}\fR
.sp
\fBhtml::h1\fR \fIstring {param {}}\fR
.sp
\fBhtml::h2\fR \fIstring {param {}}\fR
.sp
\fBhtml::h3\fR \fIstring {param {}}\fR
.sp
\fBhtml::h4\fR \fIstring {param {}}\fR
.sp
\fBhtml::h5\fR \fIstring {param {}}\fR
.sp
\fBhtml::h6\fR \fIstring {param {}}\fR
.sp
\fBhtml::hdrRow\fR \fIargs\fR
.sp
\fBhtml::head\fR \fItitle\fR
.sp
\fBhtml::headTag\fR \fIstring\fR
.sp
\fBhtml::if\fR \fIexpr1 body1\fR ?\fBelseif\fR \fIexpr2 body2 ...\fR? ?\fBelse\fR \fIbodyN?\fR
.sp
\fBhtml::keywords\fR \fIargs\fR
.sp
\fBhtml::mailto\fR \fIemail {subject {}}\fR
.sp
\fBhtml::meta\fR \fIargs\fR
.sp
\fBhtml::minorMenu\fR \fIlist {sep { | }}\fR
.sp
\fBhtml::minorList\fR \fIlist {ordered { 0 }}\fR
.sp
\fBhtml::openTag\fR \fItag args\fR
.sp
\fBhtml::passwordInput\fR \fI{name password}\fR
.sp
\fBhtml::passwordInputRow\fR \fIlabel {name password}\fR
.sp
\fBhtml::quoteFormValue\fR \fIvalue\fR
.sp
\fBhtml::radioSet\fR \fIkey sep list\fR
.sp
\fBhtml::radioValue\fR \fIname value\fR
.sp
\fBhtml::refresh\fR \fIseconds {url {}}\fR
.sp
\fBhtml::init\fR \fI{nvlist {}}\fR
.sp
\fBhtml::row\fR \fIargs\fR
.sp
\fBhtml::paramRow\fR \fIlist {rparam {}} {cparam {}}\fR
.sp
\fBhtml::select\fR \fIname param choices {current {}}\fR
.sp
\fBhtml::selectPlain\fR \fIname param choices {current {}}\fR
.sp
\fBhtml::set\fR \fIvar val\fR
.sp
\fBhtml::submit\fR \fIlabel {name submit}\fR
.sp
\fBhtml::tableFromArray\fR \fIarrname {param {}} {pat *}\fR
.sp
\fBhtml::tableFromList\fR \fIquerylist {param {}}\fR
.sp
\fBhtml::textarea\fR \fIname {param {}} {current {}}\fR
.sp
\fBhtml::textInput\fR \fIname args\fR
.sp
\fBhtml::textInputRow\fR \fIlabel name args\fR
.sp
\fBhtml::title\fR \fItitle\fR
.sp
\fBhtml::varEmpty\fR \fIname\fR
.sp
\fBhtml::while\fR \fItest body\fR
.BE
.SH DESCRIPTION
.PP
The \fB::html\fR package provides commands that generate HTML.
These commands typically return an HTML string as their result.
In particular, they do not output their result to \fBstdout\fR.
.PP
The \fBhtml::init\fP procedure should be called early to initialize
the module.  You can also use this procedure to define default values
for HTML tag parameters.
.TP
\fBhtml::author\fR \fIauthor\fR
\fISide effect only\fP.  Call this before \fBhtml::head\fR to define an
author for the page.  The author is noted in a comment in the
HEAD section.

.TP
\fBhtml::bodyTag\fR \fIargs\fR
Generate a BODY tag.
The tag parameters are taken from \fIargs\fP or from the
body.* attributes define with \fBhtml::init\fR

.TP
\fBhtml::cell\fR \fIparam value {tag td}\fR
Generate a TD (or TH) tag, a value, and a closing TD (or TH) tag.
The tag parameters come from \fIparam\fP or TD.* attributes
defined with \fBhtml::init\fR.
This uses \fBhtml::font\fP to insert a standard FONT tag
into the table cell.

.TP
\fBhtml::checkbox\fR \fIname value\fR
Generate a CHECKBOX form element with the specified name and value.
This uses \fBhtml::checkValue\fR.

.TP
\fBhtml::checkSet\fR \fIkey sep list\fR
Generate a set of CHECKBOX form elements and associated labels.
The \fIlist\fP should contain an alternating list of
labels and values.
This uses \fBhtml::checkbox\fR.

.TP
\fBhtml::checkValue\fR \fIname {value 1}\fR
Generate the "name=\fIname\fP value=\fIval\fP for a CHECKBOX form element.
If the CGI variable \fIname\fP has the value \fIval\fP, then
SELECTED is added to the return value.

.TP
\fBhtml::closeTag\fR \fI\fR
Pop a tag off the stack created by \fBhtml::openTag\fR
and generate the corresponding close tag (e.g., /BODY)

.TP
\fBhtml::default\fR \fIkey {param {}}\fR
This procedure is used by 
\fBhtml::tagParam\fP
to generate the name, value list of parameters for a tag.
The \fBhtml::default\fR procedure is used to generate default
values for those items not already in \fIparam\fP.
If the value identified by \fIkey\fP matches a value in \fIparam\fP
then this procedure returns the empty string.
Otherwise, it returns
a \fIparameter=value\fR string for a form element identified by
\fIkey\fP.
The \fIkey\fP has the form \fItag.parameter\fR
(e.g., body.bgcolor).
Use \fBhtml::init\fP to register default values.  

.TP
\fBhtml::description\fR \fIdescription\fR
\fISide effect only\fP.  Call this before \fBhtml::head\fR to define a
description META tag for the page.
This tag is generated later in the call to \fBhtml::head\fR.

.TP
\fBhtml::end\fR \fI\fR
Pop all open tags from the stack and generate the corresponding
close HTML tags, (e.g., </body></html>).

.TP
\fBhtml::eval\fR \fIarg ?args?\fR
This procedure is similar to the built-in Tcl \fBeval\fR command.  The
only difference is that it returns "" so it can be called from an HTML
template file without appending unwanted results.

.TP
\fBhtml::extractParam\fR \fIparam key {varName ""}\fR
This is a parsing procedure that extracts the value of \fIkey\fP
from \fIparam\fP,
which is a HTML-style \fIname=quotedvalue\fP list.
\fIvarName\fP is used as the name of a Tcl variable that is
changed to have the value found in the parameters.
The function returns 1 if the parameter was found in \fIparam\fP,
otherwise it returns 0.
If the \fIvarName\fP is not specified, then \fIkey\fP is
used as the variable name.

.TP
\fBhtml::font\fR \fIargs\fR
Generate a standard FONT tag.
The parameters to the tag are taken from \fIargs\fP
and the HTML defaults defined with \fBhtml::init\fP.

.TP
\fBhtml::for\fR \fIstart test next body\fR
This procedure is similar to the built-in Tcl \fBfor\fR control
structure.  Rather than evaluating the body, it returns the subst'ed
\fIbody\fR.  Each iteration of the loop causes another string to be
concatenated to the result value.

.TP
\fBhtml::foreach\fR \fIvarlist1 list1 ?varlist2 list2 ...? body\fR
This procedure is similar to the built-in Tcl \fBforeach\fR control
structure.  Rather than evaluating the body, it returns the subst'ed
\fIbody\fR.  Each iteration of the loop causes another string to be
concatenated to the result value.

.TP
\fBhtml::formValue\fR \fIname {defvalue {}}\fR
Return a name and value pair, where the value is initialized
from existing CGI data, if any.
The result has this form:
.DS
name="fred" value="freds value"
.DE

.TP
\fBhtml::getFormInfo\fR \fIargs\fR
Generate hidden fields to capture form values.
If \fIargs\fP is empty, then hidden fields are generated
for all CGI values.
Otherwise args is a list of string match patterns for
form element names.

.TP
\fBhtml::getTitle\fR \fI\fR
Return the title string, with out the surrounding TITLE tag,
set with a previous call to \fBhtml::title\fP.

.TP
\fBhtml::h\fR \fIlevel string {param {}}\fR
Generate a heading (e.g., H1) tag.
The \fIstring\fP is nested in the heading, and
\fIparam\fP is used for the tag parameters.
.TP
\fBhtml::h1\fR \fIstring {param {}}\fR
Generate an H1 tag.  See \fBhtml::h\fR
.TP
\fBhtml::h2\fR \fIstring {param {}}\fR
Generate an H2 tag.  See \fBhtml::h\fR
.TP
\fBhtml::h3\fR \fIstring {param {}}\fR
Generate an H3 tag.  See \fBhtml::h\fR
.TP
\fBhtml::h4\fR \fIstring {param {}}\fR
Generate an H4 tag.  See \fBhtml::h\fR
.TP
\fBhtml::h5\fR \fIstring {param {}}\fR
Generate an H5 tag.  See \fBhtml::h\fR
.TP
\fBhtml::h6\fR \fIstring {param {}}\fR
Generate an H6 tag.  See \fBhtml::h\fR

.TP
\fBhtml::hdrRow\fR \fIargs\fR
Generate a table row, including TR and TH tags.
Each value in \fIargs\fP is place into its own table cell.
This uses \fIhtml::cell\fP.

.TP
\fBhtml::head\fR \fItitle\fR
Generate the HEAD section that includes the page TITLE.
If previous calls have been made to
\fBhtml::author\fP, 
\fBhtml::keywords\fP, 
\fBhtml::description\fP, 
of
\fBhtml::meta\fP
then additional tags are inserted into the HEAD section.
This leaves an open HTML tag pushed on the stack with
\fBopenTag\fP.

.TP
\fBhtml::headTag\fR \fIstring\fR
Save a tag for inclusion in the HEAD section generated
by \fBhtml::head\fR.  The \fIstring\fP is everything
in the tag except the enclosing angle brackets, < >.

.TP
\fBhtml::if\fR \fIexpr1 body1\fR ?\fBelseif\fR \fIexpr2 body2 ...\fR? ?\fBelse\fR \fIbodyN?\fR
This procedure is similar to the built-in Tcl \fBif\fR control
structure.  Rather than evaluating the body of the branch that is
taken, it returns the subst'ed \fIbody\fR.  Note that the syntax is
slightly more restrictive than that of the built-in Tcl \fBif\fR
control structure.

.TP
\fBhtml::keywords\fR \fIargs\fR
\fISide effect only\fP.  Call this before \fBhtml::head\fR to define a
keyword META tag for the page.
The META tag is included in the result of \fBhtml::head\fP.

.TP
\fBhtml::mailto\fR \fIemail {subject {}}\fR
Generate a hypertext link to a mailto: URL.

.TP
\fBhtml::meta\fR \fIargs\fR
\fISide effect only\fP.  Call this before \fBhtml::head\fR to define a
META tag for the page.
The \fIargs\fP is a Tcl-style name, value list that is used
for the name= and value= parameters for the META tag.
The META tag is included in the result of \fBhtml::head\fP.

.TP
\fBhtml::minorMenu\fR \fIlist {sep { | }}\fR
Generate a series of hypertext links.
The \fIlist\fP is a Tcl-style name, value list of
labels and urls for the links.
The \fIsep\fP is the text to put between each link.
.TP
\fBhtml::minorList\fR \fIlist {ordered { 0 }}\fR
Generate an ordered or unordered list of links.  The \fIlist\fP is a
Tcl-style name, value list of labels and urls for the links.
\fIordered\fP is a boolean used to choose between an ordered or
unordered list.
.TP
\fBhtml::openTag\fR \fItag args\fR
Push \fItag\fP onto a stack and generate the opening tag
for \fItag\fP.  Use \fBhtml::closeTag\fP to pop the tag
from the stack.

.TP
\fBhtml::passwordInput\fR \fI{name password}\fR
Generate an INPUT tag of type PASSWORD.

.TP
\fBhtml::passwordInputRow\fR \fIlabel {name password}\fR
Format a table row containing
a label and an INPUT tag of type PASSWORD.

.TP
\fBhtml::quoteFormValue\fR \fIvalue\fR
Quote special characters in \fIvalue\fP by replacing them
with HTML entities for quotes, ampersand, and angle brackets.

.TP
\fBhtml::radioSet\fR \fIkey sep list\fR
Generate a set of INPUT tags of type RADIO and an associated text label.
All the radio buttons
share the same \fIkey\fP for their name.
The \fIsep\fP is text used to separate the elements.
The \fIlist\fP is a Tcl-style label, value list.

.TP
\fBhtml::radioValue\fR \fIname value\fR
Generate the "name=\fIname\fP value=\fIval\fP for a RADIO form element.
If the CGI variable \fIname\fP has the value \fIval\fP, then
SELECTED is added to the return value.

.TP
\fBhtml::refresh\fR \fIseconds url\fR
Set up a refresh META tag. Call this before \fBhtml::head\fP and
the HEAD section will contain a META tag that causes the
document to refresh in \fIseconds\fP seconds.
The \fIurl\fP is optional.  If specified, it specifies a new
page to load after the refresh interval.

.TP
\fBhtml::init\fR \fI{list {}}\fR
\fBhtml::init\fP accepts a Tcl-style name-value list that defines
values for items with a name of the form \fItag\fP.\fIparameter\fP.
For example, a default with key \fBbody.bgcolor\fP defines
the background color for the BODY tag.
.TP
\fBhtml::row\fR \fIargs\fR
Generate a table row, including TR and TD tags.
Each value in \fIargs\fP is place into its own table cell.
This uses \fIhtml::cell\fP.
.TP
\fBhtml::paramRow\fR \fIlist {rparam {}} {cparam {}}\fR
Generate a table row, including TR and TD tags. Each value in
\fIlist\fP is placed into its own table cell. This uses
\fIhtml::cell\fP. The value of \fIrparam\fP is used as parameter for
the TR tag. The value of \fIcparam\fP is passed to \fIhtml::cell\fP as
parameter for the TD tags.
.TP
\fBhtml::select\fR \fIname param choices {current {}}\fR
Generate a SELECT form element and nested OPTION tags.
The \fIname\fP and \fIparam\fP are used to generate the
SELECT tag.  The \fIchoice\fP list is a Tcl-style 
name, value
list.

.TP
\fBhtml::selectPlain\fR \fIname param choices {current {}}\fR
Like \fBhtml::select\fP except that \fIchoices\fP is a Tcl list
of values used for the OPTION tags.  The label and the value for
each OPTION are the same.
.TP
\fBhtml::submit\fR \fIlabel {name submit}\fR
Generate an INPUT tag of type SUBMIT.

.TP
\fBhtml::set\fR \fIvar val\fR
This procedure is similar to the built-in Tcl \fBset\fR command.  The
main difference is that it returns "" so it can be called from an HTML
template file without appending unwanted results.  The other
difference is that it must take two arguments.

.TP
\fBhtml::tableFromArray\fR \fIarrname {param {}} {pat *}\fR
Generate a TABLE and nested rows to display a Tcl array.
The \fIparam\fP are for the TABLE tag.
The \fIpat\fP is a string match pattern used to select
array elements.

.TP
\fBhtml::tableFromList\fR \fIquerylist {param {}}\fR
Generate a TABLE and nested rows to display \fIquerylist\fP,
which is a Tcl-style name, value list.
The \fIparam\fP are for the TABLE tag.

.TP
\fBhtml::textarea\fR \fIname {param {}} {current {}}\fR
Generate a TEXTAREA tag wrapped around its current values.

.TP
\fBhtml::textInput\fR \fIname args\fR
Generate an INPUT form tag with type TEXT.
This uses
\fBhtml::formValue\fP.
The args is any additional tag attributes you want
to put into the INPUT tag.

.TP
\fBhtml::textInputRow\fR \fIlabel name args\fR
Generate an INPUT form tag with type TEXT formatted into
a table row with an associated label.
The args is any additional tag attributes you want
to put into the INPUT tag.

.TP
\fBhtml::title\fR \fItitle\fR
\fISide effect only\fP.  Call this before \fBhtml::head\fR to define 
the TITLE for a page.

.TP
\fBhtml::varEmpty\fR \fIname\fR
This returns 1 if the named variable either does not exist or
has the empty string for its value.

.TP
\fBhtml::while\fR \fItest body\fR
This procedure is similar to the built-in Tcl \fBwhile\fR control
structure.  Rather than evaluating the body, it returns the subst'ed
\fIbody\fR.  Each iteration of the loop causes another string to be
concatenated to the result value.

.SH "SEE ALSO"
ncgi

.SH KEYWORDS
html, form, table, checkbox, radiobutton, checkbutton
