[manpage_begin textutil n 0.5]
[moddesc   {Texts and strings utils}]
[titledesc {Procedures to manipulate texts and strings.}]
[require Tcl 8.2]
[require textutil [opt 0.5]]
[description]

The [strong textutil] package provides commands that manipulate
strings or texts (a.k.a. long strings or string with embedded newlines
or paragraphs).

[para]

The complete set of procedures is described below.

[list_begin definitions]

[call [cmd textutil::adjust] [arg "string args"]]

Do a justification on the [arg string] according to [arg args].  The
string is taken as one big paragraph, ignoring any newlines.  Then the
line is formatted according to the options used, and the command
return a new string with enough lines to contain all the printable
chars in the input string. A line is a set of chars between the
beginning of the string and a newline, or between 2 newlines, or
between a newline and the end of the string. If the input string is
small enough, the returned string won't contain any newlines.

[nl]

By default, any occurrence of spaces characters or tabulation are
replaced by a single space so each word in a line is separated from
the next one by exactly one space char, and this forms a [emph real]
line. Each [emph real] line is placed in a [emph logical] line, which
have exactly a given length (see [arg -length] option below). The
[emph real] line may have a lesser length. Again by default, any
trailing spaces are ignored before returning the string (see

[arg -full] option below). The following options may be used after the
[arg string] parameter, and change the way the command place a

[emph real] line in a [emph logical] line.


[list_begin definitions]

[lst_item "-full [arg boolean]"]

If set to [strong false], any trailing space chars are deleted before
returning the string. If set to [strong true], any trailing space
chars are left in the string. Default to [strong false].


[lst_item "-justify ([strong center|left|plain|right])"]

Set the justification of the returned string to [strong center],
[strong left], [strong plain] or [strong right]. By default, it is set
to [strong left].  The justification means that any line in the
returned string but the last one is build according to the value. If
the justification is set to [strong plain] and the number of printable
chars in the last line is less than 90% of the length of a line (see
[arg -length]), then this line is justified with the [strong left]
value, avoiding the expansion of this line when it is too small. The
meaning of each value is:

[list_begin definitions]

[lst_item [strong center]]

The real line is centered in the logical line. If needed, a set of
space char are added at the beginning (half of the needed set) and at
the end (half of the needed set) of the line if required (see the
option [arg -full]).

[lst_item [strong left]]

The real line is set on the left of the logical line. It means that
there are no space chars at the beginning of this line. If required,
all needed space chars are added at the end of the line (see the
option [arg -full]).

[lst_item [strong plain]]

The real line is exactly set in the logical line. It means that there
are no leading or trailing space chars. All the needed space chars are
added in the [emph real] line, between 2 (or more) words.

[lst_item [strong right]]

The real line is set on the right of the logical line. It means that
there are no space chars at the end of this line, and there may be
some space chars at the beginning, despite of the [arg -full] option.

[list_end]

[lst_item "-length [arg integer]"]

Set the length of the [emph logical] line in the string to

[arg integer].  [arg integer] must be a positive integer
value. Defaults to [emph 72].


[lst_item "-strictlength [arg boolean]"]

If set to [strong false], a line can exceed the specified

[arg -length] if a single word is longer than [arg -length]. If set to
[strong true], words that are longer than [arg -length] are split so
that no line exceeds the specified [arg -length]. Defaults to

[strong false].

[list_end]


[call [cmd textutil::splitx] [arg string] [opt [arg regexp]]]

Split the [arg string] and return a list. The string is split
according to the regular expression [arg regexp] instead of a simple
list of chars. Note that if you add parenthesis into the [arg regexp],
the parentheses part of separator would be added into list as
additional element. If the [arg string] is empty the result is the
empty list, like for [cmd split]. If [arg regexp] is empty the

[arg string] is split at every character, like [cmd split] does.

The regular expression [arg regexp] defaults to "[lb]\\t \\r\\n[rb]+".


[call [cmd textutil::tabify] [arg string] [opt [arg num]]]]

Tabify the [arg string] by replacing any substring of [arg num] space
chars by a tabulation and return the result as a new string. [arg num]
defaults to 8.


[call [cmd textutil::tabify2] [arg string] [opt [arg num]]]]

Similar to [cmd textutil::tabify] this command tabifies the

[arg string] and returns the result as a new string. A different
algorithm is used however. Instead of replacing any substring of

[arg num] spaces this comand works more like an editor. [arg num]
defaults to 8.

[nl]

Each line of the text in [arg string] is treated as if there are
tabstops every [arg num] columns. Only sequences of space characters
containing more than one space character and found immediately before
a tabstop are replaced with tabs.


[call [cmd textutil::trim] [arg string] [opt [arg regexp]]]]

Remove in [arg string] any leading and trailing substring according to
the regular expression [arg regexp] and return the result as a new
string.  This apply on any [emph line] in the string, that is any
substring between 2 newline chars, or between the beginning of the
string and a newline, or between a newline and the end of the string,
or, if the string contain no newline, between the beginning and the
end of the string.

The regular expression [arg regexp] defaults to "[lb] \\t[rb]+".


[call [cmd textutil::trimleft] [arg string] [opt [arg regexp]]]]

Remove in [arg string] any leading substring according to the regular
expression [arg regexp] and return the result as a new string. This
apply on any [emph line] in the string, that is any substring between
2 newline chars, or between the beginning of the string and a newline,
or between a newline and the end of the string, or, if the string
contain no newline, between the beginning and the end of the string.

The regular expression [arg regexp] defaults to "[lb] \\t[rb]+".

[call [cmd textutil::trimright] [arg string] [opt [arg regexp]]]]

Remove in [arg string] any trailing substring according to the regular
expression [arg regexp] and return the result as a new string. This
apply on any [emph line] in the string, that is any substring between
2 newline chars, or between the beginning of the string and a newline,
or between a newline and the end of the string, or, if the string
contain no newline, between the beginning and the end of the string.

The regular expression [arg regexp] defaults to "[lb] \\t[rb]+".


[call [cmd textutil::untabify] [arg string] [opt [arg num]]]]

Untabify the [arg string] by replacing any tabulation char by a
substring of [arg num] space chars and return the result as a new
string. [arg num] defaults to 8.


[call [cmd textutil::untabify2] [arg string] [opt [arg num]]]]

Untabify the [arg string] by replacing any tabulation char by a
substring of at most [arg num] space chars and return the result as a
new string. Unlike [cmd textutil::untabify] each tab is not replaced
by a fixed number of space characters.  The command overlays each line
in the [arg string] with tabstops every [arg num] columns instead and
replaces tabs with just enough space characters to reach the next
tabstop. This is the complement of the actions taken by

[cmd textutil::tabify2]. [arg num] defaults to 8.

[nl]

There is one asymmetry though: A tab can be replaced with a single
space, but not the other way around.


[call [cmd textutil::strRepeat] [arg "text num"]]

The implementation depends on the core executing the package. Used
[cmd "string repeat"] if it is present, or a fast tcl implementation
if it is not. Returns a string containing the [arg text] repeated

[arg num] times. The repetitions are joined without characters between
them. A value of [arg num] <= 0 causes the command to return an empty
string.

[list_end]


[see_also regexp(n) split(n) string(n)]
[keywords string {regular expression}]
[manpage_end]
