#ifndef GTOOLKIT_GTKCLIST_H
#define GTOOLKIT_GTKCLIST_H

#include <GToolKit/GTKContainer.h>
#include <gtk/gtkclist.h>

@interface GTKCList : GTKContainer
+ (guint) getType;
- (void) construct:(gint) columns titles:(NSArray  *) titles;
+ cListWithColumns:(gint) columns;
- initWithColumns:(gint) columns;
+ cListWithTitles:(gint) columns titles:(NSArray  *) titles;
- initWithTitles:(gint) columns titles:(NSArray  *) titles;
- (void) setBorder:(GtkShadowType) border;
- (void) setSelectionMode:(GtkSelectionMode) mode;
- (void) setPolicy:(GtkPolicyType) vscrollbar_policy hscrollbarPolicy:(GtkPolicyType) hscrollbar_policy;
- (void) freeze;
- (void) thaw;
- (void) columnTitlesShow;
- (void) columnTitlesHide;
- (void) columnTitleActive:(gint) column;
- (void) columnTitlePassive:(gint) column;
- (void) columnTitlesActive;
- (void) columnTitlesPassive;
- (void) setColumnTitle:(gint) column title:(NSString *) title;
- (void) setColumnWidget:(gint) column widget:(GTKWidget *) widget;
- (void) setColumnJustification:(gint) column justification:(GtkJustification) justification;
- (void) setColumnWidth:(gint) column width:(gint) width;
- (void) setRowHeight:(gint) height;
- (void) moveto:(gint) row column:(gint) column rowAlign:(gfloat) row_align colAlign:(gfloat) col_align;
- (GtkVisibility) rowIsVisible:(gint) row;
- (GtkCellType) getCellType:(gint) row column:(gint) column;
- (void) setText:(gint) row column:(gint) column text:(NSString *) text;
- (gint) getText:(gint) row column:(gint) column text:(NSString **) text;
- (void) setPixmap:(gint) row column:(gint) column pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask;
- (gint) getPixmap:(gint) row column:(gint) column pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask;
- (void) setPixtext:(gint) row column:(gint) column text:(NSString *) text spacing:(guint8) spacing pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask;
- (gint) getPixtext:(gint) row column:(gint) column text:(NSString **) text spacing:(guint8 *) spacing pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask;
- (void) setForeground:(gint) row color:(GdkColor *) color;
- (void) setBackground:(gint) row color:(GdkColor *) color;
- (void) setShift:(gint) row column:(gint) column vertical:(gint) vertical horizontal:(gint) horizontal;
- (gint) append:(NSArray  *) text;
- (void) insert:(gint) row text:(NSArray  *) text;
- (void) remove:(gint) row;
- (void) setRowData:(gint) row data:(gpointer) data;
- (void) setRowDataFull:(gint) row data:(gpointer) data destroy:(GtkDestroyNotify) destroy;
- (gpointer) getRowData:(gint) row;
- (gint) findRowFromData:(gpointer) data;
- (void) selectRow:(gint) row column:(gint) column;
- (void) unselectRow:(gint) row column:(gint) column;
- (void) clear;
- (gint) getSelectionInfo:(gint) x y:(gint) y row:(gint *) row column:(gint *) column;
@end

#endif
