#ifndef GTOOLKIT_GTKLIST_H
#define GTOOLKIT_GTKLIST_H

#include <GToolKit/GTKContainer.h>
#include <gtk/gtklist.h>

@interface GTKList : GTKContainer
+ (GtkType) getType;
+ list;
- init;
- (void) insertItems:(NSArray *) items position:(gint) position;
- (void) appendItems:(NSArray *) items;
- (void) prependItems:(NSArray *) items;
- (void) removeItems:(NSArray *) items;
- (void) removeItemsNoUnref:(NSArray *) items;
- (void) clearItems:(gint) start end:(gint) end;
- (void) selectItem:(gint) item;
- (void) unselectItem:(gint) item;
- (void) selectChild:(GTKWidget *) child;
- (void) unselectChild:(GTKWidget *) child;
- (gint) childPosition:(GTKWidget *) child;
- (void) setSelectionMode:(GtkSelectionMode) mode;
- (NSArray *) selection;
@end

#endif
