/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998  Elmar Ludwig - Universitaet Osnabrueck
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef GTOOLKIT_GTKACTION_H
#define GTOOLKIT_GTKACTION_H

#include <Foundation/NSObject.h>
#include <gtk/gtktypeutils.h>

/*
 * The GTKAction class manages connections between objects.
 * Instances of this class can be passed as arguments to @GTK's
 * @GTK#-connectSignal:withAction: methods.
 */
@interface GTKAction : NSObject
{
    id target;		// target object of this action
    SEL selector;	// target selector to perform
    IMP method;		// target function pointer
    void *data;		// optional user data
}

/* creating actions */
+ actionWithTarget:target selector:(SEL) selector;
+ actionWithTarget:target selector:(SEL) selector data:(const void *) data;
- initWithTarget:target selector:(SEL) selector;
- initWithTarget:target selector:(SEL) selector data:(const void *) data;
- (void) setTarget:target selector:(SEL) selector;
- (void) setData:(const void *) data;

/* inspecting action values */
- target;
- (SEL) selector;
- (void *) data;

/* invoking an action */
- (void) performWithSender:sender args:(GtkArg *) args count:(unsigned) count;
@end

#endif
