/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1999  Elmar Ludwig - Universitaet Osnabrueck
 *
 * Generated automatically from gtkclist.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 */
#ifndef GTOOLKIT_GTKCLIST_H
#define GTOOLKIT_GTKCLIST_H

#include <GToolKit/GTKContainer.h>
#include <gtk/gtkclist.h>

@interface GTKCList : GTKContainer
+ (GtkType) getType;
- (void) construct:(gint) columns titles:(NSArray  *) titles;
+ cListWithColumns:(gint) columns;
- initWithColumns:(gint) columns;
+ cListWithTitles:(gint) columns titles:(NSArray  *) titles;
- initWithTitles:(gint) columns titles:(NSArray  *) titles;
- (void) setHadjustment:(GTKAdjustment *) adjustment;
- (void) setVadjustment:(GTKAdjustment *) adjustment;
- (GTKAdjustment*) getHadjustment;
- (GTKAdjustment*) getVadjustment;
- (void) setShadowType:(GtkShadowType) type;
- (void) setSelectionMode:(GtkSelectionMode) mode;
- (void) setReorderable:(gboolean) reorderable;
- (void) setUseDragIcons:(gboolean) use_icons;
- (void) setButtonActions:(guint) button buttonActions:(guint8) button_actions;
- (void) freeze;
- (void) thaw;
- (void) columnTitlesShow;
- (void) columnTitlesHide;
- (void) columnTitleActive:(gint) column;
- (void) columnTitlePassive:(gint) column;
- (void) columnTitlesActive;
- (void) columnTitlesPassive;
- (void) setColumn:(gint) column title:(const NSString *) title;
- (NSString *) getColumnTitle:(gint) column;
- (void) setColumn:(gint) column widget:(GTKWidget *) widget;
- (GTKWidget *) getColumnWidget:(gint) column;
- (void) setColumn:(gint) column justification:(GtkJustification) justification;
- (void) setColumnVisibility:(gint) column visible:(gboolean) visible;
- (void) setColumn:(gint) column resizeable:(gboolean) resizeable;
- (void) setColumn:(gint) column autoResize:(gboolean) auto_resize;
- (gint) columnsAutosize;
- (gint) optimalColumnWidth:(gint) column;
- (void) setColumn:(gint) column width:(gint) width;
- (void) setColumn:(gint) column minWidth:(gint) min_width;
- (void) setColumn:(gint) column maxWidth:(gint) max_width;
- (void) setRowHeight:(guint) height;
- (void) moveto:(gint) row column:(gint) column rowAlign:(gfloat) row_align colAlign:(gfloat) col_align;
- (GtkVisibility) rowIsVisible:(gint) row;
- (GtkCellType) getCellType:(gint) row column:(gint) column;
- (void) setText:(gint) row column:(gint) column text:(const NSString *) text;
- (gint) getText:(gint) row column:(gint) column text:(NSString **) text;
- (void) setPixmap:(gint) row column:(gint) column pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask;
- (gint) getPixmap:(gint) row column:(gint) column pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask;
- (void) setPixtext:(gint) row column:(gint) column text:(const NSString *) text spacing:(guint8) spacing pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask;
- (gint) getPixtext:(gint) row column:(gint) column text:(NSString **) text spacing:(guint8 *) spacing pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask;
- (void) setForeground:(gint) row color:(GdkColor *) color;
- (void) setBackground:(gint) row color:(GdkColor *) color;
- (void) setCellStyle:(gint) row column:(gint) column style:(GTKStyle *) style;
- (GTKStyle *) getCellStyle:(gint) row column:(gint) column;
- (void) setRow:(gint) row style:(GTKStyle *) style;
- (GTKStyle *) getRowStyle:(gint) row;
- (void) setShift:(gint) row column:(gint) column vertical:(gint) vertical horizontal:(gint) horizontal;
- (void) setSelectable:(gint) row selectable:(gboolean) selectable;
- (gboolean) getSelectable:(gint) row;
- (gint) prepend:(NSArray  *) text;
- (gint) append:(NSArray  *) text;
- (gint) insert:(gint) row text:(NSArray  *) text;
- (void) remove:(gint) row;
- (void) setRow:(gint) row data:(gpointer) data;
- (void) setRowDataFull:(gint) row data:(gpointer) data destroy:(GtkDestroyNotify) destroy;
- (gpointer) getRowData:(gint) row;
- (gint) findRowFromData:(gpointer) data;
- (void) selectRow:(gint) row column:(gint) column;
- (void) unselectRow:(gint) row column:(gint) column;
- (void) undoSelection;
- (void) clear;
- (gint) getSelectionInfo:(gint) x y:(gint) y row:(gint *) row column:(gint *) column;
- (void) selectAll;
- (void) unselectAll;
- (void) swapRows:(gint) row1 row2:(gint) row2;
- (void) rowMove:(gint) source_row destRow:(gint) dest_row;
- (void) setCompareFunc:(GtkCListCompareFunc) cmp_func;
- (void) setSortColumn:(gint) column;
- (void) setSortType:(GtkSortType) sort_type;
- (void) sort;
- (void) setAutoSort:(gboolean) auto_sort;
@end

#endif
