/* LocaleInformation_ta.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_ta extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "";

  private static final String currenciesDisplayNameValues = "";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "INR";

  private static final String currenciesSymbolValues = "\u0bb0\u0bc2";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "\u0b9c\u0ba9.",
    "\u0baa\u0bbf\u0baa\u0bcd.",
    "\u0bae\u0bbe\u0bb0\u0bcd.",
    "\u0b8f\u0baa\u0bcd.",
    "\u0bae\u0bc7",
    "\u0b9c\u0bc2\u0ba9\u0bcd",
    "\u0b9c\u0bc2\u0bb2\u0bc8",
    "\u0b86\u0b95.",
    "\u0b9a\u0bc6\u0baa\u0bcd.",
    "\u0b85\u0b95\u0bcd.",
    "\u0ba8\u0bb5.",
    "\u0b9f\u0bbf\u0b9a.",
    null,
  };

  private static final String[] months = {
    "\u0b9c\u0ba9\u0bb5\u0bb0\u0bbf",
    "\u0baa\u0bbf\u0baa\u0bcd\u0bb0\u0bb5\u0bb0\u0bbf",
    "\u0bae\u0bbe\u0bb0\u0bcd\u0b9a\u0bcd",
    "\u0b8f\u0baa\u0bcd\u0bb0\u0bb2\u0bcd",
    "\u0bae\u0bc7",
    "\u0b9c\u0bc2\u0ba9\u0bcd",
    "\u0b9c\u0bc2\u0bb2\u0bc8",
    "\u0b86\u0b95\u0bb8\u0bcd\u0b9f\u0bcd",
    "\u0b9a\u0bc6\u0baa\u0bcd\u0b9f\u0bae\u0bcd\u0baa\u0bb0\u0bcd",
    "\u0b85\u0b95\u0bcd\u0b9f\u0bcb\u0baa\u0bb0\u0bcd",
    "\u0ba8\u0bb5\u0bae\u0bcd\u0baa\u0bb0\u0bcd",
    "\u0b9f\u0bbf\u0b9a\u0bae\u0bcd\u0baa\u0bb0\u0bcd",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u0b9e\u0bbe",
    "\u0ba4\u0bbf",
    "\u0b9a\u0bc6",
    "\u0baa\u0bc1",
    "\u0bb5\u0bbf",
    "\u0bb5\u0bc6",
    "\u0b9a",
  };

  private static final String[] weekdays = {
    null,
    "\u0b9e\u0bbe\u0baf\u0bbf\u0bb1\u0bc1",
    "\u0ba4\u0bbf\u0b99\u0bcd\u0b95\u0bb3\u0bcd",
    "\u0b9a\u0bc6\u0bb5\u0bcd\u0bb5\u0bbe\u0baf\u0bcd",
    "\u0baa\u0bc1\u0ba4\u0ba9\u0bcd",
    "\u0bb5\u0bbf\u0baf\u0bbe\u0bb4\u0ba9\u0bcd",
    "\u0bb5\u0bc6\u0bb3\u0bcd\u0bb3\u0bbf",
    "\u0b9a\u0ba9\u0bbf",
  };

  private static final String[] eras = {
    "\u0b95\u0bbf\u0bae\u0bc1",
    "\u0b95\u0bbf\u0baa\u0bbf",
  };

  private static final String[] ampms = {
    "\u0b95\u0bbe\u0bb2\u0bc8",
    "\u0bae\u0bbe\u0bb2\u0bc8",
  };

  private static final String[][] zoneStrings =
  {
    { "IST", "\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0baa\u0bcd\u0baa\u0b9f\u0bbf", "IST", "\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0baa\u0bcd\u0baa\u0b9f\u0bbf",  "Asia/Calcutta" },
  };

  private static final String territoriesKeys = "TJ|TH|GY|TD|GW|GT|GR|GQ|SY|GN|GM|SV|GH|SR|GE|GD|SM|GB|GA|SK|SI|SG|SE|SB|SA|FR|RU|FJ|FI|RO|ET|ES|EG|EE|EC|DZ|QA|DO|PY|DM|DK|DJ|PT|DE|PL|PK|PH|PG|CZ|PE|CY|CV|PA|CU|CR|CO|CN|CM|CL|CI|CH|CG|CF|OM|CA|BZ|BY|BW|BT|BS|BR|NZ|BO|BN|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|AZ|AU|NA|AT|AR|AO|MY|MX|AM|MW|AL|MV|ZA|MT|AG|AF|AE|AD|MN|MM|ML|MK|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LB|LA|KZ|KW|KR|KP|KM|KI|WS|KH|KG|KE|JP|JO|JM|VU|VN|VE|VA|IT|IS|IR|IQ|UZ|UY|IN|IL|US|IE|ID|UA|HU|HT|HR|HN|TW|TV|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u0ba4\u0bbe\u0b9c\u0bbf\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd|\u0ba4\u0bbe\u0baf\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1|\u0b95\u0baf\u0bbe\u0ba9\u0bbe|\u0b9a\u0bbe\u0b9f\u0bcd|\u0b95\u0bbf\u0ba9\u0bbf-\u0baa\u0bbf\u0bb8\u0bcd\u0bb8\u0bbe\u0bb5\u0bcd|\u0b95\u0bc1\u0bb5\u0bbe\u0ba4\u0bcd\u0ba4\u0bbe\u0bae\u0bbe\u0bb2\u0bbe|\u0b95\u0bbf\u0bb0\u0bc0\u0bb8\u0bcd|\u0b88\u0b95\u0bcd\u0b95\u0bc1\u0bb5\u0bbf\u0b9f\u0bcb\u0bb0\u0bbf\u0baf\u0bb2\u0bcd \u0b95\u0bbf\u0ba9\u0bbf|\u0b9a\u0bbf\u0bb0\u0bbf\u0baf\u0bbe|\u0b95\u0bbf\u0ba9\u0bbf|\u0b95\u0bbe\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe|\u0b8e\u0bb2\u0bcd \u0b9a\u0bbe\u0bb2\u0bcd\u0bb5\u0b9f\u0bbe\u0bb0\u0bcd|\u0b95\u0bbe\u0ba9\u0bbe|\u0b9a\u0bc2\u0bb0\u0bbf\u0ba9\u0bbe\u0bae\u0bcd|\u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe|\u0b95\u0bbf\u0bb0\u0ba9\u0bc6\u0b9f\u0bbe|\u0b9a\u0bbe\u0ba9\u0bcd\u0bae\u0bc6\u0bb0\u0bbf\u0ba9\u0bcb|\u0baa\u0bbf\u0bb0\u0bbf\u0b9f\u0bbf\u0bb7\u0bcd \u0b95\u0bc2\u0b9f\u0bcd\u0b9f\u0bb0\u0b9a\u0bc1|\u0b95\u0bbe\u0baa\u0bcb\u0ba9\u0bcd|\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bbe\u0b95\u0bbf\u0baf\u0bbe|\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bc7\u0ba9\u0bbf\u0baf\u0bbe|\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd|\u0bb8\u0bcd\u0bb5\u0bc0\u0b9f\u0ba9\u0bcd|\u0b9a\u0bbe\u0bb2\u0bae\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd|\u0b9a\u0bb5\u0bc2\u0ba4\u0bbf \u0b85\u0bb0\u0bc7\u0baa\u0bbf\u0baf\u0bbe|\u0baa\u0bbf\u0bb0\u0bbe\u0ba9\u0bcd\u0bb8\u0bcd|\u0bb0\u0bb7\u0bcd\u0baf\u0bbe|\u0baa\u0bbf\u0b9c\u0bbf|\u0baa\u0bbf\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1|\u0bb0\u0bc1\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0bbe|\u0b8e\u0ba4\u0bbf\u0baf\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf\u0bbe|\u0bb8\u0bcd\u0baa\u0bc6\u0baf\u0bbf\u0ba9\u0bcd|\u0b8e\u0b95\u0bbf\u0baa\u0bcd\u0ba4\u0bc1|\u0b8e\u0bb8\u0bcd\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe|\u0b88\u0b95\u0bcd\u0bb5\u0b9f\u0bbe\u0bb0\u0bcd|\u0b85\u0bb2\u0bcd\u0b9c\u0bc0\u0bb0\u0bbf\u0baf\u0bbe|\u0b95\u0bbe\u0b9f\u0bbe\u0bb0\u0bcd|\u0b9f\u0bca\u0bae\u0bbf\u0ba9\u0bbf\u0b95\u0ba9\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1|\u0baa\u0bbe\u0bb0\u0b95\u0bc1\u0bb5\u0bc7|\u0b9f\u0bca\u0bae\u0bbf\u0ba9\u0bbf\u0b95\u0bbe|\u0b9f\u0bc6\u0ba9\u0bcd\u0bae\u0bbe\u0bb0\u0bcd\u0b95\u0bcd|\u0b9c\u0bbf\u0baa\u0bcc\u0b9f\u0bbf|\u0baa\u0bcb\u0bb0\u0bcd\u0b9a\u0bcd\u0b9a\u0bc1\u0b95\u0bcd\u0b95\u0bb2\u0bcd|\u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd|\u0baa\u0bcb\u0bb2\u0ba8\u0bcd\u0ba4\u0bc1|\u0baa\u0bbe\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd|\u0baa\u0bbf\u0bb2\u0bbf\u0baa\u0bcd\u0baa\u0bc8\u0ba9\u0bcd\u0bb8\u0bcd|\u0baa\u0bbe\u0baa\u0bcd\u0baa\u0bc1\u0bb5\u0bbe-\u0ba8\u0bbf\u0baf\u0bc2\u0b95\u0bbf\u0ba9\u0bbf|\u0b9a\u0bc6\u0b95\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1|\u0baa\u0bc6\u0bb0\u0bc1|\u0b9a\u0bc8\u0baa\u0bcd\u0bb0\u0bb8\u0bcd|\u0b95\u0bc7\u0baa\u0bcd \u0bb5\u0bc6\u0bb0\u0bcd\u0b9f\u0bc7|\u0baa\u0ba3\u0bbe\u0bae\u0bbe|\u0b95\u0bbf\u0baf\u0bc2\u0baa\u0bbe|\u0b95\u0bcb\u0bb8\u0bcd\u0b9f\u0bbe\u0bb0\u0bbf\u0b95\u0bbe|\u0b95\u0bca\u0bb2\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe|\u0b9a\u0bc0\u0ba9|\u0b95\u0bc7\u0bae\u0bb0\u0bc2\u0ba9\u0bcd|\u0b9a\u0bbf\u0bb2\u0bbf|\u0b90\u0bb5\u0bb0\u0bbf \u0b95\u0bcb\u0bb8\u0bcd\u0b9f\u0bcd|\u0bb8\u0bcd\u0bb5\u0bbf\u0b9f\u0bcd\u0b9a\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1|\u0b95\u0bbe\u0b99\u0bcd\u0b95\u0bcb|\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0b95\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1|\u0b93\u0bae\u0bbe\u0ba9\u0bcd|\u0b95\u0ba9\u0b9f\u0bbe|\u0baa\u0bc6\u0bb2\u0bbf\u0bb8\u0bcd|\u0baa\u0bc6\u0bb2\u0bbe\u0bb0\u0bc2\u0bb8\u0bcd|\u0baa\u0bcb\u0b9f\u0bcd\u0bb8\u0bcd\u0bb5\u0bbe\u0ba9\u0bbe|\u0baa\u0bc2\u0b9f\u0bbe\u0ba9\u0bcd|\u0baa\u0bb9\u0bbe\u0bae\u0bbe\u0bb8\u0bcd|\u0baa\u0bbf\u0bb0\u0bc7\u0bb8\u0bbf\u0bb2\u0bcd|\u0ba8\u0bbf\u0baf\u0bc2\u0b9a\u0bbf\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1|\u0baa\u0bca\u0bb2\u0bbf\u0bb5\u0bbf\u0baf\u0bbe|\u0baa\u0bc1\u0bb0\u0bc2\u0ba9\u0bc7\u0baf\u0bcd|\u0baa\u0bc6\u0ba9\u0bbf\u0ba9\u0bcd|\u0baa\u0bc1\u0bb0\u0bc1\u0ba3\u0bcd\u0b9f\u0bbf|\u0baa\u0bb9\u0bcd\u0bb0\u0bc8\u0ba9\u0bcd|\u0ba8\u0bcc\u0bb0\u0bc1|\u0baa\u0bb2\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0bbe|\u0baa\u0bb0\u0bcd\u0b95\u0bbf\u0ba9\u0bcb \u0baa\u0bbe\u0bb8\u0bcb|\u0ba8\u0bc7\u0baa\u0bbe\u0bb3\u0bae\u0bcd|\u0baa\u0bc6\u0bb2\u0bcd\u0b9c\u0bbf\u0baf\u0bae\u0bcd|\u0ba8\u0bbe\u0bb0\u0bcd\u0bb5\u0bc7|\u0baa\u0b99\u0bcd\u0b95\u0bb3\u0bbe\u0ba4\u0bc7\u0bb7\u0bcd|\u0baa\u0bbe\u0bb0\u0bcd\u0baa\u0b9f\u0bcb\u0bb8\u0bcd|\u0b9c\u0bbf\u0bae\u0bcd\u0baa\u0bbe\u0baa\u0bcd\u0bb5\u0bc7|\u0ba8\u0bc6\u0ba4\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1|\u0baa\u0bcb\u0bb8\u0bcd\u0ba9\u0bbf\u0baf\u0bbe \u0bb9\u0bc6\u0bb0\u0bcd\u0bb8\u0bbf\u0b95\u0bcb\u0bb5\u0bbf\u0ba9\u0bbe|\u0ba8\u0bbf\u0b95\u0bbe\u0bb0\u0bbe\u0b95\u0bc1\u0bb5\u0bbe|\u0b85\u0b9c\u0bb0\u0bcd\u0baa\u0bc8\u0b9c\u0bbe\u0ba9\u0bcd|\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0bbe|\u0ba9\u0bbe\u0bae\u0bc0\u0baa\u0bbf\u0baf\u0bbe|\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bbf\u0baf\u0bbe|\u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba3\u0bcd\u0b9f\u0bbf\u0ba9\u0bbe|\u0b85\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbe|\u0bae\u0bb2\u0bc7\u0bb7\u0bbf\u0baf\u0bbe|\u0bae\u0bc6\u0b95\u0bcd\u0b9a\u0bbf\u0b95\u0bcb|\u0b86\u0bb0\u0bcd\u0bae\u0bc0\u0ba9\u0bbf\u0baf\u0bbe|\u0bae\u0bb2\u0bbe\u0bb5\u0bc0|\u0b85\u0bb2\u0bcd\u0baa\u0bc7\u0ba9\u0bbf\u0baf\u0bbe|\u0bae\u0bbe\u0bb2\u0ba4\u0bcd\u0ba4\u0bc0\u0bb5\u0bc1|\u0ba4\u0bc6\u0ba9\u0bcd \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe|\u0bae\u0bbe\u0bb2\u0bcd\u0b9f\u0bbe|\u0b86\u0ba9\u0bcd\u0b9f\u0bbf\u0b95\u0bc1\u0bb5\u0bbe \u0baa\u0bbe\u0bb0\u0bcd\u0baa\u0bc1\u0b9f\u0bbe|\u0b86\u0baa\u0bcd\u0b95\u0bbe\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd|\u0b90\u0b95\u0bcd\u0b95\u0bbf\u0baf \u0b85\u0bb0\u0baa\u0bc1 \u0b95\u0bc2\u0b9f\u0bcd\u0b9f\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf|\u0b85\u0ba9\u0bcd\u0b9f\u0bcb\u0bb0\u0bbe|\u0bae\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbf\u0baf\u0bbe|\u0bae\u0bbf\u0baf\u0bbe\u0ba9\u0bcd\u0bae\u0bbe\u0bb0\u0bcd|\u0bae\u0bbe\u0bb2\u0bc0|\u0bae\u0b9a\u0bc6\u0b9f\u0bcb\u0ba3\u0bbf\u0baf\u0bbe|\u0bae\u0bbe\u0bb2\u0bcd\u0b9f\u0bcb\u0bb5\u0bbe|\u0bae\u0bca\u0ba9\u0bbe\u0b95\u0bcd\u0b95\u0bcb|\u0bae\u0bca\u0bb0\u0bcb\u0b95\u0bcd\u0b95\u0bcb|\u0baf\u0bc7\u0bae\u0ba9\u0bcd|\u0bb2\u0bbf\u0baa\u0bcd\u0baf\u0bbe|\u0bb2\u0bbe\u0b9f\u0bcd\u0bb5\u0bbf\u0baf\u0bbe|\u0bb2\u0b95\u0bcd\u0bb8\u0bcd\u0b9a\u0bae\u0bcd\u0baa\u0bb0\u0bcd\u0b95\u0bcd|\u0bb2\u0bbf\u0ba4\u0bc1\u0bb5\u0bc7\u0ba9\u0bbf\u0baf\u0bbe|\u0bb2\u0bc6\u0b9a\u0bcb\u0ba4\u0bcb|\u0bb2\u0bc8\u0baa\u0bc0\u0bb0\u0bbf\u0baf\u0bbe|\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8|\u0bb2\u0bbf\u0b9a\u0bcd\u0b9f\u0bc6\u0ba3\u0bcd\u0bb8\u0bcd\u0b9f\u0bc0\u0ba9\u0bcd|\u0bb2\u0bc6\u0baa\u0ba9\u0bbe\u0ba9\u0bcd|\u0bb2\u0bbe\u0bb5\u0bcb\u0bb8\u0bcd|\u0b95\u0b9c\u0b95\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd|\u0b95\u0bc1\u0bb5\u0bc8\u0ba4\u0bcd\u0ba4\u0bc1|\u0ba4\u0bc6\u0ba9\u0bcd \u0b95\u0bca\u0bb0\u0bbf\u0baf\u0bbe|\u0bb5\u0b9f \u0b95\u0bca\u0bb0\u0bbf\u0baf\u0bbe|\u0b95\u0bcb\u0bae\u0bb0\u0bcb\u0bb8\u0bcd|\u0b95\u0bbf\u0bb0\u0bbf\u0baa\u0b9f\u0bbf|\u0b9a\u0bae\u0bcb\u0bb5\u0bbe|\u0b95\u0bae\u0bcd\u0baa\u0bcb\u0b9f\u0bbf\u0baf\u0bbe|\u0b95\u0bbf\u0bb0\u0bcd\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd|\u0b95\u0bc6\u0ba9\u0bcd\u0baf\u0bbe|\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bcd|\u0b9c\u0bca\u0bb0\u0bcd\u0b9f\u0bbe\u0ba9\u0bcd|\u0b9c\u0bae\u0bbe\u0baf\u0bcd\u0b95\u0bcd\u0b95\u0bbe|\u0bb5\u0ba9\u0bc1\u0bb5\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1|\u0bb5\u0bbf\u0baf\u0b9f\u0bcd\u0ba8\u0bbe\u0bae\u0bcd|\u0bb5\u0bc6\u0ba9\u0b9c\u0bc1\u0bb5\u0bc7\u0bb2\u0bbe|\u0bb5\u0bbe\u0b9f\u0bbf\u0b95\u0ba9\u0bcd|\u0b87\u0ba4\u0bcd\u0ba4\u0bbe\u0bb2\u0bbf|\u0b90\u0bb8\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1|\u0b88\u0bb0\u0bbe\u0ba9\u0bcd|\u0b87\u0bb0\u0bbe\u0b95\u0bcd|\u0b89\u0bb8\u0bcd\u0baa\u0bc6\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd|\u0b89\u0bb0\u0bc1\u0b95\u0bc1\u0bb5\u0bc7|\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe|\u0b87\u0bb8\u0bcd\u0bb0\u0bc7\u0bb2\u0bcd|\u0b90\u0b95\u0bcd\u0b95\u0bbf\u0baf \u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1|\u0b85\u0baf\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1|\u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0bbe|\u0b89\u0b95\u0bcd\u0bb0\u0bc8\u0ba9\u0bcd|\u0bb9\u0b99\u0bcd\u0b95\u0bc7\u0bb0\u0bbf|\u0bb9\u0bc6\u0baf\u0bcd\u0ba4\u0bbf|\u0b95\u0bc1\u0bb0\u0bcb\u0b9a\u0bbf\u0baf\u0bbe|\u0bb9\u0bbe\u0ba3\u0bcd\u0b9f\u0bc1\u0bb0\u0bbe\u0bb8\u0bcd|\u0ba4\u0bc8\u0bb5\u0bbe\u0ba9\u0bcd|\u0ba4\u0bc1\u0bb5\u0bbe\u0bb2\u0bc2|\u0ba4\u0bbf\u0bb0\u0bbf\u0ba9\u0bbf\u0b9f\u0bbe\u0b9f\u0bcd \u0ba4\u0bca\u0baa\u0bbe\u0b95\u0bcb|\u0ba4\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0b95\u0bbf|\u0ba4\u0bca\u0b99\u0bcd\u0b95\u0bbe|\u0ba4\u0bc1\u0ba9\u0bbf\u0b9a\u0bbf\u0baf\u0bbe|\u0ba4\u0bc1\u0bb0\u0bcd\u0b95\u0bcd\u0bae\u0bc6\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|ks|en|el|qu|ko|kn|kok|km|kl|kk|wo|ka|dz|jv|pt|ps|de|pl|da|vo|ja|vi|cy|pa|cs|iu|it|co|is|uz|or|ik|ur|om|ca|ie|id|uk|ia|oc|ug|hy|br|hu|bo|bn|hr|bi|tw|bh|bg|tt|no|be|ts|hi|tr|nl|zu|ba|to|he|tn|tl|tk|ha|ne|az|ti|ay|th|tg|na|te|zh|as|ar|ta|gu|my|am|za|mt|ms|gn|sw|mr|sv|gl|su|af|st|mo|ss|mn|sr|sq|ml|ab|mk|aa|so|sn|mi|gd|sm|sl|mg|sk|ga|yo|si|sh|sg|yi|sd|fy|sa|fr|lv|lt|fo|rw|root|ru|lo|fj|ln|fi|ro|rn|rm|fa|la|xh|eu|ky|et";

  private static final String languagesValues = "\u0bb8\u0bcd\u0baa\u0bc7\u0ba9\u0bbf\u0bb7\u0bcd|\u0b95\u0bc1\u0bb0\u0bcd\u0ba4\u0bbf\u0bb7\u0bcd|\u0b8e\u0bb8\u0bcd\u0baa\u0bb0\u0bc7\u0ba9\u0bcd\u0b9f\u0bcb|\u0b95\u0bbe\u0bb7\u0bcd\u0bae\u0bbf\u0bb0\u0bbf|\u0b86\u0b99\u0bcd\u0b95\u0bbf\u0bb2\u0bae\u0bcd|\u0b95\u0bbf\u0bb0\u0bc7\u0b95\u0bcd\u0b95\u0bae\u0bcd|\u0b95\u0bbf\u0baf\u0bc1\u0b9a\u0bbe|\u0b95\u0bca\u0bb0\u0bbf\u0baf\u0ba9\u0bcd|\u0b95\u0ba9\u0bcd\u0ba9\u0b9f\u0bbe|\u0b95\u0bca\u0b99\u0bcd\u0b95\u0ba9\u0bbf|\u0b95\u0bae\u0bcd\u0baa\u0bcb\u0b9f\u0bbf\u0baf\u0ba9\u0bcd|\u0b95\u0bbf\u0bb0\u0bbf\u0ba9\u0bcd\u0bb2\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0b95\u0bcd|\u0b95\u0b9a\u0bbe\u0b95\u0bcd|\u0b92\u0bb2\u0bcb\u0baa\u0bcd|\u0b95\u0ba9\u0bcd\u0ba9\u0b9f\u0bae\u0bcd|\u0baa\u0bc1\u0b9f\u0bbe\u0ba9\u0bbf|\u0b9c\u0bbe\u0bb5\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd|\u0baa\u0bcb\u0bb0\u0bcd\u0ba4\u0bcd\u0ba4\u0bc1\u0b95\u0bc0\u0bb8\u0bcd|\u0baa\u0bc7\u0bb7\u0bcd\u0b9f\u0bcb (\u0baa\u0bc1\u0bb7\u0bcd\u0b9f\u0bcb)|\u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bcd|\u0baa\u0bcb\u0bb2\u0bbf\u0bb7\u0bcd|\u0b9f\u0bbe\u0ba9\u0bbf\u0bb7\u0bcd|\u0b92\u0bb2\u0baa\u0bc1\u0b95\u0bcd|\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd|\u0bb5\u0bbf\u0baf\u0b9f\u0bcd\u0ba8\u0bbe\u0bae\u0bbf\u0bb8\u0bcd|\u0bb5\u0bc6\u0bb2\u0bcd\u0bb7\u0bcd|\u0baa\u0b9e\u0bcd\u0b9a\u0bbe\u0baa\u0bbf|\u0b9a\u0bc6\u0b95\u0bcd|\u0b87\u0ba9\u0bc1\u0b95\u0bbf\u0b9f\u0b9f\u0bcd|\u0b87\u0ba4\u0bcd\u0ba4\u0bbe\u0bb2\u0bbf\u0baf\u0ba9\u0bcd|\u0b95\u0bbe\u0bb0\u0bcd\u0b9a\u0bbf\u0baf\u0ba9\u0bcd|\u0b90\u0bb8\u0bcd\u0bb2\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0b95\u0bcd|\u0b89\u0bb8\u0bcd\u0baa\u0bc6\u0b95\u0bcd|\u0b92\u0bb0\u0bbf\u0baf\u0bbe|\u0b87\u0ba9\u0bc1\u0baa\u0bc6\u0b95\u0bcd|\u0b89\u0bb0\u0bc1\u0ba4\u0bc1|\u0b92\u0bb0\u0bcb\u0bae (\u0b85\u0baa\u0ba9\u0bcd)|\u0b95\u0bbe\u0b9f\u0bb2\u0bbe\u0ba9\u0bcd|\u0b87\u0ba9\u0bcd\u0b9f\u0bb0\u0bcd\u0bb2\u0bbf\u0b99\u0bcd\u0b95\u0bc1\u0bb5\u0bbe|\u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0ba9\u0bcd|\u0b89\u0b95\u0bcd\u0bb0\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd|\u0b87\u0ba9\u0bcd\u0b9f\u0bb0\u0bcd\u0bb2\u0bbf\u0b99\u0bcd\u0b95\u0bc1\u0bb5\u0bbe|\u0b86\u0b95\u0bbf\u0b9f\u0bbf\u0baf\u0ba9\u0bcd|\u0baf\u0bc1\u0b95\u0bc1\u0bb0\u0bcd|\u0b86\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd|\u0baa\u0bbf\u0bb0\u0bbf\u0b9f\u0ba9\u0bcd|\u0bb9\u0b99\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0ba9\u0bcd|\u0ba4\u0bbf\u0baa\u0bc6\u0ba4\u0bcd\u0ba4\u0bc1|\u0bb5\u0b99\u0bcd\u0b95\u0bbe\u0bb3\u0bae\u0bcd|\u0b95\u0bb0\u0bcb\u0bb7\u0bbf\u0baf\u0ba9\u0bcd|\u0baa\u0bbf\u0bb8\u0bcd\u0bb2\u0bbe\u0bae\u0bbe|\u0ba4\u0bcd\u0ba4\u0bbf\u0bb5\u0bbf|\u0baa\u0bbf\u0bb9\u0bbe\u0bb0\u0bbf|\u0baa\u0bb2\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0ba9\u0bcd|\u0b9f\u0bbe\u0b9f\u0bb0\u0bcd|\u0ba8\u0bbe\u0bb0\u0bcd\u0bb5\u0bc7\u0b95\u0bbf\u0baf\u0ba9\u0bcd|\u0baa\u0bc8\u0bb2\u0bcb\u0bb0\u0bc1\u0bb7\u0bcd\u0ba9\u0bcd|\u0bb8\u0bcb\u0b99\u0bcd\u0b95\u0bbe|\u0b87\u0ba8\u0bcd\u0ba4\u0bbf|\u0b9f\u0bb0\u0bcd\u0b95\u0bbf\u0bb7\u0bcd|\u0b9f\u0b9a\u0bcd\u0b9a\u0bc1|\u0b9c\u0bc2\u0bb2\u0bc2|\u0baa\u0bbe\u0bb7\u0bcd\u0b95\u0bbf\u0bb0\u0bcd0|\u0b9f\u0bcb\u0b99\u0bcd\u0b95\u0bbe|\u0bb9\u0bc1\u0baa\u0bcd\u0bb0\u0bc1|\u0bb8\u0bc6\u0b9f\u0bcd\u0bb8\u0bcd\u0bb5\u0bbe\u0ba9\u0bbe|\u0b9f\u0bbe\u0b95\u0bbe\u0bb2\u0bcb\u0b95\u0bcd|\u0b9f\u0bb0\u0bcd\u0b95\u0bcd\u0bae\u0bc6\u0ba9\u0bcd|\u0bb9\u0bca\u0bb8\u0bbe|\u0ba8\u0bc7\u0baa\u0bcd\u0baa\u0bbe\u0bb2\u0bbf|\u0b85\u0b9a\u0bb0\u0bcd\u0baa\u0bbe\u0baf\u0bcd\u0b9c\u0bbe\u0ba9\u0bbf|\u0b9f\u0bbf\u0b95\u0bcd\u0bb0\u0bbf\u0ba9\u0bcd\u0baf\u0bbe|\u0b85\u0baf\u0bae\u0bb0\u0bbe|\u0ba4\u0bbe\u0baf\u0bcd|\u0ba4\u0bbe\u0b9c\u0bbf\u0b95\u0bcd|\u0ba8\u0bbe\u0bb0\u0bc2|\u0ba4\u0bc6\u0bb2\u0bc1\u0b99\u0bcd\u0b95\u0bc1|\u0b9a\u0bc0\u0ba9\u0bae\u0bcd|\u0b85\u0bb8\u0bcd\u0bb8\u0bbe\u0bae\u0bbf|\u0b85\u0bb0\u0baa\u0bc1|\u0ba4\u0bae\u0bbf\u0bb4\u0bcd|\u0b95\u0bc1\u0b9c\u0bb0\u0bbe\u0ba4\u0bcd\u0ba4\u0bbf|\u0baa\u0bb0\u0bcd\u0bae\u0bbf\u0bb8\u0bcd|\u0b85\u0bae\u0bcd\u0bb9\u0bbe\u0bb0\u0bbf\u0b95\u0bcd|\u0b9c\u0bc1\u0bb5\u0bbe\u0b99\u0bcd|\u0bae\u0bbe\u0bb2\u0bcd\u0b9f\u0bbf\u0bb8\u0bcd|\u0bae\u0bb2\u0bbe\u0baf\u0bcd|\u0b95\u0bc1\u0bb0\u0bbe\u0ba9\u0bbf|\u0b9a\u0bc1\u0bb5\u0bbe\u0bb9\u0bbf\u0bb2\u0bbf|\u0bae\u0bb0\u0bbe\u0ba4\u0bcd\u0ba4\u0bbf|\u0bb7\u0bc0\u0bb5\u0bbf\u0b9f\u0bbf\u0bb8\u0bcd|\u0b95\u0bc6\u0bb2\u0bbf\u0bb8\u0bbf\u0baf\u0ba9\u0bcd|\u0b9a\u0bc1\u0b9f\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd|\u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0ba9\u0bcd\u0bb8\u0bcd|\u0bb7\u0bc6\u0bb8\u0bcd\u0bb8\u0bcb\u0ba4\u0bcb|\u0bae\u0bcb\u0bb2\u0bcd\u0b9f\u0bc7\u0bb5\u0bbf\u0baf\u0ba9\u0bcd|\u0bb7\u0bbf\u0bb8\u0bcd\u0bb5\u0bbe\u0ba4\u0bbf|\u0bae\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbf\u0baf\u0ba9\u0bcd|\u0b9a\u0bb0\u0bcd\u0baa\u0bbf\u0baf\u0ba9\u0bcd|\u0b85\u0bb2\u0bcd\u0baa\u0bc6\u0ba9\u0bbf\u0baf\u0ba9\u0bcd|\u0bae\u0bb2\u0bc8\u0baf\u0bbe\u0bb3\u0bae\u0bcd|\u0b85\u0baa\u0bcd\u0b95\u0bbe\u0bb8\u0bbf\u0ba9\u0bcd|\u0bae\u0bc6\u0b95\u0bcd\u0b95\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0ba9\u0bcd|\u0b85\u0baa\u0bbe\u0bb0\u0bcd|\u0b9a\u0bcb\u0bae\u0bbe\u0bb2\u0bbf|\u0bb7\u0bcb\u0ba9\u0bbe|\u0bae\u0bcb\u0bb0\u0bbf|\u0bb8\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0bb8\u0bcd \u0b95\u0bbe\u0bb2\u0bc6\u0b95\u0bcd|\u0bb8\u0bc6\u0bae\u0bcb\u0ba9\u0bcd|\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bbf\u0ba9\u0bc7\u0baf\u0bbf\u0ba9\u0bcd|\u0bae\u0bb2\u0b95\u0bc6\u0bb8\u0bbf|\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bc6\u0b95\u0bcd|\u0b90\u0bb0\u0bbf\u0bb7\u0bcd|\u0baf\u0bcb\u0bb0\u0bc1\u0baa\u0bcd\u0baa\u0bbe|\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0bb3\u0bae\u0bcd|\u0b9a\u0bc6\u0bb0\u0bcd\u0baa\u0bcb-\u0b95\u0bcd\u0bb0\u0bcb\u0bb7\u0bbf\u0baf\u0ba9\u0bcd|\u0b9a\u0bc6\u0ba9\u0bcd\u0b95\u0bcd\u0bb0\u0bcb|\u0b88\u0ba4\u0bcd\u0ba4\u0bbf\u0bb7|\u0b9a\u0bbf\u0ba8\u0bcd\u0ba4\u0bbf|\u0baa\u0bbf\u0bb0\u0bbf\u0bb7\u0bbf\u0baf\u0ba9\u0bcd|\u0b9a\u0bae\u0bb8\u0bcd\u0b95\u0bbf\u0bb0\u0bc1\u0ba4\u0bae\u0bcd|\u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1|\u0bb2\u0bc7\u0b9f\u0bcd\u0bb5\u0bbf\u0baf\u0ba9\u0bcd (\u0bb2\u0bc7\u0b9f\u0bcd\u0b9f\u0bbf\u0bb7\u0bcd)|\u0bb2\u0bc1\u0ba4\u0bcd\u0ba4\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd|\u0baa\u0bc8\u0bb0\u0bcb\u0bb8\u0bbf|\u0b95\u0bbf\u0ba9\u0bcd\u0baf\u0bb0\u0bcd\u0bb5\u0bc6\u0ba9\u0bcd\u0b9f\u0bbe|\u0ba4\u0bae\u0bbf\u0bb4\u0bcd|\u0bb0\u0bb7\u0bbf\u0baf\u0ba9\u0bcd|\u0bb2\u0bcb\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0ba9\u0bcd|\u0baa\u0bbf\u0b9c\u0bbf|\u0bb2\u0bbf\u0b99\u0bcd\u0b95\u0bbe\u0bb2\u0bbe|\u0baa\u0bbf\u0ba9\u0bcd\u0ba9\u0bbf\u0bb7\u0bcd|\u0bb0\u0bcb\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd|\u0b95\u0bbf\u0bb0\u0bc1\u0ba8\u0bcd\u0ba4\u0bbf|\u0bb0\u0bc8\u0b9f\u0bcd\u0b9f\u0bcb-\u0bb0\u0bcb\u0bae\u0bc6\u0ba9\u0bcd\u0bb8\u0bcd|\u0baa\u0bb0\u0bcd\u0bb8\u0bbf\u0baf\u0ba9\u0bcd|\u0bb2\u0bbe\u0ba4\u0bbf\u0ba9\u0bcd|\u0bb9\u0bcb\u0bb7\u0bbe|\u0baa\u0bb8\u0bcd\u0b95\u0bcd|\u0b95\u0bbf\u0bb0\u0bcd\u0b95\u0bbf\u0bb7\u0bcd|\u0b8e\u0bb8\u0bcd\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0ba9\u0bcd";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "percentFormat", "#,##,##0%" },
    { "currencyFormat", "\u00a4 #,##,##0.00;-\u00a4 #,##,##0.00" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
