#! /bin/zsh -f

# Written by SL Baur  <steve@xemacs.org>
# December, 1998
# This file is an unofficial part of XEmacs and is used by the maintainers
#  for creating distributions

setopt extendedglob
setopt nonomatch
set -e

if [ $# != 5 ]; then
	echo "Usage: $0: previous-tag next-tag MAJOR MINOR BUILD"
	exit 1
fi

export ptag=$1
export ntag=$2
export MAJOR=$3
export MINOR=$4
export BUILD=$5
export FULLVERSION=${MAJOR}.${MINOR}.${BUILD}
if [ "$ptag" ]; then
	export LASTVERSION=$(echo $ptag | sed -e 's/-/\./g')
fi

if [ ! -d xemacs-${MAJOR}.${MINOR} ]; then
	echo "${BUILDDIR}: does not exist"
	exit 1
fi

if [ "$ptag" ]; then
	rm -f xemacs-${LASTVERSION}-${FULLVERSION}.patch*
	cvs rdiff -u -r${ptag} -r${ntag} xemacs \
		> xemacs-${LASTVERSION}-${FULLVERSION}.patch
	gzip -9 xemacs-${LASTVERSION}-${FULLVERSION}.patch
	chmod 444 xemacs-${LASTVERSION}-${FULLVERSION}.patch.gz
fi

mv xemacs-${MAJOR}.${MINOR} xemacs-${FULLVERSION}

# Main Tarball
rm -f xemacs-${FULLVERSION}.tar*
tar --exclude CVS --exclude .precious --exclude '*.info*' \
	--exclude '*.elc'  \
	-cf "xemacs-${FULLVERSION}.tar" \
	"xemacs-${FULLVERSION}"
gzip -v9 "xemacs-${FULLVERSION}.tar"
chmod 444 "xemacs-${FULLVERSION}.tar".gz

# bytecompiled XEmacs Lisp Tarball
rm -f xemacs-${FULLVERSION}-elc.tar*
tar -cf xemacs-${FULLVERSION}-elc.tar \
	xemacs-${FULLVERSION}/lisp/**/*.elc
gzip -v9 xemacs-${FULLVERSION}-elc.tar
chmod 444 xemacs-${FULLVERSION}-elc.tar.gz

# compiled XEmacs info tree
rm -f xemacs-${FULLVERSION}-info.tar*
tar -cf xemacs-${FULLVERSION}-info.tar xemacs-${FULLVERSION}/**/*.info*
gzip -v9 xemacs-${FULLVERSION}-info.tar
chmod 444 xemacs-${FULLVERSION}-info.tar.gz

mv xemacs-${FULLVERSION} xemacs-${MAJOR}.${MINOR}

exit 0
