#ifndef _INDEX_H_
#define _INDEX_H_

typedef struct indexEntry Index;
typedef struct index_desc *IndexDesc;

#include "gnats.h"
#include "database.h"
#include "field.h"
#include "pr.h"

extern void initIndex (DatabaseInfo database);

extern IndexDesc newIndexDesc (const DatabaseInfo database);
extern void addFieldToIndex (IndexDesc desc, FieldList ent);
extern void setIndexDescPath (IndexDesc desc, const char *path);
extern void setIndexDescSeparator (IndexDesc desc, const char *separator);
extern void setIndexDescBinary (IndexDesc desc, int flag);

extern void allocIndex (PR *pr);

extern void clearPRChain (const DatabaseInfo database);
extern int checkPRChain (const DatabaseInfo database, ErrorDesc *err);

extern PR *getFirstPR (const DatabaseInfo database, ErrorDesc *err);

extern PR *getPrevPR (PR *pr);
extern PR *getNextPR (PR *pr);
extern void setPrevPR (PR *pr, PR *prev_pr);
extern void setNextPR (PR *pr, PR *next_pr);

extern void freePRIndex (PR *pr);

/* Construct an index entry for PR.  */
extern void buildIndexEntry (PR *pr);

/* Return a non-zero value if FIELD is part of the index for its database. */
extern int isIndexedFieldIndex (FieldIndex field);
extern int isIndexedField (ComplexFieldIndex field);

/* Write out the database's PR index from the copy in memory.  Returns 0 on
   success, a non-zero value otherwise.  */
extern int writeIndex (const DatabaseInfo database, ErrorDesc *err);
/* Add the PR to the GNATS index file for its database.  Returns
   0 on success, a non-zero value otherwise.  */
extern int addToIndex (PR *pr, ErrorDesc *err);

/* Create a new string representing the index entry for PR in DEST.  */
extern char *createIndexEntry (PR *pr, size_t *entLen);
extern char *createIndexEntryBinary (PR *pr, size_t *entLen);

extern int replaceCurrentPRInIndex (PR *curr_pr, PR *newPR, ErrorDesc *err);

extern char *indexValue (PR *pr, FieldIndex field);

extern char *getCategoryFromIndex (const DatabaseInfo database,
				   const char *prnum, ErrorDesc *err);

extern int removePRFromIndex (const DatabaseInfo database, const char *prNum,
			      ErrorDesc *err);

extern void finishIndexDesc (const DatabaseInfo database, IndexDesc new);

extern void freeIndexDesc (IndexDesc desc);

extern int indexIsBinary (const DatabaseInfo database);

extern int indexFieldCount (const DatabaseInfo database);

extern int verifyPRExists (const DatabaseInfo database, const char *prID);
#endif

