#!/usr/bin/env raku

use Terminal::ANSI;
use Terminal::Print::DecodedInput;

my $in-supply = decoded-input-supply;

save-screen;
clear-screen;
home;

sub scroll($row,$col = 1, $height = 7) {
  print-at $row,$col, "━" x 20;
  print-at $row + $height,$col, "━" x 20;
  my $on = $row;
  for 0..10 {
    atomically {
      set-scroll-region($row + 1,$row + $height - 1);
      scroll-up if $on >= $row + $height - 1;
      print-at ++$on min $row + $height - 1, $col, "number $_";
      reset-scroll-region;
    }
  }
}

my $first = 2;
my $last = 10;
scroll(12,10,10);
my $row = 12;
my $height = 10;

hide-cursor;

react whenever $in-supply -> $c {
  if $c eq 'j' {
    set-scroll-region($row + 1,$row + $height - 1);
    move-to($row + 1, 0);
    scroll-up;
    print-at($row + $height - 1, 10, "number " ~ ++$last);
    $first++;
  }
  if $c eq 'k' {
    set-scroll-region($row + 1,$row + $height - 1);
    move-to($row + 1, 0);
    scroll-down;
    $last--;
    print-at($row + 1, 10, "number " ~ --$first);
  }
  if $c eq 'q' {
    done;
  }
}

show-cursor;
reset-scroll-region;
restore-screen;
