
### -- t/05selector.t -- autogenerated from xilpl (22/04/2001) ---###

BEGIN {
    $|++;
    print "1..261\n";
}

use strict;

# todo: avoid length on undef below
no warnings;

#- test parsing and selector handling ------------------------------#

my $tst_result = '';
use CSS::SAC                qw();
use CSS::SAC::Selector      qw(:constants);
use CSS::SAC::Condition     qw(:constants);
my $tsth = bless [];
my $sac = CSS::SAC->new({ DocumentHandler => $tsth });

my $css1 = <<'EOCSS';
@namespace foo url('http://www.foo.com/');

* {}                E {}                foo|* {}            foo|E {}
[bar] {}            [foo|bar] {}        E[bar] {}           [bar='baz'] {}
[bar="baz"] {}      [bar~='baz'] {}
[bar^='baz'] {}     [bar$='baz'] {}     [bar|='baz'] {}     :root {}    E:root {}
:nth-child(5) {}    :nth-child(5n+2) {} :nth-child(5n-2) {} :nth-last-child(5) {}
:nth-of-type(5) {}  :nth-last-of-type(5) {}                 :first-child {}
:last-child {}      :first-of-type {}   :last-of-type {}    :only-child {}
:only-of-type {}    :empty {}           :link {}            :target {}
:lang(en) {}        :contains('foo') {} ::first-line {}
::first-letter {}   .warning {}         E.warning {}        #myid {}
E#myid {}           :not(B) {}			E:not(A) {}

E F {}              E > F {}            E + F {}            E ~ F {}
EOCSS

my $tst_idx = 0;

# the namespace handler
sub namespace_declaration {
    my $dh = shift;
    my $prefix = shift;
    my $uri = shift;

    $tst_idx++;

    print 'not ' if $prefix ne 'foo';
    print "ok 1\n";

    print 'not ' if $uri ne 'http://www.foo.com/';
    print "ok 2\n";
}

my @sel_tests = qw(
                    namespace

                    universal element ns-universal ns-element attr
                    ns-attr element-attr attr-is attr-is-double attr-one-of
                    attr-starts attr-ends attr-begin-hy root
                    element-root nth-child nth-child-an+b
                    nth-child-an-b nth-last-child nth-of-type
                    nth-last-of-type first-child last-child
                    first-of-type last-of-type only-child
                    only-of-type pc-empty pc-link pc-target lang
                    contains pe-first-line
                    pe-first-letter class element-class id element-id
                    not element-not

                    descendant child adjacent-sibling sibling

                    comment
                  );
$sac->parse({ string => $css1 });

# this is the selector handler
sub start_selector {
    my $dh = shift;
    my $sel_list = shift;
    my $sel = $sel_list->[0];

    if ($sel_tests[$tst_idx] eq 'universal') {
        print 'not ' unless $sel->is_type(ELEMENT_NODE_SELECTOR); print "ok 3\n";
        print 'not ' if length  $sel->NamespaceURI;               print "ok 4\n";
        print 'not ' if defined $sel->LocalName;                  print "ok 5\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'element') {
        print 'not ' unless $sel->is_type(ELEMENT_NODE_SELECTOR); print "ok 6\n";
        print 'not ' if length  $sel->NamespaceURI;               print "ok 7\n";
        print 'not ' if $sel->LocalName ne 'E';                   print "ok 8\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'ns-universal') {
        print 'not ' unless $sel->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 9\n";
        print 'not ' if $sel->NamespaceURI ne 'http://www.foo.com/';print "ok 10\n";
        print 'not ' if defined $sel->LocalName;                    print "ok 11\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'ns-element') {
        print 'not ' unless $sel->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 12\n";
        print 'not ' if $sel->NamespaceURI ne 'http://www.foo.com/';print "ok 13\n";
        print 'not ' if $sel->LocalName ne 'E';                   	print "ok 14\n";
    }

    elsif ($sel_tests[$tst_idx] eq 'attr') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 15\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 16\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 17\n";
        print 'not ' unless $c->is_type(ATTRIBUTE_CONDITION);   	print "ok 18\n";
        print 'not ' if length  $c->NamespaceURI;               	print "ok 19\n";
        print 'not ' if $c->LocalName ne 'bar';                     print "ok 20\n";
        print 'not ' if $c->Specified;               				print "ok 21\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'ns-attr') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 22\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 23\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 24\n";
        print 'not ' unless $c->is_type(ATTRIBUTE_CONDITION);   	print "ok 25\n";
        print 'not ' if $c->NamespaceURI ne 'http://www.foo.com/';  print "ok 26\n";
        print 'not ' if $c->LocalName ne 'bar';                     print "ok 27\n";
        print 'not ' if $c->Specified;               				print "ok 28\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'element-attr') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 29\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if length $s->NamespaceURI;               		print "ok 30\n";
        print 'not ' if $s->LocalName ne 'E';                  		print "ok 31\n";
        print 'not ' unless $c->is_type(ATTRIBUTE_CONDITION);   	print "ok 32\n";
        print 'not ' if length  $c->NamespaceURI;               	print "ok 33\n";
        print 'not ' if $c->LocalName ne 'bar';                     print "ok 34\n";
        print 'not ' if $c->Specified;               				print "ok 35\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'attr-is') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 36\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 37\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 38\n";
        print 'not ' unless $c->is_type(ATTRIBUTE_CONDITION);   	print "ok 39\n";
        print 'not ' if length  $c->NamespaceURI;               	print "ok 40\n";
        print 'not ' if $c->LocalName ne 'bar';                     print "ok 41\n";
        print 'not ' if not $c->Specified;             				print "ok 42\n";
        print 'not ' if $c->Value ne 'baz';            				print "ok 43\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'attr-is-double') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 44\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 45\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 46\n";
        print 'not ' unless $c->is_type(ATTRIBUTE_CONDITION);   	print "ok 47\n";
        print 'not ' if length  $c->NamespaceURI;               	print "ok 48\n";
        print 'not ' if $c->LocalName ne 'bar';                     print "ok 49\n";
        print 'not ' if not $c->Specified;             				print "ok 50\n";
        print 'not ' if $c->Value ne 'baz';            				print "ok 51\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'attr-one-of') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 52\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 53\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 54\n";
        print 'not ' unless $c->is_type(ONE_OF_ATTRIBUTE_CONDITION); print "ok 55\n";
        print 'not ' if length  $c->NamespaceURI;               	print "ok 56\n";
        print 'not ' if $c->LocalName ne 'bar';                     print "ok 57\n";
        print 'not ' if not $c->Specified;             				print "ok 58\n";
        print 'not ' if $c->Value ne 'baz';            				print "ok 59\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'attr-starts') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 60\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 61\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 62\n";
        print 'not ' unless $c->is_type(STARTS_WITH_ATTRIBUTE_CONDITION); print "ok 63\n";
        print 'not ' if length  $c->NamespaceURI;               	print "ok 64\n";
        print 'not ' if $c->LocalName ne 'bar';                     print "ok 65\n";
        print 'not ' if not $c->Specified;             				print "ok 66\n";
        print 'not ' if $c->Value ne 'baz';            				print "ok 67\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'attr-ends') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 68\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 69\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 70\n";
        print 'not ' unless $c->is_type(ENDS_WITH_ATTRIBUTE_CONDITION); print "ok 71\n";
        print 'not ' if length  $c->NamespaceURI;               	print "ok 72\n";
        print 'not ' if $c->LocalName ne 'bar';                     print "ok 73\n";
        print 'not ' if not $c->Specified;             				print "ok 74\n";
        print 'not ' if $c->Value ne 'baz';            				print "ok 75\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'attr-begin-hy') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 76\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 77\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 78\n";
        print 'not ' unless $c->is_type(BEGIN_HYPHEN_ATTRIBUTE_CONDITION); print "ok 79\n";
        print 'not ' if length  $c->NamespaceURI;               	print "ok 80\n";
        print 'not ' if $c->LocalName ne 'bar';                     print "ok 81\n";
        print 'not ' if not $c->Specified;             				print "ok 82\n";
        print 'not ' if $c->Value ne 'baz';            				print "ok 83\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'root') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 84\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 85\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 86\n";
        print 'not ' unless $c->is_type(IS_ROOT_CONDITION); 		print "ok 87\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'element-root') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 88\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if length $s->NamespaceURI;               		print "ok 89\n";
        print 'not ' if $s->LocalName ne 'E';                  		print "ok 90\n";
        print 'not ' unless $c->is_type(IS_ROOT_CONDITION); 		print "ok 91\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'nth-child') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 92\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 93\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 94\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 95\n";
        print 'not ' if $c->Type; 									print "ok 96\n";
        print 'not ' if $c->Position != 5; 							print "ok 97\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'nth-child-an+b') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 98\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 99\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 100\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 101\n";
        print 'not ' if $c->Type; 									print "ok 102\n";
        print 'not ' if $c->Position ne '5n+2';						print "ok 103\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'nth-child-an-b') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 104\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 105\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 106\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 107\n";
        print 'not ' if $c->Type; 									print "ok 108\n";
        print 'not ' if $c->Position ne '5n-2';						print "ok 109\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'nth-last-child') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 110\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 111\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 112\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 113\n";
        print 'not ' if $c->Type; 									print "ok 114\n";
        print 'not ' if $c->Position != -5;							print "ok 115\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'nth-of-type') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 116\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 117\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 118\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 119\n";
        print 'not ' if not $c->Type; 								print "ok 120\n";
        print 'not ' if $c->Position != 5; 							print "ok 121\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'nth-last-of-type') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 122\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 123\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 124\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 125\n";
        print 'not ' if not $c->Type; 								print "ok 126\n";
        print 'not ' if $c->Position != -5;							print "ok 127\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'first-child') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 128\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 129\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 130\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 131\n";
        print 'not ' if $c->Type; 									print "ok 132\n";
        print 'not ' if $c->Position != 1; 							print "ok 133\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'last-child') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 134\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 135\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 136\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 137\n";
        print 'not ' if $c->Type; 									print "ok 138\n";
        print 'not ' if $c->Position != -1;							print "ok 139\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'first-of-type') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 140\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 141\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 142\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 143\n";
        print 'not ' if not $c->Type; 								print "ok 144\n";
        print 'not ' if $c->Position != 1;							print "ok 145\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'last-of-type') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 146\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 147\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 148\n";
        print 'not ' unless $c->is_type(POSITIONAL_CONDITION); 		print "ok 149\n";
        print 'not ' if not $c->Type; 								print "ok 150\n";
        print 'not ' if $c->Position != -1;							print "ok 151\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'only-child') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 152\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 153\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 154\n";
        print 'not ' unless $c->is_type(AND_CONDITION); 			print "ok 155\n";
        print 'not ' unless $c->FirstCondition->is_type(POSITIONAL_CONDITION); print "ok 156\n";
        print 'not ' if $c->FirstCondition->Type;					print "ok 157\n";
        print 'not ' if $c->FirstCondition->Position != 1;			print "ok 158\n";
        print 'not ' unless $c->SecondCondition->is_type(POSITIONAL_CONDITION); print "ok 159\n";
        print 'not ' if $c->SecondCondition->Type;					print "ok 160\n";
        print 'not ' if $c->SecondCondition->Position != -1;		print "ok 161\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'only-of-type') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 162\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 163\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 164\n";
        print 'not ' unless $c->is_type(AND_CONDITION); 			print "ok 165\n";
        print 'not ' unless $c->FirstCondition->is_type(POSITIONAL_CONDITION); print "ok 166\n";
        print 'not ' if not $c->FirstCondition->Type;				print "ok 167\n";
        print 'not ' if $c->FirstCondition->Position != 1;			print "ok 168\n";
        print 'not ' unless $c->SecondCondition->is_type(POSITIONAL_CONDITION); print "ok 169\n";
        print 'not ' if not $c->SecondCondition->Type;				print "ok 170\n";
        print 'not ' if $c->SecondCondition->Position != -1;		print "ok 171\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'pc-empty') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 172\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 173\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 174\n";
        print 'not ' unless $c->is_type(IS_EMPTY_CONDITION); 		print "ok 175\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'pc-link') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 176\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 177\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 178\n";
        print 'not ' unless $c->is_type(PSEUDO_CLASS_CONDITION); 	print "ok 179\n";
        print 'not ' unless $c->Value eq 'link'; 					print "ok 180\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'pc-target') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 181\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 182\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 183\n";
        print 'not ' unless $c->is_type(PSEUDO_CLASS_CONDITION); 	print "ok 184\n";
        print 'not ' unless $c->Value eq 'target'; 					print "ok 185\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'lang') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 186\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 187\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 188\n";
        print 'not ' unless $c->is_type(LANG_CONDITION); 			print "ok 189\n";
        print 'not ' unless $c->Lang eq 'en'; 						print "ok 190\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'contains') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 191\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 192\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 193\n";
        print 'not ' unless $c->is_type(CONTENT_CONDITION); 		print "ok 194\n";
        print 'not ' unless $c->Data eq 'foo'; 						print "ok 195\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'pe-first-line') {
        print 'not ' unless $sel->is_type(PSEUDO_ELEMENT_SELECTOR);	print "ok 196\n";
        print 'not ' if $sel->LocalName ne 'first-line';           	print "ok 197\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'pe-first-letter') {
        print 'not ' unless $sel->is_type(PSEUDO_ELEMENT_SELECTOR);	print "ok 198\n";
        print 'not ' if $sel->LocalName ne 'first-letter';       	print "ok 199\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'class') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 200\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 201\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 202\n";
        print 'not ' unless $c->is_type(CLASS_CONDITION);			print "ok 203\n";
        print 'not ' if $c->Value ne 'warning';                   	print "ok 204\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'element-class') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 205\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if length $s->NamespaceURI;               		print "ok 206\n";
        print 'not ' if $s->LocalName ne 'E';                  		print "ok 207\n";
        print 'not ' unless $c->is_type(CLASS_CONDITION);			print "ok 208\n";
        print 'not ' if $c->Value ne 'warning';                   	print "ok 209\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'id') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 210\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 211\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 212\n";
        print 'not ' unless $c->is_type(ID_CONDITION);				print "ok 213\n";
        print 'not ' if $c->Value ne 'myid';                   		print "ok 214\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'element-id') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 215\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if length $s->NamespaceURI;               		print "ok 216\n";
        print 'not ' if $s->LocalName ne 'E';                  		print "ok 217\n";
        print 'not ' unless $c->is_type(ID_CONDITION);				print "ok 218\n";
        print 'not ' if $c->Value ne 'myid';                   		print "ok 219\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'not') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 220\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if defined $s->NamespaceURI;               	print "ok 221\n";
        print 'not ' if defined $s->LocalName;                  	print "ok 222\n";
        print 'not ' unless $c->is_type(NEGATIVE_CONDITION);		print "ok 223\n";
        my $s2 = $c->Condition;
        print 'not ' unless $s2->is_type(ELEMENT_NODE_SELECTOR);	print "ok 224\n";
        print 'not ' if length $s2->NamespaceURI;               	print "ok 225\n";
        print 'not ' if $s2->LocalName ne 'B';                  	print "ok 226\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'element-not') {
        print 'not ' unless $sel->is_type(CONDITIONAL_SELECTOR); 	print "ok 227\n";
        my $s = $sel->SimpleSelector; my $c = $sel->Condition;
        print 'not ' if length $s->NamespaceURI;               		print "ok 228\n";
        print 'not ' if $s->LocalName ne 'E';                  		print "ok 229\n";
        print 'not ' unless $c->is_type(NEGATIVE_CONDITION);		print "ok 230\n";
        my $s2 = $c->Condition;
        print 'not ' unless $s2->is_type(ELEMENT_NODE_SELECTOR);	print "ok 231\n";
        print 'not ' if length $s2->NamespaceURI;               	print "ok 232\n";
        print 'not ' if $s2->LocalName ne 'A';                  	print "ok 233\n";
    }

    elsif ($sel_tests[$tst_idx] eq 'descendant') {
        print 'not ' unless $sel->is_type(DESCENDANT_SELECTOR); 	print "ok 234\n";
        my $s1 = $sel->AncestorSelector;
        my $s2 = $sel->SimpleSelector;
        print 'not ' unless $s1->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 235\n";
        print 'not ' unless $s2->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 236\n";
        print 'not ' if length $s1->NamespaceURI;               	print "ok 237\n";
        print 'not ' if $s1->LocalName ne 'E';                  	print "ok 238\n";
        print 'not ' if length $s2->NamespaceURI;               	print "ok 239\n";
        print 'not ' if $s2->LocalName ne 'F';                  	print "ok 240\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'child') {
        print 'not ' unless $sel->is_type(CHILD_SELECTOR); 			print "ok 241\n";
        my $s1 = $sel->AncestorSelector;
        my $s2 = $sel->SimpleSelector;
        print 'not ' unless $s1->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 242\n";
        print 'not ' unless $s2->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 243\n";
        print 'not ' if length $s1->NamespaceURI;               	print "ok 244\n";
        print 'not ' if $s1->LocalName ne 'E';                  	print "ok 245\n";
        print 'not ' if length $s2->NamespaceURI;               	print "ok 246\n";
        print 'not ' if $s2->LocalName ne 'F';                  	print "ok 247\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'adjacent-sibling') {
        print 'not ' unless $sel->is_type(DIRECT_ADJACENT_SELECTOR);print "ok 248\n";
        my $s1 = $sel->Selector;
        my $s2 = $sel->SiblingSelector;
        print 'not ' unless $s1->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 249\n";
        print 'not ' unless $s2->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 250\n";
        print 'not ' if length $s1->NamespaceURI;               	print "ok 251\n";
        print 'not ' if $s1->LocalName ne 'E';                  	print "ok 252\n";
        print 'not ' if length $s2->NamespaceURI;               	print "ok 253\n";
        print 'not ' if $s2->LocalName ne 'F';                  	print "ok 254\n";
    }
    elsif ($sel_tests[$tst_idx] eq 'sibling') {
        print 'not ' unless $sel->is_type(INDIRECT_ADJACENT_SELECTOR);print "ok 255\n";
        my $s1 = $sel->Selector;
        my $s2 = $sel->SiblingSelector;
        print 'not ' unless $s1->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 256\n";
        print 'not ' unless $s2->is_type(ELEMENT_NODE_SELECTOR); 	print "ok 257\n";
        print 'not ' if length $s1->NamespaceURI;               	print "ok 258\n";
        print 'not ' if $s1->LocalName ne 'E';                  	print "ok 259\n";
        print 'not ' if length $s2->NamespaceURI;               	print "ok 260\n";
        print 'not ' if $s2->LocalName ne 'F';                  	print "ok 261\n";
    }

    $tst_idx++;
}




