package LINE::Bot::API::Constants;
use strict;
use warnings;
use parent 'Exporter';

our @EXPORT = qw(
    OP_ADDED_AS_FRIEND OP_BLOCKED
    CONTENT_TEXT CONTENT_IMAGE CONTENT_VIDEO CONTENT_AUDIO CONTENT_LOCATION CONTENT_STICKER CONTENT_CONTACT CONTENT_RICH_MESSAGE
    RECIPIENT_USER

    EVENT_TYPE_RECEIVING_MESSAGE EVENT_TYPE_RECEIVING_OPERATION
    EVENT_TYPE_SENDING_MESSAGE EVENT_TYPE_SENDING_MULTIPLE_MESSAGE
    BOT_API_SENDING_CHANNEL_ID BOT_API_RECEIVING_CHANNEL_ID BOT_API_RECEIVING_CHANNEL_MID
);

our %EXPORT_TAGS = (
    op_type      => [qw/ OP_ADDED_AS_FRIEND OP_BLOCKED /],
    content_type => [qw/ CONTENT_TEXT CONTENT_IMAGE CONTENT_VIDEO CONTENT_AUDIO CONTENT_LOCATION CONTENT_STICKER CONTENT_CONTACT CONTENT_RICH_MESSAGE /],
    to_type      => [qw/ RECIPIENT_USER /],
    event_type   => [qw/ EVENT_TYPE_RECEIVING_MESSAGE EVENT_TYPE_RECEIVING_OPERATION EVENT_TYPE_SENDING_MESSAGE EVENT_TYPE_SENDING_MULTIPLE_MESSAGE /],
    bot_api_conf => [qw/ BOT_API_SENDING_CHANNEL_ID BOT_API_CHANNEL_ID BOT_API_CHANNEL_MID /],
);


# OpType
use constant +{
    OP_ADDED_AS_FRIEND => 4,
    OP_BLOCKED         => 8,
};

# contentType
use constant +{
    CONTENT_TEXT         => 1,
    CONTENT_IMAGE        => 2,
    CONTENT_VIDEO        => 3,
    CONTENT_AUDIO        => 4,
    CONTENT_LOCATION     => 7,
    CONTENT_STICKER      => 8,
    CONTENT_CONTACT      => 10,
    CONTENT_RICH_MESSAGE => 12,
};

# toType
use constant +{
    RECIPIENT_USER => 1,
};

# enventType
use constant +{
    EVENT_TYPE_RECEIVING_MESSAGE   => "138311609000106303",
    EVENT_TYPE_RECEIVING_OPERATION => "138311609100106403",

    EVENT_TYPE_SENDING_MESSAGE          => "138311608800106203",
    EVENT_TYPE_SENDING_MULTIPLE_MESSAGE => "140177271400161403",
};

# bot API::Constants
use constant +{
    BOT_API_RECEIVING_CHANNEL_ID  => 1341301815,
    BOT_API_RECEIVING_CHANNEL_MID => 'u206d25c2ea6bd87c17655609a1c37cb8',

    BOT_API_SENDING_CHANNEL_ID => 1383378250,
};

1;

