package SockJS::Transport::XHRSend;

use strict;
use warnings;

use base 'SockJS::Transport::Base';

use JSON ();

sub new {
    my $self = shift->SUPER::new(@_);

    push @{$self->{allowed_methods}}, 'POST';

    return $self;
}

sub dispatch_POST {
    my $self = shift;
    my ($env, $session, $path) = @_;

    return [404, [], ['Not found']] unless $session->is_connected;

    my $data = $self->_get_content($env);
    return $data if $data && ref $data eq 'ARRAY';

    return $self->_return_error('Payload expected.') unless length $data;

    my $json = JSON->new->utf8->allow_nonref(0);

    my $message;
    eval { $message = $json->decode($data) } || do {
        return $self->_return_error('Broken JSON encoding.');
    };

    if ($message && ref $message eq 'ARRAY') {
        $session->fire_event('data', @$message);
    }

    return [ 204, [ 'Content-Type' => 'text/plain; charset=UTF-8' ], [] ];
}

sub _get_content {
    my $self = shift;
    my ($env) = @_;

    my $content_length = $env->{CONTENT_LENGTH} || 0;
    my $rcount = $env->{'psgi.input'}->read(my $chunk, $content_length);

    return $self->_return_error('System error') unless $rcount == $content_length;

    return $chunk;
}

1;
