# This Makefile.PL for Perl-Types was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.012;
use ExtUtils::MakeMaker;

#our $VERSION = 0.041_000;  # DEV NOTE: comment to avoid potential conflict w/ Dist::Zilla & friends
use 5.012;  # NEED ANSWER, CORRELATION #rp000: is RPerl truly incompatible with Perl v5.10 and earlier?

#use ExtUtils::MakeMaker;  # NEED DELETE, RPERL REFACTOR

BEGIN { 
    use Config;
    use English qw(-no_match_vars);  # for $OSNAME
}

# choose correct C++11 compiler for each OS and/or Perl configuration;
# if unsupported compiler, `exit 0` to avoid creating any CPAN Testers failure or report at all
my $min_cxx_versions = {
    'g++' => 4.7,
    'clang++' => 3.3
};
my $cxx = 'g++';
if ($OSNAME eq 'freebsd') {
    $cxx = 'c++';
}
if ($Config{cc} =~ /clang/) {
    $cxx = 'clang++';
}

=begin COMPILER_VERSION_OUTPUT_EXAMPLES

$ g++ --version
g++ (Ubuntu 5.4.0-6ubuntu1~16.04.4) 5.4.0 20160609
...

$ g++ --version
g++ (i686-posix-sjlj, built by strawberryperl.com project) 4.9.2
Copyright (C) 2014 Free Software Foundation, Inc.
This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

$ clang++ --version
Ubuntu clang version 3.4-1ubuntu3 ...
...

=end COMPILER_VERSION_OUTPUT_EXAMPLES

=cut

# run external compiler command to get version info
my $version_retval = `$cxx --version`;
#print {*STDERR} '<<< DEBUG >>>: have $version_retval = ', "\n", $version_retval, "\n";
if ((not defined $version_retval) or ($version_retval eq q{})) {
    print {*STDERR} 'C++ compiler ', $cxx, ' not found, bailing out!', "\n";
    exit 0;
}

# FreeBSD c++ is sometimes g++, sometimes clang++
my $cxx_real = $cxx;
if ($cxx eq 'c++') {
    if ($version_retval =~ m/clang/xms) {
        $cxx_real = 'clang++';
    }
    elsif ($version_retval =~ m/Free\ Software\ Foundation/xms) {
        $cxx_real = 'g++';
    }
    else {
        print {*STDERR} 'C++ compiler ', $cxx, ' does not seem to provide the known g++ or clang++ compilers, bailing out!', "\n";
        exit 0;
    }
}
#print {*STDERR} '<<< DEBUG >>>: have $cxx_real = ', $cxx_real, "\n";

# must meet minimum compiler version requirements
$version_retval =~ m/(\d+\.\d+)/xms;
my $version = $1 + 0;
#print {*STDERR} '<<< DEBUG >>>: have $version = ', $version, "\n";
if ($version < $min_cxx_versions->{$cxx_real}) {
    print {*STDERR} 'C++ compiler ', $cxx_real, ' version ', $version, ' found, does not meet minimum version requirement ', $min_cxx_versions->{$cxx_real} , ', bailing out!', "\n";
    exit 0;
}

# fix read-only blib/lib in MS Windows
if ( $OSNAME eq 'MSWin32' ) {
    push( @ExtUtils::MakeMaker::Overridable, qw(pm_to_blib) );
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "the Perl data type system",
  "AUTHOR" => "William N. Braswell, Jr. <wbraswell\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Alien::GMP" => "1.16",
    "Alien::GSL" => "1.07",
    "Inline" => "0.86",
    "Inline::C" => "0.80",
    "Inline::CPP" => "0.80",
    "Inline::Filters" => "0.20"
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Perl-Types",
  "EXE_FILES" => [
    "bin/dev/find_replace_recurse_scalars.sh",
    "bin/dev/namespaces_regenerate.pl",
    "bin/dev/perl_types_refactor_cpp_namespaces.pl",
    "bin/dev/perl_types_refactor_cpp_namespaces.txt",
    "bin/dev/perl_types_refactor_headers.pl",
    "bin/dev/perl_types_refactor_names.pl",
    "bin/dev/perl_types_refactor_names.txt",
    "bin/dev/perl_types_refactor_names_accept_mapped.sh",
    "bin/dev/perl_types_refactor_names_delete_mapped.sh",
    "bin/dev/perl_types_refactor_names_map.pm",
    "bin/dev/perl_types_refactor_names_parser.out",
    "bin/dev/perl_types_refactor_names_parser.pl",
    "bin/dev/refactor_names_map_create_groups.pl",
    "bin/dev/t09_interpret_execute__mv_failures.sh"
  ],
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.012",
  "NAME" => "Perl::Types",
  "PREREQ_PM" => {
    "PadWalker" => "2.5"
  },
  "TEST_REQUIRES" => {
    "Test::CPAN::Changes" => "0.5",
    "Test::Exception" => "0.43",
    "Test::Number::Delta" => "1.06"
  },
  "VERSION" => "0.200",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Alien::GMP" => "1.16",
  "Alien::GSL" => "1.07",
  "Inline" => "0.86",
  "Inline::C" => "0.80",
  "Inline::CPP" => "0.80",
  "Inline::Filters" => "0.20",
  "PadWalker" => "2.5",
  "Test::CPAN::Changes" => "0.5",
  "Test::Exception" => "0.43",
  "Test::Number::Delta" => "1.06"
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

#our $VERSION = 0.041_000;  # DEV NOTE: comment to avoid potential conflict w/ Dist::Zilla & friends

package MY;
BEGIN { use English; }

sub pm_to_blib {
    my $self = shift;
    my $blib = $self->SUPER::pm_to_blib(@_);

    # un-read-only blib/lib for tests to pass, files are modified at runtime there
    if ( $OSNAME eq 'MSWin32' ) {
        my ( $lastline, $start ) = qq{\t\$(NOECHO) \$(TOUCH) pm_to_blib\n};
        ( $start = index( $blib, $lastline ) ) == -1
            && die "Can't find replacement string for pm_to_blib target";
        substr( $blib, $start, 0, "\t" . 'attrib -R /S  blib/lib/*' . "\n" );
    }
    return $blib;
}

# disable PERL_DL_NONLAZY=1 to avoid C++ compile errors for GMP library (and possibly others)
sub test_via_harness {
    my $self = shift;
    my $command = $self->MM::test_via_harness(@_);
    $command =~ s/\bPERL_DL_NONLAZY=1\s+//gxms;
    return $command;
}

sub test_via_script {
    my $self = shift;
    my $command = $self->MM::test_via_script(@_);
    $command =~ s/\bPERL_DL_NONLAZY=1\s+//gxms;
    return $command;
}
