#include <libecc/lib_ecc_config.h>
#ifdef WITH_CURVE_GOST_R3410_2012_512_PARAMSETTEST

#ifndef __EC_PARAMS_GOST_R3410_2012_512_PARAMSETTEST_H__
#define __EC_PARAMS_GOST_R3410_2012_512_PARAMSETTEST_H__
#include <libecc/curves/known/ec_params_external.h>
static const u8 gost_R3410_2012_512_paramSetTest_p[] = {
	0x45, 0x31, 0xac, 0xd1, 0xfe, 0x00, 0x23, 0xc7,
	0x55, 0x0d, 0x26, 0x7b, 0x6b, 0x2f, 0xee, 0x80,
	0x92, 0x2b, 0x14, 0xb2, 0xff, 0xb9, 0x0f, 0x04,
	0xd4, 0xeb, 0x7c, 0x09, 0xb5, 0xd2, 0xd1, 0x5d,
	0xf1, 0xd8, 0x52, 0x74, 0x1a, 0xf4, 0x70, 0x4a,
	0x04, 0x58, 0x04, 0x7e, 0x80, 0xe4, 0x54, 0x6d,
	0x35, 0xb8, 0x33, 0x6f, 0xac, 0x22, 0x4d, 0xd8,
	0x16, 0x64, 0xbb, 0xf5, 0x28, 0xbe, 0x63, 0x73,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p);

#define CURVE_GOST_R3410_2012_512_PARAMSETTEST_P_BITLEN 511
static const u8 gost_R3410_2012_512_paramSetTest_p_bitlen[] = {
	0x01, 0xff,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_bitlen);

#if (WORD_BYTES == 8)     /* 64-bit words */
static const u8 gost_R3410_2012_512_paramSetTest_r[] = {
	0x30, 0x6a, 0xf9, 0x8a, 0x05, 0xff, 0x94, 0xaa,
	0x00, 0xd8, 0x8c, 0x8d, 0xbe, 0x70, 0x34, 0x7e,
	0x49, 0x7e, 0xc1, 0xe7, 0x00, 0xd4, 0xd2, 0xf1,
	0x81, 0x3d, 0x8b, 0xe2, 0xde, 0x87, 0x8b, 0xe6,
	0x2a, 0x77, 0x08, 0xa3, 0xaf, 0x22, 0xaf, 0x21,
	0xf2, 0xf7, 0xf2, 0x84, 0x7d, 0x53, 0x02, 0xb8,
	0x5e, 0xd7, 0x65, 0xb0, 0xfb, 0x99, 0x16, 0x77,
	0xbc, 0xd1, 0xcc, 0x20, 0x85, 0xc4, 0xd5, 0xa7,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_r);

static const u8 gost_R3410_2012_512_paramSetTest_r_square[] = {
	0x1d, 0x88, 0x7d, 0xcd, 0x9c, 0xd1, 0x9c, 0x10,
	0x01, 0xfd, 0xe9, 0xca, 0x99, 0xde, 0x08, 0x52,
	0xfc, 0xd9, 0x83, 0xcf, 0xb7, 0xc6, 0x63, 0xd9,
	0xca, 0x0b, 0xc8, 0xaf, 0x77, 0xc8, 0x69, 0x0a,
	0x08, 0x15, 0xb9, 0xeb, 0x1e, 0x7d, 0xd3, 0x00,
	0xe4, 0x17, 0xd5, 0x8d, 0x20, 0x0c, 0x2a, 0xa0,
	0x4b, 0x90, 0x7a, 0x71, 0xe6, 0x47, 0xee, 0x63,
	0x00, 0x1c, 0x10, 0xbc, 0x2d, 0x00, 0x5b, 0x65,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_r_square);

static const u8 gost_R3410_2012_512_paramSetTest_mpinv[] = {
	0xd6, 0x41, 0x2f, 0xf7, 0xc2, 0x9b, 0x86, 0x45,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_mpinv);

static const u8 gost_R3410_2012_512_paramSetTest_p_shift[] = {
	0x01,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_shift);

static const u8 gost_R3410_2012_512_paramSetTest_p_normalized[] = {
	0x8a, 0x63, 0x59, 0xa3, 0xfc, 0x00, 0x47, 0x8e,
	0xaa, 0x1a, 0x4c, 0xf6, 0xd6, 0x5f, 0xdd, 0x01,
	0x24, 0x56, 0x29, 0x65, 0xff, 0x72, 0x1e, 0x09,
	0xa9, 0xd6, 0xf8, 0x13, 0x6b, 0xa5, 0xa2, 0xbb,
	0xe3, 0xb0, 0xa4, 0xe8, 0x35, 0xe8, 0xe0, 0x94,
	0x08, 0xb0, 0x08, 0xfd, 0x01, 0xc8, 0xa8, 0xda,
	0x6b, 0x70, 0x66, 0xdf, 0x58, 0x44, 0x9b, 0xb0,
	0x2c, 0xc9, 0x77, 0xea, 0x51, 0x7c, 0xc6, 0xe6,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_normalized);

static const u8 gost_R3410_2012_512_paramSetTest_p_reciprocal[] = {
	0xd9, 0x91, 0x18, 0x3c, 0xe8, 0xbf, 0x25, 0x61,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_reciprocal);

#elif (WORD_BYTES == 4)   /* 32-bit words */
static const u8 gost_R3410_2012_512_paramSetTest_r[] = {
	0x30, 0x6a, 0xf9, 0x8a, 0x05, 0xff, 0x94, 0xaa,
	0x00, 0xd8, 0x8c, 0x8d, 0xbe, 0x70, 0x34, 0x7e,
	0x49, 0x7e, 0xc1, 0xe7, 0x00, 0xd4, 0xd2, 0xf1,
	0x81, 0x3d, 0x8b, 0xe2, 0xde, 0x87, 0x8b, 0xe6,
	0x2a, 0x77, 0x08, 0xa3, 0xaf, 0x22, 0xaf, 0x21,
	0xf2, 0xf7, 0xf2, 0x84, 0x7d, 0x53, 0x02, 0xb8,
	0x5e, 0xd7, 0x65, 0xb0, 0xfb, 0x99, 0x16, 0x77,
	0xbc, 0xd1, 0xcc, 0x20, 0x85, 0xc4, 0xd5, 0xa7,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_r);

static const u8 gost_R3410_2012_512_paramSetTest_r_square[] = {
	0x1d, 0x88, 0x7d, 0xcd, 0x9c, 0xd1, 0x9c, 0x10,
	0x01, 0xfd, 0xe9, 0xca, 0x99, 0xde, 0x08, 0x52,
	0xfc, 0xd9, 0x83, 0xcf, 0xb7, 0xc6, 0x63, 0xd9,
	0xca, 0x0b, 0xc8, 0xaf, 0x77, 0xc8, 0x69, 0x0a,
	0x08, 0x15, 0xb9, 0xeb, 0x1e, 0x7d, 0xd3, 0x00,
	0xe4, 0x17, 0xd5, 0x8d, 0x20, 0x0c, 0x2a, 0xa0,
	0x4b, 0x90, 0x7a, 0x71, 0xe6, 0x47, 0xee, 0x63,
	0x00, 0x1c, 0x10, 0xbc, 0x2d, 0x00, 0x5b, 0x65,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_r_square);

static const u8 gost_R3410_2012_512_paramSetTest_mpinv[] = {
	0xc2, 0x9b, 0x86, 0x45,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_mpinv);

static const u8 gost_R3410_2012_512_paramSetTest_p_shift[] = {
	0x01,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_shift);

static const u8 gost_R3410_2012_512_paramSetTest_p_normalized[] = {
	0x8a, 0x63, 0x59, 0xa3, 0xfc, 0x00, 0x47, 0x8e,
	0xaa, 0x1a, 0x4c, 0xf6, 0xd6, 0x5f, 0xdd, 0x01,
	0x24, 0x56, 0x29, 0x65, 0xff, 0x72, 0x1e, 0x09,
	0xa9, 0xd6, 0xf8, 0x13, 0x6b, 0xa5, 0xa2, 0xbb,
	0xe3, 0xb0, 0xa4, 0xe8, 0x35, 0xe8, 0xe0, 0x94,
	0x08, 0xb0, 0x08, 0xfd, 0x01, 0xc8, 0xa8, 0xda,
	0x6b, 0x70, 0x66, 0xdf, 0x58, 0x44, 0x9b, 0xb0,
	0x2c, 0xc9, 0x77, 0xea, 0x51, 0x7c, 0xc6, 0xe6,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_normalized);

static const u8 gost_R3410_2012_512_paramSetTest_p_reciprocal[] = {
	0xd9, 0x91, 0x18, 0x3c,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_reciprocal);

#elif (WORD_BYTES == 2)   /* 16-bit words */
static const u8 gost_R3410_2012_512_paramSetTest_r[] = {
	0x30, 0x6a, 0xf9, 0x8a, 0x05, 0xff, 0x94, 0xaa,
	0x00, 0xd8, 0x8c, 0x8d, 0xbe, 0x70, 0x34, 0x7e,
	0x49, 0x7e, 0xc1, 0xe7, 0x00, 0xd4, 0xd2, 0xf1,
	0x81, 0x3d, 0x8b, 0xe2, 0xde, 0x87, 0x8b, 0xe6,
	0x2a, 0x77, 0x08, 0xa3, 0xaf, 0x22, 0xaf, 0x21,
	0xf2, 0xf7, 0xf2, 0x84, 0x7d, 0x53, 0x02, 0xb8,
	0x5e, 0xd7, 0x65, 0xb0, 0xfb, 0x99, 0x16, 0x77,
	0xbc, 0xd1, 0xcc, 0x20, 0x85, 0xc4, 0xd5, 0xa7,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_r);

static const u8 gost_R3410_2012_512_paramSetTest_r_square[] = {
	0x1d, 0x88, 0x7d, 0xcd, 0x9c, 0xd1, 0x9c, 0x10,
	0x01, 0xfd, 0xe9, 0xca, 0x99, 0xde, 0x08, 0x52,
	0xfc, 0xd9, 0x83, 0xcf, 0xb7, 0xc6, 0x63, 0xd9,
	0xca, 0x0b, 0xc8, 0xaf, 0x77, 0xc8, 0x69, 0x0a,
	0x08, 0x15, 0xb9, 0xeb, 0x1e, 0x7d, 0xd3, 0x00,
	0xe4, 0x17, 0xd5, 0x8d, 0x20, 0x0c, 0x2a, 0xa0,
	0x4b, 0x90, 0x7a, 0x71, 0xe6, 0x47, 0xee, 0x63,
	0x00, 0x1c, 0x10, 0xbc, 0x2d, 0x00, 0x5b, 0x65,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_r_square);

static const u8 gost_R3410_2012_512_paramSetTest_mpinv[] = {
	0x86, 0x45,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_mpinv);

static const u8 gost_R3410_2012_512_paramSetTest_p_shift[] = {
	0x01,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_shift);

static const u8 gost_R3410_2012_512_paramSetTest_p_normalized[] = {
	0x8a, 0x63, 0x59, 0xa3, 0xfc, 0x00, 0x47, 0x8e,
	0xaa, 0x1a, 0x4c, 0xf6, 0xd6, 0x5f, 0xdd, 0x01,
	0x24, 0x56, 0x29, 0x65, 0xff, 0x72, 0x1e, 0x09,
	0xa9, 0xd6, 0xf8, 0x13, 0x6b, 0xa5, 0xa2, 0xbb,
	0xe3, 0xb0, 0xa4, 0xe8, 0x35, 0xe8, 0xe0, 0x94,
	0x08, 0xb0, 0x08, 0xfd, 0x01, 0xc8, 0xa8, 0xda,
	0x6b, 0x70, 0x66, 0xdf, 0x58, 0x44, 0x9b, 0xb0,
	0x2c, 0xc9, 0x77, 0xea, 0x51, 0x7c, 0xc6, 0xe6,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_normalized);

static const u8 gost_R3410_2012_512_paramSetTest_p_reciprocal[] = {
	0xd9, 0x91,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_p_reciprocal);

#else                     /* unknown word size */
#error "Unsupported word size"
#endif

static const u8 gost_R3410_2012_512_paramSetTest_a[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_a);

static const u8 gost_R3410_2012_512_paramSetTest_b[] = {
	0x1c, 0xff, 0x08, 0x06, 0xa3, 0x11, 0x16, 0xda,
	0x29, 0xd8, 0xcf, 0xa5, 0x4e, 0x57, 0xeb, 0x74,
	0x8b, 0xc5, 0xf3, 0x77, 0xe4, 0x94, 0x00, 0xfd,
	0xd7, 0x88, 0xb6, 0x49, 0xec, 0xa1, 0xac, 0x43,
	0x61, 0x83, 0x40, 0x13, 0xb2, 0xad, 0x73, 0x22,
	0x48, 0x0a, 0x89, 0xca, 0x58, 0xe0, 0xcf, 0x74,
	0xbc, 0x9e, 0x54, 0x0c, 0x2a, 0xdd, 0x68, 0x97,
	0xfa, 0xd0, 0xa3, 0x08, 0x4f, 0x30, 0x2a, 0xdc,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_b);

#define CURVE_GOST_R3410_2012_512_PARAMSETTEST_CURVE_ORDER_BITLEN 511
static const u8 gost_R3410_2012_512_paramSetTest_curve_order[] = {
	0x45, 0x31, 0xac, 0xd1, 0xfe, 0x00, 0x23, 0xc7,
	0x55, 0x0d, 0x26, 0x7b, 0x6b, 0x2f, 0xee, 0x80,
	0x92, 0x2b, 0x14, 0xb2, 0xff, 0xb9, 0x0f, 0x04,
	0xd4, 0xeb, 0x7c, 0x09, 0xb5, 0xd2, 0xd1, 0x5d,
	0xa8, 0x2f, 0x2d, 0x7e, 0xcb, 0x1d, 0xba, 0xc7,
	0x19, 0x90, 0x5c, 0x5e, 0xec, 0xc4, 0x23, 0xf1,
	0xd8, 0x6e, 0x25, 0xed, 0xbe, 0x23, 0xc5, 0x95,
	0xd6, 0x44, 0xaa, 0xf1, 0x87, 0xe6, 0xe6, 0xdf,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_curve_order);

static const u8 gost_R3410_2012_512_paramSetTest_gx[] = {
	0x24, 0xd1, 0x9c, 0xc6, 0x45, 0x72, 0xee, 0x30,
	0xf3, 0x96, 0xbf, 0x6e, 0xbb, 0xfd, 0x7a, 0x6c,
	0x52, 0x13, 0xb3, 0xb3, 0xd7, 0x05, 0x7c, 0xc8,
	0x25, 0xf9, 0x10, 0x93, 0xa6, 0x8c, 0xd7, 0x62,
	0xfd, 0x60, 0x61, 0x12, 0x62, 0xcd, 0x83, 0x8d,
	0xc6, 0xb6, 0x0a, 0xa7, 0xee, 0xe8, 0x04, 0xe2,
	0x8b, 0xc8, 0x49, 0x97, 0x7f, 0xac, 0x33, 0xb4,
	0xb5, 0x30, 0xf1, 0xb1, 0x20, 0x24, 0x8a, 0x9a,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_gx);

static const u8 gost_R3410_2012_512_paramSetTest_gy[] = {
	0x2b, 0xb3, 0x12, 0xa4, 0x3b, 0xd2, 0xce, 0x6e,
	0x0d, 0x02, 0x06, 0x13, 0xc8, 0x57, 0xac, 0xdd,
	0xcf, 0xbf, 0x06, 0x1e, 0x91, 0xe5, 0xf2, 0xc3,
	0xf3, 0x24, 0x47, 0xc2, 0x59, 0xf3, 0x9b, 0x2c,
	0x83, 0xab, 0x15, 0x6d, 0x77, 0xf1, 0x49, 0x6b,
	0xf7, 0xeb, 0x33, 0x51, 0xe1, 0xee, 0x4e, 0x43,
	0xdc, 0x1a, 0x18, 0xb9, 0x1b, 0x24, 0x64, 0x0b,
	0x6d, 0xbb, 0x92, 0xcb, 0x1a, 0xdd, 0x37, 0x1e,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_gy);

static const u8 gost_R3410_2012_512_paramSetTest_gz[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_gz);

static const u8 gost_R3410_2012_512_paramSetTest_gen_order[] = {
	0x45, 0x31, 0xac, 0xd1, 0xfe, 0x00, 0x23, 0xc7,
	0x55, 0x0d, 0x26, 0x7b, 0x6b, 0x2f, 0xee, 0x80,
	0x92, 0x2b, 0x14, 0xb2, 0xff, 0xb9, 0x0f, 0x04,
	0xd4, 0xeb, 0x7c, 0x09, 0xb5, 0xd2, 0xd1, 0x5d,
	0xa8, 0x2f, 0x2d, 0x7e, 0xcb, 0x1d, 0xba, 0xc7,
	0x19, 0x90, 0x5c, 0x5e, 0xec, 0xc4, 0x23, 0xf1,
	0xd8, 0x6e, 0x25, 0xed, 0xbe, 0x23, 0xc5, 0x95,
	0xd6, 0x44, 0xaa, 0xf1, 0x87, 0xe6, 0xe6, 0xdf,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_gen_order);

#define CURVE_GOST_R3410_2012_512_PARAMSETTEST_Q_BITLEN 511
static const u8 gost_R3410_2012_512_paramSetTest_gen_order_bitlen[] = {
	0x01, 0xff,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_gen_order_bitlen);

static const u8 gost_R3410_2012_512_paramSetTest_cofactor[] = {
	0x01,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_cofactor);

static const u8 gost_R3410_2012_512_paramSetTest_alpha_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(gost_R3410_2012_512_paramSetTest_alpha_montgomery, 0);

static const u8 gost_R3410_2012_512_paramSetTest_gamma_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(gost_R3410_2012_512_paramSetTest_gamma_montgomery, 0);

static const u8 gost_R3410_2012_512_paramSetTest_alpha_edwards[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(gost_R3410_2012_512_paramSetTest_alpha_edwards, 0);

static const u8 gost_R3410_2012_512_paramSetTest_name[] = "GOST_R3410_2012_512_PARAMSETTEST";
TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_name);

static const u8 gost_R3410_2012_512_paramSetTest_oid[] = "1.2.643.7.1.2.1.2.0";
TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetTest_oid);

static const ec_str_params gost_R3410_2012_512_paramSetTest_str_params = {
	.p = &gost_R3410_2012_512_paramSetTest_p_str_param,
	.p_bitlen = &gost_R3410_2012_512_paramSetTest_p_bitlen_str_param,
	.r = &gost_R3410_2012_512_paramSetTest_r_str_param,
	.r_square = &gost_R3410_2012_512_paramSetTest_r_square_str_param,
	.mpinv = &gost_R3410_2012_512_paramSetTest_mpinv_str_param,
	.p_shift = &gost_R3410_2012_512_paramSetTest_p_shift_str_param,
	.p_normalized = &gost_R3410_2012_512_paramSetTest_p_normalized_str_param,
	.p_reciprocal = &gost_R3410_2012_512_paramSetTest_p_reciprocal_str_param,
	.a = &gost_R3410_2012_512_paramSetTest_a_str_param,
	.b = &gost_R3410_2012_512_paramSetTest_b_str_param,
	.curve_order = &gost_R3410_2012_512_paramSetTest_curve_order_str_param,
	.gx = &gost_R3410_2012_512_paramSetTest_gx_str_param,
	.gy = &gost_R3410_2012_512_paramSetTest_gy_str_param,
	.gz = &gost_R3410_2012_512_paramSetTest_gz_str_param,
	.gen_order = &gost_R3410_2012_512_paramSetTest_gen_order_str_param,
	.gen_order_bitlen = &gost_R3410_2012_512_paramSetTest_gen_order_bitlen_str_param,
	.cofactor = &gost_R3410_2012_512_paramSetTest_cofactor_str_param,
	.alpha_montgomery = &gost_R3410_2012_512_paramSetTest_alpha_montgomery_str_param,
	.gamma_montgomery = &gost_R3410_2012_512_paramSetTest_gamma_montgomery_str_param,
	.alpha_edwards = &gost_R3410_2012_512_paramSetTest_alpha_edwards_str_param,
	.oid = &gost_R3410_2012_512_paramSetTest_oid_str_param,
	.name = &gost_R3410_2012_512_paramSetTest_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN    0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_GOST_R3410_2012_512_PARAMSETTEST_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_GOST_R3410_2012_512_PARAMSETTEST_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN    0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_GOST_R3410_2012_512_PARAMSETTEST_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_GOST_R3410_2012_512_PARAMSETTEST_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN    0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_GOST_R3410_2012_512_PARAMSETTEST_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_GOST_R3410_2012_512_PARAMSETTEST_CURVE_ORDER_BITLEN
#endif

/*
 * Compute and adapt max name and oid length
 */
#ifndef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 0
#endif
#ifndef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 0
#endif
#if (MAX_CURVE_OID_LEN < 20)
#undef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 20
#endif
#if (MAX_CURVE_NAME_LEN < 53)
#undef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 53
#endif

#endif /* __EC_PARAMS_GOST_R3410_2012_512_PARAMSETTEST_H__ */

#endif /* WITH_CURVE_GOST_R3410_2012_512_PARAMSETTEST */
