/*-
 * Copyright (c) 1982, 1988, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/9/sys/sys/ctype.h 345944 2019-04-05 11:37:17Z hselasky $
 */

#ifndef _SYS_CTYPE_H_
#define	_SYS_CTYPE_H_

#ifdef _KERNEL

static __inline int
isspace(int c)
{
	return (c == ' ' || (c >= '\t' && c <= '\r'));
}

static __inline int
isascii(int c)
{
	return ((c & ~0x7f) == 0);
}

static __inline int
isupper(int c)
{
	return (c >= 'A' && c <= 'Z');
}

static __inline int
islower(int c)
{
	return (c >= 'a' && c <= 'z');
}

static __inline int
isalpha(int c)
{
	return (isupper(c) || islower(c));
}

static __inline int
isdigit(int c)
{
	return (c >= '0' && c <= '9');
}

static __inline int
isxdigit(int c)
{
	return (isdigit(c) || (c >= 'A' && c <= 'F') || (c >= 'a' && c <= 'f'));
}

static __inline int
isprint(int c)
{
	return (c >= ' ' && c <= '~');
}

static __inline int
toupper(int c)
{
	return (c - 0x20 * ((c >= 'a') && (c <= 'z')));
}

static __inline int
tolower(int c)
{
	return (c + 0x20 * ((c >= 'A') && (c <= 'Z')));
}

#endif
#endif /* !_SYS_CTYPE_H_ */
