
/*
**
*/

#include "term.h"

	/* This helps aviod conflicts when using libtermnet.a */
#define getopt term_getopt
#define optind term_optind
#define opterr term_opterr
#define optopt term_optopt
#define optarg term_optarg

#if !defined(NO_UNIX_DOMAIN) && defined(TERM_NFS_DIR)
# define NO_UNIX_DOMAIN
#endif

#if defined(I_ERRNO)
# include <errno.h>
#endif

#ifdef I_CTYPE
# include <ctype.h>
#endif

#ifdef I_TYPES
# ifndef titan
#  include <sys/types.h>
# else
#  include <types.h>
# endif
#endif

#ifdef I_SYS
# ifndef I_TIME
#  define I_TIME
# endif
# include <sys/types.h>
# ifdef _AIX
#  include <sys/select.h>
# endif
# ifdef SVR4
   int gettimeofday(struct timeval *);
   int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
# endif
#endif

#ifdef DYNIXPTX
# include <sys/types.h>
# include <sys/select.h>
  int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
# define gettimeofday(a) get_process_stats(a,getpid(),0,0);
# define settimeofday(a) stime(a);
# ifndef I_TIME
#  define I_TIME
# endif
#endif

#ifdef I_IOCTL
# if !defined(I_TTY) || !defined(sun) || defined(SVR4)
#  include <sys/ioctl.h>
# endif
# include <fcntl.h>
#endif

#ifdef I_STRING
# include <string.h>
#endif

#ifdef I_SOCKET
# include <sys/types.h>
# if !defined(NO_UNIX_DOMAIN)
#  include <sys/un.h>
# endif
# include <netinet/in.h>
# include <netdb.h>
# include <sys/socket.h>
# ifdef SYSV
#  include <sys/utsname.h>
# endif
# ifdef SVR4
   int accept(int, struct sockaddr *, int *);
   int bind(int, struct sockaddr *, int);
   int connect(int, struct sockaddr *, int);
   int listen(int, int);
   int socket(int, int, int);
   int socketpair(int, int, int, int[]);
# endif
# ifndef NO_UNIX_DOMAIN
#  define S_Pipe(soc) socketpair(AF_UNIX, SOCK_STREAM, 0, soc) 
# else
#  ifdef SCO
#   define S_Pipe(soc) socketpair(AF_INET, SOCK_STREAM, 0, soc)
#  else
#   define S_Pipe(soc) s_pipe(soc)
#  endif
# endif
#endif

#ifdef I_GETOPT
# if defined(linux)
#  include <getopt.h>
# else
#  if defined(__hpux) || defined(__386BSD__) || defined(___386BSD___) || defined(SVR4) || defined(__NetBSD__) || defined(__OSF1__) || defined(__osf__) || defined(BSDI)
#   if defined(__hpux__) || defined(__hpux) 
/* #include <unistd.h> */
     extern char *optarg;
     extern int optind, opterr;
#   endif
/* Do nothing -- declared in stdlib.h */
#  else
    int getopt(int argc, char *argv[], char *);
    extern char *optarg;
    extern int optind, opterr;
#  endif
# endif
#endif

#ifdef I_TTY
# ifdef USE_TERMIOS
#   include <termios.h>
# else
#  include <sgtty.h>
# endif
#endif

#include <stdio.h>

#ifdef titan
  extern char *getenv(char *name);
# include <malloc.h>
#else /* titan */
# include <stdlib.h>
#endif /* titan */

#ifdef NeXT
# include <sys/types.h>
# include <sys/file.h>
#else /* next */
# include "config.h"
# include <unistd.h>
#endif /* next */

#ifdef ultrix
# include <sys/file.h>
#endif /* ultrix */

#ifdef I_SIGNAL
# include <signal.h>
#endif

#ifdef I_TIMES
# include <sys/times.h>
#endif

#ifdef I_TIME
# include <sys/time.h>
#endif

#ifdef I_ARGS
# ifdef NO_VSPRINTF
#  define va_alist a1,a2,a3,a4,a5,a6,a7,a8,a9
#  define va_dcl long a1,a2,a3,a4,a5,a6,a7,a8,a9;
#  define vsprintf(buf,fmt,v) sprintf((buf),(fmt),a1,a2,a3,a4,a5,a6,a7,a8,a9)
#  define va_list int
#  define va_start(v)
#  define va_end(v)
#  define USE_VARARGS
# else /* NO_VSPRINTF */
#  ifdef USE_VARARGS
#   include <varargs.h>
#  else /* USE_VARARGS */
#   include <stdarg.h>
#  endif /* USE_VARARGS */
# endif /* NO_VSPRINTF */
#endif /* I_ARGS */

#ifdef I_INET
# include <arpa/inet.h>
#endif

#ifdef I_PARAM
# include <sys/param.h>
#endif

#ifdef I_MEMORY
# include <memory.h>
#endif

#ifdef I_PWD
# include <pwd.h>
#endif

#ifdef I_WAIT
# include <sys/wait.h>
#endif

#ifdef I_STROPT
# if defined(SCO) || defined(SYSV)
#  include <stropts.h>
# endif
#endif

#ifdef I_STREAM
# include <sys/stream.h>
#endif

#ifdef I_STAT
# include <sys/stat.h>
# ifndef S_ISREG
#  define S_ISREG(a) (((a) & S_IFMT) == S_IFREG)
#  define S_ISDIR(a) (((a) & S_IFMT) == S_IFDIR)
# endif
#endif

#ifndef R_OK	/* Normally in unistd.h */
# define R_OK 4
#endif

#ifndef X_OK	/* Normally in unistd.h */
# define X_OK 1
#endif

#ifndef STDIN_FILENO	/* Normally in unistd.h */
# define STDIN_FILENO 0
#endif

        /* This macro allows commands to work in shared mode only by the root */
        /* and owner of the connection. */
#ifdef SHAREDIR
# ifdef _POSIX_SAVED_IDS
#  define PUBLIC_COMMAND     if (savedeid < 0) set_share_mode(); 
#  define PRIVLEDGED_COMMAND set_share_mode();savedeid = -1;
# else
#  ifdef USERSHARE
#   define PUBLIC_COMMAND 
#   define PRIVLEDGED_COMMAND set_share_mode();setuid(getuid());
#  else
#   define PUBLIC_COMMAND 
#   define PRIVLEDGED_COMMAND set_share_mode();setgid(getgid());
#  endif
# endif
#else
# define PRIVLEDGED_COMMAND
# define PUBLIC_COMMAND
#endif

