# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.sql import SqlManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-sql
# USAGE
    python resource_group_based_change_long_term_retention_backup_access_tier.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SqlManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-1111-2222-3333-444444444444",
    )

    response = client.long_term_retention_backups.begin_change_access_tier_by_resource_group(
        resource_group_name="resourceGroupName",
        location_name="japaneast",
        long_term_retention_server_name="serverName",
        long_term_retention_database_name="databaseName",
        backup_name="55555555-6666-7777-8888-999999999999;131637960820000000;Archive",
        parameters={"backupStorageAccessTier": "Hot", "operationMode": "Copy"},
    ).result()
    print(response)


# x-ms-original-file: specification/sql/resource-manager/Microsoft.Sql/preview/2024-05-01-preview/examples/ResourceGroupBasedChangeLongTermRetentionBackupAccessTier.json
if __name__ == "__main__":
    main()
