"""Script to import a more compact representation of the tzlocal library"""

from pathlib import Path
from tzlocal import windows_tz
import zoneinfo


OUTPUT_FILE = Path("ical/tzif/extended_timezones.py")

HEADER = [
    """\"\"\"This file is automatically generated by script/update_tzlocal.py. Do not edit.\"\"\"\n\n"""
]
TIMEZONES = windows_tz.win_tz

print("Number of timezones: {}".format(len(TIMEZONES)))

available_timezones = zoneinfo.available_timezones()

# Write the emoji characters to a new python file as a dictionary
with OUTPUT_FILE.open("w") as f:
    f.writelines(HEADER)
    f.write("EXTENDED_TIMEZONES = {\n")
    for k, v in TIMEZONES.items():
        if v not in available_timezones:
            raise ValueError(f"Timezone {k} not in available timezones")
        f.write(f"  '{k}': '{v}',\n")
    f.write("}\n")

print("Timezones written to {}".format(OUTPUT_FILE))
print("File size: {} bytes".format(OUTPUT_FILE.stat().st_size))
