/*
 * Copyright (c) 2010-2011 Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

static const u32 ar9280Modes_9280_2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00001030, 0x00000230, 0x00000460, 0x000002c0, 0x00000160},
	{0x00001070, 0x00000168, 0x000002d0, 0x00000318, 0x0000018c},
	{0x000010b0, 0x00000e60, 0x00001cc0, 0x00007c70, 0x00003e38},
	{0x000010f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00008014, 0x03e803e8, 0x07d007d0, 0x10801600, 0x08400b00},
	{0x0000801c, 0x128d8027, 0x128d804f, 0x12e00057, 0x12e0002b},
	{0x00008120, 0x08f04800, 0x08f04800, 0x08f04810, 0x08f04810},
	{0x000081d0, 0x00003210, 0x00003210, 0x0000320a, 0x0000320a},
	{0x00008318, 0x00003e80, 0x00007d00, 0x00006880, 0x00003440},
	{0x00009804, 0x00000300, 0x000003c4, 0x000003c4, 0x00000300},
	{0x00009820, 0x02020200, 0x02020200, 0x02020200, 0x02020200},
	{0x00009824, 0x01000e0e, 0x01000e0e, 0x01000e0e, 0x01000e0e},
	{0x00009828, 0x0a020001, 0x0a020001, 0x0a020001, 0x0a020001},
	{0x00009834, 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e},
	{0x00009838, 0x00000007, 0x00000007, 0x00000007, 0x00000007},
	{0x00009840, 0x206a022e, 0x206a022e, 0x206a012e, 0x206a012e},
	{0x00009844, 0x0372161e, 0x0372161e, 0x037216a0, 0x037216a0},
	{0x00009850, 0x6c4000e2, 0x6d4000e2, 0x6d4000e2, 0x6c4000e2},
	{0x00009858, 0x7ec88d2e, 0x7ec88d2e, 0x7ec84d2e, 0x7ec84d2e},
	{0x0000985c, 0x31395d5e, 0x3139605e, 0x3139605e, 0x31395d5e},
	{0x00009860, 0x00048d18, 0x00048d18, 0x00048d20, 0x00048d20},
	{0x00009864, 0x0001ce00, 0x0001ce00, 0x0001ce00, 0x0001ce00},
	{0x00009868, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0},
	{0x0000986c, 0x06903081, 0x06903081, 0x06903881, 0x06903881},
	{0x00009914, 0x000007d0, 0x00000fa0, 0x00001130, 0x00000898},
	{0x00009918, 0x0000000a, 0x00000014, 0x00000268, 0x0000000b},
	{0x00009924, 0xd00a8a0b, 0xd00a8a0b, 0xd00a8a0d, 0xd00a8a0d},
	{0x00009944, 0xffbc1010, 0xffbc1010, 0xffbc1010, 0xffbc1010},
	{0x00009960, 0x00000010, 0x00000010, 0x00000010, 0x00000010},
	{0x0000a960, 0x00000010, 0x00000010, 0x00000010, 0x00000010},
	{0x00009964, 0x00000210, 0x00000210, 0x00000210, 0x00000210},
	{0x0000c968, 0x000003b5, 0x000003b5, 0x000003ce, 0x000003ce},
	{0x000099b8, 0x0000001c, 0x0000001c, 0x0000001c, 0x0000001c},
	{0x000099bc, 0x00000a00, 0x00000a00, 0x00000c00, 0x00000c00},
	{0x000099c0, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4},
	{0x0000a204, 0x00000444, 0x00000444, 0x00000444, 0x00000444},
	{0x0000a20c, 0x00000014, 0x00000014, 0x0001f019, 0x0001f019},
	{0x0000b20c, 0x00000014, 0x00000014, 0x0001f019, 0x0001f019},
	{0x0000a21c, 0x1883800a, 0x1883800a, 0x1883800a, 0x1883800a},
	{0x0000a230, 0x00000000, 0x00000000, 0x00000210, 0x00000108},
	{0x0000a23c, 0x13c88000, 0x13c88000, 0x13c88001, 0x13c88000},
	{0x0000a250, 0x001ff000, 0x001ff000, 0x0004a000, 0x0004a000},
	{0x0000a358, 0x7999aa02, 0x7999aa02, 0x7999aa0e, 0x7999aa0e},
	{0x0000a388, 0x0c000000, 0x0c000000, 0x08000000, 0x0c000000},
	{0x0000a3d8, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00007894, 0x5a508000, 0x5a508000, 0x5a508000, 0x5a508000},
};

static const u32 ar9280Common_9280_2[][2] = {
	/* Addr      allmodes  */
	{0x0000000c, 0x00000000},
	{0x00000030, 0x00020015},
	{0x00000034, 0x00000005},
	{0x00000040, 0x00000000},
	{0x00000044, 0x00000008},
	{0x00000048, 0x00000008},
	{0x0000004c, 0x00000010},
	{0x00000050, 0x00000000},
	{0x00000054, 0x0000001f},
	{0x00000800, 0x00000000},
	{0x00000804, 0x00000000},
	{0x00000808, 0x00000000},
	{0x0000080c, 0x00000000},
	{0x00000810, 0x00000000},
	{0x00000814, 0x00000000},
	{0x00000818, 0x00000000},
	{0x0000081c, 0x00000000},
	{0x00000820, 0x00000000},
	{0x00000824, 0x00000000},
	{0x00001040, 0x002ffc0f},
	{0x00001044, 0x002ffc0f},
	{0x00001048, 0x002ffc0f},
	{0x0000104c, 0x002ffc0f},
	{0x00001050, 0x002ffc0f},
	{0x00001054, 0x002ffc0f},
	{0x00001058, 0x002ffc0f},
	{0x0000105c, 0x002ffc0f},
	{0x00001060, 0x002ffc0f},
	{0x00001064, 0x002ffc0f},
	{0x00001230, 0x00000000},
	{0x00001270, 0x00000000},
	{0x00001038, 0x00000000},
	{0x00001078, 0x00000000},
	{0x000010b8, 0x00000000},
	{0x000010f8, 0x00000000},
	{0x00001138, 0x00000000},
	{0x00001178, 0x00000000},
	{0x000011b8, 0x00000000},
	{0x000011f8, 0x00000000},
	{0x00001238, 0x00000000},
	{0x00001278, 0x00000000},
	{0x000012b8, 0x00000000},
	{0x000012f8, 0x00000000},
	{0x00001338, 0x00000000},
	{0x00001378, 0x00000000},
	{0x000013b8, 0x00000000},
	{0x000013f8, 0x00000000},
	{0x00001438, 0x00000000},
	{0x00001478, 0x00000000},
	{0x000014b8, 0x00000000},
	{0x000014f8, 0x00000000},
	{0x00001538, 0x00000000},
	{0x00001578, 0x00000000},
	{0x000015b8, 0x00000000},
	{0x000015f8, 0x00000000},
	{0x00001638, 0x00000000},
	{0x00001678, 0x00000000},
	{0x000016b8, 0x00000000},
	{0x000016f8, 0x00000000},
	{0x00001738, 0x00000000},
	{0x00001778, 0x00000000},
	{0x000017b8, 0x00000000},
	{0x000017f8, 0x00000000},
	{0x0000103c, 0x00000000},
	{0x0000107c, 0x00000000},
	{0x000010bc, 0x00000000},
	{0x000010fc, 0x00000000},
	{0x0000113c, 0x00000000},
	{0x0000117c, 0x00000000},
	{0x000011bc, 0x00000000},
	{0x000011fc, 0x00000000},
	{0x0000123c, 0x00000000},
	{0x0000127c, 0x00000000},
	{0x000012bc, 0x00000000},
	{0x000012fc, 0x00000000},
	{0x0000133c, 0x00000000},
	{0x0000137c, 0x00000000},
	{0x000013bc, 0x00000000},
	{0x000013fc, 0x00000000},
	{0x0000143c, 0x00000000},
	{0x0000147c, 0x00000000},
	{0x00004030, 0x00000002},
	{0x0000403c, 0x00000002},
	{0x00004024, 0x0000001f},
	{0x00004060, 0x00000000},
	{0x00004064, 0x00000000},
	{0x00007010, 0x00000033},
	{0x00007034, 0x00000002},
	{0x00007038, 0x000004c2},
	{0x00008004, 0x00000000},
	{0x00008008, 0x00000000},
	{0x0000800c, 0x00000000},
	{0x00008018, 0x00000700},
	{0x00008020, 0x00000000},
	{0x00008038, 0x00000000},
	{0x0000803c, 0x00000000},
	{0x00008048, 0x40000000},
	{0x00008054, 0x00000000},
	{0x00008058, 0x00000000},
	{0x0000805c, 0x000fc78f},
	{0x00008060, 0x0000000f},
	{0x00008064, 0x00000000},
	{0x00008070, 0x00000000},
	{0x000080c0, 0x2a80001a},
	{0x000080c4, 0x05dc01e0},
	{0x000080c8, 0x1f402710},
	{0x000080cc, 0x01f40000},
	{0x000080d0, 0x00001e00},
	{0x000080d4, 0x00000000},
	{0x000080d8, 0x00400000},
	{0x000080e0, 0xffffffff},
	{0x000080e4, 0x0000ffff},
	{0x000080e8, 0x003f3f3f},
	{0x000080ec, 0x00000000},
	{0x000080f0, 0x00000000},
	{0x000080f4, 0x00000000},
	{0x000080f8, 0x00000000},
	{0x000080fc, 0x00020000},
	{0x00008100, 0x00020000},
	{0x00008104, 0x00000001},
	{0x00008108, 0x00000052},
	{0x0000810c, 0x00000000},
	{0x00008110, 0x00000168},
	{0x00008118, 0x000100aa},
	{0x0000811c, 0x00003210},
	{0x00008124, 0x00000000},
	{0x00008128, 0x00000000},
	{0x0000812c, 0x00000000},
	{0x00008130, 0x00000000},
	{0x00008134, 0x00000000},
	{0x00008138, 0x00000000},
	{0x0000813c, 0x00000000},
	{0x00008144, 0xffffffff},
	{0x00008168, 0x00000000},
	{0x0000816c, 0x00000000},
	{0x00008170, 0x32143320},
	{0x00008174, 0xfaa4fa50},
	{0x00008178, 0x00000100},
	{0x0000817c, 0x00000000},
	{0x000081c0, 0x00000000},
	{0x000081ec, 0x00000000},
	{0x000081f0, 0x00000000},
	{0x000081f4, 0x00000000},
	{0x000081f8, 0x00000000},
	{0x000081fc, 0x00000000},
	{0x00008200, 0x00000000},
	{0x00008204, 0x00000000},
	{0x00008208, 0x00000000},
	{0x0000820c, 0x00000000},
	{0x00008210, 0x00000000},
	{0x00008214, 0x00000000},
	{0x00008218, 0x00000000},
	{0x0000821c, 0x00000000},
	{0x00008220, 0x00000000},
	{0x00008224, 0x00000000},
	{0x00008228, 0x00000000},
	{0x0000822c, 0x00000000},
	{0x00008230, 0x00000000},
	{0x00008234, 0x00000000},
	{0x00008238, 0x00000000},
	{0x0000823c, 0x00000000},
	{0x00008240, 0x00100000},
	{0x00008244, 0x0010f400},
	{0x00008248, 0x00000100},
	{0x0000824c, 0x0001e800},
	{0x00008250, 0x00000000},
	{0x00008254, 0x00000000},
	{0x00008258, 0x00000000},
	{0x0000825c, 0x400000ff},
	{0x00008260, 0x00080922},
	{0x00008264, 0x88a00010},
	{0x00008270, 0x00000000},
	{0x00008274, 0x40000000},
	{0x00008278, 0x003e4180},
	{0x0000827c, 0x00000000},
	{0x00008284, 0x0000002c},
	{0x00008288, 0x0000002c},
	{0x0000828c, 0x00000000},
	{0x00008294, 0x00000000},
	{0x00008298, 0x00000000},
	{0x0000829c, 0x00000000},
	{0x00008300, 0x00000040},
	{0x00008314, 0x00000000},
	{0x00008328, 0x00000000},
	{0x0000832c, 0x00000007},
	{0x00008330, 0x00000302},
	{0x00008334, 0x00000e00},
	{0x00008338, 0x00ff0000},
	{0x0000833c, 0x00000000},
	{0x00008340, 0x000107ff},
	{0x00008344, 0x00481043},
	{0x00009808, 0x00000000},
	{0x0000980c, 0xafa68e30},
	{0x00009810, 0xfd14e000},
	{0x00009814, 0x9c0a9f6b},
	{0x0000981c, 0x00000000},
	{0x0000982c, 0x0000a000},
	{0x00009830, 0x00000000},
	{0x0000983c, 0x00200400},
	{0x0000984c, 0x0040233c},
	{0x0000a84c, 0x0040233c},
	{0x00009854, 0x00000044},
	{0x00009900, 0x00000000},
	{0x00009904, 0x00000000},
	{0x00009908, 0x00000000},
	{0x0000990c, 0x00000000},
	{0x00009910, 0x01002310},
	{0x0000991c, 0x10000fff},
	{0x00009920, 0x04900000},
	{0x0000a920, 0x04900000},
	{0x00009928, 0x00000001},
	{0x0000992c, 0x00000004},
	{0x00009934, 0x1e1f2022},
	{0x00009938, 0x0a0b0c0d},
	{0x0000993c, 0x00000000},
	{0x00009948, 0x9280c00a},
	{0x0000994c, 0x00020028},
	{0x00009954, 0x5f3ca3de},
	{0x00009958, 0x2108ecff},
	{0x00009940, 0x14750604},
	{0x0000c95c, 0x004b6a8e},
	{0x00009970, 0x190fb514},
	{0x00009974, 0x00000000},
	{0x00009978, 0x00000001},
	{0x0000997c, 0x00000000},
	{0x00009980, 0x00000000},
	{0x00009984, 0x00000000},
	{0x00009988, 0x00000000},
	{0x0000998c, 0x00000000},
	{0x00009990, 0x00000000},
	{0x00009994, 0x00000000},
	{0x00009998, 0x00000000},
	{0x0000999c, 0x00000000},
	{0x000099a0, 0x00000000},
	{0x000099a4, 0x00000001},
	{0x000099a8, 0x201fff00},
	{0x000099ac, 0x006f0000},
	{0x000099b0, 0x03051000},
	{0x000099b4, 0x00000820},
	{0x000099c4, 0x06336f77},
	{0x000099c8, 0x6af6532f},
	{0x000099cc, 0x08f186c8},
	{0x000099d0, 0x00046384},
	{0x000099d4, 0x00000000},
	{0x000099d8, 0x00000000},
	{0x000099dc, 0x00000000},
	{0x000099e0, 0x00000000},
	{0x000099e4, 0xaaaaaaaa},
	{0x000099e8, 0x3c466478},
	{0x000099ec, 0x0cc80caa},
	{0x000099f0, 0x00000000},
	{0x000099fc, 0x00001042},
	{0x0000a208, 0x803e4788},
	{0x0000a210, 0x4080a333},
	{0x0000a214, 0x40206c10},
	{0x0000a218, 0x009c4060},
	{0x0000a220, 0x01834061},
	{0x0000a224, 0x00000400},
	{0x0000a228, 0x000003b5},
	{0x0000a22c, 0x233f7180},
	{0x0000a234, 0x20202020},
	{0x0000a238, 0x20202020},
	{0x0000a240, 0x38490a20},
	{0x0000a244, 0x00007bb6},
	{0x0000a248, 0x0fff3ffc},
	{0x0000a24c, 0x00000000},
	{0x0000a254, 0x00000000},
	{0x0000a258, 0x0cdbd380},
	{0x0000a25c, 0x0f0f0f01},
	{0x0000a260, 0xdfa91f01},
	{0x0000a268, 0x00000000},
	{0x0000a26c, 0x0e79e5c6},
	{0x0000b26c, 0x0e79e5c6},
	{0x0000d270, 0x00820820},
	{0x0000a278, 0x1ce739ce},
	{0x0000d35c, 0x07ffffef},
	{0x0000d360, 0x0fffffe7},
	{0x0000d364, 0x17ffffe5},
	{0x0000d368, 0x1fffffe4},
	{0x0000d36c, 0x37ffffe3},
	{0x0000d370, 0x3fffffe3},
	{0x0000d374, 0x57ffffe3},
	{0x0000d378, 0x5fffffe2},
	{0x0000d37c, 0x7fffffe2},
	{0x0000d380, 0x7f3c7bba},
	{0x0000d384, 0xf3307ff0},
	{0x0000a38c, 0x20202020},
	{0x0000a390, 0x20202020},
	{0x0000a394, 0x1ce739ce},
	{0x0000a398, 0x000001ce},
	{0x0000a39c, 0x00000001},
	{0x0000a3a0, 0x00000000},
	{0x0000a3a4, 0x00000000},
	{0x0000a3a8, 0x00000000},
	{0x0000a3ac, 0x00000000},
	{0x0000a3b0, 0x00000000},
	{0x0000a3b4, 0x00000000},
	{0x0000a3b8, 0x00000000},
	{0x0000a3bc, 0x00000000},
	{0x0000a3c0, 0x00000000},
	{0x0000a3c4, 0x00000000},
	{0x0000a3c8, 0x00000246},
	{0x0000a3cc, 0x20202020},
	{0x0000a3d0, 0x20202020},
	{0x0000a3d4, 0x20202020},
	{0x0000a3dc, 0x1ce739ce},
	{0x0000a3e0, 0x000001ce},
	{0x0000a3e4, 0x00000000},
	{0x0000a3e8, 0x18c43433},
	{0x00007800, 0x00040000},
	{0x00007804, 0xdb005012},
	{0x00007808, 0x04924914},
	{0x0000780c, 0x21084210},
	{0x00007810, 0x6d801300},
	{0x00007818, 0x07e41000},
	{0x00007824, 0x00040000},
	{0x00007828, 0xdb005012},
	{0x0000782c, 0x04924914},
	{0x00007830, 0x21084210},
	{0x00007834, 0x6d801300},
	{0x0000783c, 0x07e40000},
	{0x00007848, 0x00100000},
	{0x0000784c, 0x773f0567},
	{0x00007850, 0x54214514},
	{0x00007854, 0x12035828},
	{0x00007858, 0x9259269a},
	{0x00007860, 0x52802000},
	{0x00007864, 0x0a8e370e},
	{0x00007868, 0xc0102850},
	{0x0000786c, 0x812d4000},
	{0x00007870, 0x807ec400},
	{0x00007874, 0x001b6db0},
	{0x00007878, 0x00376b63},
	{0x0000787c, 0x06db6db6},
	{0x00007880, 0x006d8000},
	{0x00007884, 0xffeffffe},
	{0x00007888, 0xffeffffe},
	{0x0000788c, 0x00010000},
	{0x00007890, 0x02060aeb},
	{0x00007898, 0x2a850160},
};

static const u32 ar9280Modes_fast_clock_9280_2[][3] = {
	/* Addr      5G_HT20     5G_HT40   */
	{0x00001030, 0x00000268, 0x000004d0},
	{0x00001070, 0x0000018c, 0x00000318},
	{0x000010b0, 0x00000fd0, 0x00001fa0},
	{0x00008014, 0x044c044c, 0x08980898},
	{0x0000801c, 0x148ec02b, 0x148ec057},
	{0x00008318, 0x000044c0, 0x00008980},
	{0x00009820, 0x02020200, 0x02020200},
	{0x00009824, 0x01000f0f, 0x01000f0f},
	{0x00009828, 0x0b020001, 0x0b020001},
	{0x00009834, 0x00000f0f, 0x00000f0f},
	{0x00009844, 0x03721821, 0x03721821},
	{0x00009914, 0x00000898, 0x00001130},
	{0x00009918, 0x0000000b, 0x00000016},
};

static const u32 ar9280Modes_backoff_23db_rxgain_9280_2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00009a00, 0x00008184, 0x00008184, 0x00000290, 0x00000290},
	{0x00009a04, 0x00008188, 0x00008188, 0x00000300, 0x00000300},
	{0x00009a08, 0x0000818c, 0x0000818c, 0x00000304, 0x00000304},
	{0x00009a0c, 0x00008190, 0x00008190, 0x00000308, 0x00000308},
	{0x00009a10, 0x00008194, 0x00008194, 0x0000030c, 0x0000030c},
	{0x00009a14, 0x00008200, 0x00008200, 0x00008000, 0x00008000},
	{0x00009a18, 0x00008204, 0x00008204, 0x00008004, 0x00008004},
	{0x00009a1c, 0x00008208, 0x00008208, 0x00008008, 0x00008008},
	{0x00009a20, 0x0000820c, 0x0000820c, 0x0000800c, 0x0000800c},
	{0x00009a24, 0x00008210, 0x00008210, 0x00008080, 0x00008080},
	{0x00009a28, 0x00008214, 0x00008214, 0x00008084, 0x00008084},
	{0x00009a2c, 0x00008280, 0x00008280, 0x00008088, 0x00008088},
	{0x00009a30, 0x00008284, 0x00008284, 0x0000808c, 0x0000808c},
	{0x00009a34, 0x00008288, 0x00008288, 0x00008100, 0x00008100},
	{0x00009a38, 0x0000828c, 0x0000828c, 0x00008104, 0x00008104},
	{0x00009a3c, 0x00008290, 0x00008290, 0x00008108, 0x00008108},
	{0x00009a40, 0x00008300, 0x00008300, 0x0000810c, 0x0000810c},
	{0x00009a44, 0x00008304, 0x00008304, 0x00008110, 0x00008110},
	{0x00009a48, 0x00008308, 0x00008308, 0x00008114, 0x00008114},
	{0x00009a4c, 0x0000830c, 0x0000830c, 0x00008180, 0x00008180},
	{0x00009a50, 0x00008310, 0x00008310, 0x00008184, 0x00008184},
	{0x00009a54, 0x00008314, 0x00008314, 0x00008188, 0x00008188},
	{0x00009a58, 0x00008380, 0x00008380, 0x0000818c, 0x0000818c},
	{0x00009a5c, 0x00008384, 0x00008384, 0x00008190, 0x00008190},
	{0x00009a60, 0x00008388, 0x00008388, 0x00008194, 0x00008194},
	{0x00009a64, 0x0000838c, 0x0000838c, 0x000081a0, 0x000081a0},
	{0x00009a68, 0x00008390, 0x00008390, 0x0000820c, 0x0000820c},
	{0x00009a6c, 0x00008394, 0x00008394, 0x000081a8, 0x000081a8},
	{0x00009a70, 0x0000a380, 0x0000a380, 0x00008284, 0x00008284},
	{0x00009a74, 0x0000a384, 0x0000a384, 0x00008288, 0x00008288},
	{0x00009a78, 0x0000a388, 0x0000a388, 0x00008224, 0x00008224},
	{0x00009a7c, 0x0000a38c, 0x0000a38c, 0x00008290, 0x00008290},
	{0x00009a80, 0x0000a390, 0x0000a390, 0x00008300, 0x00008300},
	{0x00009a84, 0x0000a394, 0x0000a394, 0x00008304, 0x00008304},
	{0x00009a88, 0x0000a780, 0x0000a780, 0x00008308, 0x00008308},
	{0x00009a8c, 0x0000a784, 0x0000a784, 0x0000830c, 0x0000830c},
	{0x00009a90, 0x0000a788, 0x0000a788, 0x00008380, 0x00008380},
	{0x00009a94, 0x0000a78c, 0x0000a78c, 0x00008384, 0x00008384},
	{0x00009a98, 0x0000a790, 0x0000a790, 0x00008700, 0x00008700},
	{0x00009a9c, 0x0000a794, 0x0000a794, 0x00008704, 0x00008704},
	{0x00009aa0, 0x0000ab84, 0x0000ab84, 0x00008708, 0x00008708},
	{0x00009aa4, 0x0000ab88, 0x0000ab88, 0x0000870c, 0x0000870c},
	{0x00009aa8, 0x0000ab8c, 0x0000ab8c, 0x00008780, 0x00008780},
	{0x00009aac, 0x0000ab90, 0x0000ab90, 0x00008784, 0x00008784},
	{0x00009ab0, 0x0000ab94, 0x0000ab94, 0x00008b00, 0x00008b00},
	{0x00009ab4, 0x0000af80, 0x0000af80, 0x00008b04, 0x00008b04},
	{0x00009ab8, 0x0000af84, 0x0000af84, 0x00008b08, 0x00008b08},
	{0x00009abc, 0x0000af88, 0x0000af88, 0x00008b0c, 0x00008b0c},
	{0x00009ac0, 0x0000af8c, 0x0000af8c, 0x00008b10, 0x00008b10},
	{0x00009ac4, 0x0000af90, 0x0000af90, 0x00008b80, 0x00008b80},
	{0x00009ac8, 0x0000af94, 0x0000af94, 0x00008b84, 0x00008b84},
	{0x00009acc, 0x0000b380, 0x0000b380, 0x00008b88, 0x00008b88},
	{0x00009ad0, 0x0000b384, 0x0000b384, 0x00008b8c, 0x00008b8c},
	{0x00009ad4, 0x0000b388, 0x0000b388, 0x00008b90, 0x00008b90},
	{0x00009ad8, 0x0000b38c, 0x0000b38c, 0x00008b94, 0x00008b94},
	{0x00009adc, 0x0000b390, 0x0000b390, 0x00008b98, 0x00008b98},
	{0x00009ae0, 0x0000b394, 0x0000b394, 0x00008ba4, 0x00008ba4},
	{0x00009ae4, 0x0000b398, 0x0000b398, 0x00008ba8, 0x00008ba8},
	{0x00009ae8, 0x0000b780, 0x0000b780, 0x00008bac, 0x00008bac},
	{0x00009aec, 0x0000b784, 0x0000b784, 0x00008bb0, 0x00008bb0},
	{0x00009af0, 0x0000b788, 0x0000b788, 0x00008bb4, 0x00008bb4},
	{0x00009af4, 0x0000b78c, 0x0000b78c, 0x00008ba1, 0x00008ba1},
	{0x00009af8, 0x0000b790, 0x0000b790, 0x00008ba5, 0x00008ba5},
	{0x00009afc, 0x0000b794, 0x0000b794, 0x00008ba9, 0x00008ba9},
	{0x00009b00, 0x0000b798, 0x0000b798, 0x00008bad, 0x00008bad},
	{0x00009b04, 0x0000d784, 0x0000d784, 0x00008bb1, 0x00008bb1},
	{0x00009b08, 0x0000d788, 0x0000d788, 0x00008bb5, 0x00008bb5},
	{0x00009b0c, 0x0000d78c, 0x0000d78c, 0x00008ba2, 0x00008ba2},
	{0x00009b10, 0x0000d790, 0x0000d790, 0x00008ba6, 0x00008ba6},
	{0x00009b14, 0x0000f780, 0x0000f780, 0x00008baa, 0x00008baa},
	{0x00009b18, 0x0000f784, 0x0000f784, 0x00008bae, 0x00008bae},
	{0x00009b1c, 0x0000f788, 0x0000f788, 0x00008bb2, 0x00008bb2},
	{0x00009b20, 0x0000f78c, 0x0000f78c, 0x00008bb6, 0x00008bb6},
	{0x00009b24, 0x0000f790, 0x0000f790, 0x00008ba3, 0x00008ba3},
	{0x00009b28, 0x0000f794, 0x0000f794, 0x00008ba7, 0x00008ba7},
	{0x00009b2c, 0x0000f7a4, 0x0000f7a4, 0x00008bab, 0x00008bab},
	{0x00009b30, 0x0000f7a8, 0x0000f7a8, 0x00008baf, 0x00008baf},
	{0x00009b34, 0x0000f7ac, 0x0000f7ac, 0x00008bb3, 0x00008bb3},
	{0x00009b38, 0x0000f7b0, 0x0000f7b0, 0x00008bb7, 0x00008bb7},
	{0x00009b3c, 0x0000f7b4, 0x0000f7b4, 0x00008bc3, 0x00008bc3},
	{0x00009b40, 0x0000f7a1, 0x0000f7a1, 0x00008bc7, 0x00008bc7},
	{0x00009b44, 0x0000f7a5, 0x0000f7a5, 0x00008bcb, 0x00008bcb},
	{0x00009b48, 0x0000f7a9, 0x0000f7a9, 0x00008bcf, 0x00008bcf},
	{0x00009b4c, 0x0000f7ad, 0x0000f7ad, 0x00008bd3, 0x00008bd3},
	{0x00009b50, 0x0000f7b1, 0x0000f7b1, 0x00008bd7, 0x00008bd7},
	{0x00009b54, 0x0000f7b5, 0x0000f7b5, 0x00008bdb, 0x00008bdb},
	{0x00009b58, 0x0000f7c5, 0x0000f7c5, 0x00008bdb, 0x00008bdb},
	{0x00009b5c, 0x0000f7c9, 0x0000f7c9, 0x00008bdb, 0x00008bdb},
	{0x00009b60, 0x0000f7cd, 0x0000f7cd, 0x00008bdb, 0x00008bdb},
	{0x00009b64, 0x0000f7d1, 0x0000f7d1, 0x00008bdb, 0x00008bdb},
	{0x00009b68, 0x0000f7d5, 0x0000f7d5, 0x00008bdb, 0x00008bdb},
	{0x00009b6c, 0x0000f7c2, 0x0000f7c2, 0x00008bdb, 0x00008bdb},
	{0x00009b70, 0x0000f7c6, 0x0000f7c6, 0x00008bdb, 0x00008bdb},
	{0x00009b74, 0x0000f7ca, 0x0000f7ca, 0x00008bdb, 0x00008bdb},
	{0x00009b78, 0x0000f7ce, 0x0000f7ce, 0x00008bdb, 0x00008bdb},
	{0x00009b7c, 0x0000f7d2, 0x0000f7d2, 0x00008bdb, 0x00008bdb},
	{0x00009b80, 0x0000f7d6, 0x0000f7d6, 0x00008bdb, 0x00008bdb},
	{0x00009b84, 0x0000f7c3, 0x0000f7c3, 0x00008bdb, 0x00008bdb},
	{0x00009b88, 0x0000f7c7, 0x0000f7c7, 0x00008bdb, 0x00008bdb},
	{0x00009b8c, 0x0000f7cb, 0x0000f7cb, 0x00008bdb, 0x00008bdb},
	{0x00009b90, 0x0000f7d3, 0x0000f7d3, 0x00008bdb, 0x00008bdb},
	{0x00009b94, 0x0000f7d7, 0x0000f7d7, 0x00008bdb, 0x00008bdb},
	{0x00009b98, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009b9c, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009ba0, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009ba4, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009ba8, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bac, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bb0, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bb4, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bb8, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bbc, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bc0, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bc4, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bc8, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bcc, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bd0, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bd4, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bd8, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bdc, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009be0, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009be4, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009be8, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bec, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bf0, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bf4, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bf8, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009bfc, 0x0000f7db, 0x0000f7db, 0x00008bdb, 0x00008bdb},
	{0x00009848, 0x00001066, 0x00001066, 0x00001055, 0x00001055},
	{0x0000a848, 0x00001066, 0x00001066, 0x00001055, 0x00001055},
};

static const u32 ar9280Modes_original_rxgain_9280_2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00009a00, 0x00008184, 0x00008184, 0x00008000, 0x00008000},
	{0x00009a04, 0x00008188, 0x00008188, 0x00008000, 0x00008000},
	{0x00009a08, 0x0000818c, 0x0000818c, 0x00008000, 0x00008000},
	{0x00009a0c, 0x00008190, 0x00008190, 0x00008000, 0x00008000},
	{0x00009a10, 0x00008194, 0x00008194, 0x00008000, 0x00008000},
	{0x00009a14, 0x00008200, 0x00008200, 0x00008000, 0x00008000},
	{0x00009a18, 0x00008204, 0x00008204, 0x00008004, 0x00008004},
	{0x00009a1c, 0x00008208, 0x00008208, 0x00008008, 0x00008008},
	{0x00009a20, 0x0000820c, 0x0000820c, 0x0000800c, 0x0000800c},
	{0x00009a24, 0x00008210, 0x00008210, 0x00008080, 0x00008080},
	{0x00009a28, 0x00008214, 0x00008214, 0x00008084, 0x00008084},
	{0x00009a2c, 0x00008280, 0x00008280, 0x00008088, 0x00008088},
	{0x00009a30, 0x00008284, 0x00008284, 0x0000808c, 0x0000808c},
	{0x00009a34, 0x00008288, 0x00008288, 0x00008100, 0x00008100},
	{0x00009a38, 0x0000828c, 0x0000828c, 0x00008104, 0x00008104},
	{0x00009a3c, 0x00008290, 0x00008290, 0x00008108, 0x00008108},
	{0x00009a40, 0x00008300, 0x00008300, 0x0000810c, 0x0000810c},
	{0x00009a44, 0x00008304, 0x00008304, 0x00008110, 0x00008110},
	{0x00009a48, 0x00008308, 0x00008308, 0x00008114, 0x00008114},
	{0x00009a4c, 0x0000830c, 0x0000830c, 0x00008180, 0x00008180},
	{0x00009a50, 0x00008310, 0x00008310, 0x00008184, 0x00008184},
	{0x00009a54, 0x00008314, 0x00008314, 0x00008188, 0x00008188},
	{0x00009a58, 0x00008380, 0x00008380, 0x0000818c, 0x0000818c},
	{0x00009a5c, 0x00008384, 0x00008384, 0x00008190, 0x00008190},
	{0x00009a60, 0x00008388, 0x00008388, 0x00008194, 0x00008194},
	{0x00009a64, 0x0000838c, 0x0000838c, 0x000081a0, 0x000081a0},
	{0x00009a68, 0x00008390, 0x00008390, 0x0000820c, 0x0000820c},
	{0x00009a6c, 0x00008394, 0x00008394, 0x000081a8, 0x000081a8},
	{0x00009a70, 0x0000a380, 0x0000a380, 0x00008284, 0x00008284},
	{0x00009a74, 0x0000a384, 0x0000a384, 0x00008288, 0x00008288},
	{0x00009a78, 0x0000a388, 0x0000a388, 0x00008224, 0x00008224},
	{0x00009a7c, 0x0000a38c, 0x0000a38c, 0x00008290, 0x00008290},
	{0x00009a80, 0x0000a390, 0x0000a390, 0x00008300, 0x00008300},
	{0x00009a84, 0x0000a394, 0x0000a394, 0x00008304, 0x00008304},
	{0x00009a88, 0x0000a780, 0x0000a780, 0x00008308, 0x00008308},
	{0x00009a8c, 0x0000a784, 0x0000a784, 0x0000830c, 0x0000830c},
	{0x00009a90, 0x0000a788, 0x0000a788, 0x00008380, 0x00008380},
	{0x00009a94, 0x0000a78c, 0x0000a78c, 0x00008384, 0x00008384},
	{0x00009a98, 0x0000a790, 0x0000a790, 0x00008700, 0x00008700},
	{0x00009a9c, 0x0000a794, 0x0000a794, 0x00008704, 0x00008704},
	{0x00009aa0, 0x0000ab84, 0x0000ab84, 0x00008708, 0x00008708},
	{0x00009aa4, 0x0000ab88, 0x0000ab88, 0x0000870c, 0x0000870c},
	{0x00009aa8, 0x0000ab8c, 0x0000ab8c, 0x00008780, 0x00008780},
	{0x00009aac, 0x0000ab90, 0x0000ab90, 0x00008784, 0x00008784},
	{0x00009ab0, 0x0000ab94, 0x0000ab94, 0x00008b00, 0x00008b00},
	{0x00009ab4, 0x0000af80, 0x0000af80, 0x00008b04, 0x00008b04},
	{0x00009ab8, 0x0000af84, 0x0000af84, 0x00008b08, 0x00008b08},
	{0x00009abc, 0x0000af88, 0x0000af88, 0x00008b0c, 0x00008b0c},
	{0x00009ac0, 0x0000af8c, 0x0000af8c, 0x00008b80, 0x00008b80},
	{0x00009ac4, 0x0000af90, 0x0000af90, 0x00008b84, 0x00008b84},
	{0x00009ac8, 0x0000af94, 0x0000af94, 0x00008b88, 0x00008b88},
	{0x00009acc, 0x0000b380, 0x0000b380, 0x00008b8c, 0x00008b8c},
	{0x00009ad0, 0x0000b384, 0x0000b384, 0x00008b90, 0x00008b90},
	{0x00009ad4, 0x0000b388, 0x0000b388, 0x00008f80, 0x00008f80},
	{0x00009ad8, 0x0000b38c, 0x0000b38c, 0x00008f84, 0x00008f84},
	{0x00009adc, 0x0000b390, 0x0000b390, 0x00008f88, 0x00008f88},
	{0x00009ae0, 0x0000b394, 0x0000b394, 0x00008f8c, 0x00008f8c},
	{0x00009ae4, 0x0000b398, 0x0000b398, 0x00008f90, 0x00008f90},
	{0x00009ae8, 0x0000b780, 0x0000b780, 0x0000930c, 0x0000930c},
	{0x00009aec, 0x0000b784, 0x0000b784, 0x00009310, 0x00009310},
	{0x00009af0, 0x0000b788, 0x0000b788, 0x00009384, 0x00009384},
	{0x00009af4, 0x0000b78c, 0x0000b78c, 0x00009388, 0x00009388},
	{0x00009af8, 0x0000b790, 0x0000b790, 0x00009324, 0x00009324},
	{0x00009afc, 0x0000b794, 0x0000b794, 0x00009704, 0x00009704},
	{0x00009b00, 0x0000b798, 0x0000b798, 0x000096a4, 0x000096a4},
	{0x00009b04, 0x0000d784, 0x0000d784, 0x000096a8, 0x000096a8},
	{0x00009b08, 0x0000d788, 0x0000d788, 0x00009710, 0x00009710},
	{0x00009b0c, 0x0000d78c, 0x0000d78c, 0x00009714, 0x00009714},
	{0x00009b10, 0x0000d790, 0x0000d790, 0x00009720, 0x00009720},
	{0x00009b14, 0x0000f780, 0x0000f780, 0x00009724, 0x00009724},
	{0x00009b18, 0x0000f784, 0x0000f784, 0x00009728, 0x00009728},
	{0x00009b1c, 0x0000f788, 0x0000f788, 0x0000972c, 0x0000972c},
	{0x00009b20, 0x0000f78c, 0x0000f78c, 0x000097a0, 0x000097a0},
	{0x00009b24, 0x0000f790, 0x0000f790, 0x000097a4, 0x000097a4},
	{0x00009b28, 0x0000f794, 0x0000f794, 0x000097a8, 0x000097a8},
	{0x00009b2c, 0x0000f7a4, 0x0000f7a4, 0x000097b0, 0x000097b0},
	{0x00009b30, 0x0000f7a8, 0x0000f7a8, 0x000097b4, 0x000097b4},
	{0x00009b34, 0x0000f7ac, 0x0000f7ac, 0x000097b8, 0x000097b8},
	{0x00009b38, 0x0000f7b0, 0x0000f7b0, 0x000097a5, 0x000097a5},
	{0x00009b3c, 0x0000f7b4, 0x0000f7b4, 0x000097a9, 0x000097a9},
	{0x00009b40, 0x0000f7a1, 0x0000f7a1, 0x000097ad, 0x000097ad},
	{0x00009b44, 0x0000f7a5, 0x0000f7a5, 0x000097b1, 0x000097b1},
	{0x00009b48, 0x0000f7a9, 0x0000f7a9, 0x000097b5, 0x000097b5},
	{0x00009b4c, 0x0000f7ad, 0x0000f7ad, 0x000097b9, 0x000097b9},
	{0x00009b50, 0x0000f7b1, 0x0000f7b1, 0x000097c5, 0x000097c5},
	{0x00009b54, 0x0000f7b5, 0x0000f7b5, 0x000097c9, 0x000097c9},
	{0x00009b58, 0x0000f7c5, 0x0000f7c5, 0x000097d1, 0x000097d1},
	{0x00009b5c, 0x0000f7c9, 0x0000f7c9, 0x000097d5, 0x000097d5},
	{0x00009b60, 0x0000f7cd, 0x0000f7cd, 0x000097d9, 0x000097d9},
	{0x00009b64, 0x0000f7d1, 0x0000f7d1, 0x000097c6, 0x000097c6},
	{0x00009b68, 0x0000f7d5, 0x0000f7d5, 0x000097ca, 0x000097ca},
	{0x00009b6c, 0x0000f7c2, 0x0000f7c2, 0x000097ce, 0x000097ce},
	{0x00009b70, 0x0000f7c6, 0x0000f7c6, 0x000097d2, 0x000097d2},
	{0x00009b74, 0x0000f7ca, 0x0000f7ca, 0x000097d6, 0x000097d6},
	{0x00009b78, 0x0000f7ce, 0x0000f7ce, 0x000097c3, 0x000097c3},
	{0x00009b7c, 0x0000f7d2, 0x0000f7d2, 0x000097c7, 0x000097c7},
	{0x00009b80, 0x0000f7d6, 0x0000f7d6, 0x000097cb, 0x000097cb},
	{0x00009b84, 0x0000f7c3, 0x0000f7c3, 0x000097cf, 0x000097cf},
	{0x00009b88, 0x0000f7c7, 0x0000f7c7, 0x000097d7, 0x000097d7},
	{0x00009b8c, 0x0000f7cb, 0x0000f7cb, 0x000097db, 0x000097db},
	{0x00009b90, 0x0000f7d3, 0x0000f7d3, 0x000097db, 0x000097db},
	{0x00009b94, 0x0000f7d7, 0x0000f7d7, 0x000097db, 0x000097db},
	{0x00009b98, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009b9c, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009ba0, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009ba4, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009ba8, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bac, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bb0, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bb4, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bb8, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bbc, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bc0, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bc4, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bc8, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bcc, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bd0, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bd4, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bd8, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bdc, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009be0, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009be4, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009be8, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bec, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bf0, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bf4, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bf8, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009bfc, 0x0000f7db, 0x0000f7db, 0x000097db, 0x000097db},
	{0x00009848, 0x00001066, 0x00001066, 0x00001063, 0x00001063},
	{0x0000a848, 0x00001066, 0x00001066, 0x00001063, 0x00001063},
};

static const u32 ar9280Modes_backoff_13db_rxgain_9280_2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00009a00, 0x00008184, 0x00008184, 0x00000290, 0x00000290},
	{0x00009a04, 0x00008188, 0x00008188, 0x00000300, 0x00000300},
	{0x00009a08, 0x0000818c, 0x0000818c, 0x00000304, 0x00000304},
	{0x00009a0c, 0x00008190, 0x00008190, 0x00000308, 0x00000308},
	{0x00009a10, 0x00008194, 0x00008194, 0x0000030c, 0x0000030c},
	{0x00009a14, 0x00008200, 0x00008200, 0x00008000, 0x00008000},
	{0x00009a18, 0x00008204, 0x00008204, 0x00008004, 0x00008004},
	{0x00009a1c, 0x00008208, 0x00008208, 0x00008008, 0x00008008},
	{0x00009a20, 0x0000820c, 0x0000820c, 0x0000800c, 0x0000800c},
	{0x00009a24, 0x00008210, 0x00008210, 0x00008080, 0x00008080},
	{0x00009a28, 0x00008214, 0x00008214, 0x00008084, 0x00008084},
	{0x00009a2c, 0x00008280, 0x00008280, 0x00008088, 0x00008088},
	{0x00009a30, 0x00008284, 0x00008284, 0x0000808c, 0x0000808c},
	{0x00009a34, 0x00008288, 0x00008288, 0x00008100, 0x00008100},
	{0x00009a38, 0x0000828c, 0x0000828c, 0x00008104, 0x00008104},
	{0x00009a3c, 0x00008290, 0x00008290, 0x00008108, 0x00008108},
	{0x00009a40, 0x00008300, 0x00008300, 0x0000810c, 0x0000810c},
	{0x00009a44, 0x00008304, 0x00008304, 0x00008110, 0x00008110},
	{0x00009a48, 0x00008308, 0x00008308, 0x00008114, 0x00008114},
	{0x00009a4c, 0x0000830c, 0x0000830c, 0x00008180, 0x00008180},
	{0x00009a50, 0x00008310, 0x00008310, 0x00008184, 0x00008184},
	{0x00009a54, 0x00008314, 0x00008314, 0x00008188, 0x00008188},
	{0x00009a58, 0x00008380, 0x00008380, 0x0000818c, 0x0000818c},
	{0x00009a5c, 0x00008384, 0x00008384, 0x00008190, 0x00008190},
	{0x00009a60, 0x00008388, 0x00008388, 0x00008194, 0x00008194},
	{0x00009a64, 0x0000838c, 0x0000838c, 0x000081a0, 0x000081a0},
	{0x00009a68, 0x00008390, 0x00008390, 0x0000820c, 0x0000820c},
	{0x00009a6c, 0x00008394, 0x00008394, 0x000081a8, 0x000081a8},
	{0x00009a70, 0x0000a380, 0x0000a380, 0x00008284, 0x00008284},
	{0x00009a74, 0x0000a384, 0x0000a384, 0x00008288, 0x00008288},
	{0x00009a78, 0x0000a388, 0x0000a388, 0x00008224, 0x00008224},
	{0x00009a7c, 0x0000a38c, 0x0000a38c, 0x00008290, 0x00008290},
	{0x00009a80, 0x0000a390, 0x0000a390, 0x00008300, 0x00008300},
	{0x00009a84, 0x0000a394, 0x0000a394, 0x00008304, 0x00008304},
	{0x00009a88, 0x0000a780, 0x0000a780, 0x00008308, 0x00008308},
	{0x00009a8c, 0x0000a784, 0x0000a784, 0x0000830c, 0x0000830c},
	{0x00009a90, 0x0000a788, 0x0000a788, 0x00008380, 0x00008380},
	{0x00009a94, 0x0000a78c, 0x0000a78c, 0x00008384, 0x00008384},
	{0x00009a98, 0x0000a790, 0x0000a790, 0x00008700, 0x00008700},
	{0x00009a9c, 0x0000a794, 0x0000a794, 0x00008704, 0x00008704},
	{0x00009aa0, 0x0000ab84, 0x0000ab84, 0x00008708, 0x00008708},
	{0x00009aa4, 0x0000ab88, 0x0000ab88, 0x0000870c, 0x0000870c},
	{0x00009aa8, 0x0000ab8c, 0x0000ab8c, 0x00008780, 0x00008780},
	{0x00009aac, 0x0000ab90, 0x0000ab90, 0x00008784, 0x00008784},
	{0x00009ab0, 0x0000ab94, 0x0000ab94, 0x00008b00, 0x00008b00},
	{0x00009ab4, 0x0000af80, 0x0000af80, 0x00008b04, 0x00008b04},
	{0x00009ab8, 0x0000af84, 0x0000af84, 0x00008b08, 0x00008b08},
	{0x00009abc, 0x0000af88, 0x0000af88, 0x00008b0c, 0x00008b0c},
	{0x00009ac0, 0x0000af8c, 0x0000af8c, 0x00008b80, 0x00008b80},
	{0x00009ac4, 0x0000af90, 0x0000af90, 0x00008b84, 0x00008b84},
	{0x00009ac8, 0x0000af94, 0x0000af94, 0x00008b88, 0x00008b88},
	{0x00009acc, 0x0000b380, 0x0000b380, 0x00008b8c, 0x00008b8c},
	{0x00009ad0, 0x0000b384, 0x0000b384, 0x00008b90, 0x00008b90},
	{0x00009ad4, 0x0000b388, 0x0000b388, 0x00008f80, 0x00008f80},
	{0x00009ad8, 0x0000b38c, 0x0000b38c, 0x00008f84, 0x00008f84},
	{0x00009adc, 0x0000b390, 0x0000b390, 0x00008f88, 0x00008f88},
	{0x00009ae0, 0x0000b394, 0x0000b394, 0x00008f8c, 0x00008f8c},
	{0x00009ae4, 0x0000b398, 0x0000b398, 0x00008f90, 0x00008f90},
	{0x00009ae8, 0x0000b780, 0x0000b780, 0x00009310, 0x00009310},
	{0x00009aec, 0x0000b784, 0x0000b784, 0x00009314, 0x00009314},
	{0x00009af0, 0x0000b788, 0x0000b788, 0x00009320, 0x00009320},
	{0x00009af4, 0x0000b78c, 0x0000b78c, 0x00009324, 0x00009324},
	{0x00009af8, 0x0000b790, 0x0000b790, 0x00009328, 0x00009328},
	{0x00009afc, 0x0000b794, 0x0000b794, 0x0000932c, 0x0000932c},
	{0x00009b00, 0x0000b798, 0x0000b798, 0x00009330, 0x00009330},
	{0x00009b04, 0x0000d784, 0x0000d784, 0x00009334, 0x00009334},
	{0x00009b08, 0x0000d788, 0x0000d788, 0x00009321, 0x00009321},
	{0x00009b0c, 0x0000d78c, 0x0000d78c, 0x00009325, 0x00009325},
	{0x00009b10, 0x0000d790, 0x0000d790, 0x00009329, 0x00009329},
	{0x00009b14, 0x0000f780, 0x0000f780, 0x0000932d, 0x0000932d},
	{0x00009b18, 0x0000f784, 0x0000f784, 0x00009331, 0x00009331},
	{0x00009b1c, 0x0000f788, 0x0000f788, 0x00009335, 0x00009335},
	{0x00009b20, 0x0000f78c, 0x0000f78c, 0x00009322, 0x00009322},
	{0x00009b24, 0x0000f790, 0x0000f790, 0x00009326, 0x00009326},
	{0x00009b28, 0x0000f794, 0x0000f794, 0x0000932a, 0x0000932a},
	{0x00009b2c, 0x0000f7a4, 0x0000f7a4, 0x0000932e, 0x0000932e},
	{0x00009b30, 0x0000f7a8, 0x0000f7a8, 0x00009332, 0x00009332},
	{0x00009b34, 0x0000f7ac, 0x0000f7ac, 0x00009336, 0x00009336},
	{0x00009b38, 0x0000f7b0, 0x0000f7b0, 0x00009323, 0x00009323},
	{0x00009b3c, 0x0000f7b4, 0x0000f7b4, 0x00009327, 0x00009327},
	{0x00009b40, 0x0000f7a1, 0x0000f7a1, 0x0000932b, 0x0000932b},
	{0x00009b44, 0x0000f7a5, 0x0000f7a5, 0x0000932f, 0x0000932f},
	{0x00009b48, 0x0000f7a9, 0x0000f7a9, 0x00009333, 0x00009333},
	{0x00009b4c, 0x0000f7ad, 0x0000f7ad, 0x00009337, 0x00009337},
	{0x00009b50, 0x0000f7b1, 0x0000f7b1, 0x00009343, 0x00009343},
	{0x00009b54, 0x0000f7b5, 0x0000f7b5, 0x00009347, 0x00009347},
	{0x00009b58, 0x0000f7c5, 0x0000f7c5, 0x0000934b, 0x0000934b},
	{0x00009b5c, 0x0000f7c9, 0x0000f7c9, 0x0000934f, 0x0000934f},
	{0x00009b60, 0x0000f7cd, 0x0000f7cd, 0x00009353, 0x00009353},
	{0x00009b64, 0x0000f7d1, 0x0000f7d1, 0x00009357, 0x00009357},
	{0x00009b68, 0x0000f7d5, 0x0000f7d5, 0x0000935b, 0x0000935b},
	{0x00009b6c, 0x0000f7c2, 0x0000f7c2, 0x0000935b, 0x0000935b},
	{0x00009b70, 0x0000f7c6, 0x0000f7c6, 0x0000935b, 0x0000935b},
	{0x00009b74, 0x0000f7ca, 0x0000f7ca, 0x0000935b, 0x0000935b},
	{0x00009b78, 0x0000f7ce, 0x0000f7ce, 0x0000935b, 0x0000935b},
	{0x00009b7c, 0x0000f7d2, 0x0000f7d2, 0x0000935b, 0x0000935b},
	{0x00009b80, 0x0000f7d6, 0x0000f7d6, 0x0000935b, 0x0000935b},
	{0x00009b84, 0x0000f7c3, 0x0000f7c3, 0x0000935b, 0x0000935b},
	{0x00009b88, 0x0000f7c7, 0x0000f7c7, 0x0000935b, 0x0000935b},
	{0x00009b8c, 0x0000f7cb, 0x0000f7cb, 0x0000935b, 0x0000935b},
	{0x00009b90, 0x0000f7d3, 0x0000f7d3, 0x0000935b, 0x0000935b},
	{0x00009b94, 0x0000f7d7, 0x0000f7d7, 0x0000935b, 0x0000935b},
	{0x00009b98, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009b9c, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009ba0, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009ba4, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009ba8, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bac, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bb0, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bb4, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bb8, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bbc, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bc0, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bc4, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bc8, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bcc, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bd0, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bd4, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bd8, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bdc, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009be0, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009be4, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009be8, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bec, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bf0, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bf4, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bf8, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009bfc, 0x0000f7db, 0x0000f7db, 0x0000935b, 0x0000935b},
	{0x00009848, 0x00001066, 0x00001066, 0x0000105a, 0x0000105a},
	{0x0000a848, 0x00001066, 0x00001066, 0x0000105a, 0x0000105a},
};

static const u32 ar9280Modes_high_power_tx_gain_9280_2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a274, 0x0a19e652, 0x0a19e652, 0x0a1aa652, 0x0a1aa652},
	{0x0000a27c, 0x050739ce, 0x050739ce, 0x050739ce, 0x050739ce},
	{0x0000a300, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a304, 0x00003002, 0x00003002, 0x00004002, 0x00004002},
	{0x0000a308, 0x00006004, 0x00006004, 0x00007008, 0x00007008},
	{0x0000a30c, 0x0000a006, 0x0000a006, 0x0000c010, 0x0000c010},
	{0x0000a310, 0x0000e012, 0x0000e012, 0x00010012, 0x00010012},
	{0x0000a314, 0x00011014, 0x00011014, 0x00013014, 0x00013014},
	{0x0000a318, 0x0001504a, 0x0001504a, 0x0001820a, 0x0001820a},
	{0x0000a31c, 0x0001904c, 0x0001904c, 0x0001b211, 0x0001b211},
	{0x0000a320, 0x0001c04e, 0x0001c04e, 0x0001e213, 0x0001e213},
	{0x0000a324, 0x00021092, 0x00021092, 0x00022411, 0x00022411},
	{0x0000a328, 0x0002510a, 0x0002510a, 0x00025413, 0x00025413},
	{0x0000a32c, 0x0002910c, 0x0002910c, 0x00029811, 0x00029811},
	{0x0000a330, 0x0002c18b, 0x0002c18b, 0x0002c813, 0x0002c813},
	{0x0000a334, 0x0002f1cc, 0x0002f1cc, 0x00030a14, 0x00030a14},
	{0x0000a338, 0x000321eb, 0x000321eb, 0x00035a50, 0x00035a50},
	{0x0000a33c, 0x000341ec, 0x000341ec, 0x00039c4c, 0x00039c4c},
	{0x0000a340, 0x000341ec, 0x000341ec, 0x0003de8a, 0x0003de8a},
	{0x0000a344, 0x000341ec, 0x000341ec, 0x00042e92, 0x00042e92},
	{0x0000a348, 0x000341ec, 0x000341ec, 0x00046ed2, 0x00046ed2},
	{0x0000a34c, 0x000341ec, 0x000341ec, 0x0004bed5, 0x0004bed5},
	{0x0000a350, 0x000341ec, 0x000341ec, 0x0004ff54, 0x0004ff54},
	{0x0000a354, 0x000341ec, 0x000341ec, 0x00055fd5, 0x00055fd5},
	{0x0000a3ec, 0x00f70081, 0x00f70081, 0x00f70081, 0x00f70081},
	{0x00007814, 0x00198eff, 0x00198eff, 0x00198eff, 0x00198eff},
	{0x00007838, 0x00198eff, 0x00198eff, 0x00198eff, 0x00198eff},
	{0x0000781c, 0x00172000, 0x00172000, 0x00172000, 0x00172000},
	{0x00007840, 0x00172000, 0x00172000, 0x00172000, 0x00172000},
	{0x00007820, 0xf258a480, 0xf258a480, 0xf258a480, 0xf258a480},
	{0x00007844, 0xf258a480, 0xf258a480, 0xf258a480, 0xf258a480},
};

static const u32 ar9280Modes_original_tx_gain_9280_2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a274, 0x0a19c652, 0x0a19c652, 0x0a1aa652, 0x0a1aa652},
	{0x0000a27c, 0x050701ce, 0x050701ce, 0x050701ce, 0x050701ce},
	{0x0000a300, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a304, 0x00003002, 0x00003002, 0x00003002, 0x00003002},
	{0x0000a308, 0x00006004, 0x00006004, 0x00008009, 0x00008009},
	{0x0000a30c, 0x0000a006, 0x0000a006, 0x0000b00b, 0x0000b00b},
	{0x0000a310, 0x0000e012, 0x0000e012, 0x0000e012, 0x0000e012},
	{0x0000a314, 0x00011014, 0x00011014, 0x00012048, 0x00012048},
	{0x0000a318, 0x0001504a, 0x0001504a, 0x0001604a, 0x0001604a},
	{0x0000a31c, 0x0001904c, 0x0001904c, 0x0001a211, 0x0001a211},
	{0x0000a320, 0x0001c04e, 0x0001c04e, 0x0001e213, 0x0001e213},
	{0x0000a324, 0x00020092, 0x00020092, 0x0002121b, 0x0002121b},
	{0x0000a328, 0x0002410a, 0x0002410a, 0x00024412, 0x00024412},
	{0x0000a32c, 0x0002710c, 0x0002710c, 0x00028414, 0x00028414},
	{0x0000a330, 0x0002b18b, 0x0002b18b, 0x0002b44a, 0x0002b44a},
	{0x0000a334, 0x0002e1cc, 0x0002e1cc, 0x00030649, 0x00030649},
	{0x0000a338, 0x000321ec, 0x000321ec, 0x0003364b, 0x0003364b},
	{0x0000a33c, 0x000321ec, 0x000321ec, 0x00038a49, 0x00038a49},
	{0x0000a340, 0x000321ec, 0x000321ec, 0x0003be48, 0x0003be48},
	{0x0000a344, 0x000321ec, 0x000321ec, 0x0003ee4a, 0x0003ee4a},
	{0x0000a348, 0x000321ec, 0x000321ec, 0x00042e88, 0x00042e88},
	{0x0000a34c, 0x000321ec, 0x000321ec, 0x00046e8a, 0x00046e8a},
	{0x0000a350, 0x000321ec, 0x000321ec, 0x00049ec9, 0x00049ec9},
	{0x0000a354, 0x000321ec, 0x000321ec, 0x0004bf42, 0x0004bf42},
	{0x0000a3ec, 0x00f70081, 0x00f70081, 0x00f70081, 0x00f70081},
	{0x00007814, 0x0019beff, 0x0019beff, 0x0019beff, 0x0019beff},
	{0x00007838, 0x0019beff, 0x0019beff, 0x0019beff, 0x0019beff},
	{0x0000781c, 0x00392000, 0x00392000, 0x00392000, 0x00392000},
	{0x00007840, 0x00392000, 0x00392000, 0x00392000, 0x00392000},
	{0x00007820, 0x92592480, 0x92592480, 0x92592480, 0x92592480},
	{0x00007844, 0x92592480, 0x92592480, 0x92592480, 0x92592480},
};

static const u32 ar9280PciePhy_clkreq_off_L1_9280[][2] = {
	/* Addr      allmodes  */
	{0x00004040, 0x9248fd00},
	{0x00004040, 0x24924924},
	{0x00004040, 0xa8000019},
	{0x00004040, 0x13160820},
	{0x00004040, 0xe5980560},
	{0x00004040, 0xc01dcffc},
	{0x00004040, 0x1aaabe41},
	{0x00004040, 0xbe105554},
	{0x00004040, 0x00043007},
	{0x00004044, 0x00000000},
};

static const u32 ar9280PciePhy_clkreq_always_on_L1_9280[][2] = {
	/* Addr      allmodes  */
	{0x00004040, 0x9248fd00},
	{0x00004040, 0x24924924},
	{0x00004040, 0xa8000019},
	{0x00004040, 0x13160820},
	{0x00004040, 0xe5980560},
	{0x00004040, 0xc01dcffd},
	{0x00004040, 0x1aaabe41},
	{0x00004040, 0xbe105554},
	{0x00004040, 0x00043007},
	{0x00004044, 0x00000000},
};

static const u32 ar9285Modes_9285_1_2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00001030, 0x00000230, 0x00000460, 0x000002c0, 0x00000160},
	{0x00001070, 0x00000168, 0x000002d0, 0x00000318, 0x0000018c},
	{0x000010b0, 0x00000e60, 0x00001cc0, 0x00007c70, 0x00003e38},
	{0x000010f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00008014, 0x03e803e8, 0x07d007d0, 0x10801600, 0x08400b00},
	{0x0000801c, 0x128d8027, 0x128d804f, 0x12e00057, 0x12e0002b},
	{0x00008318, 0x00003e80, 0x00007d00, 0x00006880, 0x00003440},
	{0x00009804, 0x00000300, 0x000003c4, 0x000003c4, 0x00000300},
	{0x00009820, 0x02020200, 0x02020200, 0x02020200, 0x02020200},
	{0x00009824, 0x01000e0e, 0x01000e0e, 0x01000e0e, 0x01000e0e},
	{0x00009828, 0x0a020001, 0x0a020001, 0x0a020001, 0x0a020001},
	{0x00009834, 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e},
	{0x00009838, 0x00000007, 0x00000007, 0x00000007, 0x00000007},
	{0x00009840, 0x206a012e, 0x206a012e, 0x206a012e, 0x206a012e},
	{0x00009844, 0x0372161e, 0x0372161e, 0x03721620, 0x03721620},
	{0x00009848, 0x00001066, 0x00001066, 0x00001053, 0x00001053},
	{0x0000a848, 0x00001066, 0x00001066, 0x00001053, 0x00001053},
	{0x00009850, 0x6d4000e2, 0x6d4000e2, 0x6d4000e2, 0x6d4000e2},
	{0x00009858, 0x7ec84d2e, 0x7ec84d2e, 0x7ec84d2e, 0x7ec84d2e},
	{0x0000985c, 0x3139605e, 0x3139605e, 0x3137605e, 0x3137605e},
	{0x00009860, 0x00058d18, 0x00058d18, 0x00058d20, 0x00058d20},
	{0x00009864, 0x0000fe00, 0x0000fe00, 0x0001ce00, 0x0001ce00},
	{0x00009868, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0},
	{0x0000986c, 0x06903081, 0x06903081, 0x06903881, 0x06903881},
	{0x00009914, 0x000007d0, 0x00000fa0, 0x00001130, 0x00000898},
	{0x00009918, 0x0000000a, 0x00000014, 0x00000016, 0x0000000b},
	{0x00009924, 0xd00a8007, 0xd00a8007, 0xd00a800d, 0xd00a800d},
	{0x00009944, 0xffbc1010, 0xffbc1010, 0xffbc1020, 0xffbc1020},
	{0x00009960, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00009964, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x000099b8, 0x0000421c, 0x0000421c, 0x0000421c, 0x0000421c},
	{0x000099bc, 0x00000600, 0x00000600, 0x00000c00, 0x00000c00},
	{0x000099c0, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4},
	{0x000099c4, 0x06336f77, 0x06336f77, 0x06336f77, 0x06336f77},
	{0x000099c8, 0x6af6532f, 0x6af6532f, 0x6af6532f, 0x6af6532f},
	{0x000099cc, 0x08f186c8, 0x08f186c8, 0x08f186c8, 0x08f186c8},
	{0x000099d0, 0x00046384, 0x00046384, 0x00046384, 0x00046384},
	{0x000099d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x000099d8, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00009a00, 0x00000000, 0x00000000, 0x00058084, 0x00058084},
	{0x00009a04, 0x00000000, 0x00000000, 0x00058088, 0x00058088},
	{0x00009a08, 0x00000000, 0x00000000, 0x0005808c, 0x0005808c},
	{0x00009a0c, 0x00000000, 0x00000000, 0x00058100, 0x00058100},
	{0x00009a10, 0x00000000, 0x00000000, 0x00058104, 0x00058104},
	{0x00009a14, 0x00000000, 0x00000000, 0x00058108, 0x00058108},
	{0x00009a18, 0x00000000, 0x00000000, 0x0005810c, 0x0005810c},
	{0x00009a1c, 0x00000000, 0x00000000, 0x00058110, 0x00058110},
	{0x00009a20, 0x00000000, 0x00000000, 0x00058114, 0x00058114},
	{0x00009a24, 0x00000000, 0x00000000, 0x00058180, 0x00058180},
	{0x00009a28, 0x00000000, 0x00000000, 0x00058184, 0x00058184},
	{0x00009a2c, 0x00000000, 0x00000000, 0x00058188, 0x00058188},
	{0x00009a30, 0x00000000, 0x00000000, 0x0005818c, 0x0005818c},
	{0x00009a34, 0x00000000, 0x00000000, 0x00058190, 0x00058190},
	{0x00009a38, 0x00000000, 0x00000000, 0x00058194, 0x00058194},
	{0x00009a3c, 0x00000000, 0x00000000, 0x000581a0, 0x000581a0},
	{0x00009a40, 0x00000000, 0x00000000, 0x0005820c, 0x0005820c},
	{0x00009a44, 0x00000000, 0x00000000, 0x000581a8, 0x000581a8},
	{0x00009a48, 0x00000000, 0x00000000, 0x00058284, 0x00058284},
	{0x00009a4c, 0x00000000, 0x00000000, 0x00058288, 0x00058288},
	{0x00009a50, 0x00000000, 0x00000000, 0x00058224, 0x00058224},
	{0x00009a54, 0x00000000, 0x00000000, 0x00058290, 0x00058290},
	{0x00009a58, 0x00000000, 0x00000000, 0x00058300, 0x00058300},
	{0x00009a5c, 0x00000000, 0x00000000, 0x00058304, 0x00058304},
	{0x00009a60, 0x00000000, 0x00000000, 0x00058308, 0x00058308},
	{0x00009a64, 0x00000000, 0x00000000, 0x0005830c, 0x0005830c},
	{0x00009a68, 0x00000000, 0x00000000, 0x00058380, 0x00058380},
	{0x00009a6c, 0x00000000, 0x00000000, 0x00058384, 0x00058384},
	{0x00009a70, 0x00000000, 0x00000000, 0x00068700, 0x00068700},
	{0x00009a74, 0x00000000, 0x00000000, 0x00068704, 0x00068704},
	{0x00009a78, 0x00000000, 0x00000000, 0x00068708, 0x00068708},
	{0x00009a7c, 0x00000000, 0x00000000, 0x0006870c, 0x0006870c},
	{0x00009a80, 0x00000000, 0x00000000, 0x00068780, 0x00068780},
	{0x00009a84, 0x00000000, 0x00000000, 0x00068784, 0x00068784},
	{0x00009a88, 0x00000000, 0x00000000, 0x00078b00, 0x00078b00},
	{0x00009a8c, 0x00000000, 0x00000000, 0x00078b04, 0x00078b04},
	{0x00009a90, 0x00000000, 0x00000000, 0x00078b08, 0x00078b08},
	{0x00009a94, 0x00000000, 0x00000000, 0x00078b0c, 0x00078b0c},
	{0x00009a98, 0x00000000, 0x00000000, 0x00078b80, 0x00078b80},
	{0x00009a9c, 0x00000000, 0x00000000, 0x00078b84, 0x00078b84},
	{0x00009aa0, 0x00000000, 0x00000000, 0x00078b88, 0x00078b88},
	{0x00009aa4, 0x00000000, 0x00000000, 0x00078b8c, 0x00078b8c},
	{0x00009aa8, 0x00000000, 0x00000000, 0x00078b90, 0x00078b90},
	{0x00009aac, 0x00000000, 0x00000000, 0x000caf80, 0x000caf80},
	{0x00009ab0, 0x00000000, 0x00000000, 0x000caf84, 0x000caf84},
	{0x00009ab4, 0x00000000, 0x00000000, 0x000caf88, 0x000caf88},
	{0x00009ab8, 0x00000000, 0x00000000, 0x000caf8c, 0x000caf8c},
	{0x00009abc, 0x00000000, 0x00000000, 0x000caf90, 0x000caf90},
	{0x00009ac0, 0x00000000, 0x00000000, 0x000db30c, 0x000db30c},
	{0x00009ac4, 0x00000000, 0x00000000, 0x000db310, 0x000db310},
	{0x00009ac8, 0x00000000, 0x00000000, 0x000db384, 0x000db384},
	{0x00009acc, 0x00000000, 0x00000000, 0x000db388, 0x000db388},
	{0x00009ad0, 0x00000000, 0x00000000, 0x000db324, 0x000db324},
	{0x00009ad4, 0x00000000, 0x00000000, 0x000eb704, 0x000eb704},
	{0x00009ad8, 0x00000000, 0x00000000, 0x000eb6a4, 0x000eb6a4},
	{0x00009adc, 0x00000000, 0x00000000, 0x000eb6a8, 0x000eb6a8},
	{0x00009ae0, 0x00000000, 0x00000000, 0x000eb710, 0x000eb710},
	{0x00009ae4, 0x00000000, 0x00000000, 0x000eb714, 0x000eb714},
	{0x00009ae8, 0x00000000, 0x00000000, 0x000eb720, 0x000eb720},
	{0x00009aec, 0x00000000, 0x00000000, 0x000eb724, 0x000eb724},
	{0x00009af0, 0x00000000, 0x00000000, 0x000eb728, 0x000eb728},
	{0x00009af4, 0x00000000, 0x00000000, 0x000eb72c, 0x000eb72c},
	{0x00009af8, 0x00000000, 0x00000000, 0x000eb7a0, 0x000eb7a0},
	{0x00009afc, 0x00000000, 0x00000000, 0x000eb7a4, 0x000eb7a4},
	{0x00009b00, 0x00000000, 0x00000000, 0x000eb7a8, 0x000eb7a8},
	{0x00009b04, 0x00000000, 0x00000000, 0x000eb7b0, 0x000eb7b0},
	{0x00009b08, 0x00000000, 0x00000000, 0x000eb7b4, 0x000eb7b4},
	{0x00009b0c, 0x00000000, 0x00000000, 0x000eb7b8, 0x000eb7b8},
	{0x00009b10, 0x00000000, 0x00000000, 0x000eb7a5, 0x000eb7a5},
	{0x00009b14, 0x00000000, 0x00000000, 0x000eb7a9, 0x000eb7a9},
	{0x00009b18, 0x00000000, 0x00000000, 0x000eb7ad, 0x000eb7ad},
	{0x00009b1c, 0x00000000, 0x00000000, 0x000eb7b1, 0x000eb7b1},
	{0x00009b20, 0x00000000, 0x00000000, 0x000eb7b5, 0x000eb7b5},
	{0x00009b24, 0x00000000, 0x00000000, 0x000eb7b9, 0x000eb7b9},
	{0x00009b28, 0x00000000, 0x00000000, 0x000eb7c5, 0x000eb7c5},
	{0x00009b2c, 0x00000000, 0x00000000, 0x000eb7c9, 0x000eb7c9},
	{0x00009b30, 0x00000000, 0x00000000, 0x000eb7d1, 0x000eb7d1},
	{0x00009b34, 0x00000000, 0x00000000, 0x000eb7d5, 0x000eb7d5},
	{0x00009b38, 0x00000000, 0x00000000, 0x000eb7d9, 0x000eb7d9},
	{0x00009b3c, 0x00000000, 0x00000000, 0x000eb7c6, 0x000eb7c6},
	{0x00009b40, 0x00000000, 0x00000000, 0x000eb7ca, 0x000eb7ca},
	{0x00009b44, 0x00000000, 0x00000000, 0x000eb7ce, 0x000eb7ce},
	{0x00009b48, 0x00000000, 0x00000000, 0x000eb7d2, 0x000eb7d2},
	{0x00009b4c, 0x00000000, 0x00000000, 0x000eb7d6, 0x000eb7d6},
	{0x00009b50, 0x00000000, 0x00000000, 0x000eb7c3, 0x000eb7c3},
	{0x00009b54, 0x00000000, 0x00000000, 0x000eb7c7, 0x000eb7c7},
	{0x00009b58, 0x00000000, 0x00000000, 0x000eb7cb, 0x000eb7cb},
	{0x00009b5c, 0x00000000, 0x00000000, 0x000eb7cf, 0x000eb7cf},
	{0x00009b60, 0x00000000, 0x00000000, 0x000eb7d7, 0x000eb7d7},
	{0x00009b64, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b68, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b6c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b70, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b74, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b78, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b7c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b80, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b84, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b88, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b8c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b90, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b94, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b98, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b9c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009ba0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009ba4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009ba8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bac, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bb0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bb4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bb8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bbc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bc0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bc4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bc8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bcc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bd0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bd4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bd8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bdc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009be0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009be4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009be8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bec, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bf0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bf4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bf8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bfc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000aa00, 0x00000000, 0x00000000, 0x00058084, 0x00058084},
	{0x0000aa04, 0x00000000, 0x00000000, 0x00058088, 0x00058088},
	{0x0000aa08, 0x00000000, 0x00000000, 0x0005808c, 0x0005808c},
	{0x0000aa0c, 0x00000000, 0x00000000, 0x00058100, 0x00058100},
	{0x0000aa10, 0x00000000, 0x00000000, 0x00058104, 0x00058104},
	{0x0000aa14, 0x00000000, 0x00000000, 0x00058108, 0x00058108},
	{0x0000aa18, 0x00000000, 0x00000000, 0x0005810c, 0x0005810c},
	{0x0000aa1c, 0x00000000, 0x00000000, 0x00058110, 0x00058110},
	{0x0000aa20, 0x00000000, 0x00000000, 0x00058114, 0x00058114},
	{0x0000aa24, 0x00000000, 0x00000000, 0x00058180, 0x00058180},
	{0x0000aa28, 0x00000000, 0x00000000, 0x00058184, 0x00058184},
	{0x0000aa2c, 0x00000000, 0x00000000, 0x00058188, 0x00058188},
	{0x0000aa30, 0x00000000, 0x00000000, 0x0005818c, 0x0005818c},
	{0x0000aa34, 0x00000000, 0x00000000, 0x00058190, 0x00058190},
	{0x0000aa38, 0x00000000, 0x00000000, 0x00058194, 0x00058194},
	{0x0000aa3c, 0x00000000, 0x00000000, 0x000581a0, 0x000581a0},
	{0x0000aa40, 0x00000000, 0x00000000, 0x0005820c, 0x0005820c},
	{0x0000aa44, 0x00000000, 0x00000000, 0x000581a8, 0x000581a8},
	{0x0000aa48, 0x00000000, 0x00000000, 0x00058284, 0x00058284},
	{0x0000aa4c, 0x00000000, 0x00000000, 0x00058288, 0x00058288},
	{0x0000aa50, 0x00000000, 0x00000000, 0x00058224, 0x00058224},
	{0x0000aa54, 0x00000000, 0x00000000, 0x00058290, 0x00058290},
	{0x0000aa58, 0x00000000, 0x00000000, 0x00058300, 0x00058300},
	{0x0000aa5c, 0x00000000, 0x00000000, 0x00058304, 0x00058304},
	{0x0000aa60, 0x00000000, 0x00000000, 0x00058308, 0x00058308},
	{0x0000aa64, 0x00000000, 0x00000000, 0x0005830c, 0x0005830c},
	{0x0000aa68, 0x00000000, 0x00000000, 0x00058380, 0x00058380},
	{0x0000aa6c, 0x00000000, 0x00000000, 0x00058384, 0x00058384},
	{0x0000aa70, 0x00000000, 0x00000000, 0x00068700, 0x00068700},
	{0x0000aa74, 0x00000000, 0x00000000, 0x00068704, 0x00068704},
	{0x0000aa78, 0x00000000, 0x00000000, 0x00068708, 0x00068708},
	{0x0000aa7c, 0x00000000, 0x00000000, 0x0006870c, 0x0006870c},
	{0x0000aa80, 0x00000000, 0x00000000, 0x00068780, 0x00068780},
	{0x0000aa84, 0x00000000, 0x00000000, 0x00068784, 0x00068784},
	{0x0000aa88, 0x00000000, 0x00000000, 0x00078b00, 0x00078b00},
	{0x0000aa8c, 0x00000000, 0x00000000, 0x00078b04, 0x00078b04},
	{0x0000aa90, 0x00000000, 0x00000000, 0x00078b08, 0x00078b08},
	{0x0000aa94, 0x00000000, 0x00000000, 0x00078b0c, 0x00078b0c},
	{0x0000aa98, 0x00000000, 0x00000000, 0x00078b80, 0x00078b80},
	{0x0000aa9c, 0x00000000, 0x00000000, 0x00078b84, 0x00078b84},
	{0x0000aaa0, 0x00000000, 0x00000000, 0x00078b88, 0x00078b88},
	{0x0000aaa4, 0x00000000, 0x00000000, 0x00078b8c, 0x00078b8c},
	{0x0000aaa8, 0x00000000, 0x00000000, 0x00078b90, 0x00078b90},
	{0x0000aaac, 0x00000000, 0x00000000, 0x000caf80, 0x000caf80},
	{0x0000aab0, 0x00000000, 0x00000000, 0x000caf84, 0x000caf84},
	{0x0000aab4, 0x00000000, 0x00000000, 0x000caf88, 0x000caf88},
	{0x0000aab8, 0x00000000, 0x00000000, 0x000caf8c, 0x000caf8c},
	{0x0000aabc, 0x00000000, 0x00000000, 0x000caf90, 0x000caf90},
	{0x0000aac0, 0x00000000, 0x00000000, 0x000db30c, 0x000db30c},
	{0x0000aac4, 0x00000000, 0x00000000, 0x000db310, 0x000db310},
	{0x0000aac8, 0x00000000, 0x00000000, 0x000db384, 0x000db384},
	{0x0000aacc, 0x00000000, 0x00000000, 0x000db388, 0x000db388},
	{0x0000aad0, 0x00000000, 0x00000000, 0x000db324, 0x000db324},
	{0x0000aad4, 0x00000000, 0x00000000, 0x000eb704, 0x000eb704},
	{0x0000aad8, 0x00000000, 0x00000000, 0x000eb6a4, 0x000eb6a4},
	{0x0000aadc, 0x00000000, 0x00000000, 0x000eb6a8, 0x000eb6a8},
	{0x0000aae0, 0x00000000, 0x00000000, 0x000eb710, 0x000eb710},
	{0x0000aae4, 0x00000000, 0x00000000, 0x000eb714, 0x000eb714},
	{0x0000aae8, 0x00000000, 0x00000000, 0x000eb720, 0x000eb720},
	{0x0000aaec, 0x00000000, 0x00000000, 0x000eb724, 0x000eb724},
	{0x0000aaf0, 0x00000000, 0x00000000, 0x000eb728, 0x000eb728},
	{0x0000aaf4, 0x00000000, 0x00000000, 0x000eb72c, 0x000eb72c},
	{0x0000aaf8, 0x00000000, 0x00000000, 0x000eb7a0, 0x000eb7a0},
	{0x0000aafc, 0x00000000, 0x00000000, 0x000eb7a4, 0x000eb7a4},
	{0x0000ab00, 0x00000000, 0x00000000, 0x000eb7a8, 0x000eb7a8},
	{0x0000ab04, 0x00000000, 0x00000000, 0x000eb7b0, 0x000eb7b0},
	{0x0000ab08, 0x00000000, 0x00000000, 0x000eb7b4, 0x000eb7b4},
	{0x0000ab0c, 0x00000000, 0x00000000, 0x000eb7b8, 0x000eb7b8},
	{0x0000ab10, 0x00000000, 0x00000000, 0x000eb7a5, 0x000eb7a5},
	{0x0000ab14, 0x00000000, 0x00000000, 0x000eb7a9, 0x000eb7a9},
	{0x0000ab18, 0x00000000, 0x00000000, 0x000eb7ad, 0x000eb7ad},
	{0x0000ab1c, 0x00000000, 0x00000000, 0x000eb7b1, 0x000eb7b1},
	{0x0000ab20, 0x00000000, 0x00000000, 0x000eb7b5, 0x000eb7b5},
	{0x0000ab24, 0x00000000, 0x00000000, 0x000eb7b9, 0x000eb7b9},
	{0x0000ab28, 0x00000000, 0x00000000, 0x000eb7c5, 0x000eb7c5},
	{0x0000ab2c, 0x00000000, 0x00000000, 0x000eb7c9, 0x000eb7c9},
	{0x0000ab30, 0x00000000, 0x00000000, 0x000eb7d1, 0x000eb7d1},
	{0x0000ab34, 0x00000000, 0x00000000, 0x000eb7d5, 0x000eb7d5},
	{0x0000ab38, 0x00000000, 0x00000000, 0x000eb7d9, 0x000eb7d9},
	{0x0000ab3c, 0x00000000, 0x00000000, 0x000eb7c6, 0x000eb7c6},
	{0x0000ab40, 0x00000000, 0x00000000, 0x000eb7ca, 0x000eb7ca},
	{0x0000ab44, 0x00000000, 0x00000000, 0x000eb7ce, 0x000eb7ce},
	{0x0000ab48, 0x00000000, 0x00000000, 0x000eb7d2, 0x000eb7d2},
	{0x0000ab4c, 0x00000000, 0x00000000, 0x000eb7d6, 0x000eb7d6},
	{0x0000ab50, 0x00000000, 0x00000000, 0x000eb7c3, 0x000eb7c3},
	{0x0000ab54, 0x00000000, 0x00000000, 0x000eb7c7, 0x000eb7c7},
	{0x0000ab58, 0x00000000, 0x00000000, 0x000eb7cb, 0x000eb7cb},
	{0x0000ab5c, 0x00000000, 0x00000000, 0x000eb7cf, 0x000eb7cf},
	{0x0000ab60, 0x00000000, 0x00000000, 0x000eb7d7, 0x000eb7d7},
	{0x0000ab64, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab68, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab6c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab70, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab74, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab78, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab7c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab80, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab84, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab88, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab8c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab90, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab94, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab98, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab9c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000aba0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000aba4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000aba8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abac, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abb0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abb4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abb8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abbc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abc0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abc4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abc8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abcc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abd0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abd4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abd8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abdc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abe0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abe4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abe8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abec, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abf0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abf4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abf8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abfc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000a204, 0x00000004, 0x00000004, 0x00000004, 0x00000004},
	{0x0000a20c, 0x00000014, 0x00000014, 0x0001f000, 0x0001f000},
	{0x0000b20c, 0x00000014, 0x00000014, 0x0001f000, 0x0001f000},
	{0x0000a21c, 0x1883800a, 0x1883800a, 0x1883800a, 0x1883800a},
	{0x0000a230, 0x00000000, 0x00000000, 0x00000210, 0x00000108},
	{0x0000a250, 0x0004f000, 0x0004f000, 0x0004a000, 0x0004a000},
	{0x0000a358, 0x7999aa02, 0x7999aa02, 0x7999aa0e, 0x7999aa0e},
};

static const u32 ar9285Common_9285_1_2[][2] = {
	/* Addr      allmodes  */
	{0x0000000c, 0x00000000},
	{0x00000030, 0x00020045},
	{0x00000034, 0x00000005},
	{0x00000040, 0x00000000},
	{0x00000044, 0x00000008},
	{0x00000048, 0x00000008},
	{0x0000004c, 0x00000010},
	{0x00000050, 0x00000000},
	{0x00000054, 0x0000001f},
	{0x00000800, 0x00000000},
	{0x00000804, 0x00000000},
	{0x00000808, 0x00000000},
	{0x0000080c, 0x00000000},
	{0x00000810, 0x00000000},
	{0x00000814, 0x00000000},
	{0x00000818, 0x00000000},
	{0x0000081c, 0x00000000},
	{0x00000820, 0x00000000},
	{0x00000824, 0x00000000},
	{0x00001040, 0x002ffc0f},
	{0x00001044, 0x002ffc0f},
	{0x00001048, 0x002ffc0f},
	{0x0000104c, 0x002ffc0f},
	{0x00001050, 0x002ffc0f},
	{0x00001054, 0x002ffc0f},
	{0x00001058, 0x002ffc0f},
	{0x0000105c, 0x002ffc0f},
	{0x00001060, 0x002ffc0f},
	{0x00001064, 0x002ffc0f},
	{0x00001230, 0x00000000},
	{0x00001270, 0x00000000},
	{0x00001038, 0x00000000},
	{0x00001078, 0x00000000},
	{0x000010b8, 0x00000000},
	{0x000010f8, 0x00000000},
	{0x00001138, 0x00000000},
	{0x00001178, 0x00000000},
	{0x000011b8, 0x00000000},
	{0x000011f8, 0x00000000},
	{0x00001238, 0x00000000},
	{0x00001278, 0x00000000},
	{0x000012b8, 0x00000000},
	{0x000012f8, 0x00000000},
	{0x00001338, 0x00000000},
	{0x00001378, 0x00000000},
	{0x000013b8, 0x00000000},
	{0x000013f8, 0x00000000},
	{0x00001438, 0x00000000},
	{0x00001478, 0x00000000},
	{0x000014b8, 0x00000000},
	{0x000014f8, 0x00000000},
	{0x00001538, 0x00000000},
	{0x00001578, 0x00000000},
	{0x000015b8, 0x00000000},
	{0x000015f8, 0x00000000},
	{0x00001638, 0x00000000},
	{0x00001678, 0x00000000},
	{0x000016b8, 0x00000000},
	{0x000016f8, 0x00000000},
	{0x00001738, 0x00000000},
	{0x00001778, 0x00000000},
	{0x000017b8, 0x00000000},
	{0x000017f8, 0x00000000},
	{0x0000103c, 0x00000000},
	{0x0000107c, 0x00000000},
	{0x000010bc, 0x00000000},
	{0x000010fc, 0x00000000},
	{0x0000113c, 0x00000000},
	{0x0000117c, 0x00000000},
	{0x000011bc, 0x00000000},
	{0x000011fc, 0x00000000},
	{0x0000123c, 0x00000000},
	{0x0000127c, 0x00000000},
	{0x000012bc, 0x00000000},
	{0x000012fc, 0x00000000},
	{0x0000133c, 0x00000000},
	{0x0000137c, 0x00000000},
	{0x000013bc, 0x00000000},
	{0x000013fc, 0x00000000},
	{0x0000143c, 0x00000000},
	{0x0000147c, 0x00000000},
	{0x00004030, 0x00000002},
	{0x0000403c, 0x00000002},
	{0x00004024, 0x0000001f},
	{0x00004060, 0x00000000},
	{0x00004064, 0x00000000},
	{0x00007010, 0x00000031},
	{0x00007034, 0x00000002},
	{0x00007038, 0x000004c2},
	{0x00008004, 0x00000000},
	{0x00008008, 0x00000000},
	{0x0000800c, 0x00000000},
	{0x00008018, 0x00000700},
	{0x00008020, 0x00000000},
	{0x00008038, 0x00000000},
	{0x0000803c, 0x00000000},
	{0x00008048, 0x00000000},
	{0x00008054, 0x00000000},
	{0x00008058, 0x00000000},
	{0x0000805c, 0x000fc78f},
	{0x00008060, 0x0000000f},
	{0x00008064, 0x00000000},
	{0x00008070, 0x00000000},
	{0x000080c0, 0x2a80001a},
	{0x000080c4, 0x05dc01e0},
	{0x000080c8, 0x1f402710},
	{0x000080cc, 0x01f40000},
	{0x000080d0, 0x00001e00},
	{0x000080d4, 0x00000000},
	{0x000080d8, 0x00400000},
	{0x000080e0, 0xffffffff},
	{0x000080e4, 0x0000ffff},
	{0x000080e8, 0x003f3f3f},
	{0x000080ec, 0x00000000},
	{0x000080f0, 0x00000000},
	{0x000080f4, 0x00000000},
	{0x000080f8, 0x00000000},
	{0x000080fc, 0x00020000},
	{0x00008100, 0x00020000},
	{0x00008104, 0x00000001},
	{0x00008108, 0x00000052},
	{0x0000810c, 0x00000000},
	{0x00008110, 0x00000168},
	{0x00008118, 0x000100aa},
	{0x0000811c, 0x00003210},
	{0x00008120, 0x08f04810},
	{0x00008124, 0x00000000},
	{0x00008128, 0x00000000},
	{0x0000812c, 0x00000000},
	{0x00008130, 0x00000000},
	{0x00008134, 0x00000000},
	{0x00008138, 0x00000000},
	{0x0000813c, 0x00000000},
	{0x00008144, 0xffffffff},
	{0x00008168, 0x00000000},
	{0x0000816c, 0x00000000},
	{0x00008170, 0x32143320},
	{0x00008174, 0xfaa4fa50},
	{0x00008178, 0x00000100},
	{0x0000817c, 0x00000000},
	{0x000081c0, 0x00000000},
	{0x000081d0, 0x0000320a},
	{0x000081ec, 0x00000000},
	{0x000081f0, 0x00000000},
	{0x000081f4, 0x00000000},
	{0x000081f8, 0x00000000},
	{0x000081fc, 0x00000000},
	{0x00008200, 0x00000000},
	{0x00008204, 0x00000000},
	{0x00008208, 0x00000000},
	{0x0000820c, 0x00000000},
	{0x00008210, 0x00000000},
	{0x00008214, 0x00000000},
	{0x00008218, 0x00000000},
	{0x0000821c, 0x00000000},
	{0x00008220, 0x00000000},
	{0x00008224, 0x00000000},
	{0x00008228, 0x00000000},
	{0x0000822c, 0x00000000},
	{0x00008230, 0x00000000},
	{0x00008234, 0x00000000},
	{0x00008238, 0x00000000},
	{0x0000823c, 0x00000000},
	{0x00008240, 0x00100000},
	{0x00008244, 0x0010f400},
	{0x00008248, 0x00000100},
	{0x0000824c, 0x0001e800},
	{0x00008250, 0x00000000},
	{0x00008254, 0x00000000},
	{0x00008258, 0x00000000},
	{0x0000825c, 0x400000ff},
	{0x00008260, 0x00080922},
	{0x00008264, 0x88a00010},
	{0x00008270, 0x00000000},
	{0x00008274, 0x40000000},
	{0x00008278, 0x003e4180},
	{0x0000827c, 0x00000000},
	{0x00008284, 0x0000002c},
	{0x00008288, 0x0000002c},
	{0x0000828c, 0x00000000},
	{0x00008294, 0x00000000},
	{0x00008298, 0x00000000},
	{0x0000829c, 0x00000000},
	{0x00008300, 0x00000040},
	{0x00008314, 0x00000000},
	{0x00008328, 0x00000000},
	{0x0000832c, 0x00000001},
	{0x00008330, 0x00000302},
	{0x00008334, 0x00000e00},
	{0x00008338, 0x00ff0000},
	{0x0000833c, 0x00000000},
	{0x00008340, 0x00010380},
	{0x00008344, 0x00481043},
	{0x00009808, 0x00000000},
	{0x0000980c, 0xafe68e30},
	{0x00009810, 0xfd14e000},
	{0x00009814, 0x9c0a9f6b},
	{0x0000981c, 0x00000000},
	{0x0000982c, 0x0000a000},
	{0x00009830, 0x00000000},
	{0x0000983c, 0x00200400},
	{0x0000984c, 0x0040233c},
	{0x00009854, 0x00000044},
	{0x00009900, 0x00000000},
	{0x00009904, 0x00000000},
	{0x00009908, 0x00000000},
	{0x0000990c, 0x00000000},
	{0x00009910, 0x01002310},
	{0x0000991c, 0x10000fff},
	{0x00009920, 0x04900000},
	{0x00009928, 0x00000001},
	{0x0000992c, 0x00000004},
	{0x00009934, 0x1e1f2022},
	{0x00009938, 0x0a0b0c0d},
	{0x0000993c, 0x00000000},
	{0x00009940, 0x14750604},
	{0x00009948, 0x9280c00a},
	{0x0000994c, 0x00020028},
	{0x00009954, 0x5f3ca3de},
	{0x00009958, 0x2108ecff},
	{0x00009968, 0x000003ce},
	{0x00009970, 0x192bb514},
	{0x00009974, 0x00000000},
	{0x00009978, 0x00000001},
	{0x0000997c, 0x00000000},
	{0x00009980, 0x00000000},
	{0x00009984, 0x00000000},
	{0x00009988, 0x00000000},
	{0x0000998c, 0x00000000},
	{0x00009990, 0x00000000},
	{0x00009994, 0x00000000},
	{0x00009998, 0x00000000},
	{0x0000999c, 0x00000000},
	{0x000099a0, 0x00000000},
	{0x000099a4, 0x00000001},
	{0x000099a8, 0x201fff00},
	{0x000099ac, 0x2def0400},
	{0x000099b0, 0x03051000},
	{0x000099b4, 0x00000820},
	{0x000099dc, 0x00000000},
	{0x000099e0, 0x00000000},
	{0x000099e4, 0xaaaaaaaa},
	{0x000099e8, 0x3c466478},
	{0x000099ec, 0x0cc80caa},
	{0x000099f0, 0x00000000},
	{0x0000a208, 0x803e68c8},
	{0x0000a210, 0x4080a333},
	{0x0000a214, 0x00206c10},
	{0x0000a218, 0x009c4060},
	{0x0000a220, 0x01834061},
	{0x0000a224, 0x00000400},
	{0x0000a228, 0x000003b5},
	{0x0000a22c, 0x00000000},
	{0x0000a234, 0x20202020},
	{0x0000a238, 0x20202020},
	{0x0000a244, 0x00000000},
	{0x0000a248, 0xfffffffc},
	{0x0000a24c, 0x00000000},
	{0x0000a254, 0x00000000},
	{0x0000a258, 0x0ccb5380},
	{0x0000a25c, 0x15151501},
	{0x0000a260, 0xdfa90f01},
	{0x0000a268, 0x00000000},
	{0x0000a26c, 0x0ebae9e6},
	{0x0000d270, 0x0d820820},
	{0x0000d35c, 0x07ffffef},
	{0x0000d360, 0x0fffffe7},
	{0x0000d364, 0x17ffffe5},
	{0x0000d368, 0x1fffffe4},
	{0x0000d36c, 0x37ffffe3},
	{0x0000d370, 0x3fffffe3},
	{0x0000d374, 0x57ffffe3},
	{0x0000d378, 0x5fffffe2},
	{0x0000d37c, 0x7fffffe2},
	{0x0000d380, 0x7f3c7bba},
	{0x0000d384, 0xf3307ff0},
	{0x0000a388, 0x0c000000},
	{0x0000a38c, 0x20202020},
	{0x0000a390, 0x20202020},
	{0x0000a39c, 0x00000001},
	{0x0000a3a0, 0x00000000},
	{0x0000a3a4, 0x00000000},
	{0x0000a3a8, 0x00000000},
	{0x0000a3ac, 0x00000000},
	{0x0000a3b0, 0x00000000},
	{0x0000a3b4, 0x00000000},
	{0x0000a3b8, 0x00000000},
	{0x0000a3bc, 0x00000000},
	{0x0000a3c0, 0x00000000},
	{0x0000a3c4, 0x00000000},
	{0x0000a3cc, 0x20202020},
	{0x0000a3d0, 0x20202020},
	{0x0000a3d4, 0x20202020},
	{0x0000a3e4, 0x00000000},
	{0x0000a3e8, 0x18c43433},
	{0x0000a3ec, 0x00f70081},
	{0x00007800, 0x00140000},
	{0x00007804, 0x0e4548d8},
	{0x00007808, 0x54214514},
	{0x0000780c, 0x02025830},
	{0x00007810, 0x71c0d388},
	{0x0000781c, 0x00000000},
	{0x00007824, 0x00d86fff},
	{0x0000782c, 0x6e36d97b},
	{0x00007834, 0x71400087},
	{0x00007844, 0x000c0db6},
	{0x00007848, 0x6db6246f},
	{0x0000784c, 0x6d9b66db},
	{0x00007850, 0x6d8c6dba},
	{0x00007854, 0x00040000},
	{0x00007858, 0xdb003012},
	{0x0000785c, 0x04924914},
	{0x00007860, 0x21084210},
	{0x00007864, 0xf7d7ffde},
	{0x00007868, 0xc2034080},
	{0x00007870, 0x10142c00},
};

static const u32 ar9285Modes_high_power_tx_gain_9285_1_2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a300, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a304, 0x00000000, 0x00000000, 0x00006200, 0x00006200},
	{0x0000a308, 0x00000000, 0x00000000, 0x00008201, 0x00008201},
	{0x0000a30c, 0x00000000, 0x00000000, 0x0000b240, 0x0000b240},
	{0x0000a310, 0x00000000, 0x00000000, 0x0000d241, 0x0000d241},
	{0x0000a314, 0x00000000, 0x00000000, 0x0000f600, 0x0000f600},
	{0x0000a318, 0x00000000, 0x00000000, 0x00012800, 0x00012800},
	{0x0000a31c, 0x00000000, 0x00000000, 0x00016802, 0x00016802},
	{0x0000a320, 0x00000000, 0x00000000, 0x0001b805, 0x0001b805},
	{0x0000a324, 0x00000000, 0x00000000, 0x00021a80, 0x00021a80},
	{0x0000a328, 0x00000000, 0x00000000, 0x00028b00, 0x00028b00},
	{0x0000a32c, 0x00000000, 0x00000000, 0x0002ab40, 0x0002ab40},
	{0x0000a330, 0x00000000, 0x00000000, 0x0002cd80, 0x0002cd80},
	{0x0000a334, 0x00000000, 0x00000000, 0x00033d82, 0x00033d82},
	{0x0000a338, 0x0003891e, 0x0003891e, 0x0003891e, 0x0003891e},
	{0x0000a33c, 0x0003a95e, 0x0003a95e, 0x0003a95e, 0x0003a95e},
	{0x0000a340, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a344, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a348, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a34c, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a350, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a354, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x00007814, 0x924934a8, 0x924934a8, 0x924934a8, 0x924934a8},
	{0x00007828, 0x26d2491b, 0x26d2491b, 0x26d2491b, 0x26d2491b},
	{0x00007830, 0xedb6d96e, 0xedb6d96e, 0xedb6d96e, 0xedb6d96e},
	{0x00007838, 0xfac68803, 0xfac68803, 0xfac68803, 0xfac68803},
	{0x0000783c, 0x0001fffe, 0x0001fffe, 0x0001fffe, 0x0001fffe},
	{0x00007840, 0xffeb1a20, 0xffeb1a20, 0xffeb1a20, 0xffeb1a20},
	{0x0000786c, 0x08609ebe, 0x08609ebe, 0x08609ebe, 0x08609ebe},
	{0x00007820, 0x00000c00, 0x00000c00, 0x00000c00, 0x00000c00},
	{0x0000a274, 0x0a22a652, 0x0a22a652, 0x0a216652, 0x0a216652},
	{0x0000a278, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7},
	{0x0000a27c, 0x050380e7, 0x050380e7, 0x050380e7, 0x050380e7},
	{0x0000a394, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7},
	{0x0000a398, 0x000000e7, 0x000000e7, 0x000000e7, 0x000000e7},
	{0x0000a3dc, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7},
	{0x0000a3e0, 0x000000e7, 0x000000e7, 0x000000e7, 0x000000e7},
};

static const u32 ar9285Modes_original_tx_gain_9285_1_2[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a300, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a304, 0x00000000, 0x00000000, 0x00009200, 0x00009200},
	{0x0000a308, 0x00000000, 0x00000000, 0x00010208, 0x00010208},
	{0x0000a30c, 0x00000000, 0x00000000, 0x00019608, 0x00019608},
	{0x0000a310, 0x00000000, 0x00000000, 0x00022618, 0x00022618},
	{0x0000a314, 0x00000000, 0x00000000, 0x0002a6c9, 0x0002a6c9},
	{0x0000a318, 0x00000000, 0x00000000, 0x00031710, 0x00031710},
	{0x0000a31c, 0x00000000, 0x00000000, 0x00035718, 0x00035718},
	{0x0000a320, 0x00000000, 0x00000000, 0x00038758, 0x00038758},
	{0x0000a324, 0x00000000, 0x00000000, 0x0003c75a, 0x0003c75a},
	{0x0000a328, 0x00000000, 0x00000000, 0x0004075c, 0x0004075c},
	{0x0000a32c, 0x00000000, 0x00000000, 0x0004475e, 0x0004475e},
	{0x0000a330, 0x00000000, 0x00000000, 0x0004679f, 0x0004679f},
	{0x0000a334, 0x00000000, 0x00000000, 0x000487df, 0x000487df},
	{0x0000a338, 0x0003891e, 0x0003891e, 0x0003891e, 0x0003891e},
	{0x0000a33c, 0x0003a95e, 0x0003a95e, 0x0003a95e, 0x0003a95e},
	{0x0000a340, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a344, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a348, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a34c, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a350, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a354, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x00007814, 0x924934a8, 0x924934a8, 0x924934a8, 0x924934a8},
	{0x00007828, 0x26d2491b, 0x26d2491b, 0x26d2491b, 0x26d2491b},
	{0x00007830, 0xedb6d96e, 0xedb6d96e, 0xedb6d96e, 0xedb6d96e},
	{0x00007838, 0xfac68801, 0xfac68801, 0xfac68801, 0xfac68801},
	{0x0000783c, 0x0001fffe, 0x0001fffe, 0x0001fffe, 0x0001fffe},
	{0x00007840, 0xffeb1a20, 0xffeb1a20, 0xffeb1a20, 0xffeb1a20},
	{0x0000786c, 0x48609eb4, 0x48609eb4, 0x48609eb4, 0x48609eb4},
	{0x00007820, 0x00000c04, 0x00000c04, 0x00000c04, 0x00000c04},
	{0x0000a274, 0x0a21c652, 0x0a21c652, 0x0a21a652, 0x0a21a652},
	{0x0000a278, 0x39ce739c, 0x39ce739c, 0x39ce739c, 0x39ce739c},
	{0x0000a27c, 0x050e039c, 0x050e039c, 0x050e039c, 0x050e039c},
	{0x0000a394, 0x39ce739c, 0x39ce739c, 0x39ce739c, 0x39ce739c},
	{0x0000a398, 0x0000039c, 0x0000039c, 0x0000039c, 0x0000039c},
	{0x0000a3dc, 0x39ce739c, 0x39ce739c, 0x39ce739c, 0x39ce739c},
	{0x0000a3e0, 0x0000039c, 0x0000039c, 0x0000039c, 0x0000039c},
};

static const u32 ar9285Modes_XE2_0_normal_power[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a300, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a304, 0x00000000, 0x00000000, 0x00009200, 0x00009200},
	{0x0000a308, 0x00000000, 0x00000000, 0x00010208, 0x00010208},
	{0x0000a30c, 0x00000000, 0x00000000, 0x00019608, 0x00019608},
	{0x0000a310, 0x00000000, 0x00000000, 0x00022618, 0x00022618},
	{0x0000a314, 0x00000000, 0x00000000, 0x0002a6c9, 0x0002a6c9},
	{0x0000a318, 0x00000000, 0x00000000, 0x00031710, 0x00031710},
	{0x0000a31c, 0x00000000, 0x00000000, 0x00035718, 0x00035718},
	{0x0000a320, 0x00000000, 0x00000000, 0x00038758, 0x00038758},
	{0x0000a324, 0x00000000, 0x00000000, 0x0003c75a, 0x0003c75a},
	{0x0000a328, 0x00000000, 0x00000000, 0x0004075c, 0x0004075c},
	{0x0000a32c, 0x00000000, 0x00000000, 0x0004475e, 0x0004475e},
	{0x0000a330, 0x00000000, 0x00000000, 0x0004679f, 0x0004679f},
	{0x0000a334, 0x00000000, 0x00000000, 0x000487df, 0x000487df},
	{0x0000a338, 0x0003891e, 0x0003891e, 0x0003891e, 0x0003891e},
	{0x0000a33c, 0x0003a95e, 0x0003a95e, 0x0003a95e, 0x0003a95e},
	{0x0000a340, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a344, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a348, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a34c, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a350, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a354, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x00007814, 0x92497ca8, 0x92497ca8, 0x92497ca8, 0x92497ca8},
	{0x00007828, 0x4ad2491b, 0x4ad2491b, 0x2ad2491b, 0x4ad2491b},
	{0x00007830, 0xedb6da6e, 0xedb6da6e, 0xedb6da6e, 0xedb6da6e},
	{0x00007838, 0xdac71441, 0xdac71441, 0xdac71441, 0xdac71441},
	{0x0000783c, 0x2481f6fe, 0x2481f6fe, 0x2481f6fe, 0x2481f6fe},
	{0x00007840, 0xba5f638c, 0xba5f638c, 0xba5f638c, 0xba5f638c},
	{0x0000786c, 0x48609eb4, 0x48609eb4, 0x48609eb4, 0x48609eb4},
	{0x00007820, 0x00000c04, 0x00000c04, 0x00000c04, 0x00000c04},
	{0x0000a274, 0x0a21c652, 0x0a21c652, 0x0a21a652, 0x0a21a652},
	{0x0000a278, 0x39ce739c, 0x39ce739c, 0x39ce739c, 0x39ce739c},
	{0x0000a27c, 0x050e039c, 0x050e039c, 0x050e039c, 0x050e039c},
	{0x0000a394, 0x39ce739c, 0x39ce739c, 0x39ce739c, 0x39ce739c},
	{0x0000a398, 0x0000039c, 0x0000039c, 0x0000039c, 0x0000039c},
	{0x0000a3dc, 0x39ce739c, 0x39ce739c, 0x39ce739c, 0x39ce739c},
	{0x0000a3e0, 0x0000039c, 0x0000039c, 0x0000039c, 0x0000039c},
};

static const u32 ar9285Modes_XE2_0_high_power[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a300, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a304, 0x00000000, 0x00000000, 0x00006200, 0x00006200},
	{0x0000a308, 0x00000000, 0x00000000, 0x00008201, 0x00008201},
	{0x0000a30c, 0x00000000, 0x00000000, 0x0000b240, 0x0000b240},
	{0x0000a310, 0x00000000, 0x00000000, 0x0000d241, 0x0000d241},
	{0x0000a314, 0x00000000, 0x00000000, 0x0000f600, 0x0000f600},
	{0x0000a318, 0x00000000, 0x00000000, 0x00012800, 0x00012800},
	{0x0000a31c, 0x00000000, 0x00000000, 0x00016802, 0x00016802},
	{0x0000a320, 0x00000000, 0x00000000, 0x0001b805, 0x0001b805},
	{0x0000a324, 0x00000000, 0x00000000, 0x00021a80, 0x00021a80},
	{0x0000a328, 0x00000000, 0x00000000, 0x00028b00, 0x00028b00},
	{0x0000a32c, 0x00000000, 0x00000000, 0x0002ab40, 0x0002ab40},
	{0x0000a330, 0x00000000, 0x00000000, 0x0002cd80, 0x0002cd80},
	{0x0000a334, 0x00000000, 0x00000000, 0x00033d82, 0x00033d82},
	{0x0000a338, 0x0003891e, 0x0003891e, 0x0003891e, 0x0003891e},
	{0x0000a33c, 0x0003a95e, 0x0003a95e, 0x0003a95e, 0x0003a95e},
	{0x0000a340, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a344, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a348, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a34c, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a350, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a354, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x00007814, 0x92497ca8, 0x92497ca8, 0x92497ca8, 0x92497ca8},
	{0x00007828, 0x4ad2491b, 0x4ad2491b, 0x2ad2491b, 0x4ad2491b},
	{0x00007830, 0xedb6da6e, 0xedb6da6e, 0xedb6da6e, 0xedb6da6e},
	{0x00007838, 0xdac71443, 0xdac71443, 0xdac71443, 0xdac71443},
	{0x0000783c, 0x2481f6fe, 0x2481f6fe, 0x2481f6fe, 0x2481f6fe},
	{0x00007840, 0xba5f638c, 0xba5f638c, 0xba5f638c, 0xba5f638c},
	{0x0000786c, 0x08609ebe, 0x08609ebe, 0x08609ebe, 0x08609ebe},
	{0x00007820, 0x00000c00, 0x00000c00, 0x00000c00, 0x00000c00},
	{0x0000a274, 0x0a22a652, 0x0a22a652, 0x0a216652, 0x0a216652},
	{0x0000a278, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7},
	{0x0000a27c, 0x050380e7, 0x050380e7, 0x050380e7, 0x050380e7},
	{0x0000a394, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7},
	{0x0000a398, 0x000000e7, 0x000000e7, 0x000000e7, 0x000000e7},
	{0x0000a3dc, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7},
	{0x0000a3e0, 0x000000e7, 0x000000e7, 0x000000e7, 0x000000e7},
};

static const u32 ar9287Modes_9287_1_1[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00001030, 0x00000000, 0x00000000, 0x000002c0, 0x00000160},
	{0x00001070, 0x00000000, 0x00000000, 0x00000318, 0x0000018c},
	{0x000010b0, 0x00000000, 0x00000000, 0x00007c70, 0x00003e38},
	{0x000010f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00008014, 0x00000000, 0x00000000, 0x10801600, 0x08400b00},
	{0x0000801c, 0x00000000, 0x00000000, 0x12e00057, 0x12e0002b},
	{0x00008120, 0x08f04800, 0x08f04800, 0x08f04810, 0x08f04810},
	{0x000081d0, 0x00003200, 0x00003200, 0x0000320a, 0x0000320a},
	{0x00008318, 0x00000000, 0x00000000, 0x00006880, 0x00003440},
	{0x00009804, 0x00000000, 0x00000000, 0x000003c4, 0x00000300},
	{0x00009820, 0x00000000, 0x00000000, 0x02020200, 0x02020200},
	{0x00009824, 0x00000000, 0x00000000, 0x01000e0e, 0x01000e0e},
	{0x00009828, 0x00000000, 0x00000000, 0x3a020001, 0x3a020001},
	{0x00009834, 0x00000000, 0x00000000, 0x00000e0e, 0x00000e0e},
	{0x00009838, 0x00000003, 0x00000003, 0x00000007, 0x00000007},
	{0x00009840, 0x206a002e, 0x206a002e, 0x206a012e, 0x206a012e},
	{0x00009844, 0x03720000, 0x03720000, 0x037216a0, 0x037216a0},
	{0x00009850, 0x60000000, 0x60000000, 0x6d4000e2, 0x6c4000e2},
	{0x00009858, 0x7c000d00, 0x7c000d00, 0x7ec84d2e, 0x7ec84d2e},
	{0x0000985c, 0x3100005e, 0x3100005e, 0x3139605e, 0x31395d5e},
	{0x00009860, 0x00058d00, 0x00058d00, 0x00058d20, 0x00058d20},
	{0x00009864, 0x00000e00, 0x00000e00, 0x0001ce00, 0x0001ce00},
	{0x00009868, 0x000040c0, 0x000040c0, 0x5ac640d0, 0x5ac640d0},
	{0x0000986c, 0x00000080, 0x00000080, 0x06903881, 0x06903881},
	{0x00009914, 0x00000000, 0x00000000, 0x00001130, 0x00000898},
	{0x00009918, 0x00000000, 0x00000000, 0x00000016, 0x0000000b},
	{0x00009924, 0xd00a8a01, 0xd00a8a01, 0xd00a8a0d, 0xd00a8a0d},
	{0x00009944, 0xefbc0000, 0xefbc0000, 0xefbc1010, 0xefbc1010},
	{0x00009960, 0x00000000, 0x00000000, 0x00000010, 0x00000010},
	{0x0000a960, 0x00000000, 0x00000000, 0x00000010, 0x00000010},
	{0x00009964, 0x00000000, 0x00000000, 0x00000210, 0x00000210},
	{0x0000c968, 0x00000200, 0x00000200, 0x000003ce, 0x000003ce},
	{0x000099b8, 0x00000000, 0x00000000, 0x0000001c, 0x0000001c},
	{0x000099bc, 0x00000000, 0x00000000, 0x00000c00, 0x00000c00},
	{0x000099c0, 0x00000000, 0x00000000, 0x05eea6d4, 0x05eea6d4},
	{0x0000a204, 0x00000440, 0x00000440, 0x00000444, 0x00000444},
	{0x0000a20c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000b20c, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a21c, 0x1803800a, 0x1803800a, 0x1883800a, 0x1883800a},
	{0x0000a230, 0x00000000, 0x00000000, 0x00000210, 0x00000108},
	{0x0000a250, 0x00000000, 0x00000000, 0x0004a000, 0x0004a000},
	{0x0000a358, 0x7999aa02, 0x7999aa02, 0x7999aa0e, 0x7999aa0e},
	{0x0000a3d8, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
};

static const u32 ar9287Common_9287_1_1[][2] = {
	/* Addr      allmodes  */
	{0x0000000c, 0x00000000},
	{0x00000030, 0x00020015},
	{0x00000034, 0x00000005},
	{0x00000040, 0x00000000},
	{0x00000044, 0x00000008},
	{0x00000048, 0x00000008},
	{0x0000004c, 0x00000010},
	{0x00000050, 0x00000000},
	{0x00000054, 0x0000001f},
	{0x00000800, 0x00000000},
	{0x00000804, 0x00000000},
	{0x00000808, 0x00000000},
	{0x0000080c, 0x00000000},
	{0x00000810, 0x00000000},
	{0x00000814, 0x00000000},
	{0x00000818, 0x00000000},
	{0x0000081c, 0x00000000},
	{0x00000820, 0x00000000},
	{0x00000824, 0x00000000},
	{0x00001040, 0x002ffc0f},
	{0x00001044, 0x002ffc0f},
	{0x00001048, 0x002ffc0f},
	{0x0000104c, 0x002ffc0f},
	{0x00001050, 0x002ffc0f},
	{0x00001054, 0x002ffc0f},
	{0x00001058, 0x002ffc0f},
	{0x0000105c, 0x002ffc0f},
	{0x00001060, 0x002ffc0f},
	{0x00001064, 0x002ffc0f},
	{0x00001230, 0x00000000},
	{0x00001270, 0x00000000},
	{0x00001038, 0x00000000},
	{0x00001078, 0x00000000},
	{0x000010b8, 0x00000000},
	{0x000010f8, 0x00000000},
	{0x00001138, 0x00000000},
	{0x00001178, 0x00000000},
	{0x000011b8, 0x00000000},
	{0x000011f8, 0x00000000},
	{0x00001238, 0x00000000},
	{0x00001278, 0x00000000},
	{0x000012b8, 0x00000000},
	{0x000012f8, 0x00000000},
	{0x00001338, 0x00000000},
	{0x00001378, 0x00000000},
	{0x000013b8, 0x00000000},
	{0x000013f8, 0x00000000},
	{0x00001438, 0x00000000},
	{0x00001478, 0x00000000},
	{0x000014b8, 0x00000000},
	{0x000014f8, 0x00000000},
	{0x00001538, 0x00000000},
	{0x00001578, 0x00000000},
	{0x000015b8, 0x00000000},
	{0x000015f8, 0x00000000},
	{0x00001638, 0x00000000},
	{0x00001678, 0x00000000},
	{0x000016b8, 0x00000000},
	{0x000016f8, 0x00000000},
	{0x00001738, 0x00000000},
	{0x00001778, 0x00000000},
	{0x000017b8, 0x00000000},
	{0x000017f8, 0x00000000},
	{0x0000103c, 0x00000000},
	{0x0000107c, 0x00000000},
	{0x000010bc, 0x00000000},
	{0x000010fc, 0x00000000},
	{0x0000113c, 0x00000000},
	{0x0000117c, 0x00000000},
	{0x000011bc, 0x00000000},
	{0x000011fc, 0x00000000},
	{0x0000123c, 0x00000000},
	{0x0000127c, 0x00000000},
	{0x000012bc, 0x00000000},
	{0x000012fc, 0x00000000},
	{0x0000133c, 0x00000000},
	{0x0000137c, 0x00000000},
	{0x000013bc, 0x00000000},
	{0x000013fc, 0x00000000},
	{0x0000143c, 0x00000000},
	{0x0000147c, 0x00000000},
	{0x00004030, 0x00000002},
	{0x0000403c, 0x00000002},
	{0x00004024, 0x0000001f},
	{0x00004060, 0x00000000},
	{0x00004064, 0x00000000},
	{0x00007010, 0x00000033},
	{0x00007020, 0x00000000},
	{0x00007034, 0x00000002},
	{0x00007038, 0x000004c2},
	{0x00008004, 0x00000000},
	{0x00008008, 0x00000000},
	{0x0000800c, 0x00000000},
	{0x00008018, 0x00000700},
	{0x00008020, 0x00000000},
	{0x00008038, 0x00000000},
	{0x0000803c, 0x00000000},
	{0x00008048, 0x40000000},
	{0x00008054, 0x00000000},
	{0x00008058, 0x00000000},
	{0x0000805c, 0x000fc78f},
	{0x00008060, 0x0000000f},
	{0x00008064, 0x00000000},
	{0x00008070, 0x00000000},
	{0x000080c0, 0x2a80001a},
	{0x000080c4, 0x05dc01e0},
	{0x000080c8, 0x1f402710},
	{0x000080cc, 0x01f40000},
	{0x000080d0, 0x00001e00},
	{0x000080d4, 0x00000000},
	{0x000080d8, 0x00400000},
	{0x000080e0, 0xffffffff},
	{0x000080e4, 0x0000ffff},
	{0x000080e8, 0x003f3f3f},
	{0x000080ec, 0x00000000},
	{0x000080f0, 0x00000000},
	{0x000080f4, 0x00000000},
	{0x000080f8, 0x00000000},
	{0x000080fc, 0x00020000},
	{0x00008100, 0x00020000},
	{0x00008104, 0x00000001},
	{0x00008108, 0x00000052},
	{0x0000810c, 0x00000000},
	{0x00008110, 0x00000168},
	{0x00008118, 0x000100aa},
	{0x0000811c, 0x00003210},
	{0x00008124, 0x00000000},
	{0x00008128, 0x00000000},
	{0x0000812c, 0x00000000},
	{0x00008130, 0x00000000},
	{0x00008134, 0x00000000},
	{0x00008138, 0x00000000},
	{0x0000813c, 0x00000000},
	{0x00008144, 0xffffffff},
	{0x00008168, 0x00000000},
	{0x0000816c, 0x00000000},
	{0x00008170, 0x18487320},
	{0x00008174, 0xfaa4fa50},
	{0x00008178, 0x00000100},
	{0x0000817c, 0x00000000},
	{0x000081c0, 0x00000000},
	{0x000081c4, 0x00000000},
	{0x000081d4, 0x00000000},
	{0x000081ec, 0x00000000},
	{0x000081f0, 0x00000000},
	{0x000081f4, 0x00000000},
	{0x000081f8, 0x00000000},
	{0x000081fc, 0x00000000},
	{0x00008200, 0x00000000},
	{0x00008204, 0x00000000},
	{0x00008208, 0x00000000},
	{0x0000820c, 0x00000000},
	{0x00008210, 0x00000000},
	{0x00008214, 0x00000000},
	{0x00008218, 0x00000000},
	{0x0000821c, 0x00000000},
	{0x00008220, 0x00000000},
	{0x00008224, 0x00000000},
	{0x00008228, 0x00000000},
	{0x0000822c, 0x00000000},
	{0x00008230, 0x00000000},
	{0x00008234, 0x00000000},
	{0x00008238, 0x00000000},
	{0x0000823c, 0x00000000},
	{0x00008240, 0x00100000},
	{0x00008244, 0x0010f400},
	{0x00008248, 0x00000100},
	{0x0000824c, 0x0001e800},
	{0x00008250, 0x00000000},
	{0x00008254, 0x00000000},
	{0x00008258, 0x00000000},
	{0x0000825c, 0x400000ff},
	{0x00008260, 0x00080922},
	{0x00008264, 0x88a00010},
	{0x00008270, 0x00000000},
	{0x00008274, 0x40000000},
	{0x00008278, 0x003e4180},
	{0x0000827c, 0x00000000},
	{0x00008284, 0x0000002c},
	{0x00008288, 0x0000002c},
	{0x0000828c, 0x000000ff},
	{0x00008294, 0x00000000},
	{0x00008298, 0x00000000},
	{0x0000829c, 0x00000000},
	{0x00008300, 0x00000040},
	{0x00008314, 0x00000000},
	{0x00008328, 0x00000000},
	{0x0000832c, 0x00000007},
	{0x00008330, 0x00000302},
	{0x00008334, 0x00000e00},
	{0x00008338, 0x00ff0000},
	{0x0000833c, 0x00000000},
	{0x00008340, 0x000107ff},
	{0x00008344, 0x01c81043},
	{0x00008360, 0xffffffff},
	{0x00008364, 0xffffffff},
	{0x00008368, 0x00000000},
	{0x00008370, 0x00000000},
	{0x00008374, 0x000000ff},
	{0x00008378, 0x00000000},
	{0x0000837c, 0x00000000},
	{0x00008380, 0xffffffff},
	{0x00008384, 0xffffffff},
	{0x00008390, 0x0fffffff},
	{0x00008394, 0x0fffffff},
	{0x00008398, 0x00000000},
	{0x0000839c, 0x00000000},
	{0x000083a0, 0x00000000},
	{0x00009808, 0x00000000},
	{0x0000980c, 0xafe68e30},
	{0x00009810, 0xfd14e000},
	{0x00009814, 0x9c0a9f6b},
	{0x0000981c, 0x00000000},
	{0x0000982c, 0x0000a000},
	{0x00009830, 0x00000000},
	{0x0000983c, 0x00200400},
	{0x0000984c, 0x0040233c},
	{0x0000a84c, 0x0040233c},
	{0x00009854, 0x00000044},
	{0x00009900, 0x00000000},
	{0x00009904, 0x00000000},
	{0x00009908, 0x00000000},
	{0x0000990c, 0x00000000},
	{0x00009910, 0x10002310},
	{0x0000991c, 0x10000fff},
	{0x00009920, 0x04900000},
	{0x0000a920, 0x04900000},
	{0x00009928, 0x00000001},
	{0x0000992c, 0x00000004},
	{0x00009930, 0x00000000},
	{0x0000a930, 0x00000000},
	{0x00009934, 0x1e1f2022},
	{0x00009938, 0x0a0b0c0d},
	{0x0000993c, 0x00000000},
	{0x00009948, 0x9280c00a},
	{0x0000994c, 0x00020028},
	{0x00009954, 0x5f3ca3de},
	{0x00009958, 0x0108ecff},
	{0x00009940, 0x14750604},
	{0x0000c95c, 0x004b6a8e},
	{0x00009970, 0x990bb514},
	{0x00009974, 0x00000000},
	{0x00009978, 0x00000001},
	{0x0000997c, 0x00000000},
	{0x000099a0, 0x00000000},
	{0x000099a4, 0x00000001},
	{0x000099a8, 0x201fff00},
	{0x000099ac, 0x0c6f0000},
	{0x000099b0, 0x03051000},
	{0x000099b4, 0x00000820},
	{0x000099c4, 0x06336f77},
	{0x000099c8, 0x6af6532f},
	{0x000099cc, 0x08f186c8},
	{0x000099d0, 0x00046384},
	{0x000099dc, 0x00000000},
	{0x000099e0, 0x00000000},
	{0x000099e4, 0xaaaaaaaa},
	{0x000099e8, 0x3c466478},
	{0x000099ec, 0x0cc80caa},
	{0x000099f0, 0x00000000},
	{0x000099fc, 0x00001042},
	{0x0000a208, 0x803e4788},
	{0x0000a210, 0x4080a333},
	{0x0000a214, 0x40206c10},
	{0x0000a218, 0x009c4060},
	{0x0000a220, 0x01834061},
	{0x0000a224, 0x00000400},
	{0x0000a228, 0x000003b5},
	{0x0000a22c, 0x233f7180},
	{0x0000a234, 0x20202020},
	{0x0000a238, 0x20202020},
	{0x0000a23c, 0x13c889af},
	{0x0000a240, 0x38490a20},
	{0x0000a244, 0x00000000},
	{0x0000a248, 0xfffffffc},
	{0x0000a24c, 0x00000000},
	{0x0000a254, 0x00000000},
	{0x0000a258, 0x0cdbd380},
	{0x0000a25c, 0x0f0f0f01},
	{0x0000a260, 0xdfa91f01},
	{0x0000a264, 0x00418a11},
	{0x0000b264, 0x00418a11},
	{0x0000a268, 0x00000000},
	{0x0000a26c, 0x0e79e5c6},
	{0x0000b26c, 0x0e79e5c6},
	{0x0000d270, 0x00820820},
	{0x0000a278, 0x1ce739ce},
	{0x0000a27c, 0x050701ce},
	{0x0000d35c, 0x07ffffef},
	{0x0000d360, 0x0fffffe7},
	{0x0000d364, 0x17ffffe5},
	{0x0000d368, 0x1fffffe4},
	{0x0000d36c, 0x37ffffe3},
	{0x0000d370, 0x3fffffe3},
	{0x0000d374, 0x57ffffe3},
	{0x0000d378, 0x5fffffe2},
	{0x0000d37c, 0x7fffffe2},
	{0x0000d380, 0x7f3c7bba},
	{0x0000d384, 0xf3307ff0},
	{0x0000a388, 0x0c000000},
	{0x0000a38c, 0x20202020},
	{0x0000a390, 0x20202020},
	{0x0000a394, 0x1ce739ce},
	{0x0000a398, 0x000001ce},
	{0x0000b398, 0x000001ce},
	{0x0000a39c, 0x00000001},
	{0x0000a3c8, 0x00000246},
	{0x0000a3cc, 0x20202020},
	{0x0000a3d0, 0x20202020},
	{0x0000a3d4, 0x20202020},
	{0x0000a3dc, 0x1ce739ce},
	{0x0000a3e0, 0x000001ce},
	{0x0000a3e4, 0x00000000},
	{0x0000a3e8, 0x18c43433},
	{0x0000a3ec, 0x00f70081},
	{0x0000a3f0, 0x01036a1e},
	{0x0000a3f4, 0x00000000},
	{0x0000b3f4, 0x00000000},
	{0x0000a7d8, 0x000003f1},
	{0x00007800, 0x00000800},
	{0x00007804, 0x6c35ffd2},
	{0x00007808, 0x6db6c000},
	{0x0000780c, 0x6db6cb30},
	{0x00007810, 0x6db6cb6c},
	{0x00007814, 0x0501e200},
	{0x00007818, 0x0094128d},
	{0x0000781c, 0x976ee392},
	{0x00007820, 0xf75ff6fc},
	{0x00007824, 0x00040000},
	{0x00007828, 0xdb003012},
	{0x0000782c, 0x04924914},
	{0x00007830, 0x21084210},
	{0x00007834, 0x00140000},
	{0x00007838, 0x0e4548d8},
	{0x0000783c, 0x54214514},
	{0x00007840, 0x02025830},
	{0x00007844, 0x71c0d388},
	{0x00007848, 0x934934a8},
	{0x00007850, 0x00000000},
	{0x00007854, 0x00000800},
	{0x00007858, 0x6c35ffd2},
	{0x0000785c, 0x6db6c000},
	{0x00007860, 0x6db6cb30},
	{0x00007864, 0x6db6cb6c},
	{0x00007868, 0x0501e200},
	{0x0000786c, 0x0094128d},
	{0x00007870, 0x976ee392},
	{0x00007874, 0xf75ff6fc},
	{0x00007878, 0x00040000},
	{0x0000787c, 0xdb003012},
	{0x00007880, 0x04924914},
	{0x00007884, 0x21084210},
	{0x00007888, 0x001b6db0},
	{0x0000788c, 0x00376b63},
	{0x00007890, 0x06db6db6},
	{0x00007894, 0x006d8000},
	{0x00007898, 0x48100000},
	{0x0000789c, 0x00000000},
	{0x000078a0, 0x08000000},
	{0x000078a4, 0x0007ffd8},
	{0x000078a8, 0x0007ffd8},
	{0x000078ac, 0x001c0020},
	{0x000078b0, 0x00060aeb},
	{0x000078b4, 0x40008080},
	{0x000078b8, 0x2a850160},
};

static const u32 ar9287Common_normal_cck_fir_coeff_9287_1_1[][2] = {
	/* Addr      allmodes  */
	{0x0000a1f4, 0x00fffeff},
	{0x0000a1f8, 0x00f5f9ff},
	{0x0000a1fc, 0xb79f6427},
};

static const u32 ar9287Common_japan_2484_cck_fir_coeff_9287_1_1[][2] = {
	/* Addr      allmodes  */
	{0x0000a1f4, 0x00000000},
	{0x0000a1f8, 0xefff0301},
	{0x0000a1fc, 0xca9228ee},
};

static const u32 ar9287Modes_tx_gain_9287_1_1[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a300, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a304, 0x00000000, 0x00000000, 0x00004002, 0x00004002},
	{0x0000a308, 0x00000000, 0x00000000, 0x00008004, 0x00008004},
	{0x0000a30c, 0x00000000, 0x00000000, 0x0000c00a, 0x0000c00a},
	{0x0000a310, 0x00000000, 0x00000000, 0x0001000c, 0x0001000c},
	{0x0000a314, 0x00000000, 0x00000000, 0x0001420b, 0x0001420b},
	{0x0000a318, 0x00000000, 0x00000000, 0x0001824a, 0x0001824a},
	{0x0000a31c, 0x00000000, 0x00000000, 0x0001c44a, 0x0001c44a},
	{0x0000a320, 0x00000000, 0x00000000, 0x0002064a, 0x0002064a},
	{0x0000a324, 0x00000000, 0x00000000, 0x0002484a, 0x0002484a},
	{0x0000a328, 0x00000000, 0x00000000, 0x00028a4a, 0x00028a4a},
	{0x0000a32c, 0x00000000, 0x00000000, 0x0002cc4a, 0x0002cc4a},
	{0x0000a330, 0x00000000, 0x00000000, 0x00030e4a, 0x00030e4a},
	{0x0000a334, 0x00000000, 0x00000000, 0x00034e8a, 0x00034e8a},
	{0x0000a338, 0x00000000, 0x00000000, 0x00038e8c, 0x00038e8c},
	{0x0000a33c, 0x00000000, 0x00000000, 0x0003cecc, 0x0003cecc},
	{0x0000a340, 0x00000000, 0x00000000, 0x00040ed4, 0x00040ed4},
	{0x0000a344, 0x00000000, 0x00000000, 0x00044edc, 0x00044edc},
	{0x0000a348, 0x00000000, 0x00000000, 0x00048ede, 0x00048ede},
	{0x0000a34c, 0x00000000, 0x00000000, 0x0004cf1e, 0x0004cf1e},
	{0x0000a350, 0x00000000, 0x00000000, 0x00050f5e, 0x00050f5e},
	{0x0000a354, 0x00000000, 0x00000000, 0x00054f9e, 0x00054f9e},
	{0x0000a780, 0x00000000, 0x00000000, 0x00000062, 0x00000062},
	{0x0000a784, 0x00000000, 0x00000000, 0x00004064, 0x00004064},
	{0x0000a788, 0x00000000, 0x00000000, 0x000080a4, 0x000080a4},
	{0x0000a78c, 0x00000000, 0x00000000, 0x0000c0aa, 0x0000c0aa},
	{0x0000a790, 0x00000000, 0x00000000, 0x000100ac, 0x000100ac},
	{0x0000a794, 0x00000000, 0x00000000, 0x000140b4, 0x000140b4},
	{0x0000a798, 0x00000000, 0x00000000, 0x000180f4, 0x000180f4},
	{0x0000a79c, 0x00000000, 0x00000000, 0x0001c134, 0x0001c134},
	{0x0000a7a0, 0x00000000, 0x00000000, 0x00020174, 0x00020174},
	{0x0000a7a4, 0x00000000, 0x00000000, 0x0002417c, 0x0002417c},
	{0x0000a7a8, 0x00000000, 0x00000000, 0x0002817e, 0x0002817e},
	{0x0000a7ac, 0x00000000, 0x00000000, 0x0002c1be, 0x0002c1be},
	{0x0000a7b0, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a7b4, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a7b8, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a7bc, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a7c0, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a7c4, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a7c8, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a7cc, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a7d0, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a7d4, 0x00000000, 0x00000000, 0x000301fe, 0x000301fe},
	{0x0000a274, 0x0a180000, 0x0a180000, 0x0a1aa000, 0x0a1aa000},
};

static const u32 ar9287Modes_rx_gain_9287_1_1[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00009a00, 0x00000000, 0x00000000, 0x0000a120, 0x0000a120},
	{0x00009a04, 0x00000000, 0x00000000, 0x0000a124, 0x0000a124},
	{0x00009a08, 0x00000000, 0x00000000, 0x0000a128, 0x0000a128},
	{0x00009a0c, 0x00000000, 0x00000000, 0x0000a12c, 0x0000a12c},
	{0x00009a10, 0x00000000, 0x00000000, 0x0000a130, 0x0000a130},
	{0x00009a14, 0x00000000, 0x00000000, 0x0000a194, 0x0000a194},
	{0x00009a18, 0x00000000, 0x00000000, 0x0000a198, 0x0000a198},
	{0x00009a1c, 0x00000000, 0x00000000, 0x0000a20c, 0x0000a20c},
	{0x00009a20, 0x00000000, 0x00000000, 0x0000a210, 0x0000a210},
	{0x00009a24, 0x00000000, 0x00000000, 0x0000a284, 0x0000a284},
	{0x00009a28, 0x00000000, 0x00000000, 0x0000a288, 0x0000a288},
	{0x00009a2c, 0x00000000, 0x00000000, 0x0000a28c, 0x0000a28c},
	{0x00009a30, 0x00000000, 0x00000000, 0x0000a290, 0x0000a290},
	{0x00009a34, 0x00000000, 0x00000000, 0x0000a294, 0x0000a294},
	{0x00009a38, 0x00000000, 0x00000000, 0x0000a2a0, 0x0000a2a0},
	{0x00009a3c, 0x00000000, 0x00000000, 0x0000a2a4, 0x0000a2a4},
	{0x00009a40, 0x00000000, 0x00000000, 0x0000a2a8, 0x0000a2a8},
	{0x00009a44, 0x00000000, 0x00000000, 0x0000a2ac, 0x0000a2ac},
	{0x00009a48, 0x00000000, 0x00000000, 0x0000a2b0, 0x0000a2b0},
	{0x00009a4c, 0x00000000, 0x00000000, 0x0000a2b4, 0x0000a2b4},
	{0x00009a50, 0x00000000, 0x00000000, 0x0000a2b8, 0x0000a2b8},
	{0x00009a54, 0x00000000, 0x00000000, 0x0000a2c4, 0x0000a2c4},
	{0x00009a58, 0x00000000, 0x00000000, 0x0000a708, 0x0000a708},
	{0x00009a5c, 0x00000000, 0x00000000, 0x0000a70c, 0x0000a70c},
	{0x00009a60, 0x00000000, 0x00000000, 0x0000a710, 0x0000a710},
	{0x00009a64, 0x00000000, 0x00000000, 0x0000ab04, 0x0000ab04},
	{0x00009a68, 0x00000000, 0x00000000, 0x0000ab08, 0x0000ab08},
	{0x00009a6c, 0x00000000, 0x00000000, 0x0000ab0c, 0x0000ab0c},
	{0x00009a70, 0x00000000, 0x00000000, 0x0000ab10, 0x0000ab10},
	{0x00009a74, 0x00000000, 0x00000000, 0x0000ab14, 0x0000ab14},
	{0x00009a78, 0x00000000, 0x00000000, 0x0000ab18, 0x0000ab18},
	{0x00009a7c, 0x00000000, 0x00000000, 0x0000ab8c, 0x0000ab8c},
	{0x00009a80, 0x00000000, 0x00000000, 0x0000ab90, 0x0000ab90},
	{0x00009a84, 0x00000000, 0x00000000, 0x0000ab94, 0x0000ab94},
	{0x00009a88, 0x00000000, 0x00000000, 0x0000ab98, 0x0000ab98},
	{0x00009a8c, 0x00000000, 0x00000000, 0x0000aba4, 0x0000aba4},
	{0x00009a90, 0x00000000, 0x00000000, 0x0000aba8, 0x0000aba8},
	{0x00009a94, 0x00000000, 0x00000000, 0x0000cb04, 0x0000cb04},
	{0x00009a98, 0x00000000, 0x00000000, 0x0000cb08, 0x0000cb08},
	{0x00009a9c, 0x00000000, 0x00000000, 0x0000cb0c, 0x0000cb0c},
	{0x00009aa0, 0x00000000, 0x00000000, 0x0000cb10, 0x0000cb10},
	{0x00009aa4, 0x00000000, 0x00000000, 0x0000cb14, 0x0000cb14},
	{0x00009aa8, 0x00000000, 0x00000000, 0x0000cb18, 0x0000cb18},
	{0x00009aac, 0x00000000, 0x00000000, 0x0000cb8c, 0x0000cb8c},
	{0x00009ab0, 0x00000000, 0x00000000, 0x0000cb90, 0x0000cb90},
	{0x00009ab4, 0x00000000, 0x00000000, 0x0000cf18, 0x0000cf18},
	{0x00009ab8, 0x00000000, 0x00000000, 0x0000cf24, 0x0000cf24},
	{0x00009abc, 0x00000000, 0x00000000, 0x0000cf28, 0x0000cf28},
	{0x00009ac0, 0x00000000, 0x00000000, 0x0000d314, 0x0000d314},
	{0x00009ac4, 0x00000000, 0x00000000, 0x0000d318, 0x0000d318},
	{0x00009ac8, 0x00000000, 0x00000000, 0x0000d38c, 0x0000d38c},
	{0x00009acc, 0x00000000, 0x00000000, 0x0000d390, 0x0000d390},
	{0x00009ad0, 0x00000000, 0x00000000, 0x0000d394, 0x0000d394},
	{0x00009ad4, 0x00000000, 0x00000000, 0x0000d398, 0x0000d398},
	{0x00009ad8, 0x00000000, 0x00000000, 0x0000d3a4, 0x0000d3a4},
	{0x00009adc, 0x00000000, 0x00000000, 0x0000d3a8, 0x0000d3a8},
	{0x00009ae0, 0x00000000, 0x00000000, 0x0000d3ac, 0x0000d3ac},
	{0x00009ae4, 0x00000000, 0x00000000, 0x0000d3b0, 0x0000d3b0},
	{0x00009ae8, 0x00000000, 0x00000000, 0x0000f380, 0x0000f380},
	{0x00009aec, 0x00000000, 0x00000000, 0x0000f384, 0x0000f384},
	{0x00009af0, 0x00000000, 0x00000000, 0x0000f388, 0x0000f388},
	{0x00009af4, 0x00000000, 0x00000000, 0x0000f710, 0x0000f710},
	{0x00009af8, 0x00000000, 0x00000000, 0x0000f714, 0x0000f714},
	{0x00009afc, 0x00000000, 0x00000000, 0x0000f718, 0x0000f718},
	{0x00009b00, 0x00000000, 0x00000000, 0x0000fb10, 0x0000fb10},
	{0x00009b04, 0x00000000, 0x00000000, 0x0000fb14, 0x0000fb14},
	{0x00009b08, 0x00000000, 0x00000000, 0x0000fb18, 0x0000fb18},
	{0x00009b0c, 0x00000000, 0x00000000, 0x0000fb8c, 0x0000fb8c},
	{0x00009b10, 0x00000000, 0x00000000, 0x0000fb90, 0x0000fb90},
	{0x00009b14, 0x00000000, 0x00000000, 0x0000fb94, 0x0000fb94},
	{0x00009b18, 0x00000000, 0x00000000, 0x0000ff8c, 0x0000ff8c},
	{0x00009b1c, 0x00000000, 0x00000000, 0x0000ff90, 0x0000ff90},
	{0x00009b20, 0x00000000, 0x00000000, 0x0000ff94, 0x0000ff94},
	{0x00009b24, 0x00000000, 0x00000000, 0x0000ffa0, 0x0000ffa0},
	{0x00009b28, 0x00000000, 0x00000000, 0x0000ffa4, 0x0000ffa4},
	{0x00009b2c, 0x00000000, 0x00000000, 0x0000ffa8, 0x0000ffa8},
	{0x00009b30, 0x00000000, 0x00000000, 0x0000ffac, 0x0000ffac},
	{0x00009b34, 0x00000000, 0x00000000, 0x0000ffb0, 0x0000ffb0},
	{0x00009b38, 0x00000000, 0x00000000, 0x0000ffb4, 0x0000ffb4},
	{0x00009b3c, 0x00000000, 0x00000000, 0x0000ffa1, 0x0000ffa1},
	{0x00009b40, 0x00000000, 0x00000000, 0x0000ffa5, 0x0000ffa5},
	{0x00009b44, 0x00000000, 0x00000000, 0x0000ffa9, 0x0000ffa9},
	{0x00009b48, 0x00000000, 0x00000000, 0x0000ffad, 0x0000ffad},
	{0x00009b4c, 0x00000000, 0x00000000, 0x0000ffb1, 0x0000ffb1},
	{0x00009b50, 0x00000000, 0x00000000, 0x0000ffb5, 0x0000ffb5},
	{0x00009b54, 0x00000000, 0x00000000, 0x0000ffb9, 0x0000ffb9},
	{0x00009b58, 0x00000000, 0x00000000, 0x0000ffc5, 0x0000ffc5},
	{0x00009b5c, 0x00000000, 0x00000000, 0x0000ffc9, 0x0000ffc9},
	{0x00009b60, 0x00000000, 0x00000000, 0x0000ffcd, 0x0000ffcd},
	{0x00009b64, 0x00000000, 0x00000000, 0x0000ffd1, 0x0000ffd1},
	{0x00009b68, 0x00000000, 0x00000000, 0x0000ffd5, 0x0000ffd5},
	{0x00009b6c, 0x00000000, 0x00000000, 0x0000ffc2, 0x0000ffc2},
	{0x00009b70, 0x00000000, 0x00000000, 0x0000ffc6, 0x0000ffc6},
	{0x00009b74, 0x00000000, 0x00000000, 0x0000ffca, 0x0000ffca},
	{0x00009b78, 0x00000000, 0x00000000, 0x0000ffce, 0x0000ffce},
	{0x00009b7c, 0x00000000, 0x00000000, 0x0000ffd2, 0x0000ffd2},
	{0x00009b80, 0x00000000, 0x00000000, 0x0000ffd6, 0x0000ffd6},
	{0x00009b84, 0x00000000, 0x00000000, 0x0000ffda, 0x0000ffda},
	{0x00009b88, 0x00000000, 0x00000000, 0x0000ffc7, 0x0000ffc7},
	{0x00009b8c, 0x00000000, 0x00000000, 0x0000ffcb, 0x0000ffcb},
	{0x00009b90, 0x00000000, 0x00000000, 0x0000ffcf, 0x0000ffcf},
	{0x00009b94, 0x00000000, 0x00000000, 0x0000ffd3, 0x0000ffd3},
	{0x00009b98, 0x00000000, 0x00000000, 0x0000ffd7, 0x0000ffd7},
	{0x00009b9c, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009ba0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009ba4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009ba8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bac, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bb0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bb4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bb8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bbc, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bc0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bc4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bc8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bcc, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bd0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bd4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bd8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bdc, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009be0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009be4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009be8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bec, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bf0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bf4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bf8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009bfc, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000aa00, 0x00000000, 0x00000000, 0x0000a120, 0x0000a120},
	{0x0000aa04, 0x00000000, 0x00000000, 0x0000a124, 0x0000a124},
	{0x0000aa08, 0x00000000, 0x00000000, 0x0000a128, 0x0000a128},
	{0x0000aa0c, 0x00000000, 0x00000000, 0x0000a12c, 0x0000a12c},
	{0x0000aa10, 0x00000000, 0x00000000, 0x0000a130, 0x0000a130},
	{0x0000aa14, 0x00000000, 0x00000000, 0x0000a194, 0x0000a194},
	{0x0000aa18, 0x00000000, 0x00000000, 0x0000a198, 0x0000a198},
	{0x0000aa1c, 0x00000000, 0x00000000, 0x0000a20c, 0x0000a20c},
	{0x0000aa20, 0x00000000, 0x00000000, 0x0000a210, 0x0000a210},
	{0x0000aa24, 0x00000000, 0x00000000, 0x0000a284, 0x0000a284},
	{0x0000aa28, 0x00000000, 0x00000000, 0x0000a288, 0x0000a288},
	{0x0000aa2c, 0x00000000, 0x00000000, 0x0000a28c, 0x0000a28c},
	{0x0000aa30, 0x00000000, 0x00000000, 0x0000a290, 0x0000a290},
	{0x0000aa34, 0x00000000, 0x00000000, 0x0000a294, 0x0000a294},
	{0x0000aa38, 0x00000000, 0x00000000, 0x0000a2a0, 0x0000a2a0},
	{0x0000aa3c, 0x00000000, 0x00000000, 0x0000a2a4, 0x0000a2a4},
	{0x0000aa40, 0x00000000, 0x00000000, 0x0000a2a8, 0x0000a2a8},
	{0x0000aa44, 0x00000000, 0x00000000, 0x0000a2ac, 0x0000a2ac},
	{0x0000aa48, 0x00000000, 0x00000000, 0x0000a2b0, 0x0000a2b0},
	{0x0000aa4c, 0x00000000, 0x00000000, 0x0000a2b4, 0x0000a2b4},
	{0x0000aa50, 0x00000000, 0x00000000, 0x0000a2b8, 0x0000a2b8},
	{0x0000aa54, 0x00000000, 0x00000000, 0x0000a2c4, 0x0000a2c4},
	{0x0000aa58, 0x00000000, 0x00000000, 0x0000a708, 0x0000a708},
	{0x0000aa5c, 0x00000000, 0x00000000, 0x0000a70c, 0x0000a70c},
	{0x0000aa60, 0x00000000, 0x00000000, 0x0000a710, 0x0000a710},
	{0x0000aa64, 0x00000000, 0x00000000, 0x0000ab04, 0x0000ab04},
	{0x0000aa68, 0x00000000, 0x00000000, 0x0000ab08, 0x0000ab08},
	{0x0000aa6c, 0x00000000, 0x00000000, 0x0000ab0c, 0x0000ab0c},
	{0x0000aa70, 0x00000000, 0x00000000, 0x0000ab10, 0x0000ab10},
	{0x0000aa74, 0x00000000, 0x00000000, 0x0000ab14, 0x0000ab14},
	{0x0000aa78, 0x00000000, 0x00000000, 0x0000ab18, 0x0000ab18},
	{0x0000aa7c, 0x00000000, 0x00000000, 0x0000ab8c, 0x0000ab8c},
	{0x0000aa80, 0x00000000, 0x00000000, 0x0000ab90, 0x0000ab90},
	{0x0000aa84, 0x00000000, 0x00000000, 0x0000ab94, 0x0000ab94},
	{0x0000aa88, 0x00000000, 0x00000000, 0x0000ab98, 0x0000ab98},
	{0x0000aa8c, 0x00000000, 0x00000000, 0x0000aba4, 0x0000aba4},
	{0x0000aa90, 0x00000000, 0x00000000, 0x0000aba8, 0x0000aba8},
	{0x0000aa94, 0x00000000, 0x00000000, 0x0000cb04, 0x0000cb04},
	{0x0000aa98, 0x00000000, 0x00000000, 0x0000cb08, 0x0000cb08},
	{0x0000aa9c, 0x00000000, 0x00000000, 0x0000cb0c, 0x0000cb0c},
	{0x0000aaa0, 0x00000000, 0x00000000, 0x0000cb10, 0x0000cb10},
	{0x0000aaa4, 0x00000000, 0x00000000, 0x0000cb14, 0x0000cb14},
	{0x0000aaa8, 0x00000000, 0x00000000, 0x0000cb18, 0x0000cb18},
	{0x0000aaac, 0x00000000, 0x00000000, 0x0000cb8c, 0x0000cb8c},
	{0x0000aab0, 0x00000000, 0x00000000, 0x0000cb90, 0x0000cb90},
	{0x0000aab4, 0x00000000, 0x00000000, 0x0000cf18, 0x0000cf18},
	{0x0000aab8, 0x00000000, 0x00000000, 0x0000cf24, 0x0000cf24},
	{0x0000aabc, 0x00000000, 0x00000000, 0x0000cf28, 0x0000cf28},
	{0x0000aac0, 0x00000000, 0x00000000, 0x0000d314, 0x0000d314},
	{0x0000aac4, 0x00000000, 0x00000000, 0x0000d318, 0x0000d318},
	{0x0000aac8, 0x00000000, 0x00000000, 0x0000d38c, 0x0000d38c},
	{0x0000aacc, 0x00000000, 0x00000000, 0x0000d390, 0x0000d390},
	{0x0000aad0, 0x00000000, 0x00000000, 0x0000d394, 0x0000d394},
	{0x0000aad4, 0x00000000, 0x00000000, 0x0000d398, 0x0000d398},
	{0x0000aad8, 0x00000000, 0x00000000, 0x0000d3a4, 0x0000d3a4},
	{0x0000aadc, 0x00000000, 0x00000000, 0x0000d3a8, 0x0000d3a8},
	{0x0000aae0, 0x00000000, 0x00000000, 0x0000d3ac, 0x0000d3ac},
	{0x0000aae4, 0x00000000, 0x00000000, 0x0000d3b0, 0x0000d3b0},
	{0x0000aae8, 0x00000000, 0x00000000, 0x0000f380, 0x0000f380},
	{0x0000aaec, 0x00000000, 0x00000000, 0x0000f384, 0x0000f384},
	{0x0000aaf0, 0x00000000, 0x00000000, 0x0000f388, 0x0000f388},
	{0x0000aaf4, 0x00000000, 0x00000000, 0x0000f710, 0x0000f710},
	{0x0000aaf8, 0x00000000, 0x00000000, 0x0000f714, 0x0000f714},
	{0x0000aafc, 0x00000000, 0x00000000, 0x0000f718, 0x0000f718},
	{0x0000ab00, 0x00000000, 0x00000000, 0x0000fb10, 0x0000fb10},
	{0x0000ab04, 0x00000000, 0x00000000, 0x0000fb14, 0x0000fb14},
	{0x0000ab08, 0x00000000, 0x00000000, 0x0000fb18, 0x0000fb18},
	{0x0000ab0c, 0x00000000, 0x00000000, 0x0000fb8c, 0x0000fb8c},
	{0x0000ab10, 0x00000000, 0x00000000, 0x0000fb90, 0x0000fb90},
	{0x0000ab14, 0x00000000, 0x00000000, 0x0000fb94, 0x0000fb94},
	{0x0000ab18, 0x00000000, 0x00000000, 0x0000ff8c, 0x0000ff8c},
	{0x0000ab1c, 0x00000000, 0x00000000, 0x0000ff90, 0x0000ff90},
	{0x0000ab20, 0x00000000, 0x00000000, 0x0000ff94, 0x0000ff94},
	{0x0000ab24, 0x00000000, 0x00000000, 0x0000ffa0, 0x0000ffa0},
	{0x0000ab28, 0x00000000, 0x00000000, 0x0000ffa4, 0x0000ffa4},
	{0x0000ab2c, 0x00000000, 0x00000000, 0x0000ffa8, 0x0000ffa8},
	{0x0000ab30, 0x00000000, 0x00000000, 0x0000ffac, 0x0000ffac},
	{0x0000ab34, 0x00000000, 0x00000000, 0x0000ffb0, 0x0000ffb0},
	{0x0000ab38, 0x00000000, 0x00000000, 0x0000ffb4, 0x0000ffb4},
	{0x0000ab3c, 0x00000000, 0x00000000, 0x0000ffa1, 0x0000ffa1},
	{0x0000ab40, 0x00000000, 0x00000000, 0x0000ffa5, 0x0000ffa5},
	{0x0000ab44, 0x00000000, 0x00000000, 0x0000ffa9, 0x0000ffa9},
	{0x0000ab48, 0x00000000, 0x00000000, 0x0000ffad, 0x0000ffad},
	{0x0000ab4c, 0x00000000, 0x00000000, 0x0000ffb1, 0x0000ffb1},
	{0x0000ab50, 0x00000000, 0x00000000, 0x0000ffb5, 0x0000ffb5},
	{0x0000ab54, 0x00000000, 0x00000000, 0x0000ffb9, 0x0000ffb9},
	{0x0000ab58, 0x00000000, 0x00000000, 0x0000ffc5, 0x0000ffc5},
	{0x0000ab5c, 0x00000000, 0x00000000, 0x0000ffc9, 0x0000ffc9},
	{0x0000ab60, 0x00000000, 0x00000000, 0x0000ffcd, 0x0000ffcd},
	{0x0000ab64, 0x00000000, 0x00000000, 0x0000ffd1, 0x0000ffd1},
	{0x0000ab68, 0x00000000, 0x00000000, 0x0000ffd5, 0x0000ffd5},
	{0x0000ab6c, 0x00000000, 0x00000000, 0x0000ffc2, 0x0000ffc2},
	{0x0000ab70, 0x00000000, 0x00000000, 0x0000ffc6, 0x0000ffc6},
	{0x0000ab74, 0x00000000, 0x00000000, 0x0000ffca, 0x0000ffca},
	{0x0000ab78, 0x00000000, 0x00000000, 0x0000ffce, 0x0000ffce},
	{0x0000ab7c, 0x00000000, 0x00000000, 0x0000ffd2, 0x0000ffd2},
	{0x0000ab80, 0x00000000, 0x00000000, 0x0000ffd6, 0x0000ffd6},
	{0x0000ab84, 0x00000000, 0x00000000, 0x0000ffda, 0x0000ffda},
	{0x0000ab88, 0x00000000, 0x00000000, 0x0000ffc7, 0x0000ffc7},
	{0x0000ab8c, 0x00000000, 0x00000000, 0x0000ffcb, 0x0000ffcb},
	{0x0000ab90, 0x00000000, 0x00000000, 0x0000ffcf, 0x0000ffcf},
	{0x0000ab94, 0x00000000, 0x00000000, 0x0000ffd3, 0x0000ffd3},
	{0x0000ab98, 0x00000000, 0x00000000, 0x0000ffd7, 0x0000ffd7},
	{0x0000ab9c, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000aba0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000aba4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000aba8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abac, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abb0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abb4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abb8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abbc, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abc0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abc4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abc8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abcc, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abd0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abd4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abd8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abdc, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abe0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abe4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abe8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abec, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abf0, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abf4, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abf8, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x0000abfc, 0x00000000, 0x00000000, 0x0000ffdb, 0x0000ffdb},
	{0x00009848, 0x00000000, 0x00000000, 0x00001067, 0x00001067},
	{0x0000a848, 0x00000000, 0x00000000, 0x00001067, 0x00001067},
};

static const u32 ar9271Modes_9271[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00001030, 0x00000230, 0x00000460, 0x000002c0, 0x00000160},
	{0x00001070, 0x00000168, 0x000002d0, 0x00000318, 0x0000018c},
	{0x000010b0, 0x00000e60, 0x00001cc0, 0x00007c70, 0x00003e38},
	{0x000010f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00008014, 0x03e803e8, 0x07d007d0, 0x10801600, 0x08400b00},
	{0x0000801c, 0x128d8027, 0x128d804f, 0x12e00057, 0x12e0002b},
	{0x00008318, 0x00003e80, 0x00007d00, 0x00006880, 0x00003440},
	{0x00009804, 0x00000300, 0x000003c4, 0x000003c4, 0x00000300},
	{0x00009820, 0x02020200, 0x02020200, 0x02020200, 0x02020200},
	{0x00009824, 0x01000e0e, 0x01000e0e, 0x01000e0e, 0x01000e0e},
	{0x00009828, 0x3a020001, 0x3a020001, 0x3a020001, 0x3a020001},
	{0x00009834, 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e},
	{0x00009838, 0x00000007, 0x00000007, 0x00000007, 0x00000007},
	{0x00009840, 0x206a012e, 0x206a012e, 0x206a012e, 0x206a012e},
	{0x00009844, 0x0372161e, 0x0372161e, 0x03721620, 0x03721620},
	{0x00009848, 0x00001066, 0x00001066, 0x00001053, 0x00001053},
	{0x0000a848, 0x00001066, 0x00001066, 0x00001053, 0x00001053},
	{0x00009850, 0x6d4000e2, 0x6d4000e2, 0x6d4000e2, 0x6d4000e2},
	{0x00009858, 0x7ec84d2e, 0x7ec84d2e, 0x7ec84d2e, 0x7ec84d2e},
	{0x0000985c, 0x3139605e, 0x3139605e, 0x3137605e, 0x3137605e},
	{0x00009860, 0x00058d18, 0x00058d18, 0x00058d18, 0x00058d18},
	{0x00009864, 0x0000fe00, 0x0000fe00, 0x0001ce00, 0x0001ce00},
	{0x00009868, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0},
	{0x0000986c, 0x06903081, 0x06903081, 0x06903881, 0x06903881},
	{0x00009910, 0x30002310, 0x30002310, 0x30002310, 0x30002310},
	{0x00009914, 0x000007d0, 0x00000fa0, 0x00001130, 0x00000898},
	{0x00009918, 0x0000000a, 0x00000014, 0x00000016, 0x0000000b},
	{0x00009924, 0xd00a8007, 0xd00a8007, 0xd00a800d, 0xd00a800d},
	{0x00009944, 0xffbc1010, 0xffbc1010, 0xffbc1020, 0xffbc1020},
	{0x00009960, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00009964, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x000099b8, 0x0000421c, 0x0000421c, 0x0000421c, 0x0000421c},
	{0x000099bc, 0x00000600, 0x00000600, 0x00000c00, 0x00000c00},
	{0x000099c0, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4},
	{0x000099c4, 0x06336f77, 0x06336f77, 0x06336f77, 0x06336f77},
	{0x000099c8, 0x6af6532f, 0x6af6532f, 0x6af6532f, 0x6af6532f},
	{0x000099cc, 0x08f186c8, 0x08f186c8, 0x08f186c8, 0x08f186c8},
	{0x000099d0, 0x00046384, 0x00046384, 0x00046384, 0x00046384},
	{0x000099d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x000099d8, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x00009a00, 0x00000000, 0x00000000, 0x00058084, 0x00058084},
	{0x00009a04, 0x00000000, 0x00000000, 0x00058088, 0x00058088},
	{0x00009a08, 0x00000000, 0x00000000, 0x0005808c, 0x0005808c},
	{0x00009a0c, 0x00000000, 0x00000000, 0x00058100, 0x00058100},
	{0x00009a10, 0x00000000, 0x00000000, 0x00058104, 0x00058104},
	{0x00009a14, 0x00000000, 0x00000000, 0x00058108, 0x00058108},
	{0x00009a18, 0x00000000, 0x00000000, 0x0005810c, 0x0005810c},
	{0x00009a1c, 0x00000000, 0x00000000, 0x00058110, 0x00058110},
	{0x00009a20, 0x00000000, 0x00000000, 0x00058114, 0x00058114},
	{0x00009a24, 0x00000000, 0x00000000, 0x00058180, 0x00058180},
	{0x00009a28, 0x00000000, 0x00000000, 0x00058184, 0x00058184},
	{0x00009a2c, 0x00000000, 0x00000000, 0x00058188, 0x00058188},
	{0x00009a30, 0x00000000, 0x00000000, 0x0005818c, 0x0005818c},
	{0x00009a34, 0x00000000, 0x00000000, 0x00058190, 0x00058190},
	{0x00009a38, 0x00000000, 0x00000000, 0x00058194, 0x00058194},
	{0x00009a3c, 0x00000000, 0x00000000, 0x000581a0, 0x000581a0},
	{0x00009a40, 0x00000000, 0x00000000, 0x0005820c, 0x0005820c},
	{0x00009a44, 0x00000000, 0x00000000, 0x000581a8, 0x000581a8},
	{0x00009a48, 0x00000000, 0x00000000, 0x00058284, 0x00058284},
	{0x00009a4c, 0x00000000, 0x00000000, 0x00058288, 0x00058288},
	{0x00009a50, 0x00000000, 0x00000000, 0x00058224, 0x00058224},
	{0x00009a54, 0x00000000, 0x00000000, 0x00058290, 0x00058290},
	{0x00009a58, 0x00000000, 0x00000000, 0x00058300, 0x00058300},
	{0x00009a5c, 0x00000000, 0x00000000, 0x00058304, 0x00058304},
	{0x00009a60, 0x00000000, 0x00000000, 0x00058308, 0x00058308},
	{0x00009a64, 0x00000000, 0x00000000, 0x0005830c, 0x0005830c},
	{0x00009a68, 0x00000000, 0x00000000, 0x00058380, 0x00058380},
	{0x00009a6c, 0x00000000, 0x00000000, 0x00058384, 0x00058384},
	{0x00009a70, 0x00000000, 0x00000000, 0x00068700, 0x00068700},
	{0x00009a74, 0x00000000, 0x00000000, 0x00068704, 0x00068704},
	{0x00009a78, 0x00000000, 0x00000000, 0x00068708, 0x00068708},
	{0x00009a7c, 0x00000000, 0x00000000, 0x0006870c, 0x0006870c},
	{0x00009a80, 0x00000000, 0x00000000, 0x00068780, 0x00068780},
	{0x00009a84, 0x00000000, 0x00000000, 0x00068784, 0x00068784},
	{0x00009a88, 0x00000000, 0x00000000, 0x00078b00, 0x00078b00},
	{0x00009a8c, 0x00000000, 0x00000000, 0x00078b04, 0x00078b04},
	{0x00009a90, 0x00000000, 0x00000000, 0x00078b08, 0x00078b08},
	{0x00009a94, 0x00000000, 0x00000000, 0x00078b0c, 0x00078b0c},
	{0x00009a98, 0x00000000, 0x00000000, 0x00078b80, 0x00078b80},
	{0x00009a9c, 0x00000000, 0x00000000, 0x00078b84, 0x00078b84},
	{0x00009aa0, 0x00000000, 0x00000000, 0x00078b88, 0x00078b88},
	{0x00009aa4, 0x00000000, 0x00000000, 0x00078b8c, 0x00078b8c},
	{0x00009aa8, 0x00000000, 0x00000000, 0x00078b90, 0x00078b90},
	{0x00009aac, 0x00000000, 0x00000000, 0x000caf80, 0x000caf80},
	{0x00009ab0, 0x00000000, 0x00000000, 0x000caf84, 0x000caf84},
	{0x00009ab4, 0x00000000, 0x00000000, 0x000caf88, 0x000caf88},
	{0x00009ab8, 0x00000000, 0x00000000, 0x000caf8c, 0x000caf8c},
	{0x00009abc, 0x00000000, 0x00000000, 0x000caf90, 0x000caf90},
	{0x00009ac0, 0x00000000, 0x00000000, 0x000db30c, 0x000db30c},
	{0x00009ac4, 0x00000000, 0x00000000, 0x000db310, 0x000db310},
	{0x00009ac8, 0x00000000, 0x00000000, 0x000db384, 0x000db384},
	{0x00009acc, 0x00000000, 0x00000000, 0x000db388, 0x000db388},
	{0x00009ad0, 0x00000000, 0x00000000, 0x000db324, 0x000db324},
	{0x00009ad4, 0x00000000, 0x00000000, 0x000eb704, 0x000eb704},
	{0x00009ad8, 0x00000000, 0x00000000, 0x000eb6a4, 0x000eb6a4},
	{0x00009adc, 0x00000000, 0x00000000, 0x000eb6a8, 0x000eb6a8},
	{0x00009ae0, 0x00000000, 0x00000000, 0x000eb710, 0x000eb710},
	{0x00009ae4, 0x00000000, 0x00000000, 0x000eb714, 0x000eb714},
	{0x00009ae8, 0x00000000, 0x00000000, 0x000eb720, 0x000eb720},
	{0x00009aec, 0x00000000, 0x00000000, 0x000eb724, 0x000eb724},
	{0x00009af0, 0x00000000, 0x00000000, 0x000eb728, 0x000eb728},
	{0x00009af4, 0x00000000, 0x00000000, 0x000eb72c, 0x000eb72c},
	{0x00009af8, 0x00000000, 0x00000000, 0x000eb7a0, 0x000eb7a0},
	{0x00009afc, 0x00000000, 0x00000000, 0x000eb7a4, 0x000eb7a4},
	{0x00009b00, 0x00000000, 0x00000000, 0x000eb7a8, 0x000eb7a8},
	{0x00009b04, 0x00000000, 0x00000000, 0x000eb7b0, 0x000eb7b0},
	{0x00009b08, 0x00000000, 0x00000000, 0x000eb7b4, 0x000eb7b4},
	{0x00009b0c, 0x00000000, 0x00000000, 0x000eb7b8, 0x000eb7b8},
	{0x00009b10, 0x00000000, 0x00000000, 0x000eb7a5, 0x000eb7a5},
	{0x00009b14, 0x00000000, 0x00000000, 0x000eb7a9, 0x000eb7a9},
	{0x00009b18, 0x00000000, 0x00000000, 0x000eb7ad, 0x000eb7ad},
	{0x00009b1c, 0x00000000, 0x00000000, 0x000eb7b1, 0x000eb7b1},
	{0x00009b20, 0x00000000, 0x00000000, 0x000eb7b5, 0x000eb7b5},
	{0x00009b24, 0x00000000, 0x00000000, 0x000eb7b9, 0x000eb7b9},
	{0x00009b28, 0x00000000, 0x00000000, 0x000eb7c5, 0x000eb7c5},
	{0x00009b2c, 0x00000000, 0x00000000, 0x000eb7c9, 0x000eb7c9},
	{0x00009b30, 0x00000000, 0x00000000, 0x000eb7d1, 0x000eb7d1},
	{0x00009b34, 0x00000000, 0x00000000, 0x000eb7d5, 0x000eb7d5},
	{0x00009b38, 0x00000000, 0x00000000, 0x000eb7d9, 0x000eb7d9},
	{0x00009b3c, 0x00000000, 0x00000000, 0x000eb7c6, 0x000eb7c6},
	{0x00009b40, 0x00000000, 0x00000000, 0x000eb7ca, 0x000eb7ca},
	{0x00009b44, 0x00000000, 0x00000000, 0x000eb7ce, 0x000eb7ce},
	{0x00009b48, 0x00000000, 0x00000000, 0x000eb7d2, 0x000eb7d2},
	{0x00009b4c, 0x00000000, 0x00000000, 0x000eb7d6, 0x000eb7d6},
	{0x00009b50, 0x00000000, 0x00000000, 0x000eb7c3, 0x000eb7c3},
	{0x00009b54, 0x00000000, 0x00000000, 0x000eb7c7, 0x000eb7c7},
	{0x00009b58, 0x00000000, 0x00000000, 0x000eb7cb, 0x000eb7cb},
	{0x00009b5c, 0x00000000, 0x00000000, 0x000eb7cf, 0x000eb7cf},
	{0x00009b60, 0x00000000, 0x00000000, 0x000eb7d7, 0x000eb7d7},
	{0x00009b64, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b68, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b6c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b70, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b74, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b78, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b7c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b80, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b84, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b88, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b8c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b90, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b94, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b98, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009b9c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009ba0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009ba4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009ba8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bac, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bb0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bb4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bb8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bbc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bc0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bc4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bc8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bcc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bd0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bd4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bd8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bdc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009be0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009be4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009be8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bec, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bf0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bf4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bf8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x00009bfc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000aa00, 0x00000000, 0x00000000, 0x00058084, 0x00058084},
	{0x0000aa04, 0x00000000, 0x00000000, 0x00058088, 0x00058088},
	{0x0000aa08, 0x00000000, 0x00000000, 0x0005808c, 0x0005808c},
	{0x0000aa0c, 0x00000000, 0x00000000, 0x00058100, 0x00058100},
	{0x0000aa10, 0x00000000, 0x00000000, 0x00058104, 0x00058104},
	{0x0000aa14, 0x00000000, 0x00000000, 0x00058108, 0x00058108},
	{0x0000aa18, 0x00000000, 0x00000000, 0x0005810c, 0x0005810c},
	{0x0000aa1c, 0x00000000, 0x00000000, 0x00058110, 0x00058110},
	{0x0000aa20, 0x00000000, 0x00000000, 0x00058114, 0x00058114},
	{0x0000aa24, 0x00000000, 0x00000000, 0x00058180, 0x00058180},
	{0x0000aa28, 0x00000000, 0x00000000, 0x00058184, 0x00058184},
	{0x0000aa2c, 0x00000000, 0x00000000, 0x00058188, 0x00058188},
	{0x0000aa30, 0x00000000, 0x00000000, 0x0005818c, 0x0005818c},
	{0x0000aa34, 0x00000000, 0x00000000, 0x00058190, 0x00058190},
	{0x0000aa38, 0x00000000, 0x00000000, 0x00058194, 0x00058194},
	{0x0000aa3c, 0x00000000, 0x00000000, 0x000581a0, 0x000581a0},
	{0x0000aa40, 0x00000000, 0x00000000, 0x0005820c, 0x0005820c},
	{0x0000aa44, 0x00000000, 0x00000000, 0x000581a8, 0x000581a8},
	{0x0000aa48, 0x00000000, 0x00000000, 0x00058284, 0x00058284},
	{0x0000aa4c, 0x00000000, 0x00000000, 0x00058288, 0x00058288},
	{0x0000aa50, 0x00000000, 0x00000000, 0x00058224, 0x00058224},
	{0x0000aa54, 0x00000000, 0x00000000, 0x00058290, 0x00058290},
	{0x0000aa58, 0x00000000, 0x00000000, 0x00058300, 0x00058300},
	{0x0000aa5c, 0x00000000, 0x00000000, 0x00058304, 0x00058304},
	{0x0000aa60, 0x00000000, 0x00000000, 0x00058308, 0x00058308},
	{0x0000aa64, 0x00000000, 0x00000000, 0x0005830c, 0x0005830c},
	{0x0000aa68, 0x00000000, 0x00000000, 0x00058380, 0x00058380},
	{0x0000aa6c, 0x00000000, 0x00000000, 0x00058384, 0x00058384},
	{0x0000aa70, 0x00000000, 0x00000000, 0x00068700, 0x00068700},
	{0x0000aa74, 0x00000000, 0x00000000, 0x00068704, 0x00068704},
	{0x0000aa78, 0x00000000, 0x00000000, 0x00068708, 0x00068708},
	{0x0000aa7c, 0x00000000, 0x00000000, 0x0006870c, 0x0006870c},
	{0x0000aa80, 0x00000000, 0x00000000, 0x00068780, 0x00068780},
	{0x0000aa84, 0x00000000, 0x00000000, 0x00068784, 0x00068784},
	{0x0000aa88, 0x00000000, 0x00000000, 0x00078b00, 0x00078b00},
	{0x0000aa8c, 0x00000000, 0x00000000, 0x00078b04, 0x00078b04},
	{0x0000aa90, 0x00000000, 0x00000000, 0x00078b08, 0x00078b08},
	{0x0000aa94, 0x00000000, 0x00000000, 0x00078b0c, 0x00078b0c},
	{0x0000aa98, 0x00000000, 0x00000000, 0x00078b80, 0x00078b80},
	{0x0000aa9c, 0x00000000, 0x00000000, 0x00078b84, 0x00078b84},
	{0x0000aaa0, 0x00000000, 0x00000000, 0x00078b88, 0x00078b88},
	{0x0000aaa4, 0x00000000, 0x00000000, 0x00078b8c, 0x00078b8c},
	{0x0000aaa8, 0x00000000, 0x00000000, 0x00078b90, 0x00078b90},
	{0x0000aaac, 0x00000000, 0x00000000, 0x000caf80, 0x000caf80},
	{0x0000aab0, 0x00000000, 0x00000000, 0x000caf84, 0x000caf84},
	{0x0000aab4, 0x00000000, 0x00000000, 0x000caf88, 0x000caf88},
	{0x0000aab8, 0x00000000, 0x00000000, 0x000caf8c, 0x000caf8c},
	{0x0000aabc, 0x00000000, 0x00000000, 0x000caf90, 0x000caf90},
	{0x0000aac0, 0x00000000, 0x00000000, 0x000db30c, 0x000db30c},
	{0x0000aac4, 0x00000000, 0x00000000, 0x000db310, 0x000db310},
	{0x0000aac8, 0x00000000, 0x00000000, 0x000db384, 0x000db384},
	{0x0000aacc, 0x00000000, 0x00000000, 0x000db388, 0x000db388},
	{0x0000aad0, 0x00000000, 0x00000000, 0x000db324, 0x000db324},
	{0x0000aad4, 0x00000000, 0x00000000, 0x000eb704, 0x000eb704},
	{0x0000aad8, 0x00000000, 0x00000000, 0x000eb6a4, 0x000eb6a4},
	{0x0000aadc, 0x00000000, 0x00000000, 0x000eb6a8, 0x000eb6a8},
	{0x0000aae0, 0x00000000, 0x00000000, 0x000eb710, 0x000eb710},
	{0x0000aae4, 0x00000000, 0x00000000, 0x000eb714, 0x000eb714},
	{0x0000aae8, 0x00000000, 0x00000000, 0x000eb720, 0x000eb720},
	{0x0000aaec, 0x00000000, 0x00000000, 0x000eb724, 0x000eb724},
	{0x0000aaf0, 0x00000000, 0x00000000, 0x000eb728, 0x000eb728},
	{0x0000aaf4, 0x00000000, 0x00000000, 0x000eb72c, 0x000eb72c},
	{0x0000aaf8, 0x00000000, 0x00000000, 0x000eb7a0, 0x000eb7a0},
	{0x0000aafc, 0x00000000, 0x00000000, 0x000eb7a4, 0x000eb7a4},
	{0x0000ab00, 0x00000000, 0x00000000, 0x000eb7a8, 0x000eb7a8},
	{0x0000ab04, 0x00000000, 0x00000000, 0x000eb7b0, 0x000eb7b0},
	{0x0000ab08, 0x00000000, 0x00000000, 0x000eb7b4, 0x000eb7b4},
	{0x0000ab0c, 0x00000000, 0x00000000, 0x000eb7b8, 0x000eb7b8},
	{0x0000ab10, 0x00000000, 0x00000000, 0x000eb7a5, 0x000eb7a5},
	{0x0000ab14, 0x00000000, 0x00000000, 0x000eb7a9, 0x000eb7a9},
	{0x0000ab18, 0x00000000, 0x00000000, 0x000eb7ad, 0x000eb7ad},
	{0x0000ab1c, 0x00000000, 0x00000000, 0x000eb7b1, 0x000eb7b1},
	{0x0000ab20, 0x00000000, 0x00000000, 0x000eb7b5, 0x000eb7b5},
	{0x0000ab24, 0x00000000, 0x00000000, 0x000eb7b9, 0x000eb7b9},
	{0x0000ab28, 0x00000000, 0x00000000, 0x000eb7c5, 0x000eb7c5},
	{0x0000ab2c, 0x00000000, 0x00000000, 0x000eb7c9, 0x000eb7c9},
	{0x0000ab30, 0x00000000, 0x00000000, 0x000eb7d1, 0x000eb7d1},
	{0x0000ab34, 0x00000000, 0x00000000, 0x000eb7d5, 0x000eb7d5},
	{0x0000ab38, 0x00000000, 0x00000000, 0x000eb7d9, 0x000eb7d9},
	{0x0000ab3c, 0x00000000, 0x00000000, 0x000eb7c6, 0x000eb7c6},
	{0x0000ab40, 0x00000000, 0x00000000, 0x000eb7ca, 0x000eb7ca},
	{0x0000ab44, 0x00000000, 0x00000000, 0x000eb7ce, 0x000eb7ce},
	{0x0000ab48, 0x00000000, 0x00000000, 0x000eb7d2, 0x000eb7d2},
	{0x0000ab4c, 0x00000000, 0x00000000, 0x000eb7d6, 0x000eb7d6},
	{0x0000ab50, 0x00000000, 0x00000000, 0x000eb7c3, 0x000eb7c3},
	{0x0000ab54, 0x00000000, 0x00000000, 0x000eb7c7, 0x000eb7c7},
	{0x0000ab58, 0x00000000, 0x00000000, 0x000eb7cb, 0x000eb7cb},
	{0x0000ab5c, 0x00000000, 0x00000000, 0x000eb7cf, 0x000eb7cf},
	{0x0000ab60, 0x00000000, 0x00000000, 0x000eb7d7, 0x000eb7d7},
	{0x0000ab64, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab68, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab6c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab70, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab74, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab78, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab7c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab80, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab84, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab88, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab8c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab90, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab94, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab98, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000ab9c, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000aba0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000aba4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000aba8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abac, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abb0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abb4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abb8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abbc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abc0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abc4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abc8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abcc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abd0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abd4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abd8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abdc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abe0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abe4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abe8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abec, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abf0, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abf4, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abf8, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000abfc, 0x00000000, 0x00000000, 0x000eb7db, 0x000eb7db},
	{0x0000a204, 0x00000004, 0x00000004, 0x00000004, 0x00000004},
	{0x0000a20c, 0x00000014, 0x00000014, 0x0001f000, 0x0001f000},
	{0x0000b20c, 0x00000014, 0x00000014, 0x0001f000, 0x0001f000},
	{0x0000a21c, 0x1883800a, 0x1883800a, 0x1883800a, 0x1883800a},
	{0x0000a230, 0x00000000, 0x00000000, 0x00000210, 0x00000108},
	{0x0000a250, 0x0004f000, 0x0004f000, 0x0004a000, 0x0004a000},
	{0x0000a358, 0x7999aa02, 0x7999aa02, 0x7999aa0e, 0x7999aa0e},
};

static const u32 ar9271Common_9271[][2] = {
	/* Addr      allmodes  */
	{0x0000000c, 0x00000000},
	{0x00000030, 0x00020045},
	{0x00000034, 0x00000005},
	{0x00000040, 0x00000000},
	{0x00000044, 0x00000008},
	{0x00000048, 0x00000008},
	{0x0000004c, 0x00000010},
	{0x00000050, 0x00000000},
	{0x00000054, 0x0000001f},
	{0x00000800, 0x00000000},
	{0x00000804, 0x00000000},
	{0x00000808, 0x00000000},
	{0x0000080c, 0x00000000},
	{0x00000810, 0x00000000},
	{0x00000814, 0x00000000},
	{0x00000818, 0x00000000},
	{0x0000081c, 0x00000000},
	{0x00000820, 0x00000000},
	{0x00000824, 0x00000000},
	{0x00001040, 0x002ffc0f},
	{0x00001044, 0x002ffc0f},
	{0x00001048, 0x002ffc0f},
	{0x0000104c, 0x002ffc0f},
	{0x00001050, 0x002ffc0f},
	{0x00001054, 0x002ffc0f},
	{0x00001058, 0x002ffc0f},
	{0x0000105c, 0x002ffc0f},
	{0x00001060, 0x002ffc0f},
	{0x00001064, 0x002ffc0f},
	{0x00001230, 0x00000000},
	{0x00001270, 0x00000000},
	{0x00001038, 0x00000000},
	{0x00001078, 0x00000000},
	{0x000010b8, 0x00000000},
	{0x000010f8, 0x00000000},
	{0x00001138, 0x00000000},
	{0x00001178, 0x00000000},
	{0x000011b8, 0x00000000},
	{0x000011f8, 0x00000000},
	{0x00001238, 0x00000000},
	{0x00001278, 0x00000000},
	{0x000012b8, 0x00000000},
	{0x000012f8, 0x00000000},
	{0x00001338, 0x00000000},
	{0x00001378, 0x00000000},
	{0x000013b8, 0x00000000},
	{0x000013f8, 0x00000000},
	{0x00001438, 0x00000000},
	{0x00001478, 0x00000000},
	{0x000014b8, 0x00000000},
	{0x000014f8, 0x00000000},
	{0x00001538, 0x00000000},
	{0x00001578, 0x00000000},
	{0x000015b8, 0x00000000},
	{0x000015f8, 0x00000000},
	{0x00001638, 0x00000000},
	{0x00001678, 0x00000000},
	{0x000016b8, 0x00000000},
	{0x000016f8, 0x00000000},
	{0x00001738, 0x00000000},
	{0x00001778, 0x00000000},
	{0x000017b8, 0x00000000},
	{0x000017f8, 0x00000000},
	{0x0000103c, 0x00000000},
	{0x0000107c, 0x00000000},
	{0x000010bc, 0x00000000},
	{0x000010fc, 0x00000000},
	{0x0000113c, 0x00000000},
	{0x0000117c, 0x00000000},
	{0x000011bc, 0x00000000},
	{0x000011fc, 0x00000000},
	{0x0000123c, 0x00000000},
	{0x0000127c, 0x00000000},
	{0x000012bc, 0x00000000},
	{0x000012fc, 0x00000000},
	{0x0000133c, 0x00000000},
	{0x0000137c, 0x00000000},
	{0x000013bc, 0x00000000},
	{0x000013fc, 0x00000000},
	{0x0000143c, 0x00000000},
	{0x0000147c, 0x00000000},
	{0x00004030, 0x00000002},
	{0x0000403c, 0x00000002},
	{0x00004024, 0x0000001f},
	{0x00004060, 0x00000000},
	{0x00004064, 0x00000000},
	{0x00008004, 0x00000000},
	{0x00008008, 0x00000000},
	{0x0000800c, 0x00000000},
	{0x00008018, 0x00000700},
	{0x00008020, 0x00000000},
	{0x00008038, 0x00000000},
	{0x0000803c, 0x00000000},
	{0x00008048, 0x00000000},
	{0x00008054, 0x00000000},
	{0x00008058, 0x00000000},
	{0x0000805c, 0x000fc78f},
	{0x00008060, 0x0000000f},
	{0x00008064, 0x00000000},
	{0x00008070, 0x00000000},
	{0x000080b0, 0x00000000},
	{0x000080b4, 0x00000000},
	{0x000080b8, 0x00000000},
	{0x000080bc, 0x00000000},
	{0x000080c0, 0x2a80001a},
	{0x000080c4, 0x05dc01e0},
	{0x000080c8, 0x1f402710},
	{0x000080cc, 0x01f40000},
	{0x000080d0, 0x00001e00},
	{0x000080d4, 0x00000000},
	{0x000080d8, 0x00400000},
	{0x000080e0, 0xffffffff},
	{0x000080e4, 0x0000ffff},
	{0x000080e8, 0x003f3f3f},
	{0x000080ec, 0x00000000},
	{0x000080f0, 0x00000000},
	{0x000080f4, 0x00000000},
	{0x000080f8, 0x00000000},
	{0x000080fc, 0x00020000},
	{0x00008100, 0x00020000},
	{0x00008104, 0x00000001},
	{0x00008108, 0x00000052},
	{0x0000810c, 0x00000000},
	{0x00008110, 0x00000168},
	{0x00008118, 0x000100aa},
	{0x0000811c, 0x00003210},
	{0x00008120, 0x08f04810},
	{0x00008124, 0x00000000},
	{0x00008128, 0x00000000},
	{0x0000812c, 0x00000000},
	{0x00008130, 0x00000000},
	{0x00008134, 0x00000000},
	{0x00008138, 0x00000000},
	{0x0000813c, 0x00000000},
	{0x00008144, 0xffffffff},
	{0x00008168, 0x00000000},
	{0x0000816c, 0x00000000},
	{0x00008170, 0x32143320},
	{0x00008174, 0xfaa4fa50},
	{0x00008178, 0x00000100},
	{0x0000817c, 0x00000000},
	{0x000081c0, 0x00000000},
	{0x000081d0, 0x0000320a},
	{0x000081ec, 0x00000000},
	{0x000081f0, 0x00000000},
	{0x000081f4, 0x00000000},
	{0x000081f8, 0x00000000},
	{0x000081fc, 0x00000000},
	{0x00008200, 0x00000000},
	{0x00008204, 0x00000000},
	{0x00008208, 0x00000000},
	{0x0000820c, 0x00000000},
	{0x00008210, 0x00000000},
	{0x00008214, 0x00000000},
	{0x00008218, 0x00000000},
	{0x0000821c, 0x00000000},
	{0x00008220, 0x00000000},
	{0x00008224, 0x00000000},
	{0x00008228, 0x00000000},
	{0x0000822c, 0x00000000},
	{0x00008230, 0x00000000},
	{0x00008234, 0x00000000},
	{0x00008238, 0x00000000},
	{0x0000823c, 0x00000000},
	{0x00008240, 0x00100000},
	{0x00008244, 0x0010f400},
	{0x00008248, 0x00000100},
	{0x0000824c, 0x0001e800},
	{0x00008250, 0x00000000},
	{0x00008254, 0x00000000},
	{0x00008258, 0x00000000},
	{0x0000825c, 0x400000ff},
	{0x00008260, 0x00080922},
	{0x00008264, 0x88a00010},
	{0x00008270, 0x00000000},
	{0x00008274, 0x40000000},
	{0x00008278, 0x003e4180},
	{0x0000827c, 0x00000000},
	{0x00008284, 0x0000002c},
	{0x00008288, 0x0000002c},
	{0x0000828c, 0x00000000},
	{0x00008294, 0x00000000},
	{0x00008298, 0x00000000},
	{0x0000829c, 0x00000000},
	{0x00008300, 0x00000040},
	{0x00008314, 0x00000000},
	{0x00008328, 0x00000000},
	{0x0000832c, 0x00000001},
	{0x00008330, 0x00000302},
	{0x00008334, 0x00000e00},
	{0x00008338, 0x00ff0000},
	{0x0000833c, 0x00000000},
	{0x00008340, 0x00010380},
	{0x00008344, 0x00581043},
	{0x00007010, 0x00000030},
	{0x00007034, 0x00000002},
	{0x00007038, 0x000004c2},
	{0x00007800, 0x00140000},
	{0x00007804, 0x0e4548d8},
	{0x00007808, 0x54214514},
	{0x0000780c, 0x02025820},
	{0x00007810, 0x71c0d388},
	{0x00007814, 0x924934a8},
	{0x0000781c, 0x00000000},
	{0x00007828, 0x66964300},
	{0x0000782c, 0x8db6d961},
	{0x00007830, 0x8db6d96c},
	{0x00007834, 0x6140008b},
	{0x0000783c, 0x72ee0a72},
	{0x00007840, 0xbbfffffc},
	{0x00007844, 0x000c0db6},
	{0x00007848, 0x6db6246f},
	{0x0000784c, 0x6d9b66db},
	{0x00007850, 0x6d8c6dba},
	{0x00007854, 0x00040000},
	{0x00007858, 0xdb003012},
	{0x0000785c, 0x04924914},
	{0x00007860, 0x21084210},
	{0x00007864, 0xf7d7ffde},
	{0x00007868, 0xc2034080},
	{0x00007870, 0x10142c00},
	{0x00009808, 0x00000000},
	{0x0000980c, 0xafe68e30},
	{0x00009810, 0xfd14e000},
	{0x00009814, 0x9c0a9f6b},
	{0x0000981c, 0x00000000},
	{0x0000982c, 0x0000a000},
	{0x00009830, 0x00000000},
	{0x0000983c, 0x00200400},
	{0x0000984c, 0x0040233c},
	{0x00009854, 0x00000044},
	{0x00009900, 0x00000000},
	{0x00009904, 0x00000000},
	{0x00009908, 0x00000000},
	{0x0000990c, 0x00000000},
	{0x0000991c, 0x10000fff},
	{0x00009920, 0x04900000},
	{0x00009928, 0x00000001},
	{0x0000992c, 0x00000004},
	{0x00009934, 0x1e1f2022},
	{0x00009938, 0x0a0b0c0d},
	{0x0000993c, 0x00000000},
	{0x00009940, 0x14750604},
	{0x00009948, 0x9280c00a},
	{0x0000994c, 0x00020028},
	{0x00009954, 0x5f3ca3de},
	{0x00009958, 0x0108ecff},
	{0x00009968, 0x000003ce},
	{0x00009970, 0x192bb514},
	{0x00009974, 0x00000000},
	{0x00009978, 0x00000001},
	{0x0000997c, 0x00000000},
	{0x00009980, 0x00000000},
	{0x00009984, 0x00000000},
	{0x00009988, 0x00000000},
	{0x0000998c, 0x00000000},
	{0x00009990, 0x00000000},
	{0x00009994, 0x00000000},
	{0x00009998, 0x00000000},
	{0x0000999c, 0x00000000},
	{0x000099a0, 0x00000000},
	{0x000099a4, 0x00000001},
	{0x000099a8, 0x201fff00},
	{0x000099ac, 0x2def0400},
	{0x000099b0, 0x03051000},
	{0x000099b4, 0x00000820},
	{0x000099dc, 0x00000000},
	{0x000099e0, 0x00000000},
	{0x000099e4, 0xaaaaaaaa},
	{0x000099e8, 0x3c466478},
	{0x000099ec, 0x0cc80caa},
	{0x000099f0, 0x00000000},
	{0x0000a208, 0x803e68c8},
	{0x0000a210, 0x4080a333},
	{0x0000a214, 0x00206c10},
	{0x0000a218, 0x009c4060},
	{0x0000a220, 0x01834061},
	{0x0000a224, 0x00000400},
	{0x0000a228, 0x000003b5},
	{0x0000a22c, 0x00000000},
	{0x0000a234, 0x20202020},
	{0x0000a238, 0x20202020},
	{0x0000a244, 0x00000000},
	{0x0000a248, 0xfffffffc},
	{0x0000a24c, 0x00000000},
	{0x0000a254, 0x00000000},
	{0x0000a258, 0x0ccb5380},
	{0x0000a25c, 0x15151501},
	{0x0000a260, 0xdfa90f01},
	{0x0000a268, 0x00000000},
	{0x0000a26c, 0x0ebae9e6},
	{0x0000a388, 0x0c000000},
	{0x0000a38c, 0x20202020},
	{0x0000a390, 0x20202020},
	{0x0000a39c, 0x00000001},
	{0x0000a3a0, 0x00000000},
	{0x0000a3a4, 0x00000000},
	{0x0000a3a8, 0x00000000},
	{0x0000a3ac, 0x00000000},
	{0x0000a3b0, 0x00000000},
	{0x0000a3b4, 0x00000000},
	{0x0000a3b8, 0x00000000},
	{0x0000a3bc, 0x00000000},
	{0x0000a3c0, 0x00000000},
	{0x0000a3c4, 0x00000000},
	{0x0000a3cc, 0x20202020},
	{0x0000a3d0, 0x20202020},
	{0x0000a3d4, 0x20202020},
	{0x0000a3e4, 0x00000000},
	{0x0000a3e8, 0x18c43433},
	{0x0000a3ec, 0x00f70081},
	{0x0000a3f0, 0x01036a2f},
	{0x0000a3f4, 0x00000000},
	{0x0000d270, 0x0d820820},
	{0x0000d35c, 0x07ffffef},
	{0x0000d360, 0x0fffffe7},
	{0x0000d364, 0x17ffffe5},
	{0x0000d368, 0x1fffffe4},
	{0x0000d36c, 0x37ffffe3},
	{0x0000d370, 0x3fffffe3},
	{0x0000d374, 0x57ffffe3},
	{0x0000d378, 0x5fffffe2},
	{0x0000d37c, 0x7fffffe2},
	{0x0000d380, 0x7f3c7bba},
	{0x0000d384, 0xf3307ff0},
};

static const u32 ar9271Modes_9271_ANI_reg[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x00009850, 0x6d4000e2, 0x6d4000e2, 0x6d4000e2, 0x6d4000e2},
	{0x0000985c, 0x3139605e, 0x3139605e, 0x3137605e, 0x3137605e},
	{0x00009858, 0x7ec84d2e, 0x7ec84d2e, 0x7ec84d2e, 0x7ec84d2e},
	{0x0000986c, 0x06903881, 0x06903881, 0x06903881, 0x06903881},
	{0x00009868, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0, 0x5ac640d0},
	{0x0000a208, 0x803e68c8, 0x803e68c8, 0x803e68c8, 0x803e68c8},
	{0x00009924, 0xd00a8007, 0xd00a8007, 0xd00a800d, 0xd00a800d},
	{0x000099c0, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4, 0x05eea6d4},
};

static const u32 ar9271Modes_normal_power_tx_gain_9271[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a300, 0x00000000, 0x00000000, 0x00000000, 0x00000000},
	{0x0000a304, 0x00000000, 0x00000000, 0x00009200, 0x00009200},
	{0x0000a308, 0x00000000, 0x00000000, 0x00010208, 0x00010208},
	{0x0000a30c, 0x00000000, 0x00000000, 0x00019608, 0x00019608},
	{0x0000a310, 0x00000000, 0x00000000, 0x0001e610, 0x0001e610},
	{0x0000a314, 0x00000000, 0x00000000, 0x00024650, 0x00024650},
	{0x0000a318, 0x00000000, 0x00000000, 0x0002d6d0, 0x0002d6d0},
	{0x0000a31c, 0x00000000, 0x00000000, 0x000316d2, 0x000316d2},
	{0x0000a320, 0x00000000, 0x00000000, 0x00039758, 0x00039758},
	{0x0000a324, 0x00000000, 0x00000000, 0x0003b759, 0x0003b759},
	{0x0000a328, 0x00000000, 0x00000000, 0x0003d75a, 0x0003d75a},
	{0x0000a32c, 0x00000000, 0x00000000, 0x0004175c, 0x0004175c},
	{0x0000a330, 0x00000000, 0x00000000, 0x0004575e, 0x0004575e},
	{0x0000a334, 0x000368de, 0x000368de, 0x0004979f, 0x0004979f},
	{0x0000a338, 0x0003891e, 0x0003891e, 0x0004d7df, 0x0004d7df},
	{0x0000a33c, 0x0003a95e, 0x0003a95e, 0x0003a95e, 0x0003a95e},
	{0x0000a340, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a344, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a348, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a34c, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a350, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a354, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x00007838, 0x00000029, 0x00000029, 0x00000029, 0x00000029},
	{0x00007824, 0x00d8abff, 0x00d8abff, 0x00d8abff, 0x00d8abff},
	{0x0000786c, 0x48609eb4, 0x48609eb4, 0x48609eb4, 0x48609eb4},
	{0x00007820, 0x00000c04, 0x00000c04, 0x00000c04, 0x00000c04},
	{0x0000a274, 0x0a21c652, 0x0a21c652, 0x0a21c652, 0x0a21c652},
	{0x0000a278, 0x3bdef7bd, 0x3bdef7bd, 0x3bdef7bd, 0x3bdef7bd},
	{0x0000a27c, 0x050e83bd, 0x050e83bd, 0x050e83bd, 0x050e83bd},
	{0x0000a394, 0x3bdef7bd, 0x3bdef7bd, 0x3bdef7bd, 0x3bdef7bd},
	{0x0000a398, 0x000003bd, 0x000003bd, 0x000003bd, 0x000003bd},
	{0x0000a3dc, 0x3bdef7bd, 0x3bdef7bd, 0x3bdef7bd, 0x3bdef7bd},
	{0x0000a3e0, 0x000003bd, 0x000003bd, 0x000003bd, 0x000003bd},
};

static const u32 ar9271Modes_high_power_tx_gain_9271[][5] = {
	/* Addr      5G_HT20     5G_HT40     2G_HT40     2G_HT20   */
	{0x0000a300, 0x00000000, 0x00000000, 0x00010000, 0x00010000},
	{0x0000a304, 0x00000000, 0x00000000, 0x00016200, 0x00016200},
	{0x0000a308, 0x00000000, 0x00000000, 0x00018201, 0x00018201},
	{0x0000a30c, 0x00000000, 0x00000000, 0x0001b240, 0x0001b240},
	{0x0000a310, 0x00000000, 0x00000000, 0x0001d241, 0x0001d241},
	{0x0000a314, 0x00000000, 0x00000000, 0x0001f600, 0x0001f600},
	{0x0000a318, 0x00000000, 0x00000000, 0x00022800, 0x00022800},
	{0x0000a31c, 0x00000000, 0x00000000, 0x00026802, 0x00026802},
	{0x0000a320, 0x00000000, 0x00000000, 0x0002b805, 0x0002b805},
	{0x0000a324, 0x00000000, 0x00000000, 0x0002ea41, 0x0002ea41},
	{0x0000a328, 0x00000000, 0x00000000, 0x00038b00, 0x00038b00},
	{0x0000a32c, 0x00000000, 0x00000000, 0x0003ab40, 0x0003ab40},
	{0x0000a330, 0x00000000, 0x00000000, 0x0003cd80, 0x0003cd80},
	{0x0000a334, 0x000368de, 0x000368de, 0x000368de, 0x000368de},
	{0x0000a338, 0x0003891e, 0x0003891e, 0x0003891e, 0x0003891e},
	{0x0000a33c, 0x0003a95e, 0x0003a95e, 0x0003a95e, 0x0003a95e},
	{0x0000a340, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a344, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a348, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a34c, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a350, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x0000a354, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df},
	{0x00007838, 0x0000002b, 0x0000002b, 0x0000002b, 0x0000002b},
	{0x00007824, 0x00d8a7ff, 0x00d8a7ff, 0x00d8a7ff, 0x00d8a7ff},
	{0x0000786c, 0x08609eb6, 0x08609eb6, 0x08609eba, 0x08609eba},
	{0x00007820, 0x00000c00, 0x00000c00, 0x00000c00, 0x00000c00},
	{0x0000a274, 0x0a22a652, 0x0a22a652, 0x0a214652, 0x0a214652},
	{0x0000a278, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7, 0x0e739ce7},
	{0x0000a27c, 0x05018063, 0x05038063, 0x05018063, 0x05018063},
	{0x0000a394, 0x06318c63, 0x06318c63, 0x06318c63, 0x06318c63},
	{0x0000a398, 0x00000063, 0x00000063, 0x00000063, 0x00000063},
	{0x0000a3dc, 0x06318c63, 0x06318c63, 0x06318c63, 0x06318c63},
	{0x0000a3e0, 0x00000063, 0x00000063, 0x00000063, 0x00000063},
};

