/* SPDX-License-Identifier: GPL-2.0 */
/* Marvell RVU Admin Function driver
 *
 * Copyright (C) 2018 Marvell.
 *
 */

#ifndef NPC_PROFILE_H
#define NPC_PROFILE_H

#define NPC_KPU_PROFILE_VER	0x0000000100060000
#define NPC_KPU_VER_MAJ(ver)	((u16)(((ver) >> 32) & 0xFFFF))
#define NPC_KPU_VER_MIN(ver)	((u16)(((ver) >> 16) & 0xFFFF))
#define NPC_KPU_VER_PATCH(ver)	((u16)((ver) & 0xFFFF))

#define NPC_IH_W		0x8000
#define NPC_IH_UTAG		0x2000

#define NPC_ETYPE_IP		0x0800
#define NPC_ETYPE_IP6		0x86dd
#define NPC_ETYPE_ARP		0x0806
#define NPC_ETYPE_RARP		0x8035
#define NPC_ETYPE_NGIO		0x8842
#define NPC_ETYPE_MPLSU		0x8847
#define NPC_ETYPE_MPLSM		0x8848
#define NPC_ETYPE_ETAG		0x893f
#define NPC_ETYPE_CTAG		0x8100
#define NPC_ETYPE_SBTAG		0x88a8
#define NPC_ETYPE_ITAG		0x88e7
#define NPC_ETYPE_PTP		0x88f7
#define NPC_ETYPE_FCOE		0x8906
#define NPC_ETYPE_QINQ		0x9100
#define NPC_ETYPE_TRANS_ETH_BR	0x6558
#define NPC_ETYPE_PPP		0x880b
#define NPC_ETYPE_NSH		0x894f
#define NPC_ETYPE_DSA		0xdada
#define NPC_ETYPE_PPPOE		0x8864

#define NPC_PPP_IP		0x0021
#define NPC_PPP_IP6		0x0057

#define NPC_IPNH_HOP		0
#define NPC_IPNH_ICMP		1
#define NPC_IPNH_IGMP		2
#define NPC_IPNH_IP		4
#define NPC_IPNH_TCP		6
#define NPC_IPNH_UDP		17
#define NPC_IPNH_IP6		41
#define NPC_IPNH_ROUT		43
#define NPC_IPNH_FRAG		44
#define NPC_IPNH_GRE		47
#define NPC_IPNH_ESP		50
#define NPC_IPNH_AH		51
#define NPC_IPNH_ICMP6		58
#define NPC_IPNH_NONH		59
#define NPC_IPNH_DEST		60
#define NPC_IPNH_SCTP		132
#define NPC_IPNH_MOBILITY	135
#define NPC_IPNH_MPLS		137
#define NPC_IPNH_HOSTID		139
#define NPC_IPNH_SHIM6		140

#define NPC_UDP_PORT_PTP_E	319
#define NPC_UDP_PORT_PTP_G	320
#define NPC_UDP_PORT_GTPC	2123
#define NPC_UDP_PORT_GTPU	2152
#define NPC_UDP_PORT_VXLAN	4789
#define NPC_UDP_PORT_VXLANGPE	4790
#define NPC_UDP_PORT_GENEVE	6081
#define NPC_UDP_PORT_MPLS	6635
#define NPC_UDP_PORT_ESP	4500

#define NPC_VXLANGPE_NP_IP	0x1
#define NPC_VXLANGPE_NP_IP6	0x2
#define NPC_VXLANGPE_NP_ETH	0x3
#define NPC_VXLANGPE_NP_NSH	0x4
#define NPC_VXLANGPE_NP_MPLS	0x5
#define NPC_VXLANGPE_NP_GBP	0x6
#define NPC_VXLANGPE_NP_VBNG	0x7

#define NPC_NSH_NP_IP		0x1
#define NPC_NSH_NP_IP6		0x2
#define NPC_NSH_NP_ETH		0x3
#define NPC_NSH_NP_NSH		0x4
#define NPC_NSH_NP_MPLS		0x5

#define NPC_TCP_PORT_HTTP	80
#define NPC_TCP_PORT_HTTPS	443
#define NPC_TCP_PORT_PPTP	1723

#define NPC_MPLS_S		0x0100

#define NPC_IP_TTL_MASK		0xff00
#define NPC_IP_VER_4		0x4000
#define NPC_IP_VER_6		0x6000
#define NPC_IP_VER_MASK		0xf000
#define NPC_IP_HDR_LEN_5	0x0500
#define NPC_IP_HDR_LEN_MASK	0x0f00
#define NPC_IP_HDR_MF		0x2000
#define NPC_IP_HDR_FRAGOFF	0x1fff

#define NPC_IP6_HOP_MASK	0x00ff
#define NPC_IP6_FRAG_FRAGOFF	0xfff8

#define NPC_GRE_F_CSUM		(0x1 << 15)
#define NPC_GRE_F_ROUTE		(0x1 << 14)
#define NPC_GRE_F_KEY		(0x1 << 13)
#define NPC_GRE_F_SEQ		(0x1 << 12)
#define NPC_GRE_F_ACK		(0x1 << 7)
#define NPC_GRE_FLAG_MASK	(NPC_GRE_F_CSUM | NPC_GRE_F_ROUTE | \
				 NPC_GRE_F_KEY | NPC_GRE_F_SEQ | NPC_GRE_F_ACK)
#define NPC_GRE_VER_MASK	0x0003
#define NPC_GRE_VER_1		0x0001

#define NPC_VXLAN_I		0x0800

#define NPC_VXLANGPE_VER	(0x3 << 12)
#define NPC_VXLANGPE_I		(0x1 << 11)
#define NPC_VXLANGPE_P		(0x1 << 10)
#define NPC_VXLANGPE_B		(0x1 << 9)
#define NPC_VXLANGPE_NP_MASK	0x00ff

#define NPC_NSH_NP_MASK		0x00ff

#define NPC_GENEVE_F_OAM	(0x1 << 7)
#define NPC_GENEVE_F_CRI_OPT	(0x1 << 6)

#define NPC_GTP_PT_GTP		(0x1 << 12)
#define NPC_GTP_PT_MASK		(0x1 << 12)
#define NPC_GTP_VER1		(0x1 << 13)
#define NPC_GTP_VER_MASK	(0x7 << 13)
#define NPC_GTP_MT_G_PDU	0xff
#define NPC_GTP_MT_MASK		0xff

#define NPC_TCP_FLAGS_FIN	0x0001
#define NPC_TCP_FLAGS_SYN	0x0002
#define NPC_TCP_FLAGS_RST	0x0004
#define NPC_TCP_FLAGS_PSH	0x0008
#define NPC_TCP_FLAGS_ACK	0x0010
#define NPC_TCP_FLAGS_URG	0x0020
#define NPC_TCP_FLAGS_MASK	0x003f

#define NPC_TCP_DATA_OFFSET_5		0x5000
#define NPC_TCP_DATA_OFFSET_MASK	0xf000

#define NPC_DSA_EXTEND		0x1000
#define NPC_DSA_EDSA		0x8000
#define NPC_DSA_FDSA		0xc000

#define NPC_KEXOF_DMAC	9
#define MKEX_SIGN      0x19bbfdbd15f
#define KEX_LD_CFG(bytesm1, hdr_ofs, ena, flags_ena, key_ofs)		\
			(((bytesm1) << 16) | ((hdr_ofs) << 8) | ((ena) << 7) | \
			 ((flags_ena) << 6) | ((key_ofs) & 0x3F))

/* Rx parse key extract nibble enable */
#define NPC_PARSE_NIBBLE_INTF_RX	(NPC_PARSE_NIBBLE_CHAN | \
					 NPC_PARSE_NIBBLE_ERRCODE | \
					 NPC_PARSE_NIBBLE_LA_LTYPE | \
					 NPC_PARSE_NIBBLE_LB_LTYPE | \
					 NPC_PARSE_NIBBLE_LC_LTYPE | \
					 NPC_PARSE_NIBBLE_LD_LTYPE | \
					 NPC_PARSE_NIBBLE_LE_LTYPE)
/* Tx parse key extract nibble enable */
#define NPC_PARSE_NIBBLE_INTF_TX	(NPC_PARSE_NIBBLE_LA_LTYPE | \
					 NPC_PARSE_NIBBLE_LB_LTYPE | \
					 NPC_PARSE_NIBBLE_LC_LTYPE | \
					 NPC_PARSE_NIBBLE_LD_LTYPE | \
					 NPC_PARSE_NIBBLE_LE_LTYPE)

enum npc_kpu_parser_state {
	NPC_S_NA = 0,
	NPC_S_KPU1_ETHER,
	NPC_S_KPU1_IH_NIX,
	NPC_S_KPU1_IH,
	NPC_S_KPU1_EXDSA,
	NPC_S_KPU1_HIGIG2,
	NPC_S_KPU1_IH_NIX_HIGIG2,
	NPC_S_KPU1_CUSTOM_PRE_L2,
	NPC_S_KPU1_CPT_HDR,
	NPC_S_KPU1_VLAN_EXDSA,
	NPC_S_KPU2_CTAG,
	NPC_S_KPU2_CTAG2,
	NPC_S_KPU2_SBTAG,
	NPC_S_KPU2_QINQ,
	NPC_S_KPU2_ETAG,
	NPC_S_KPU2_PREHEADER,
	NPC_S_KPU2_EXDSA,
	NPC_S_KPU2_CPT_CTAG,
	NPC_S_KPU2_CPT_QINQ,
	NPC_S_KPU3_CTAG,
	NPC_S_KPU3_STAG,
	NPC_S_KPU3_QINQ,
	NPC_S_KPU3_CTAG_C,
	NPC_S_KPU3_STAG_C,
	NPC_S_KPU3_QINQ_C,
	NPC_S_KPU3_DSA,
	NPC_S_KPU3_VLAN_EXDSA,
	NPC_S_KPU4_MPLS,
	NPC_S_KPU4_NSH,
	NPC_S_KPU4_FDSA,
	NPC_S_KPU4_VLAN_EXDSA,
	NPC_S_KPU4_PPPOE,
	NPC_S_KPU5_IP,
	NPC_S_KPU5_IP6,
	NPC_S_KPU5_ARP,
	NPC_S_KPU5_RARP,
	NPC_S_KPU5_PTP,
	NPC_S_KPU5_FCOE,
	NPC_S_KPU5_MPLS,
	NPC_S_KPU5_MPLS_PL,
	NPC_S_KPU5_NSH,
	NPC_S_KPU5_CPT_IP,
	NPC_S_KPU5_CPT_IP6,
	NPC_S_KPU5_NGIO,
	NPC_S_KPU6_IP6_EXT,
	NPC_S_KPU6_IP6_HOP_DEST,
	NPC_S_KPU6_IP6_ROUT,
	NPC_S_KPU6_IP6_FRAG,
	NPC_S_KPU6_IP6_CPT_FRAG,
	NPC_S_KPU6_IP6_CPT_HOP_DEST,
	NPC_S_KPU6_IP6_CPT_ROUT,
	NPC_S_KPU7_IP6_EXT,
	NPC_S_KPU7_IP6_ROUT,
	NPC_S_KPU7_IP6_FRAG,
	NPC_S_KPU7_CPT_IP6_FRAG,
	NPC_S_KPU8_TCP,
	NPC_S_KPU8_UDP,
	NPC_S_KPU8_SCTP,
	NPC_S_KPU8_ICMP,
	NPC_S_KPU8_IGMP,
	NPC_S_KPU8_ICMP6,
	NPC_S_KPU8_GRE,
	NPC_S_KPU8_AH,
	NPC_S_KPU9_TU_MPLS_IN_GRE,
	NPC_S_KPU9_TU_MPLS_IN_NSH,
	NPC_S_KPU9_TU_MPLS_IN_IP,
	NPC_S_KPU9_TU_MPLS_IN_UDP,
	NPC_S_KPU9_TU_NSH_IN_GRE,
	NPC_S_KPU9_VXLAN,
	NPC_S_KPU9_VXLANGPE,
	NPC_S_KPU9_GENEVE,
	NPC_S_KPU9_GTPC,
	NPC_S_KPU9_GTPU,
	NPC_S_KPU9_ESP,
	NPC_S_KPU10_TU_MPLS_IN_VXLANGPE,
	NPC_S_KPU10_TU_MPLS_PL,
	NPC_S_KPU10_TU_MPLS,
	NPC_S_KPU10_TU_NSH_IN_VXLANGPE,
	NPC_S_KPU11_TU_ETHER,
	NPC_S_KPU11_TU_PPP,
	NPC_S_KPU11_TU_MPLS_IN_NSH,
	NPC_S_KPU11_TU_MPLS_PL,
	NPC_S_KPU11_TU_MPLS,
	NPC_S_KPU11_TU_ETHER_IN_NSH,
	NPC_S_KPU12_TU_IP,
	NPC_S_KPU12_TU_IP6,
	NPC_S_KPU12_TU_ARP,
	NPC_S_KPU13_TU_IP6_EXT,
	NPC_S_KPU14_TU_IP6_EXT,
	NPC_S_KPU15_TU_TCP,
	NPC_S_KPU15_TU_UDP,
	NPC_S_KPU15_TU_SCTP,
	NPC_S_KPU15_TU_ICMP,
	NPC_S_KPU15_TU_IGMP,
	NPC_S_KPU15_TU_ICMP6,
	NPC_S_KPU15_TU_ESP,
	NPC_S_KPU15_TU_AH,
	NPC_S_KPU16_HTTP_DATA,
	NPC_S_KPU16_HTTPS_DATA,
	NPC_S_KPU16_PPTP_DATA,
	NPC_S_KPU16_TCP_DATA,
	NPC_S_KPU16_UDP_DATA,
	NPC_S_KPU16_UDP_PTP,
	NPC_S_LAST /* has to be the last item */
};

enum npc_kpu_la_uflag {
	NPC_F_LA_U_HAS_TAG = 0x10,
	NPC_F_LA_U_HAS_IH_NIX = 0x20,
	NPC_F_LA_U_HAS_HIGIG2 = 0x40,
};
enum npc_kpu_la_lflag {
	NPC_F_LA_L_UNK_ETYPE = 1,
	NPC_F_LA_L_WITH_VLAN,
	NPC_F_LA_L_WITH_ETAG,
	NPC_F_LA_L_WITH_MPLS,
	NPC_F_LA_L_WITH_NSH,
};

enum npc_kpu_lb_uflag {
	NPC_F_LB_U_UNK_ETYPE = 0x80,
	NPC_F_LB_U_MORE_TAG = 0x40,
};
enum npc_kpu_lb_lflag {
	NPC_F_LB_L_WITH_CTAG = 1,
	NPC_F_LB_L_WITH_CTAG_UNK,
	NPC_F_LB_L_WITH_STAG_CTAG,
	NPC_F_LB_L_WITH_STAG_STAG,
	NPC_F_LB_L_WITH_QINQ_CTAG,
	NPC_F_LB_L_WITH_QINQ_QINQ,
	NPC_F_LB_L_WITH_ITAG,
	NPC_F_LB_L_WITH_ITAG_STAG,
	NPC_F_LB_L_WITH_ITAG_CTAG,
	NPC_F_LB_L_WITH_ITAG_UNK,
	NPC_F_LB_L_WITH_BTAG_ITAG,
	NPC_F_LB_L_WITH_STAG,
	NPC_F_LB_L_WITH_QINQ,
	NPC_F_LB_L_DSA,
	NPC_F_LB_L_DSA_VLAN,
	NPC_F_LB_L_EDSA,
	NPC_F_LB_L_EDSA_VLAN,
	NPC_F_LB_L_EXDSA,
	NPC_F_LB_L_EXDSA_VLAN,
	NPC_F_LB_L_FDSA,
};

enum npc_kpu_lc_uflag {
	NPC_F_LC_U_UNK_PROTO = 0x10,
	NPC_F_LC_U_IP_FRAG = 0x20,
	NPC_F_LC_U_IP6_FRAG = 0x40,
};
enum npc_kpu_lc_lflag {
	NPC_F_LC_L_IP_IN_IP = 1,
	NPC_F_LC_L_6TO4,
	NPC_F_LC_L_MPLS_IN_IP,
	NPC_F_LC_L_IP6_TUN_IP6,
	NPC_F_LC_L_IP6_MPLS_IN_IP,
	NPC_F_LC_L_MPLS_4_LABELS,
	NPC_F_LC_L_MPLS_3_LABELS,
	NPC_F_LC_L_MPLS_2_LABELS,
	NPC_F_LC_L_EXT_HOP,
	NPC_F_LC_L_EXT_DEST,
	NPC_F_LC_L_EXT_ROUT,
	NPC_F_LC_L_EXT_MOBILITY,
	NPC_F_LC_L_EXT_HOSTID,
	NPC_F_LC_L_EXT_SHIM6,
};

enum npc_kpu_ld_lflag {
	NPC_F_LD_L_TCP_UNK_PORT = 1,
	NPC_F_LD_L_TCP_HAS_OPTIONS,
	NPC_F_LD_L_TCP_UNK_PORT_HAS_OPTIONS,
	NPC_F_LD_L_UDP_UNK_PORT,
	NPC_F_LD_L_GRE_NVGRE,
	NPC_F_LD_L_GRE_HAS_SRE,
	NPC_F_LD_L_GRE_HAS_CSUM,
	NPC_F_LD_L_GRE_HAS_KEY,
	NPC_F_LD_L_GRE_HAS_SEQ,
	NPC_F_LD_L_GRE_HAS_CSUM_KEY,
	NPC_F_LD_L_GRE_HAS_CSUM_SEQ,
	NPC_F_LD_L_GRE_HAS_KEY_SEQ,
	NPC_F_LD_L_GRE_HAS_CSUM_KEY_SEQ,
	NPC_F_LD_L_GRE_HAS_ROUTE,
	NPC_F_LD_L_GRE_UNK_PROTO,
	NPC_F_LD_L_GRE_VER1,
	NPC_F_LD_L_GRE_VER1_HAS_SEQ,
	NPC_F_LD_L_GRE_VER1_HAS_ACK,
	NPC_F_LD_L_GRE_VER1_HAS_SEQ_ACK,
	NPC_F_LD_L_GRE_VER1_UNK_PROTO,
	NPC_F_LD_L_MPLS_4_LABELS,
	NPC_F_LD_L_MPLS_3_LABELS,
	NPC_F_LD_L_MPLS_2_LABELS,
};

enum npc_kpu_le_lflag {
	NPC_F_LE_L_VXLAN_NOVNI,
	NPC_F_LE_L_VXLANGPE_NOVNI,
	NPC_F_LE_L_VXLANGPE_UNK,
	NPC_F_LE_L_VXLANGPE_NONP,
	NPC_F_LE_L_GENEVE_OAM,
	NPC_F_LE_L_GENEVE_CRI_OPT,
	NPC_F_LE_L_GENEVE_OAM_CRI_OPT,
	NPC_F_LE_L_GTPU_G_PDU,
	NPC_F_LE_L_GTPU_UNK,
};

enum npc_kpu_lf_uflag {
	NPC_F_LF_U_UNK_ETYPE = 0x10,
	NPC_F_LF_U_HAS_TAG = 0x20,
};

enum npc_kpu_lf_lflag {
	NPC_F_LF_L_WITH_CTAG = 1,
	NPC_F_LF_L_WITH_STAG_CTAG,
	NPC_F_LF_L_WITH_STAG,
	NPC_F_LF_L_WITH_QINQ_CTAG,
	NPC_F_LF_L_WITH_QINQ,
};

enum npc_kpu_lg_uflag {
	NPC_F_LG_U_UNK_IP_PROTO = 0x10,
	NPC_F_LG_U_IP_HAS_OPTIONS = 0x20,
	NPC_F_LG_U_IP6_HAS_EXT = 0x40,
};

enum npc_kpu_lh_uflag {
	NPC_F_LH_U_TCP_HAS_OPTIONS = 0x80,
};

enum npc_kpu_lh_lflag {
	NPC_F_LH_L_TCP_HTTP = 1,
	NPC_F_LH_L_TCP_HTTPS,
	NPC_F_LH_L_TCP_PPTP,
	NPC_F_LH_L_TCP_UNK_PORT,
	NPC_F_LH_L_UDP_UNK_PORT,
};

enum npc_kpu_err_code {
	NPC_EC_NOERR = 0, /* has to be zero */
	NPC_EC_UNK,
	NPC_EC_IH_LENGTH,
	NPC_EC_EDSA_UNK,
	NPC_EC_L2_K1,
	NPC_EC_L2_K2,
	NPC_EC_L2_K3,
	NPC_EC_L2_K3_ETYPE_UNK,
	NPC_EC_L2_K4,
	NPC_EC_MPLS_2MANY,
	NPC_EC_MPLS_UNK,
	NPC_EC_NSH_UNK,
	NPC_EC_IP_TTL_0,
	NPC_EC_IP_FRAG_OFFSET_1,
	NPC_EC_IP_VER,
	NPC_EC_IP6_HOP_0,
	NPC_EC_IP6_VER,
	NPC_EC_TCP_FLAGS_FIN_ONLY,
	NPC_EC_TCP_FLAGS_ZERO,
	NPC_EC_TCP_FLAGS_RST_FIN,
	NPC_EC_TCP_FLAGS_URG_SYN,
	NPC_EC_TCP_FLAGS_RST_SYN,
	NPC_EC_TCP_FLAGS_SYN_FIN,
	NPC_EC_VXLAN,
	NPC_EC_NVGRE,
	NPC_EC_GRE,
	NPC_EC_GRE_VER1,
	NPC_EC_L4,
	NPC_EC_OIP4_CSUM,
	NPC_EC_IIP4_CSUM,
	NPC_EC_LAST /* has to be the last item */
};

enum NPC_ERRLEV_E {
	NPC_ERRLEV_RE = 0,
	NPC_ERRLEV_LA = 1,
	NPC_ERRLEV_LB = 2,
	NPC_ERRLEV_LC = 3,
	NPC_ERRLEV_LD = 4,
	NPC_ERRLEV_LE = 5,
	NPC_ERRLEV_LF = 6,
	NPC_ERRLEV_LG = 7,
	NPC_ERRLEV_LH = 8,
	NPC_ERRLEV_R9 = 9,
	NPC_ERRLEV_R10 = 10,
	NPC_ERRLEV_R11 = 11,
	NPC_ERRLEV_R12 = 12,
	NPC_ERRLEV_R13 = 13,
	NPC_ERRLEV_R14 = 14,
	NPC_ERRLEV_NIX = 15,
	NPC_ERRLEV_ENUM_LAST = 16,
};

#define NPC_KPU_NOP_CAM		\
	{			\
		NPC_S_NA, 0xff,	\
		0x0000,		\
		0x0000,		\
		0x0000,		\
		0x0000,		\
		0x0000,		\
		0x0000,		\
	}

#define NPC_KPU_NOP_ACTION			\
	{					\
		NPC_ERRLEV_RE, NPC_EC_NOERR,	\
		0, 0, 0, 0, 0,			\
		NPC_S_NA, 0, 0,			\
		NPC_LID_LA, NPC_LT_NA,		\
		0,				\
		0, 0, 0, 0,			\
	}

static struct npc_kpu_profile_action ikpu_action_entries[] = {
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_ETHER, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_CUSTOM_PRE_L2, 0, 1,
		NPC_LID_LA, NPC_LT_LA_CUSTOM_PRE_L2_ETHER,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_VLAN_EXDSA, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_CUSTOM_PRE_L2, 24, 1,
		NPC_LID_LA, NPC_LT_LA_CUSTOM_L2_24B_ETHER,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_CPT_HDR, 40, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		7, 7, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU1_CUSTOM_PRE_L2, 90, 1,
		NPC_LID_LA, NPC_LT_LA_CUSTOM_L2_90B_ETHER,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		36, 40, 44, 0, 0,
		NPC_S_KPU1_IH_NIX_HIGIG2, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		28, 32, 36, 0, 0,
		NPC_S_KPU1_HIGIG2, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 14, 20, 0, 0,
		NPC_S_KPU1_EXDSA, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		20, 24, 28, 0, 0,
		NPC_S_KPU1_IH_NIX, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,

	},
};

static struct npc_kpu_profile_cam kpu1_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_ETAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_DSA,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		NPC_ETYPE_PPPOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		0x0000,
		0xfc00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		0x0400,
		0xfe00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_ETHER, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_ETAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH, 0xff,
		NPC_IH_W | NPC_IH_UTAG,
		NPC_IH_W | NPC_IH_UTAG,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH, 0xff,
		NPC_IH_W,
		NPC_IH_W | NPC_IH_UTAG,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH, 0xff,
		0x0000,
		NPC_IH_W | NPC_IH_UTAG,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_EXDSA, 0xff,
		0x0000,
		0x0000,
		NPC_DSA_EXTEND,
		NPC_DSA_EXTEND,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_EXDSA, 0xff,
		NPC_DSA_FDSA,
		NPC_DSA_FDSA,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_EXDSA, 0xff,
		0x0000,
		NPC_DSA_EXTEND,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_ETAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_HIGIG2, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_ETAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_IH_NIX_HIGIG2, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_ETAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CUSTOM_PRE_L2, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CPT_HDR, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CPT_HDR, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CPT_HDR, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_CPT_HDR, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU1_VLAN_EXDSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu2_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_NGIO,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_PPPOE,
		0xffff,
		0x0000,
		0x0000,
		NPC_PPP_IP,
		0xffff,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		NPC_ETYPE_PPPOE,
		0xffff,
		0x0000,
		0x0000,
		NPC_PPP_IP6,
		0xffff,
	},
	{
		NPC_S_KPU2_CTAG, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		NPC_ETYPE_SBTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_IP,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_IP6,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_ARP,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_RARP,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_PTP,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_FCOE,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_MPLSU,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_MPLSM,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_NSH,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_SBTAG,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_CTAG,
		0xffff,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_SBTAG, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_QINQ, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_IP,
		0xffff,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_IP6,
		0xffff,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_ARP,
		0xffff,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_SBTAG,
		0xffff,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		NPC_ETYPE_CTAG,
		0xffff,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		NPC_ETYPE_ITAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_ETAG, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CTAG2, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_PREHEADER, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		NPC_DSA_EDSA,
		NPC_DSA_EDSA,
		0x0000,
		0x0000,
		NPC_ETYPE_IP,
		0xffff,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		NPC_DSA_EDSA,
		NPC_DSA_EDSA,
		0x0000,
		0x0000,
		NPC_ETYPE_IP6,
		0xffff,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		NPC_DSA_EDSA,
		NPC_DSA_EDSA,
		0x0000,
		0x0000,
		NPC_ETYPE_ARP,
		0xffff,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		NPC_DSA_EDSA,
		NPC_DSA_EDSA,
		0x0000,
		0x0000,
		NPC_ETYPE_RARP,
		0xffff,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		NPC_DSA_EDSA,
		NPC_DSA_EDSA,
		0x0000,
		0x0000,
		NPC_ETYPE_PTP,
		0xffff,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		NPC_DSA_EDSA,
		NPC_DSA_EDSA,
		0x0000,
		0x0000,
		NPC_ETYPE_FCOE,
		0xffff,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		NPC_DSA_EDSA,
		NPC_DSA_EDSA,
		0x0000,
		0x0000,
		NPC_ETYPE_CTAG,
		0xffff,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		NPC_DSA_EDSA,
		NPC_DSA_EDSA,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		0x0000,
		NPC_DSA_EDSA,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		0x0000,
		NPC_DSA_EDSA,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		0x0000,
		NPC_DSA_EDSA,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		0x0000,
		NPC_DSA_EDSA,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		0x0000,
		NPC_DSA_EDSA,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		0x0000,
		NPC_DSA_EDSA,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		0x0000,
		NPC_DSA_EDSA,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_EXDSA, 0xff,
		0x0000,
		NPC_DSA_EDSA,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CPT_CTAG, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CPT_CTAG, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CPT_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU2_CPT_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu3_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU3_CTAG, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_CTAG_C, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_STAG_C, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_QINQ_C, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_DSA, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU3_VLAN_EXDSA, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu4_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU4_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_MPLS, 0xff,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_MPLS, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU4_MPLS, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU4_NSH, 0xff,
		NPC_NSH_NP_IP,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_NSH, 0xff,
		NPC_NSH_NP_IP6,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_NSH, 0xff,
		NPC_NSH_NP_ETH,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_NSH, 0xff,
		NPC_NSH_NP_MPLS,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_NSH, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_PPPOE,
		0xffff,
		0x0000,
		0x0000,
		NPC_PPP_IP,
		0xffff,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		NPC_ETYPE_PPPOE,
		0xffff,
		0x0000,
		0x0000,
		NPC_PPP_IP6,
		0xffff,
	},
	{
		NPC_S_KPU4_FDSA, 0xff,
		0x0000,
		NPC_DSA_FDSA,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_VLAN_EXDSA, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_VLAN_EXDSA, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_VLAN_EXDSA, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_VLAN_EXDSA, 0xff,
		NPC_ETYPE_RARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_VLAN_EXDSA, 0xff,
		NPC_ETYPE_PTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_VLAN_EXDSA, 0xff,
		NPC_ETYPE_FCOE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_VLAN_EXDSA, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_PPPOE, 0xff,
		NPC_PPP_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU4_PPPOE, 0xff,
		NPC_PPP_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu5_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU5_IP, 0xff,
		0x0000,
		NPC_IP_TTL_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0001,
		NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_TCP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_UDP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_SCTP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_ICMP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_IGMP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_ESP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_AH,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_GRE,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_IP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_IP6,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_MPLS,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_TCP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_UDP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_SCTP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_ICMP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_IGMP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_ESP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_AH,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_GRE,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_IP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_IP6,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		NPC_IPNH_MPLS,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		NPC_IP_HDR_MF | NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_ARP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_RARP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_PTP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_FCOE, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		0x0000,
		NPC_IP6_HOP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_HOP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_DEST << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_ROUT << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_FRAG << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_MOBILITY << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_HOSTID << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		NPC_IPNH_SHIM6 << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_IP6, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_MPLS, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_MPLS_PL, 0xff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_MPLS_PL, 0xff,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_MPLS_PL, 0xff,
		0x0000,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_MPLS_PL, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		0x0000,
		NPC_IP_TTL_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0001,
		NPC_IP_HDR_FRAGOFF,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_TCP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_UDP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_SCTP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_ICMP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_IGMP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_ESP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_AH,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_GRE,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_IP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_IP6,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_MPLS,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_TCP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_UDP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_SCTP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_ICMP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_IGMP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_ESP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_AH,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_GRE,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_IP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_IP6,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		NPC_IPNH_MPLS,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		0x0000,
		NPC_IP6_HOP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_HOP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_DEST << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_ROUT << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_FRAG << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_MOBILITY << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_HOSTID << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		NPC_IPNH_SHIM6 << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_CPT_IP6, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU5_NGIO, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu6_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU6_IP6_EXT, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_FRAG, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_ROUT << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		NPC_IPNH_FRAG << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_HOP_DEST, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		NPC_IPNH_FRAG << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_ROUT, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_FRAG, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_ROUT << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		NPC_IPNH_FRAG << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		NPC_IPNH_FRAG << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU6_IP6_CPT_ROUT, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu7_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU7_IP6_EXT, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_ROUT, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		0x0000,
		NPC_IP6_FRAG_FRAGOFF,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_IP6_FRAG, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_GRE << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_IP6 << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		NPC_IPNH_MPLS << 8,
		0xff00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU7_CPT_IP6_FRAG, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu8_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU8_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_FIN,
		NPC_TCP_FLAGS_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_RST | NPC_TCP_FLAGS_FIN,
		NPC_TCP_FLAGS_RST | NPC_TCP_FLAGS_FIN,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_URG | NPC_TCP_FLAGS_SYN,
		NPC_TCP_FLAGS_URG | NPC_TCP_FLAGS_SYN,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_RST | NPC_TCP_FLAGS_SYN,
		NPC_TCP_FLAGS_RST | NPC_TCP_FLAGS_SYN,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_SYN | NPC_TCP_FLAGS_FIN,
		NPC_TCP_FLAGS_SYN | NPC_TCP_FLAGS_FIN,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		NPC_TCP_PORT_HTTP,
		0xffff,
		NPC_TCP_DATA_OFFSET_5,
		NPC_TCP_DATA_OFFSET_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		NPC_TCP_PORT_HTTPS,
		0xffff,
		NPC_TCP_DATA_OFFSET_5,
		NPC_TCP_DATA_OFFSET_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		NPC_TCP_PORT_PPTP,
		0xffff,
		NPC_TCP_DATA_OFFSET_5,
		NPC_TCP_DATA_OFFSET_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_DATA_OFFSET_5,
		NPC_TCP_DATA_OFFSET_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		NPC_TCP_PORT_HTTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		NPC_TCP_PORT_HTTPS,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		NPC_TCP_PORT_PPTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_TCP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		NPC_UDP_PORT_VXLAN,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		NPC_UDP_PORT_VXLANGPE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		NPC_UDP_PORT_GENEVE,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		NPC_UDP_PORT_GTPC,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		NPC_UDP_PORT_GTPU,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		NPC_UDP_PORT_PTP_E,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		NPC_UDP_PORT_PTP_G,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		NPC_UDP_PORT_MPLS,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		NPC_UDP_PORT_ESP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		0x0000,
		0x0000,
		NPC_UDP_PORT_ESP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_UDP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_SCTP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_ICMP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_IGMP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_ICMP6, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_AH, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_TRANS_ETH_BR,
		0xffff,
		NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_TRANS_ETH_BR,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		0x0000,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		NPC_GRE_F_CSUM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSU,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		0x0000,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		NPC_GRE_F_CSUM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_MPLSM,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		0x0000,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		NPC_GRE_F_CSUM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_NSH,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		NPC_GRE_F_CSUM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		NPC_GRE_F_CSUM,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		NPC_GRE_F_CSUM | NPC_GRE_F_KEY | NPC_GRE_F_SEQ,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		0x0000,
		0xffff,
		NPC_GRE_F_ROUTE,
		0x4fff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		0x0000,
		0xffff,
		0x0000,
		0x4fff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		0x0000,
		0xffff,
		0x0000,
		0x0003,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_PPP,
		0xffff,
		NPC_GRE_F_KEY | NPC_GRE_VER_1,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_PPP,
		0xffff,
		NPC_GRE_F_KEY | NPC_GRE_F_SEQ | NPC_GRE_VER_1,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_PPP,
		0xffff,
		NPC_GRE_F_KEY | NPC_GRE_F_ACK | NPC_GRE_VER_1,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		NPC_ETYPE_PPP,
		0xffff,
		NPC_GRE_F_KEY | NPC_GRE_F_SEQ | NPC_GRE_F_ACK | NPC_GRE_VER_1,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		0x0000,
		0xffff,
		0x2001,
		0xef7f,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU8_GRE, 0xff,
		0x0000,
		0xffff,
		0x0001,
		0x0003,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu9_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU9_TU_MPLS_IN_GRE, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_GRE, 0xff,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_GRE, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_GRE, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_NSH, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_NSH, 0xff,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_NSH, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_NSH, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_IP, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_IP, 0xff,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_IP, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_IP, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU9_TU_NSH_IN_GRE, 0xff,
		NPC_NSH_NP_IP,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_NSH_IN_GRE, 0xff,
		NPC_NSH_NP_IP6,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_NSH_IN_GRE, 0xff,
		NPC_NSH_NP_ETH,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_NSH_IN_GRE, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_VXLAN, 0xff,
		0x0000,
		0x0000,
		NPC_VXLAN_I,
		NPC_VXLAN_I,
		0x0000,
		0xffff,
	},
	{
		NPC_S_KPU9_VXLAN, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0xffff,
		0x0000,
		0xffff,
	},
	{
		NPC_S_KPU9_VXLAN, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_IP,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_IP6,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_ETH,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_NSH,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_MPLS,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_IP,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_IP6,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_ETH,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_NSH,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P,
		NPC_VXLANGPE_P | NPC_VXLANGPE_I,
		NPC_VXLANGPE_NP_MPLS,
		NPC_VXLANGPE_NP_MASK,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P,
		NPC_VXLANGPE_P,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		0x0000,
		NPC_VXLANGPE_P,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		0x0000,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_TRANS_ETH_BR,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		NPC_GENEVE_F_OAM,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_TRANS_ETH_BR,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		NPC_GENEVE_F_CRI_OPT,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_TRANS_ETH_BR,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_TRANS_ETH_BR,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		0x0000,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_IP,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		NPC_GENEVE_F_OAM,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_IP,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		NPC_GENEVE_F_CRI_OPT,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_IP,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_IP,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		0x0000,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_IP6,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		NPC_GENEVE_F_OAM,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_IP6,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		NPC_GENEVE_F_CRI_OPT,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_IP6,
		0xffff,
	},
	{
		NPC_S_KPU9_GENEVE, 0xff,
		0x0000,
		0x0000,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_GENEVE_F_OAM | NPC_GENEVE_F_CRI_OPT,
		NPC_ETYPE_IP6,
		0xffff,
	},
	{
		NPC_S_KPU9_GTPC, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_GTPU, 0xff,
		0x0000,
		0x0000,
		NPC_GTP_PT_GTP | NPC_GTP_VER1 | NPC_GTP_MT_G_PDU,
		NPC_GTP_PT_MASK | NPC_GTP_VER_MASK | NPC_GTP_MT_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_GTPU, 0xff,
		0x0000,
		0x0000,
		NPC_GTP_PT_GTP | NPC_GTP_VER1,
		NPC_GTP_PT_MASK | NPC_GTP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_UDP, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_UDP, 0xff,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_UDP, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU9_TU_MPLS_IN_UDP, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU9_ESP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu10_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU10_TU_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS_PL, 0xff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS_PL, 0xff,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS_PL, 0xff,
		0x0000,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS_PL, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS_IN_VXLANGPE, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS_IN_VXLANGPE, 0xff,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_MPLS_IN_VXLANGPE, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU10_TU_MPLS_IN_VXLANGPE, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		NPC_MPLS_S,
	},
	{
		NPC_S_KPU10_TU_NSH_IN_VXLANGPE, 0xff,
		NPC_NSH_NP_IP,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_NSH_IN_VXLANGPE, 0xff,
		NPC_NSH_NP_IP6,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_NSH_IN_VXLANGPE, 0xff,
		NPC_NSH_NP_ETH,
		NPC_NSH_NP_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU10_TU_NSH_IN_VXLANGPE, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu11_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_SBTAG,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		NPC_ETYPE_CTAG,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		NPC_ETYPE_IP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		NPC_ETYPE_IP6,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		NPC_ETYPE_ARP,
		0xffff,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		NPC_ETYPE_QINQ,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_PPP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_MPLS, 0xff,
		NPC_MPLS_S,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_MPLS, 0xff,
		0x0000,
		NPC_MPLS_S,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_MPLS_PL, 0xff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_MPLS_PL, 0xff,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_MPLS_PL, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU11_TU_ETHER_IN_NSH, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu12_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_TCP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_UDP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_SCTP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_ICMP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_IGMP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_ESP,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_AH,
		0x00ff,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_4 | NPC_IP_HDR_LEN_5,
		NPC_IP_VER_MASK | NPC_IP_HDR_LEN_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_TCP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_UDP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_SCTP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_ICMP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_IGMP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_ESP,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		NPC_IPNH_AH,
		0x00ff,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_4,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_ARP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP6, 0xff,
		NPC_IPNH_TCP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP6, 0xff,
		NPC_IPNH_UDP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP6, 0xff,
		NPC_IPNH_SCTP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP6, 0xff,
		NPC_IPNH_ICMP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP6, 0xff,
		NPC_IPNH_ICMP6 << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP6, 0xff,
		NPC_IPNH_ESP << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP6, 0xff,
		NPC_IPNH_AH << 8,
		0xff00,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP6, 0xff,
		0x0000,
		0x0000,
		NPC_IP_VER_6,
		NPC_IP_VER_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU12_TU_IP6, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu13_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU13_TU_IP6_EXT, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu14_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU14_TU_IP6_EXT, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu15_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_FIN,
		NPC_TCP_FLAGS_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_RST | NPC_TCP_FLAGS_FIN,
		NPC_TCP_FLAGS_RST | NPC_TCP_FLAGS_FIN,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_URG | NPC_TCP_FLAGS_SYN,
		NPC_TCP_FLAGS_URG | NPC_TCP_FLAGS_SYN,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_RST | NPC_TCP_FLAGS_SYN,
		NPC_TCP_FLAGS_RST | NPC_TCP_FLAGS_SYN,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_FLAGS_SYN | NPC_TCP_FLAGS_FIN,
		NPC_TCP_FLAGS_SYN | NPC_TCP_FLAGS_FIN,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		NPC_TCP_PORT_HTTP,
		0xffff,
		NPC_TCP_DATA_OFFSET_5,
		NPC_TCP_DATA_OFFSET_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		NPC_TCP_PORT_HTTPS,
		0xffff,
		NPC_TCP_DATA_OFFSET_5,
		NPC_TCP_DATA_OFFSET_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		NPC_TCP_PORT_PPTP,
		0xffff,
		NPC_TCP_DATA_OFFSET_5,
		NPC_TCP_DATA_OFFSET_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		0x0000,
		0x0000,
		NPC_TCP_DATA_OFFSET_5,
		NPC_TCP_DATA_OFFSET_MASK,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		NPC_TCP_PORT_HTTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		NPC_TCP_PORT_HTTPS,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		NPC_TCP_PORT_PPTP,
		0xffff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_TCP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_UDP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_SCTP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_ICMP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_IGMP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_ICMP6, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_ESP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU15_TU_AH, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_NA, 0X00,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_cam kpu16_cam_entries[] = {
	NPC_KPU_NOP_CAM,
	NPC_KPU_NOP_CAM,
	{
		NPC_S_KPU16_TCP_DATA, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU16_HTTP_DATA, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU16_HTTPS_DATA, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU16_PPTP_DATA, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU16_UDP_DATA, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
	{
		NPC_S_KPU16_UDP_PTP, 0xff,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
		0x0000,
	},
};

static struct npc_kpu_profile_action kpu1_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU5_IP, 14, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU5_IP6, 14, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_ARP, 14, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_RARP, 14, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_PTP, 14, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_FCOE, 14, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 0, 0, 0,
		NPC_S_KPU2_CTAG2, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 12, 0, 0,
		NPC_S_KPU2_CTAG, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 22, 0, 0,
		NPC_S_KPU2_SBTAG, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_QINQ, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 26, 0, 0,
		NPC_S_KPU2_ETAG, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_ETAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 14, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_L_WITH_MPLS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 14, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_L_WITH_MPLS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU4_NSH, 14, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_L_WITH_NSH,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 0, 1, 0,
		NPC_S_KPU3_DSA, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 0, 2, 0,
		NPC_S_KPU4_PPPOE, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LA, NPC_LT_LA_8023,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LA, NPC_LT_LA_8023,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_L_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU5_IP, 22, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU5_IP6, 22, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_ARP, 22, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_RARP, 22, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_PTP, 22, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_FCOE, 22, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 0, 0, 0,
		NPC_S_KPU2_CTAG2, 20, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_CTAG, 20, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 22, 0, 0,
		NPC_S_KPU2_SBTAG, 20, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_QINQ, 20, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 26, 0, 0,
		NPC_S_KPU2_ETAG, 20, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_ETAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 22, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_L_WITH_MPLS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 22, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_L_WITH_MPLS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU4_NSH, 22, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_L_WITH_NSH,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_L_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 14, 16, 0, 0,
		NPC_S_KPU2_PREHEADER, 8, 1,
		NPC_LID_LA, NPC_LT_LA_IH_8_ETHER,
		0,
		1, 0xff, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 14, 16, 0, 0,
		NPC_S_KPU2_PREHEADER, 4, 1,
		NPC_LID_LA, NPC_LT_LA_IH_4_ETHER,
		0,
		1, 0xff, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 14, 16, 0, 0,
		NPC_S_KPU2_PREHEADER, 2, 1,
		NPC_LID_LA, NPC_LT_LA_IH_2_ETHER,
		0,
		1, 0xff, 0, 0,
	},
	{
		NPC_ERRLEV_LA, NPC_EC_IH_LENGTH,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		NPC_F_LA_L_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 16, 0, 0,
		NPC_S_KPU2_EXDSA, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 12, 2, 0,
		NPC_S_KPU4_FDSA, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LA, NPC_EC_EDSA_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU5_IP, 30, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU5_IP6, 30, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_ARP, 30, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_RARP, 30, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_PTP, 30, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_FCOE, 30, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 0, 0, 0,
		NPC_S_KPU2_CTAG2, 28, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2 | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_CTAG, 28, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2 | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 22, 0, 0,
		NPC_S_KPU2_SBTAG, 28, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2 | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_QINQ, 28, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2 | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 26, 0, 0,
		NPC_S_KPU2_ETAG, 28, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2 | NPC_F_LA_U_HAS_TAG
			| NPC_F_LA_L_WITH_ETAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 30, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2 | NPC_F_LA_L_WITH_MPLS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 30, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2 | NPC_F_LA_L_WITH_MPLS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU4_NSH, 30, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2 | NPC_F_LA_L_WITH_NSH,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LA, NPC_LT_LA_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_HIGIG2 | NPC_F_LA_L_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU5_IP, 38, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU5_IP6, 38, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_ARP, 38, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_RARP, 38, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_PTP, 38, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_FCOE, 38, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 0, 0, 0,
		NPC_S_KPU2_CTAG2, 36, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2
			| NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_CTAG, 36, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2
			| NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 22, 0, 0,
		NPC_S_KPU2_SBTAG, 36, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2
			| NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_QINQ, 36, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2
			| NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 26, 0, 0,
		NPC_S_KPU2_ETAG, 36, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2
			| NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_ETAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 38, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2
			| NPC_F_LA_L_WITH_MPLS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 38, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2
			| NPC_F_LA_L_WITH_MPLS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU4_NSH, 38, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2
			| NPC_F_LA_L_WITH_NSH,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LA, NPC_LT_LA_IH_NIX_HIGIG2_ETHER,
		NPC_F_LA_U_HAS_IH_NIX | NPC_F_LA_U_HAS_HIGIG2
			| NPC_F_LA_L_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU5_IP, 14, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU5_IP6, 14, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_ARP, 14, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_RARP, 14, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_PTP, 14, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU5_FCOE, 14, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 0, 0, 0,
		NPC_S_KPU2_CTAG2, 12, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_CTAG, 12, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 22, 0, 0,
		NPC_S_KPU2_SBTAG, 12, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_QINQ, 12, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 12, 26, 0, 0,
		NPC_S_KPU2_ETAG, 12, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 14, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU4_MPLS, 14, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU4_NSH, 14, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU5_CPT_IP, 14, 1,
		NPC_LID_LA, NPC_LT_LA_CPT_HDR,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU5_CPT_IP6, 14, 1,
		NPC_LID_LA, NPC_LT_LA_CPT_HDR,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_CPT_CTAG, 12, 1,
		NPC_LID_LA, NPC_LT_LA_CPT_HDR,
		NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU2_CPT_QINQ, 12, 1,
		NPC_LID_LA, NPC_LT_LA_CPT_HDR,
		NPC_F_LA_U_HAS_TAG | NPC_F_LA_L_WITH_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 0, 0, 1, 0,
		NPC_S_KPU3_VLAN_EXDSA, 12, 1,
		NPC_LID_LA, NPC_LT_LA_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LA, NPC_EC_L2_K1,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LA, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu2_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_RARP, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_PTP, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_FCOE, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 1, 0,
		NPC_S_KPU4_NSH, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_NGIO, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 14, 1,
		NPC_LID_LB, NPC_LT_LB_PPPOE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 14, 1,
		NPC_LID_LB, NPC_LT_LB_PPPOE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		NPC_F_LB_U_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_RARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_PTP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_FCOE, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 1, 0,
		NPC_S_KPU4_NSH, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG_UNK,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 0, 0, 0,
		NPC_S_KPU3_CTAG, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_STAG_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 0, 0, 0,
		NPC_S_KPU3_STAG, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_STAG_STAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_RARP, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_PTP, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_FCOE, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 1, 0,
		NPC_S_KPU4_NSH, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU3_STAG, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG_STAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU3_CTAG, 24, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_BTAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG_UNK,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_RARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_PTP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_FCOE, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 1, 0,
		NPC_S_KPU4_NSH, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG_UNK,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 0, 0, 0,
		NPC_S_KPU3_CTAG, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_QINQ_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 0, 0, 0,
		NPC_S_KPU3_QINQ, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_QINQ_QINQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_RARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_PTP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_FCOE, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		1,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_NSH, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		2,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU3_CTAG, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 0, 0, 0,
		NPC_S_KPU3_STAG, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_STAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 0, 0, 0,
		NPC_S_KPU3_QINQ, 10, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_QINQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 28, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 28, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 28, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU3_STAG, 28, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG_STAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU3_CTAG, 28, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_ITAG_UNK,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_ETAG,
		NPC_F_LB_U_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_RARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_PTP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_FCOE, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 1, 0,
		NPC_S_KPU4_NSH, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 0, 0, 0,
		NPC_S_KPU3_QINQ, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_QINQ_QINQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_RARP, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_PTP, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_FCOE, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 0, 0, 0,
		NPC_S_KPU3_CTAG_C, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 20, 0, 0,
		NPC_S_KPU3_STAG_C, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 0, 0, 0,
		NPC_S_KPU3_QINQ_C, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU4_MPLS, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 1, 0,
		NPC_S_KPU4_NSH, 14, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 18, 1,
		NPC_LID_LB, NPC_LT_LB_EDSA,
		NPC_F_LB_L_EDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 18, 1,
		NPC_LID_LB, NPC_LT_LB_EDSA,
		NPC_F_LB_L_EDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 18, 1,
		NPC_LID_LB, NPC_LT_LB_EDSA,
		NPC_F_LB_L_EDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_RARP, 18, 1,
		NPC_LID_LB, NPC_LT_LB_EDSA,
		NPC_F_LB_L_EDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_PTP, 18, 1,
		NPC_LID_LB, NPC_LT_LB_EDSA,
		NPC_F_LB_L_EDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_FCOE, 18, 1,
		NPC_LID_LB, NPC_LT_LB_EDSA,
		NPC_F_LB_L_EDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU3_CTAG, 16, 1,
		NPC_LID_LB, NPC_LT_LB_EDSA_VLAN,
		NPC_F_LB_L_EDSA_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_EDSA,
		NPC_F_LB_U_UNK_ETYPE | NPC_F_LB_L_EDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_IP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_EXDSA,
		NPC_F_LB_L_EXDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_IP6, 10, 1,
		NPC_LID_LB, NPC_LT_LB_EXDSA,
		NPC_F_LB_L_EXDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_ARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_EXDSA,
		NPC_F_LB_L_EXDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_RARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_EXDSA,
		NPC_F_LB_L_EXDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_PTP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_EXDSA,
		NPC_F_LB_L_EXDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU5_FCOE, 10, 1,
		NPC_LID_LB, NPC_LT_LB_EXDSA,
		NPC_F_LB_L_EXDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		4, 8, 0, 0, 0,
		NPC_S_KPU3_CTAG, 8, 1,
		NPC_LID_LB, NPC_LT_LB_EXDSA_VLAN,
		NPC_F_LB_L_EXDSA_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_EXDSA,
		NPC_F_LB_U_UNK_ETYPE | NPC_F_LB_L_EXDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_CPT_IP, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_CPT_IP6, 6, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU5_CPT_IP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU5_CPT_IP6, 10, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		NPC_F_LB_U_MORE_TAG | NPC_F_LB_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_L2_K3,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu3_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 6, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 6, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 6, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 6, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 6, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 6, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 6, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 6, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 6, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_L2_K3_ETYPE_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_L2_K3_ETYPE_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_L2_K3_ETYPE_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 4, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 4, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 4, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_L2_K3_ETYPE_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_CTAG,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_L2_K3_ETYPE_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 8, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU4_MPLS, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU4_NSH, 4, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_L2_K3_ETYPE_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_STAG_QINQ,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_DSA,
		NPC_F_LB_L_DSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 10, 1,
		NPC_LID_LB, NPC_LT_LB_DSA,
		NPC_F_LB_L_DSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_DSA,
		NPC_F_LB_L_DSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_DSA,
		NPC_F_LB_L_DSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_DSA,
		NPC_F_LB_L_DSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 10, 1,
		NPC_LID_LB, NPC_LT_LB_DSA,
		NPC_F_LB_L_DSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU5_IP, 14, 1,
		NPC_LID_LB, NPC_LT_LB_DSA_VLAN,
		NPC_F_LB_L_DSA_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU5_IP6, 14, 1,
		NPC_LID_LB, NPC_LT_LB_DSA_VLAN,
		NPC_F_LB_L_DSA_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_ARP, 14, 1,
		NPC_LID_LB, NPC_LT_LB_DSA_VLAN,
		NPC_F_LB_L_DSA_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_RARP, 14, 1,
		NPC_LID_LB, NPC_LT_LB_DSA_VLAN,
		NPC_F_LB_L_DSA_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_PTP, 14, 1,
		NPC_LID_LB, NPC_LT_LB_DSA_VLAN,
		NPC_F_LB_L_DSA_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU5_FCOE, 14, 1,
		NPC_LID_LB, NPC_LT_LB_DSA_VLAN,
		NPC_F_LB_L_DSA_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_DSA_VLAN,
		NPC_F_LB_U_UNK_ETYPE | NPC_F_LB_L_DSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_DSA,
		NPC_F_LB_U_UNK_ETYPE | NPC_F_LB_L_DSA_VLAN,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU4_VLAN_EXDSA, 12, 1,
		NPC_LID_LB, NPC_LT_LB_VLAN_EXDSA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_L2_K3,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu4_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU5_MPLS_PL, 4, 1,
		NPC_LID_LC, NPC_LT_LC_MPLS,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU5_MPLS_PL, 8, 1,
		NPC_LID_LC, NPC_LT_LC_MPLS,
		NPC_F_LC_L_MPLS_2_LABELS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU5_MPLS_PL, 12, 1,
		NPC_LID_LC, NPC_LT_LC_MPLS,
		NPC_F_LC_L_MPLS_3_LABELS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 4, 0, 0, 0,
		NPC_S_KPU5_MPLS, 12, 1,
		NPC_LID_LC, NPC_LT_LC_MPLS,
		NPC_F_LC_L_MPLS_4_LABELS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 7, 0,
		NPC_S_KPU12_TU_IP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_NSH,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 7, 0,
		NPC_S_KPU12_TU_IP6, 0, 1,
		NPC_LID_LC, NPC_LT_LC_NSH,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 6, 0,
		NPC_S_KPU11_TU_ETHER, 0, 1,
		NPC_LID_LC, NPC_LT_LC_NSH,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 4, 0,
		NPC_S_KPU9_TU_MPLS_IN_NSH, 0, 1,
		NPC_LID_LC, NPC_LT_LC_NSH,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_NSH_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_NSH,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU5_IP, 6, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU5_IP6, 6, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU5_ARP, 6, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU5_RARP, 6, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU5_PTP, 6, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU5_FCOE, 6, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU5_IP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU5_IP6, 10, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU5_ARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU5_RARP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU5_PTP, 10, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU5_FCOE, 10, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU5_IP, 14, 1,
		NPC_LID_LB, NPC_LT_LB_PPPOE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU5_IP6, 14, 1,
		NPC_LID_LB, NPC_LT_LB_PPPOE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LB, NPC_LT_LB_FDSA,
		NPC_F_LB_U_UNK_ETYPE | NPC_F_LB_L_FDSA,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU5_IP, 2, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU5_IP6, 2, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU5_ARP, 2, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU5_RARP, 2, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU5_PTP, 2, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU5_FCOE, 2, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU5_IP, 10, 0,
		NPC_LID_LB, NPC_LT_LB_PPPOE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU5_IP6, 10, 0,
		NPC_LID_LB, NPC_LT_LB_PPPOE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_L2_K4,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu5_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_LC, NPC_EC_IP_TTL_0,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_IP_FRAG_OFFSET_1,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_U_IP_FRAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 2, 0,
		NPC_S_KPU8_TCP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU8_UDP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_SCTP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_ICMP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_IGMP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU9_ESP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_AH, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU8_GRE, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 6, 0,
		NPC_S_KPU12_TU_IP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_L_IP_IN_IP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 6, 0,
		NPC_S_KPU12_TU_IP6, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_L_6TO4,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 3, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_L_MPLS_IN_IP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_U_UNK_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_U_IP_FRAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 2, 0,
		NPC_S_KPU8_TCP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 8, 10, 2, 0,
		NPC_S_KPU8_UDP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_SCTP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_ICMP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_IGMP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU9_ESP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_AH, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU8_GRE, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 6, 0,
		NPC_S_KPU12_TU_IP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		NPC_F_LC_L_IP_IN_IP,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 6, 0,
		NPC_S_KPU12_TU_IP6, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		NPC_F_LC_L_6TO4,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 3, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		NPC_F_LC_L_MPLS_IN_IP,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		NPC_F_LC_U_UNK_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		NPC_F_LC_U_IP_FRAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_IP_VER,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_ARP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_RARP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_PTP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_FCOE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_IP6_HOP_0,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 2, 0,
		NPC_S_KPU8_TCP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU8_UDP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_SCTP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_ICMP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_ICMP6, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_GRE, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 6, 0,
		NPC_S_KPU12_TU_IP6, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		NPC_F_LC_L_IP6_TUN_IP6,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 3, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		NPC_F_LC_L_IP6_MPLS_IN_IP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU6_IP6_HOP_DEST, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_HOP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU6_IP6_HOP_DEST, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_DEST,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU6_IP6_ROUT, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_ROUT,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 2, 0, 0, 0,
		NPC_S_KPU6_IP6_FRAG, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_U_IP6_FRAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU9_ESP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_AH, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_MOBILITY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_HOSTID,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_SHIM6,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		NPC_F_LC_U_UNK_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_IP6_VER,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 6, 0,
		NPC_S_KPU12_TU_IP, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 6, 0,
		NPC_S_KPU12_TU_IP6, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 5, 0,
		NPC_S_KPU11_TU_ETHER, 8, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 5, 0,
		NPC_S_KPU11_TU_ETHER, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LB, NPC_EC_MPLS_2MANY,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 6, 0,
		NPC_S_KPU12_TU_IP, 0, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 6, 0,
		NPC_S_KPU12_TU_IP6, 0, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 5, 0,
		NPC_S_KPU11_TU_ETHER, 4, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 5, 0,
		NPC_S_KPU11_TU_ETHER, 0, 0,
		NPC_LID_LB, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_IP_TTL_0,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_IP_FRAG_OFFSET_1,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_U_IP_FRAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 2, 0,
		NPC_S_KPU8_TCP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU8_UDP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_SCTP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_ICMP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_IGMP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU9_ESP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_AH, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU8_GRE, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 6, 0,
		NPC_S_KPU12_TU_IP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_L_IP_IN_IP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 6, 0,
		NPC_S_KPU12_TU_IP6, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_L_6TO4,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 3, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_L_MPLS_IN_IP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		NPC_F_LC_U_UNK_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 2, 0,
		NPC_S_KPU8_TCP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 8, 10, 2, 0,
		NPC_S_KPU8_UDP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_SCTP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_ICMP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_IGMP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU9_ESP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_AH, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU8_GRE, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		0,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 6, 0,
		NPC_S_KPU12_TU_IP, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		NPC_F_LC_L_IP_IN_IP,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 6, 0,
		NPC_S_KPU12_TU_IP6, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		NPC_F_LC_L_6TO4,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 3, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 20, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		NPC_F_LC_L_MPLS_IN_IP,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP_OPT,
		NPC_F_LC_U_UNK_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_IP_VER,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_IP6_HOP_0,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 2, 0,
		NPC_S_KPU8_TCP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU8_UDP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_SCTP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_ICMP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_ICMP6, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_GRE, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 6, 0,
		NPC_S_KPU12_TU_IP6, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		NPC_F_LC_L_IP6_TUN_IP6,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 3, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		NPC_F_LC_L_IP6_MPLS_IN_IP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_HOP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU6_IP6_CPT_HOP_DEST, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_DEST,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU6_IP6_CPT_ROUT, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_ROUT,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 2, 0, 0, 0,
		NPC_S_KPU6_IP6_CPT_FRAG, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_U_IP6_FRAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 3, 0,
		NPC_S_KPU9_ESP, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU8_AH, 40, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_MOBILITY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_HOSTID,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6_EXT,
		NPC_F_LC_L_EXT_SHIM6,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		NPC_F_LC_U_UNK_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_IP6_VER,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LC, NPC_LT_LC_NGIO,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu6_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 1, 0,
		NPC_S_KPU8_TCP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 8, 10, 1, 0,
		NPC_S_KPU8_UDP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_SCTP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU9_ESP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_AH, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_GRE, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 5, 0,
		NPC_S_KPU12_TU_IP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU7_IP6_ROUT, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 2, 0, 0, 0,
		NPC_S_KPU7_IP6_FRAG, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 1, 0,
		NPC_S_KPU8_TCP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 8, 10, 1, 0,
		NPC_S_KPU8_UDP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_SCTP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU9_ESP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_AH, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_GRE, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 5, 0,
		NPC_S_KPU12_TU_IP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 2, 0, 0, 0,
		NPC_S_KPU7_IP6_FRAG, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 1, 0,
		NPC_S_KPU8_TCP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 8, 10, 1, 0,
		NPC_S_KPU8_UDP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_SCTP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU9_ESP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_AH, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_GRE, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 5, 0,
		NPC_S_KPU12_TU_IP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 1, 0,
		NPC_S_KPU8_TCP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 8, 10, 1, 0,
		NPC_S_KPU8_UDP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_SCTP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU9_ESP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_AH, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_GRE, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 5, 0,
		NPC_S_KPU12_TU_IP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU7_IP6_ROUT, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 2, 0, 0, 0,
		NPC_S_KPU7_CPT_IP6_FRAG, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 1, 0,
		NPC_S_KPU8_TCP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 8, 10, 1, 0,
		NPC_S_KPU8_UDP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_SCTP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_ICMP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU9_ESP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_AH, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU8_GRE, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 5, 0,
		NPC_S_KPU12_TU_IP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 2, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 2, 0, 0, 0,
		NPC_S_KPU7_CPT_IP6_FRAG, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu7_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 0, 0,
		NPC_S_KPU8_TCP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 8, 10, 0, 0,
		NPC_S_KPU8_UDP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_SCTP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_ICMP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_ICMP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU9_ESP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_AH, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_GRE, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 4, 0,
		NPC_S_KPU12_TU_IP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		1, 0xff, 0, 3,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 0, 0,
		NPC_S_KPU8_TCP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 8, 10, 0, 0,
		NPC_S_KPU8_UDP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_SCTP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_ICMP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_ICMP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 1, 0,
		NPC_S_KPU9_ESP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_AH, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU8_GRE, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 4, 0,
		NPC_S_KPU12_TU_IP6, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 1, 0,
		NPC_S_KPU9_TU_MPLS_IN_IP, 8, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LC, NPC_EC_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu8_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_LD, NPC_EC_TCP_FLAGS_FIN_ONLY,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LD, NPC_EC_TCP_FLAGS_ZERO,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LD, NPC_EC_TCP_FLAGS_RST_FIN,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LD, NPC_EC_TCP_FLAGS_URG_SYN,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LD, NPC_EC_TCP_FLAGS_RST_SYN,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LD, NPC_EC_TCP_FLAGS_SYN_FIN,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 7, 0,
		NPC_S_KPU16_HTTP_DATA, 20, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 7, 0,
		NPC_S_KPU16_HTTPS_DATA, 20, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 7, 0,
		NPC_S_KPU16_PPTP_DATA, 20, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 7, 0,
		NPC_S_KPU16_TCP_DATA, 20, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		NPC_F_LD_L_TCP_UNK_PORT,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 7, 0,
		NPC_S_KPU16_HTTP_DATA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		NPC_F_LD_L_TCP_HAS_OPTIONS,
		12, 0xf0, 1, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 7, 0,
		NPC_S_KPU16_HTTPS_DATA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		NPC_F_LD_L_TCP_HAS_OPTIONS,
		12, 0xf0, 1, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 7, 0,
		NPC_S_KPU16_PPTP_DATA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		NPC_F_LD_L_TCP_HAS_OPTIONS,
		12, 0xf0, 1, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 7, 0,
		NPC_S_KPU16_TCP_DATA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_TCP,
		NPC_F_LD_L_TCP_UNK_PORT_HAS_OPTIONS,
		12, 0xf0, 1, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 2, 0, 0,
		NPC_S_KPU9_VXLAN, 8, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 2, 0, 0,
		NPC_S_KPU9_VXLANGPE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 2, 0, 0,
		NPC_S_KPU9_GENEVE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 2, 0, 0,
		NPC_S_KPU9_GTPC, 8, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 2, 0, 0,
		NPC_S_KPU9_GTPU, 8, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_KPU16_UDP_PTP, 0, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_KPU16_UDP_PTP, 0, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_UDP, 8, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU9_ESP, 8, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU9_ESP, 8, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 7, 0,
		NPC_S_KPU16_UDP_DATA, 8, 1,
		NPC_LID_LD, NPC_LT_LD_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_SCTP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_ICMP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_IGMP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_ICMP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_AH,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 2, 0,
		NPC_S_KPU11_TU_ETHER, 8, 1,
		NPC_LID_LD, NPC_LT_LD_NVGRE,
		NPC_F_LD_L_GRE_NVGRE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LD, NPC_EC_NVGRE,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LD, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 4, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 16, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 4, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU9_TU_MPLS_IN_GRE, 16, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU9_TU_NSH_IN_GRE, 4, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU9_TU_NSH_IN_GRE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU9_TU_NSH_IN_GRE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU9_TU_NSH_IN_GRE, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU9_TU_NSH_IN_GRE, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU9_TU_NSH_IN_GRE, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU9_TU_NSH_IN_GRE, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU9_TU_NSH_IN_GRE, 16, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU12_TU_IP, 4, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU12_TU_IP, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU12_TU_IP, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU12_TU_IP, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 3, 0,
		NPC_S_KPU12_TU_IP, 16, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU12_TU_IP6, 4, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU12_TU_IP6, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU12_TU_IP6, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU12_TU_IP6, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU12_TU_IP6, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU12_TU_IP6, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU12_TU_IP6, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 3, 0,
		NPC_S_KPU12_TU_IP6, 16, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_CSUM_KEY_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_HAS_ROUTE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_UNK_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LD, NPC_EC_GRE,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LD, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU11_TU_PPP, 8, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_VER1,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU11_TU_PPP, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_VER1_HAS_SEQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU11_TU_PPP, 12, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_VER1_HAS_ACK,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU11_TU_PPP, 16, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_VER1_HAS_SEQ_ACK,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LD, NPC_LT_LD_GRE,
		NPC_F_LD_L_GRE_VER1_UNK_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LD, NPC_EC_GRE_VER1,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LD, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LD, NPC_EC_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LD, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu9_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 4, 1,
		NPC_LID_LE, NPC_LT_LE_TU_MPLS_IN_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 8, 1,
		NPC_LID_LE, NPC_LT_LE_TU_MPLS_IN_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 12, 1,
		NPC_LID_LE, NPC_LT_LE_TU_MPLS_IN_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 4, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS, 12, 1,
		NPC_LID_LE, NPC_LT_LE_TU_MPLS_IN_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 4, 1,
		NPC_LID_LD, NPC_LT_LD_TU_MPLS_IN_NSH,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 8, 1,
		NPC_LID_LD, NPC_LT_LD_TU_MPLS_IN_NSH,
		NPC_F_LD_L_MPLS_2_LABELS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 12, 1,
		NPC_LID_LD, NPC_LT_LD_TU_MPLS_IN_NSH,
		NPC_F_LD_L_MPLS_3_LABELS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 4, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS, 12, 1,
		NPC_LID_LD, NPC_LT_LD_TU_MPLS_IN_NSH,
		NPC_F_LD_L_MPLS_4_LABELS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 4, 1,
		NPC_LID_LD, NPC_LT_LD_TU_MPLS_IN_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 8, 1,
		NPC_LID_LD, NPC_LT_LD_TU_MPLS_IN_IP,
		NPC_F_LD_L_MPLS_2_LABELS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 12, 1,
		NPC_LID_LD, NPC_LT_LD_TU_MPLS_IN_IP,
		NPC_F_LD_L_MPLS_3_LABELS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 4, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS, 12, 1,
		NPC_LID_LD, NPC_LT_LD_TU_MPLS_IN_IP,
		NPC_F_LD_L_MPLS_4_LABELS,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU12_TU_IP, 0, 1,
		NPC_LID_LE, NPC_LT_LE_TU_NSH_IN_GRE,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU12_TU_IP6, 0, 1,
		NPC_LID_LE, NPC_LT_LE_TU_NSH_IN_GRE,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 1, 0,
		NPC_S_KPU11_TU_ETHER, 0, 1,
		NPC_LID_LE, NPC_LT_LE_TU_NSH_IN_GRE,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_LE, NPC_EC_NSH_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LE, NPC_LT_LE_TU_NSH_IN_GRE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 1, 0,
		NPC_S_KPU11_TU_ETHER, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLAN,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 1, 0,
		NPC_S_KPU11_TU_ETHER, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLAN,
		NPC_F_LE_L_VXLAN_NOVNI,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LE, NPC_EC_VXLAN,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LE, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU12_TU_IP6, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 1, 0,
		NPC_S_KPU11_TU_ETHER, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU10_TU_NSH_IN_VXLANGPE, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU10_TU_MPLS_IN_VXLANGPE, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		NPC_F_LE_L_VXLANGPE_NOVNI,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU12_TU_IP6, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		NPC_F_LE_L_VXLANGPE_NOVNI,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 1, 0,
		NPC_S_KPU11_TU_ETHER, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		NPC_F_LE_L_VXLANGPE_NOVNI,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU10_TU_NSH_IN_VXLANGPE, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		NPC_F_LE_L_VXLANGPE_NOVNI,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 6, 10, 0, 0,
		NPC_S_KPU10_TU_MPLS_IN_VXLANGPE, 8, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		NPC_F_LE_L_VXLANGPE_NOVNI,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		NPC_F_LE_L_VXLANGPE_UNK,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LE, NPC_LT_LE_VXLANGPE,
		NPC_F_LE_L_VXLANGPE_NONP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 1, 0,
		NPC_S_KPU11_TU_ETHER, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		0,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 1, 0,
		NPC_S_KPU11_TU_ETHER, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		NPC_F_LE_L_GENEVE_OAM,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 1, 0,
		NPC_S_KPU11_TU_ETHER, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		NPC_F_LE_L_GENEVE_CRI_OPT,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 1, 0,
		NPC_S_KPU11_TU_ETHER, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		NPC_F_LE_L_GENEVE_OAM_CRI_OPT,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		0,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		NPC_F_LE_L_GENEVE_OAM,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		NPC_F_LE_L_GENEVE_CRI_OPT,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		NPC_F_LE_L_GENEVE_OAM_CRI_OPT,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU12_TU_IP6, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		0,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU12_TU_IP6, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		NPC_F_LE_L_GENEVE_OAM,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU12_TU_IP6, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		NPC_F_LE_L_GENEVE_CRI_OPT,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 2, 0,
		NPC_S_KPU12_TU_IP6, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GENEVE,
		NPC_F_LE_L_GENEVE_OAM_CRI_OPT,
		0, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LE, NPC_LT_LE_GTPC,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GTPU,
		NPC_F_LE_L_GTPU_G_PDU,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 2, 0,
		NPC_S_KPU12_TU_IP, 8, 1,
		NPC_LID_LE, NPC_LT_LE_GTPU,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 4, 1,
		NPC_LID_LE, NPC_LT_LE_TU_MPLS_IN_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 8, 1,
		NPC_LID_LE, NPC_LT_LE_TU_MPLS_IN_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS_PL, 12, 1,
		NPC_LID_LE, NPC_LT_LE_TU_MPLS_IN_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 4, 0, 0, 0,
		NPC_S_KPU10_TU_MPLS, 12, 1,
		NPC_LID_LE, NPC_LT_LE_TU_MPLS_IN_UDP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LE, NPC_LT_LE_ESP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LE, NPC_EC_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LE, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu10_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU12_TU_IP, 4, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU12_TU_IP6, 4, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU11_TU_ETHER, 8, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU11_TU_ETHER, 4, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LE, NPC_EC_MPLS_2MANY,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU12_TU_IP, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU12_TU_IP6, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU11_TU_ETHER, 4, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		12, 16, 20, 0, 0,
		NPC_S_KPU11_TU_ETHER, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU11_TU_MPLS_PL, 4, 1,
		NPC_LID_LF, NPC_LT_LF_TU_MPLS_IN_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU11_TU_MPLS_PL, 8, 1,
		NPC_LID_LF, NPC_LT_LF_TU_MPLS_IN_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU11_TU_MPLS_PL, 12, 1,
		NPC_LID_LF, NPC_LT_LF_TU_MPLS_IN_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 4, 0, 0, 0,
		NPC_S_KPU11_TU_MPLS, 12, 1,
		NPC_LID_LF, NPC_LT_LF_TU_MPLS_IN_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 1, 0,
		NPC_S_KPU12_TU_IP, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_NSH_IN_VXLANGPE,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 1, 0,
		NPC_S_KPU12_TU_IP6, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_NSH_IN_VXLANGPE,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU11_TU_ETHER_IN_NSH, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_NSH_IN_VXLANGPE,
		0,
		1, 0x3f, 0, 2,
	},
	{
		NPC_ERRLEV_LF, NPC_EC_NSH_UNK,
		6, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_NSH_IN_VXLANGPE,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LE, NPC_EC_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu11_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU12_TU_IP, 14, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU12_TU_IP6, 14, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU12_TU_ARP, 14, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU12_TU_IP, 18, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU12_TU_IP6, 18, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU12_TU_ARP, 18, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_U_UNK_ETYPE | NPC_F_LF_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU12_TU_IP, 22, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_STAG_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU12_TU_IP6, 22, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_STAG_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU12_TU_ARP, 22, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_STAG_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_U_UNK_ETYPE | NPC_F_LF_L_WITH_STAG_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU12_TU_IP, 18, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU12_TU_IP6, 18, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU12_TU_ARP, 18, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_U_UNK_ETYPE | NPC_F_LF_L_WITH_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU12_TU_IP, 22, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_QINQ_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU12_TU_IP6, 22, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_QINQ_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU12_TU_ARP, 22, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_QINQ_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_U_UNK_ETYPE | NPC_F_LF_L_WITH_QINQ_CTAG,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU12_TU_IP, 18, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_QINQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU12_TU_IP6, 18, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_QINQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU12_TU_ARP, 18, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_L_WITH_QINQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_U_UNK_ETYPE | NPC_F_LF_L_WITH_QINQ,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_ETHER,
		NPC_F_LF_U_UNK_ETYPE,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LF, NPC_LT_LF_TU_PPP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU12_TU_IP, 4, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU12_TU_IP6, 4, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LF, NPC_EC_MPLS_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LF, NPC_EC_MPLS_2MANY,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		8, 0, 6, 0, 0,
		NPC_S_KPU12_TU_IP, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		6, 0, 0, 0, 0,
		NPC_S_KPU12_TU_IP6, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LF, NPC_EC_MPLS_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_ETHER_IN_NSH,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LF, NPC_EC_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LF, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu12_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 2, 0,
		NPC_S_KPU15_TU_TCP, 20, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU15_TU_UDP, 20, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_SCTP, 20, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_ICMP, 20, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_IGMP, 20, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_ESP, 20, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_AH, 20, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		NPC_F_LG_U_UNK_IP_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 2, 0,
		NPC_S_KPU15_TU_TCP, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		NPC_F_LG_U_IP_HAS_OPTIONS,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU15_TU_UDP, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		NPC_F_LG_U_IP_HAS_OPTIONS,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_SCTP, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		NPC_F_LG_U_IP_HAS_OPTIONS,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_ICMP, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		NPC_F_LG_U_IP_HAS_OPTIONS,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_IGMP, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		NPC_F_LG_U_IP_HAS_OPTIONS,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_ESP, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		NPC_F_LG_U_IP_HAS_OPTIONS,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_AH, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		NPC_F_LG_U_IP_HAS_OPTIONS,
		0, 0xf, 0, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		NPC_F_LG_U_IP_HAS_OPTIONS | NPC_F_LG_U_UNK_IP_PROTO,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LF, NPC_EC_IP_VER,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_ARP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 12, 0, 2, 0,
		NPC_S_KPU15_TU_TCP, 40, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 2, 0,
		NPC_S_KPU15_TU_UDP, 40, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_SCTP, 40, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_ICMP, 40, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_ICMP6, 40, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_ESP, 40, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 2, 0,
		NPC_S_KPU15_TU_AH, 40, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		2, 0, 0, 0, 0,
		NPC_S_KPU13_TU_IP6_EXT, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP6,
		NPC_F_LG_U_IP6_HAS_EXT,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LF, NPC_EC_IP6_VER,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LG, NPC_LT_LG_TU_IP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LF, NPC_EC_UNK,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LG, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu13_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu14_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LC, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu15_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_LG, NPC_EC_TCP_FLAGS_FIN_ONLY,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LG, NPC_EC_TCP_FLAGS_ZERO,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LG, NPC_EC_TCP_FLAGS_RST_FIN,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LG, NPC_EC_TCP_FLAGS_URG_SYN,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LG, NPC_EC_TCP_FLAGS_RST_SYN,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LG, NPC_EC_TCP_FLAGS_SYN_FIN,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU16_HTTP_DATA, 20, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		NPC_F_LH_L_TCP_HTTP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU16_HTTPS_DATA, 20, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		NPC_F_LH_L_TCP_HTTP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU16_PPTP_DATA, 20, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		NPC_F_LH_L_TCP_PPTP,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU16_TCP_DATA, 20, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		NPC_F_LH_L_TCP_UNK_PORT,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU16_HTTP_DATA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		NPC_F_LH_U_TCP_HAS_OPTIONS | NPC_F_LH_L_TCP_HTTP,
		12, 0xf0, 1, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU16_HTTPS_DATA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		NPC_F_LH_U_TCP_HAS_OPTIONS | NPC_F_LH_L_TCP_HTTPS,
		12, 0xf0, 1, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU16_PPTP_DATA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		NPC_F_LH_U_TCP_HAS_OPTIONS | NPC_F_LH_L_TCP_PPTP,
		12, 0xf0, 1, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU16_TCP_DATA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_TCP,
		NPC_F_LH_U_TCP_HAS_OPTIONS | NPC_F_LH_L_TCP_UNK_PORT,
		12, 0xf0, 1, 2,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 0,
		NPC_S_KPU16_UDP_DATA, 8, 1,
		NPC_LID_LH, NPC_LT_LH_TU_UDP,
		NPC_F_LH_L_UDP_UNK_PORT,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_SCTP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_ICMP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_IGMP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_ICMP6,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_ESP,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 1,
		NPC_LID_LH, NPC_LT_LH_TU_AH,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_LG, NPC_EC_L4,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LH, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile_action kpu16_action_entries[] = {
	NPC_KPU_NOP_ACTION,
	NPC_KPU_NOP_ACTION,
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LH, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LH, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LH, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LH, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LH, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
	{
		NPC_ERRLEV_RE, NPC_EC_NOERR,
		0, 0, 0, 0, 1,
		NPC_S_NA, 0, 0,
		NPC_LID_LH, NPC_LT_NA,
		0,
		0, 0, 0, 0,
	},
};

static struct npc_kpu_profile npc_kpu_profiles[] = {
	{
		ARRAY_SIZE(kpu1_cam_entries),
		ARRAY_SIZE(kpu1_action_entries),
		&kpu1_cam_entries[0],
		&kpu1_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu2_cam_entries),
		ARRAY_SIZE(kpu2_action_entries),
		&kpu2_cam_entries[0],
		&kpu2_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu3_cam_entries),
		ARRAY_SIZE(kpu3_action_entries),
		&kpu3_cam_entries[0],
		&kpu3_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu4_cam_entries),
		ARRAY_SIZE(kpu4_action_entries),
		&kpu4_cam_entries[0],
		&kpu4_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu5_cam_entries),
		ARRAY_SIZE(kpu5_action_entries),
		&kpu5_cam_entries[0],
		&kpu5_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu6_cam_entries),
		ARRAY_SIZE(kpu6_action_entries),
		&kpu6_cam_entries[0],
		&kpu6_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu7_cam_entries),
		ARRAY_SIZE(kpu7_action_entries),
		&kpu7_cam_entries[0],
		&kpu7_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu8_cam_entries),
		ARRAY_SIZE(kpu8_action_entries),
		&kpu8_cam_entries[0],
		&kpu8_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu9_cam_entries),
		ARRAY_SIZE(kpu9_action_entries),
		&kpu9_cam_entries[0],
		&kpu9_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu10_cam_entries),
		ARRAY_SIZE(kpu10_action_entries),
		&kpu10_cam_entries[0],
		&kpu10_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu11_cam_entries),
		ARRAY_SIZE(kpu11_action_entries),
		&kpu11_cam_entries[0],
		&kpu11_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu12_cam_entries),
		ARRAY_SIZE(kpu12_action_entries),
		&kpu12_cam_entries[0],
		&kpu12_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu13_cam_entries),
		ARRAY_SIZE(kpu13_action_entries),
		&kpu13_cam_entries[0],
		&kpu13_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu14_cam_entries),
		ARRAY_SIZE(kpu14_action_entries),
		&kpu14_cam_entries[0],
		&kpu14_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu15_cam_entries),
		ARRAY_SIZE(kpu15_action_entries),
		&kpu15_cam_entries[0],
		&kpu15_action_entries[0],
	},
	{
		ARRAY_SIZE(kpu16_cam_entries),
		ARRAY_SIZE(kpu16_action_entries),
		&kpu16_cam_entries[0],
		&kpu16_action_entries[0],
	},
};

static struct npc_lt_def_cfg npc_lt_defaults = {
	.rx_ol2 = {
		.lid = NPC_LID_LA,
		.ltype_match = NPC_LT_LA_ETHER,
		.ltype_mask = 0x0F,
	},
	.ovlan = {
		.lid = NPC_LID_LB,
		.ltype_match = NPC_LT_LB_CTAG,
		.ltype_mask = 0x0F,
	},
	.ivlan = {
		.lid = NPC_LID_LB,
		.ltype_match = NPC_LT_LB_STAG_QINQ,
		.ltype_mask = 0x0F,
	},
	.rx_oip4 = {
		.lid = NPC_LID_LC,
		.ltype_match = NPC_LT_LC_IP,
		.ltype_mask = 0x0E,
	},
	.rx_iip4 = {
		.lid = NPC_LID_LG,
		.ltype_match = NPC_LT_LG_TU_IP,
		.ltype_mask = 0x0F,
	},
	.rx_oip6 = {
		.lid = NPC_LID_LC,
		.ltype_match = NPC_LT_LC_IP6,
		.ltype_mask = 0x0E,
	},
	.rx_iip6 = {
		.lid = NPC_LID_LG,
		.ltype_match = NPC_LT_LG_TU_IP6,
		.ltype_mask = 0x0F,
	},
	.rx_otcp = {
		.lid = NPC_LID_LD,
		.ltype_match = NPC_LT_LD_TCP,
		.ltype_mask = 0x0F,
	},
	.rx_itcp = {
		.lid = NPC_LID_LH,
		.ltype_match = NPC_LT_LH_TU_TCP,
		.ltype_mask = 0x0F,
	},
	.rx_oudp = {
		.lid = NPC_LID_LD,
		.ltype_match = NPC_LT_LD_UDP,
		.ltype_mask = 0x0F,
	},
	.rx_iudp = {
		.lid = NPC_LID_LH,
		.ltype_match = NPC_LT_LH_TU_UDP,
		.ltype_mask = 0x0F,
	},
	.rx_osctp = {
		.lid = NPC_LID_LD,
		.ltype_match = NPC_LT_LD_SCTP,
		.ltype_mask = 0x0F,
	},
	.rx_isctp = {
		.lid = NPC_LID_LH,
		.ltype_match = NPC_LT_LH_TU_SCTP,
		.ltype_mask = 0x0F,
	},
	.rx_ipsec = {
		{
			.lid = NPC_LID_LE,
			.ltype_match = NPC_LT_LE_ESP,
			.ltype_mask = 0x0F,
		},
		{
			.spi_offset = 8,
			.lid = NPC_LID_LH,
			.ltype_match = NPC_LT_LH_TU_ESP,
			.ltype_mask = 0x0F,
		},
	},
	.pck_ol2 = {
			.lid = NPC_LID_LA,
			.ltype_match = NPC_LT_LA_ETHER,
			.ltype_mask = 0x0F,
	},
	.pck_oip4 = {
			.lid = NPC_LID_LC,
			.ltype_match = NPC_LT_LC_IP,
			.ltype_mask = 0x0E,
	},
	.pck_iip4 = {
			.lid = NPC_LID_LG,
			.ltype_match = NPC_LT_LG_TU_IP,
			.ltype_mask = 0x0F,
	},
	.rx_apad0 = {
		.valid = 0,
		.lid = NPC_LID_LC,
		.ltype_match = NPC_LT_LC_IP6,
		.ltype_mask = 0x0F,
	},
	.rx_apad1 = {
		.valid = 0,
		.lid = NPC_LID_LC,
		.ltype_match = NPC_LT_LC_IP6,
		.ltype_mask = 0x0F,
	},
	.rx_et = {
		{
			.lid = NPC_LID_LB,
			.ltype_match = NPC_LT_NA,
			.ltype_mask = 0x0,
		},
		{
			.lid = NPC_LID_LB,
			.ltype_match = NPC_LT_NA,
			.ltype_mask = 0x0,
		},
	},
};

static struct npc_mcam_kex npc_mkex_default = {
	.mkex_sign = MKEX_SIGN,
	.name = "default",
	.kpu_version = NPC_KPU_PROFILE_VER,
	.keyx_cfg = {
		/* nibble: LA..LE (ltype only) + Error code + Channel */
		[NIX_INTF_RX] = ((u64)NPC_MCAM_KEY_X2 << 32) | NPC_PARSE_NIBBLE_INTF_RX,
		/* nibble: LA..LE (ltype only) */
		[NIX_INTF_TX] = ((u64)NPC_MCAM_KEY_X2 << 32) | NPC_PARSE_NIBBLE_INTF_TX,
	},
	.intf_lid_lt_ld = {
	/* Default RX MCAM KEX profile */
	[NIX_INTF_RX] = {
		[NPC_LID_LA] = {
			/* Layer A: Ethernet: */
			[NPC_LT_LA_ETHER] = {
				/* DMAC: 6 bytes, KW1[55:8] */
				KEX_LD_CFG(0x05, 0x0, 0x1, 0x0, NPC_KEXOF_DMAC),
				/* Ethertype: 2 bytes, KW0[55:40] */
				KEX_LD_CFG(0x01, 0xc, 0x1, 0x0, 0x5),
			},
			/* Layer A: HiGig2: */
			[NPC_LT_LA_HIGIG2_ETHER] = {
				/* Classification: 2 bytes, KW1[23:8] */
				KEX_LD_CFG(0x01, 0x8, 0x1, 0x0, NPC_KEXOF_DMAC),
				/* VID: 2 bytes, KW1[39:24] */
				KEX_LD_CFG(0x01, 0xc, 0x1, 0x0,
					   NPC_KEXOF_DMAC + 2),
			},
		},
		[NPC_LID_LB] = {
			/* Layer B: Single VLAN (CTAG) */
			[NPC_LT_LB_CTAG] = {
				/* CTAG VLAN: 2 bytes, KW1[7:0], KW0[63:56] */
				KEX_LD_CFG(0x01, 0x2, 0x1, 0x0, 0x7),
				/* Ethertype: 2 bytes, KW0[55:40] */
				KEX_LD_CFG(0x01, 0x4, 0x1, 0x0, 0x5),
			},
			/* Layer B: Stacked VLAN (STAG|QinQ) */
			[NPC_LT_LB_STAG_QINQ] = {
				/* Outer VLAN: 2 bytes, KW1[7:0], KW0[63:56] */
				KEX_LD_CFG(0x01, 0x2, 0x1, 0x0, 0x7),
				/* Ethertype: 2 bytes, KW0[55:40] */
				KEX_LD_CFG(0x01, 0x8, 0x1, 0x0, 0x5),
			},
			[NPC_LT_LB_FDSA] = {
				/* SWITCH PORT: 1 byte, KW0[63:56] */
				KEX_LD_CFG(0x0, 0x1, 0x1, 0x0, 0x7),
				/* Ethertype: 2 bytes, KW0[55:40] */
				KEX_LD_CFG(0x01, 0x4, 0x1, 0x0, 0x5),
			},
		},
		[NPC_LID_LC] = {
			/* Layer C: IPv4 */
			[NPC_LT_LC_IP] = {
				/* SIP+DIP: 8 bytes, KW2[63:0] */
				KEX_LD_CFG(0x07, 0xc, 0x1, 0x0, 0x10),
				/* TOS: 1 byte, KW1[63:56] */
				KEX_LD_CFG(0x0, 0x1, 0x1, 0x0, 0xf),
			},
			/* Layer C: IPv6 */
			[NPC_LT_LC_IP6] = {
				/* Everything up to SADDR: 8 bytes, KW2[63:0] */
				KEX_LD_CFG(0x07, 0x0, 0x1, 0x0, 0x10),
			},
		},
		[NPC_LID_LD] = {
			/* Layer D:UDP */
			[NPC_LT_LD_UDP] = {
				/* SPORT+DPORT: 4 bytes, KW3[31:0] */
				KEX_LD_CFG(0x3, 0x0, 0x1, 0x0, 0x18),
			},
			/* Layer D:TCP */
			[NPC_LT_LD_TCP] = {
				/* SPORT+DPORT: 4 bytes, KW3[31:0] */
				KEX_LD_CFG(0x3, 0x0, 0x1, 0x0, 0x18),
			},
		},
	},

	/* Default TX MCAM KEX profile */
	[NIX_INTF_TX] = {
		[NPC_LID_LA] = {
			/* Layer A: NIX_INST_HDR_S + Ethernet */
			/* NIX appends 8 bytes of NIX_INST_HDR_S at the
			 * start of each TX packet supplied to NPC.
			 */
			[NPC_LT_LA_IH_NIX_ETHER] = {
				/* PF_FUNC: 2B , KW0 [47:32] */
				KEX_LD_CFG(0x01, 0x0, 0x1, 0x0, 0x4),
				/* DMAC: 6 bytes, KW1[63:16] */
				KEX_LD_CFG(0x05, 0x8, 0x1, 0x0, 0xa),
			},
			/* Layer A: HiGig2: */
			[NPC_LT_LA_IH_NIX_HIGIG2_ETHER] = {
				/* PF_FUNC: 2B , KW0 [47:32] */
				KEX_LD_CFG(0x01, 0x0, 0x1, 0x0, 0x4),
				/* VID: 2 bytes, KW1[31:16] */
				KEX_LD_CFG(0x01, 0x10, 0x1, 0x0, 0xa),
			},
		},
		[NPC_LID_LB] = {
			/* Layer B: Single VLAN (CTAG) */
			[NPC_LT_LB_CTAG] = {
				/* CTAG VLAN[2..3] KW0[63:48] */
				KEX_LD_CFG(0x01, 0x2, 0x1, 0x0, 0x6),
				/* CTAG VLAN[2..3] KW1[15:0] */
				KEX_LD_CFG(0x01, 0x4, 0x1, 0x0, 0x8),
			},
			/* Layer B: Stacked VLAN (STAG|QinQ) */
			[NPC_LT_LB_STAG_QINQ] = {
				/* Outer VLAN: 2 bytes, KW0[63:48] */
				KEX_LD_CFG(0x01, 0x2, 0x1, 0x0, 0x6),
				/* Outer VLAN: 2 Bytes, KW1[15:0] */
				KEX_LD_CFG(0x01, 0x8, 0x1, 0x0, 0x8),
			},
		},
		[NPC_LID_LC] = {
			/* Layer C: IPv4 */
			[NPC_LT_LC_IP] = {
				/* SIP+DIP: 8 bytes, KW2[63:0] */
				KEX_LD_CFG(0x07, 0xc, 0x1, 0x0, 0x10),
			},
			/* Layer C: IPv6 */
			[NPC_LT_LC_IP6] = {
				/* Everything up to SADDR: 8 bytes, KW2[63:0] */
				KEX_LD_CFG(0x07, 0x0, 0x1, 0x0, 0x10),
			},
		},
		[NPC_LID_LD] = {
			/* Layer D:UDP */
			[NPC_LT_LD_UDP] = {
				/* SPORT+DPORT: 4 bytes, KW3[31:0] */
				KEX_LD_CFG(0x3, 0x0, 0x1, 0x0, 0x18),
			},
			/* Layer D:TCP */
			[NPC_LT_LD_TCP] = {
				/* SPORT+DPORT: 4 bytes, KW3[31:0] */
				KEX_LD_CFG(0x3, 0x0, 0x1, 0x0, 0x18),
			},
		},
	},
	},
};

#endif /* NPC_PROFILE_H */
