/*
 * Written by Alexei V. Galatenko <agalat@castle.nmd.msu.ru>
 */

#include <malloc.h>
#include <string.h>

#include <pniam.h>

pniam_result_t get_item (pniam_item_list_t *list, const char *key, 
				char **value)
{
    pniam_item_t *item;

    item = pniam_item_list_find (list, key);
    if (item == NULL)
	return PNIAM_SYSERR;
    if (item->len == 0)
	*value = NULL;
    else
    {
	*value = (char *) malloc (item->len + 1);
	if (*value == NULL)
	    return PNIAM_SYSERR;
	else
	{
	   memcpy (*value, item->data, item->len);
	   (*value)[item->len] = 0;
	}
    }
    return PNIAM_OK;
}
