#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <security/pam_client.h>

int main()
{
    unsigned char data[4], *binary;
    unsigned int length, control;

    for (;;) {
	int cs;

	cs = read(fileno(stdin), data, 4);
	if (4 != cs) {
	    fprintf(stderr, "[read bad length: %d]\n", cs);
	    exit(1);
	}
	length = pamc_read__u32(data);
	fprintf(stderr, "[expecting %u characters]\n", length);
	if (length < 4) {
	    fprintf(stderr, "[which is bad]\n");
	    exit(1);
	}
	cs = read(fileno(stdin), data, 4);
	if (4 != cs) {
	    fprintf(stderr, "[read bad control: only %d chars]\n", cs);
	    exit(1);
	}
	control = pamc_read__u32(data);
	fprintf(stderr, "[got %u for control]\n", control);
	if (control == PAMC_CONTROL_EXIT) {
	    fprintf(stderr, "[got the command to exit :^]\n");
	    exit(0);                          /* always ready to exit */
	}
	binary = malloc(1+(length-=4));
	binary[length] = '\0';
	cs = read(fileno(stdin), binary, length);
	if (length != cs) {
	    fprintf(stderr, "[read too few bytes: %d]\n", cs);
	    exit(1);
	}
	fprintf(stderr,"[binary message is <%s>]\n", binary);
	free(binary);

	/* fake reply */

	length = 4;
	pamc_write__u32(data, 4);
	cs = write(fileno(stdout), data, 4);
	if (4 != cs) {
	    fprintf(stderr, "[wrote bad length: %d]\n", cs);
	    exit(1);
	}
	control = PAMC_CONTROL_DONE;
	pamc_write__u32(data, control);
	cs = write(fileno(stdout), data, 4);
	if (4 != cs) {
	    fprintf(stderr, "[wrote bad control: %d bytes]\n", cs);
	    exit(1);
	}
    }

    exit(0);
}

/*
  when run with:

   ./testing.agent < testing.dat > output

  output should look like this:

             

 */
