

#include <linux/errno.h>
#include <linux/tty.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/signal.h>
/*#include <linux/string.h>*/
#include <linux/errno.h>
#include <linux/ctype.h>
#include <linux/ptrace.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/stat.h>
#include <linux/string.h>
#include <linux/kdev_t.h>
#include <asm/segment.h>
#include <asm/pgtable.h>
#include <asm/io.h>
#include <stdarg.h>
#include "log.h"



#define MODULE
#include <linux/module.h>

#include "include/syscallmgr.h"
#include "ucmd.h"
#include "log.h"

struct redirect_db {
  void *resident;
  void *transient; 
  char is_pointer;
  char savearea[5];
};

extern int printk( const char* fmt, ...);
extern int sys_execve(), _TRANSIENT_sys_execve();
extern int getname();
/*extern int console_loglevel;*/

static struct redirect_db redirect_list[]= {
	{ sys_execve, _TRANSIENT_sys_execve }
};

static int __NR_ucmd_add_sys=-1;
static int __NR_ucmd_del_sys=-1;
static int __NR_ucmd_get_sys=-1;
static int __NR_ucmd_match_sys=-1;
static int __NR_sys_audit_log=-1;
static int __NR_sys_aprintf=-1;

static struct ucmd *head=NULL;
static struct ucmd *tail=NULL;

static char buf[1024];
static char log_buf[LBL];
static unsigned long log_size=0;
static unsigned long log_start=0;
static unsigned long logged=0;
static int mutex1=0;
struct wait_queue * log_wait = NULL;
struct wait_queue * pf_wait = NULL;

int aprintf(const char *fmt,...) {
	va_list args;
	int i;
	char *p, *buf_end;
	long flags;
	
/*	while (mutex1==1) {
		if (current->signal & ~current->blocked) {
			sti();
			return -ERESTARTSYS;
		}
		interruptible_sleep_on(&pf_wait);
	}
	
	mutex1=1;*/

	save_flags(flags);
	cli();
	va_start(args,fmt);
	i=vsprintf(buf,fmt,args);
	buf_end=buf+i;
	va_end(args);
//	buf_end=buf_end+1;
	
	p=buf;
	
	for (; p<buf_end;p++) {
		log_buf[(log_start+log_size) & (LBL-1)]=*p;
		if (log_size<LBL) 
			log_size++;
		else {
			log_start++;
			log_start &= LBL-1;
		}
		logged++;
		if (*p=='\n') break;
	}
	restore_flags(flags);
	sti();
	wake_up_interruptible(&log_wait);
/*	wake_up_interruptible(&pf_wait);
	mutex1=0;*/
	return i;
}

asmlinkage int sys_aprintf(char *s,int len) {
	char buf[1020];
	int err;
	
	if (len<0) return -EINVAL;
	
	if (err=verify_area(VERIFY_READ,s,len)) return(err);
		
	memcpy_fromfs(buf,s,len);
	
	return aprintf("%s",buf);
}

















/* FRAGMENT OF CODE TAKEN DIRECTLY FROM EMUMOD - THANKS TO HANS LERMEN */

struct jmpop {
  unsigned char opcode;
  int displacement __attribute__ ((packed));
};


static void redirect_resident_routine(void *resident_addr, void *transient_addr, char *savearea)
{
  enum { JMP_OPCODE=0x0e9 };
  struct jmpop  *raddr = resident_addr;
  int flags, displ;
  
  displ=((int)transient_addr) - ((int)resident_addr+sizeof(struct jmpop));
  save_flags(flags);
  cli();
  memcpy(savearea,resident_addr,sizeof(struct jmpop));
  raddr->opcode = JMP_OPCODE;
  raddr->displacement = displ;  
  restore_flags(flags);
}

static void restore_redirect(void *resident_addr,  char *savearea)
{
  int flags;
  
  save_flags(flags);
  cli();
  memcpy(resident_addr,savearea,5);
  restore_flags(flags);
}


static void redirect_all() {
  int num=sizeof(redirect_list) / sizeof(struct redirect_db);
  struct redirect_db *p;
  int flags,i;
  
  save_flags(flags);
  for (i=0, p=redirect_list; i<num; i++, p++) {
    if (p->is_pointer) {
      *((long *)(p->savearea)) = *((long *)(p->resident));
      *((long *)(p->resident)) = (long)p->transient;
    }
    else redirect_resident_routine(p->resident, p->transient, p->savearea);
  }
  restore_flags(flags);
}

static void restore_redirect_all() {
  int num=sizeof(redirect_list) / sizeof(struct redirect_db);
  struct redirect_db *p;
  int flags,i;
  
  save_flags(flags);
  for (i=0, p=&redirect_list[num-1]; i<num; i++, p--) {
    if (p->is_pointer) {
      *((long *)(p->resident)) = *((long *)(p->savearea));
    }
    else restore_redirect(p->resident, p->savearea);
  }
  restore_flags(flags);
}

/* CODE THIEFT BLOCK 1 ENDS HERE */

#define STAR    0
#define NOTSTAR 1
#define RESET   2

int strmask(char *str, char *mask)
/*
    Tests string 'str' against mask string 'mask'
    Returns TRUE if the string matches the mask.

    The mask can contain '?' and '*' wild card characters.
    '?' matches any single character.
    '*' matches any number of any characters.

    For example:
                    strmask("Hello", "Hello");  ---> TRUE
                    strmask("Hello", "Jello");  ---> FALSE
                    strmask("Hello", "H*o");    ---> TRUE
                    strmask("Hello", "H*g");    ---> FALSE
                    strmask("Hello", "?ello");  ---> TRUE
                    strmask("Hello", "H????");  ---> TRUE
                    strmask("H", "H????");      ---> FALSE
*/
{
    char *sp, *mp, *reset_string, *reset_mask, *sn;
    int state;

    sp = str;
    mp = mask;

    while (1) {
        switch (*mp) {
        case '\0':
            return(*sp ? 0:1);
        case '?':
            sp++;
            mp++;
            break;
        default:
            if (*mp == *sp) {
                sp++;
                mp++;
                break;
            }
            else {
                return(0);
            }
        case '*':
            if (*(mp + 1) == '\0') {
                return(1);
            }
            if ((sn = strchr(sp, *(mp + 1))) == NULL) {
                return(0);
            }

            /* save place -- match rest of string */
            /* if fail, reset to here */
            reset_mask = mp;
            reset_string = sn + 1;

            mp = mp + 2;
            sp = sn + 1;
            state = NOTSTAR;
            while (state == NOTSTAR) {
                switch (*mp) {
                case '\0':
                    if (*sp == '\0') {
                        return(0);
                    }
                    else {
                        state = RESET;
                    }
                    break;
                case '?':
                    sp++;
                    mp++;
                    break;
                default:
                    if (*mp == *sp) {
                        sp++;
                        mp++;
                    }
                    else {
                        state = RESET;
                    }
                    break;
                case '*':
                    state = STAR;
                    break;
                }
            }
            /* we've reach a new star or should reset to last star */
            if (state == RESET) {
                sp = reset_string;
                mp = reset_mask;
            }
            break;
        }
    }
}

static int matchit(char *cmd) {

	struct ucmd *temp;
	
	int i=0;

	for (temp=tail;temp!=NULL;temp=temp->next) {
		if (((temp->alluids==1) || (temp->uid==current->uid)) &&
	 	    ((temp->allgids==1) || (temp->gid==current->gid)) &&
		    (strmask(cmd,temp->cmd))) {
		    		i |=temp->action;
		}
	}
	return(i);
}


static int printthem(char **argv) {
        int i = 0;
        int j = 0;
        int rc = 0;
/*        int koko = 0;*/
        char korkor[100];
        char *tmp;
        
        do {	
	        if (((tmp=get_user(argv+(i++)))==NULL) || (j>98)) {
	        	korkor[--j]='\0';
/*	        	rc=matchit(korkor);*/
	        	
	        	/* UGLY BLOODY FUCKING TRICK ON FOLLOWING LINE */
/*	        	koko = console_loglevel; console_loglevel=6;*/
/*	        	if (rc & ACT_LOG) {*/
	        		aprintf("%d (%d,%d)",current->pid,current->uid,current->gid); 
	        		if (rc & ACT_DENY) {
	        			aprintf("denied ");
	        		}
	        		if (current->tty!=NULL) {
	        			aprintf(" (%d:%d)",MAJOR(current->tty->device),MINOR(current->tty->device));
	        		}
	        		aprintf(" : %s\n",korkor);
/*	        	}*/
	        	/* END OF U.B.F.T ON FOLLOWING LINE */
/*	        	console_loglevel=koko;*/
	        	
	        	if (rc & ACT_DENY) {
	        		return(-EACCES);
	        	} else {
		        	return(0);
		        }
	        }
	        while (((korkor[j]=get_user(tmp++))!=0) && (j<99)) 
			j++;
		korkor[j++]=' ';
	        
	} while (tmp!=NULL);
	return(0);
}


asmlinkage int _TRANSIENT_sys_execve(struct pt_regs regs)
{
	int error;
	char *filename;
	
	error = getname((char *) regs.ebx, &filename);
	if (error)
		return error; 
	error = printthem((char **)regs.ecx);
	if (error)
		return error;
	error = do_execve(filename, (char **) regs.ecx, (char **) regs.edx, &regs);
	putname(filename);
	return error;
}

/* CODE THIEFT BLOCK 2 STOPS HERE */

asmlinkage int ucmd_add_sys(struct ucmd *kuku) {

	static struct ucmd *ptr;
	
	ptr=(struct ucmd *)kmalloc(sizeof(struct ucmd),GFP_KERNEL);
	memcpy_fromfs(ptr,kuku,sizeof(struct ucmd));
	
	ptr->next=NULL;
	ptr->prev=head;
	if (head!=NULL) {
		head->next=ptr;
	} 
	
	if (tail==NULL) {
		tail=ptr;
	}
	
	head=ptr;
#ifdef KRA_KRA_EKANE_TO_MAYRO_KORAKI	
	aprintf(UCMD_ID","UCMD_ADD_ID": added {%d,%d,%d,\"%s\"}\n",ptr->uid,
								  ptr->gid,
								  ptr->action,
								  ptr->cmd);
#endif	
	return(0);
}

static struct ucmd *ucmd_get_sys1(int number) {
	static struct ucmd *temp;
	int i=0;

	for (temp=tail;temp!=NULL;temp=temp->next) {
		if (++i==number) return(temp);
	}
	return(NULL);
}

asmlinkage int ucmd_get_sys(int number,struct ucmd *koko,int len) {

	struct ucmd *pop;

	int errir = verify_area(VERIFY_WRITE,koko,sizeof(struct ucmd));
	if (errir) {
		return(1);
	}
	
	if ((pop=ucmd_get_sys1(number))==NULL) {
		return(1);
	}
	
	memcpy_tofs(koko,pop,sizeof(struct ucmd));
	
	return(0);
}

asmlinkage int ucmd_del_sys(int id) /*(struct ucmd *koko)*/ {
	struct ucmd *koko;
	
	if ((koko=ucmd_get_sys1(id))==NULL) {
		aprintf(UCMD_ID","UCMD_DEL_ID": Entry %d does not exist\n",id);
		return(1);
	}
	
	if (koko->prev!=NULL) {
		koko->prev->next=koko->next;
	} else {
		tail=koko->next;
	}
	
	if (koko->next!=NULL) {
		koko->next->prev=koko->prev;
	} else {
		head=koko->prev;
	}
	
	kfree(koko);
	aprintf(UCMD_ID","UCMD_DEL_ID": Entry %d deleted\n",id);
	return(0);
}

asmlinkage int ucmd_match_sys(uid_t uid, gid_t gid, const char *cmd, int l) {

	struct ucmd *temp;
	static char boom[100];

	memcpy_fromfs(boom,cmd,strlen(cmd)+1);
	for (temp=tail;temp!=NULL;temp=temp->next) {
		if (strmask(boom,temp->cmd)) {
			return(temp->action);
		}
	}
	return(0);
}


/* Copyright infrigement notice : */
/* HEAVILY cheated code from linux/kernel/printk.c that is (C) by Linus. */

asmlinkage int sys_audit_log(int type, char *buf, int len) {
	unsigned long i;
	char c;
	int error=0;
	
	if (!suser()) {
		return -EPERM;
	}
	
	switch (type) {
		case LOG_CLEAR:
				logged=0;
				return 0;
		case LOG_READ:
				if (!buf || len<0) return -EINVAL;
				if (!len) return 0;
				if ((error=verify_area(VERIFY_WRITE,buf,len))) return error;
				cli();
				while (!log_size) {
					if (current->signal & ~current->blocked) {
						sti();
						return -ERESTARTSYS;
					}
					interruptible_sleep_on(&log_wait);
				}
				
				i=0;
				c='a';
				while (log_size && i < len-1) {
					c=*((char *)log_buf+log_start);
					log_start++;
					log_size--;
					log_start &= LBL-1;
					sti();
					put_user(c,buf);
					*buf++;
					i++;
					cli();
					if (c=='\n') {
						sti();put_user('\0',buf);cli();
						break;
					}
				}
				sti();
				return i;
		default:
				return -EINVAL;
	}
	return 0; /* shut up, gcc! */
}

	
	
	
	
				
					

				
				





















int init_module(void) {
  kernel_version[0] = kernel_version[0];
  
  printk(UCMD_ID": registering syscalls ucmd_add_sys()\n");
  __NR_ucmd_add_sys=register_syscall(0, ucmd_add_sys,UCMD_ADD_ID);
  if (__NR_ucmd_add_sys>0) {
    printk(UCMD_ID": NR_ucmd_add_sys=%d\n",__NR_ucmd_add_sys);
  }
  else {
    printk(UCMD_ID": init_module failed\n");
    return -1;
  }
  
  printk(UCMD_ID": registering syscall ucmd_get_sys()\n");
  __NR_ucmd_get_sys=register_syscall(0, ucmd_get_sys,UCMD_GET_ID);
  if (__NR_ucmd_get_sys>0) {
    printk(UCMD_ID": NR_ucmd_get_sys=%d\n",__NR_ucmd_get_sys);
  }
  else {
    printk(UCMD_ID": init_module failed\n");
    return -1;
  }
  
  printk(UCMD_ID": registering syscall ucmd_del_sys()\n");
  __NR_ucmd_del_sys=register_syscall(0, ucmd_del_sys,UCMD_DEL_ID);
  if (__NR_ucmd_del_sys>0) {
    printk(UCMD_ID": NR_ucmd_del_sys=%d\n",__NR_ucmd_del_sys);
  }
  else {
    printk(UCMD_ID ": init_module failed\n");
    return (-1);
  }
  
  printk(UCMD_ID": registering syscall ucmd_match_sys()\n");
  __NR_ucmd_match_sys=register_syscall(0, ucmd_match_sys,UCMD_MATCH_ID);
  if (__NR_ucmd_match_sys>0) {
    printk(UCMD_ID": NR_ucmd_match_sys=%d\n",__NR_ucmd_match_sys);
  }
  else {
    printk(UCMD_ID": init_module failed\n");
    return -1;
  }
  
  printk(UCMD_ID": registering syscall sys_audit_log()\n");
  __NR_sys_audit_log=register_syscall(0, sys_audit_log,SYS_AUDIT_LOG_ID);
  if (__NR_sys_audit_log>0) {
    printk(UCMD_ID": NR_sys_audit_log=%d\n",__NR_sys_audit_log);
  }
  else {
    printk(UCMD_ID": init_module failed\n");
    return -1;
  }
  
  
  printk(UCMD_ID": registering syscall sys_aprintf()\n");
  __NR_sys_aprintf=register_syscall(0,sys_aprintf,SYS_APRINTF_ID);
  if (__NR_sys_aprintf>0) {
    printk(UCMD_ID": NR_sys_aprintf=%d\n",__NR_sys_aprintf);
  }
  else {
    printk(UCMD_ID": init_module failed\n");
    return -1;
  }
  
 
  printk(UCMD_ID": redirecting execve\n");
  redirect_all();
  
  return(0);
  
}

void cleanup_module(void) {
  struct ucmd *temp;


  if (MOD_IN_USE) printk(UCMD_ID": device busy, remove delayed\n");
  else printk(UCMD_ID": cleanup module called\n");
  restore_redirect_all();
  
  printk(UCMD_ID": Clearing entry list...\n"); 
  for (temp=tail;temp!=NULL;temp=temp->next) {
  	kfree(temp);
  }
  unregister_syscall(__NR_ucmd_add_sys);
  unregister_syscall(__NR_ucmd_get_sys);
  unregister_syscall(__NR_ucmd_del_sys);
  unregister_syscall(__NR_ucmd_match_sys);
  unregister_syscall(__NR_sys_aprintf);
  unregister_syscall(__NR_sys_audit_log);
  
}