=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class TokenWriteRoleRequest
    # String or JSON list of allowed entity aliases. If set, specifies the entity aliases which are allowed to be used during token generation. This field supports globbing.
    attr_accessor :allowed_entity_aliases

    # If set, tokens can be created with any subset of the policies in this list, rather than the normal semantics of tokens being a subset of the calling token's policies. The parameter is a comma-delimited string of policy names.
    attr_accessor :allowed_policies

    # If set, tokens can be created with any subset of glob matched policies in this list, rather than the normal semantics of tokens being a subset of the calling token's policies. The parameter is a comma-delimited string of policy name globs.
    attr_accessor :allowed_policies_glob

    # Use 'token_bound_cidrs' instead.
    attr_accessor :bound_cidrs

    # If set, successful token creation via this role will require that no policies in the given list are requested. The parameter is a comma-delimited string of policy names.
    attr_accessor :disallowed_policies

    # If set, successful token creation via this role will require that no requested policies glob match any of policies in this list. The parameter is a comma-delimited string of policy name globs.
    attr_accessor :disallowed_policies_glob

    # Use 'token_explicit_max_ttl' instead.
    attr_accessor :explicit_max_ttl

    # If true, tokens created via this role will be orphan tokens (have no parent)
    attr_accessor :orphan

    # If set, tokens created via this role will contain the given suffix as a part of their path. This can be used to assist use of the 'revoke-prefix' endpoint later on. The given suffix must match the regular expression.\\w[\\w-.]+\\w
    attr_accessor :path_suffix

    # Use 'token_period' instead.
    attr_accessor :period

    # Tokens created via this role will be renewable or not according to this value. Defaults to \"true\".
    attr_accessor :renewable

    # Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token.
    attr_accessor :token_bound_cidrs

    # If set, tokens created via this role carry an explicit maximum TTL. During renewal, the current maximum TTL values of the role and the mount are not checked for changes, and any updates to these values will have no effect on the token being renewed.
    attr_accessor :token_explicit_max_ttl

    # If true, the 'default' policy will not automatically be added to generated tokens
    attr_accessor :token_no_default_policy

    # The maximum number of times a token may be used, a value of zero means unlimited
    attr_accessor :token_num_uses

    # If set, tokens created via this role will have no max lifetime; instead, their renewal period will be fixed to this value. This takes an integer number of seconds, or a string duration (e.g. \"24h\").
    attr_accessor :token_period

    # The type of token to generate, service or batch
    attr_accessor :token_type

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'allowed_entity_aliases' => :'allowed_entity_aliases',
        :'allowed_policies' => :'allowed_policies',
        :'allowed_policies_glob' => :'allowed_policies_glob',
        :'bound_cidrs' => :'bound_cidrs',
        :'disallowed_policies' => :'disallowed_policies',
        :'disallowed_policies_glob' => :'disallowed_policies_glob',
        :'explicit_max_ttl' => :'explicit_max_ttl',
        :'orphan' => :'orphan',
        :'path_suffix' => :'path_suffix',
        :'period' => :'period',
        :'renewable' => :'renewable',
        :'token_bound_cidrs' => :'token_bound_cidrs',
        :'token_explicit_max_ttl' => :'token_explicit_max_ttl',
        :'token_no_default_policy' => :'token_no_default_policy',
        :'token_num_uses' => :'token_num_uses',
        :'token_period' => :'token_period',
        :'token_type' => :'token_type'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'allowed_entity_aliases' => :'Array<String>',
        :'allowed_policies' => :'Array<String>',
        :'allowed_policies_glob' => :'Array<String>',
        :'bound_cidrs' => :'Array<String>',
        :'disallowed_policies' => :'Array<String>',
        :'disallowed_policies_glob' => :'Array<String>',
        :'explicit_max_ttl' => :'Integer',
        :'orphan' => :'Boolean',
        :'path_suffix' => :'String',
        :'period' => :'Integer',
        :'renewable' => :'Boolean',
        :'token_bound_cidrs' => :'Array<String>',
        :'token_explicit_max_ttl' => :'Integer',
        :'token_no_default_policy' => :'Boolean',
        :'token_num_uses' => :'Integer',
        :'token_period' => :'Integer',
        :'token_type' => :'String'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::TokenWriteRoleRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::TokenWriteRoleRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'allowed_entity_aliases')
        if (value = attributes[:'allowed_entity_aliases']).is_a?(Array)
          self.allowed_entity_aliases = value
        end
      end

      if attributes.key?(:'allowed_policies')
        if (value = attributes[:'allowed_policies']).is_a?(Array)
          self.allowed_policies = value
        end
      end

      if attributes.key?(:'allowed_policies_glob')
        if (value = attributes[:'allowed_policies_glob']).is_a?(Array)
          self.allowed_policies_glob = value
        end
      end

      if attributes.key?(:'bound_cidrs')
        if (value = attributes[:'bound_cidrs']).is_a?(Array)
          self.bound_cidrs = value
        end
      end

      if attributes.key?(:'disallowed_policies')
        if (value = attributes[:'disallowed_policies']).is_a?(Array)
          self.disallowed_policies = value
        end
      end

      if attributes.key?(:'disallowed_policies_glob')
        if (value = attributes[:'disallowed_policies_glob']).is_a?(Array)
          self.disallowed_policies_glob = value
        end
      end

      if attributes.key?(:'explicit_max_ttl')
        self.explicit_max_ttl = attributes[:'explicit_max_ttl']
      end

      if attributes.key?(:'orphan')
        self.orphan = attributes[:'orphan']
      end

      if attributes.key?(:'path_suffix')
        self.path_suffix = attributes[:'path_suffix']
      end

      if attributes.key?(:'period')
        self.period = attributes[:'period']
      end

      if attributes.key?(:'renewable')
        self.renewable = attributes[:'renewable']
      else
        self.renewable = true
      end

      if attributes.key?(:'token_bound_cidrs')
        if (value = attributes[:'token_bound_cidrs']).is_a?(Array)
          self.token_bound_cidrs = value
        end
      end

      if attributes.key?(:'token_explicit_max_ttl')
        self.token_explicit_max_ttl = attributes[:'token_explicit_max_ttl']
      end

      if attributes.key?(:'token_no_default_policy')
        self.token_no_default_policy = attributes[:'token_no_default_policy']
      end

      if attributes.key?(:'token_num_uses')
        self.token_num_uses = attributes[:'token_num_uses']
      end

      if attributes.key?(:'token_period')
        self.token_period = attributes[:'token_period']
      end

      if attributes.key?(:'token_type')
        self.token_type = attributes[:'token_type']
      else
        self.token_type = 'default-service'
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      true
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          allowed_entity_aliases == o.allowed_entity_aliases &&
          allowed_policies == o.allowed_policies &&
          allowed_policies_glob == o.allowed_policies_glob &&
          bound_cidrs == o.bound_cidrs &&
          disallowed_policies == o.disallowed_policies &&
          disallowed_policies_glob == o.disallowed_policies_glob &&
          explicit_max_ttl == o.explicit_max_ttl &&
          orphan == o.orphan &&
          path_suffix == o.path_suffix &&
          period == o.period &&
          renewable == o.renewable &&
          token_bound_cidrs == o.token_bound_cidrs &&
          token_explicit_max_ttl == o.token_explicit_max_ttl &&
          token_no_default_policy == o.token_no_default_policy &&
          token_num_uses == o.token_num_uses &&
          token_period == o.token_period &&
          token_type == o.token_type
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [allowed_entity_aliases, allowed_policies, allowed_policies_glob, bound_cidrs, disallowed_policies, disallowed_policies_glob, explicit_max_ttl, orphan, path_suffix, period, renewable, token_bound_cidrs, token_explicit_max_ttl, token_no_default_policy, token_num_uses, token_period, token_type].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
